#include "bsp.h"

static u16 timer_on = 0,timer_off = 0;
static u16 nCnt = 0;
static u8 nNum = 0;

//ϵͳʼ
void BspInit(void)
{
	NVIC_PriorityGroupConfig(NVIC_PriorityGroup_2);//жΪ2,NVICжϷ2:2λռȼ,2λӦȼ(0-3)
	BspTim2Init();
	BspTim4Init();
    TIM_Delay_Init();
#ifdef DEBUG
	USART1_Init(115200);
#endif
    LedInit();
	KeyInit();
	IWDG_Init();
	TIM_Delay10Ms(10);
	NRF_Init();//ʼЭ
}

void LedInit(void)
{
    GPIO_InitTypeDef GPIO_InitStructure;
	
    //RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA|RCC_APB2Periph_GPIOB, ENABLE);
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);
	
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_4;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
    GPIO_Init(GPIOA, &GPIO_InitStructure);
	
	GPIO_InitStructure.GPIO_Pin = RELAY_PIN;
	GPIO_Init(GPIOA, &GPIO_InitStructure);
}

//ʼKEY-->GPIOA.5  
void KeyInit(void)
{ 
 	GPIO_InitTypeDef GPIO_InitStructure;
	
 	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA,ENABLE);//ʹʱ

	GPIO_InitStructure.GPIO_Pin  = GPIO_Pin_5;//
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU;//ó
 	GPIO_Init(GPIOA, &GPIO_InitStructure);//ʼ
}

//ûú(,ʱ,ʱ)λ10mS,num=0xffΪģʽ
void SetLed(u8 num,u16 on_time,u16 off_time)     
{
	nNum = num;
	timer_on = on_time;
	timer_off = off_time;
	LED = 0;
	nCnt = 0;
}

void Led_10mS_Conut(void)//10mS
{
	if(nCnt)
	{
		nCnt--;
		if(nCnt == timer_off)
			LED = 0;
	}
	else
	{
		if(nNum == 0XFF)
		{
			LED = 1;
			nCnt = timer_on + timer_off;
		}
		else if(nNum)
		{
			LED = 1;
			nNum --;
			nCnt = timer_on + timer_off;
		}
	}
}

//crcֽЧ//ʽΪX8X2X1
u8 cal_crc8(u8 *ptr, u8 len) 
{
	u8 i,crc=0;
	
	while(len--!=0) 
	{
		for(i=0x80; i!=0; i/=2)
		{
			if((crc&0x80)!=0) 
			{
				crc*=2; 
				crc^=0x07;//ʽCRC2CRC
			}
			else 
				crc*=2;
			if((*ptr&i)!=0) 
				crc^=0x07;//ټϱλCRC
		}
		ptr++;
	}
	return(crc);
}

u16 cal_crc16(u8 *pData, u16 sLen)
{  
   u16 nCRC=0,i=0;
   
   while(sLen--)  //lenҪĳ
   {
       nCRC = nCRC^(int)(*pData++) << 8;
       for (i=8; i!=0; i--) 
       {
           if (nCRC & 0x8000)   
               nCRC = nCRC << 1 ^ 0x1021;    
           else
               nCRC = nCRC << 1;
       }    
   }
   return nCRC;
}

u8 Get_Nid(const u8 val)
{
	char up_id[3]={0};
	char up_id2[1]={0};
	u8 up_nid;
	
	sprintf(up_id,"%d",val);
	if(val<100)//nid
	{
		up_id2[0]=up_id[1];//2λ
		up_nid=atoi(up_id2);
	}
	else
	{
		up_id2[0]=up_id[2];//3λ
		up_nid=atoi(up_id2);
	}
	return up_nid;
}

#ifdef DEBUG
void PrintHex(u8 *buf,u16 len)
{
	u16 i;
	printf("\r\n");
	for(i=0;i<len;i++)
	{
		printf("%02x ",buf[i]);
	}
	printf("\r\n\r\n");
}
#endif

void BspClose(void)
{
    BspTim2Close();
    BspTim3Close();
	BspTim4Close();
    BspUsart1Close();
	EXTI9_5Close();
}

void MemSet(BYTE *p,BYTE val,u32 length)
{
	u32 i=0;
	for(i=0;i<length;i++)
	{
		p[i]=val;
	}
}

void MemCopy(BYTE *dst,BYTE *src,u32 length)
{
	u32 i=0;
	for(i=0;i<length;i++)
	{
		dst[i]=src[i];
	}
}

__asm void WFI_SET(void)
{
	WFI;		  
}
//رж
__asm void INTX_DISABLE(void)
{
	CPSID I;		  
}
//ж
__asm void INTX_ENABLE(void)
{
	CPSIE I;		  
}
//ջַ
//addr:ջַ
__asm void MSR_MSP(u32 addr) 
{
    MSR MSP, r0 			//set Main Stack value
    BX r14
}
