#ifndef _bsp_h_
#define _bsp_h_

#include <stm32f10x.h>

#include "BspTime2.h"
#include "BspTime3.h"
#include "BspUsart1.h"
#include "wdg.h"
#include "nrf24l01.h"
#include "nrf24l01_reg.h"
#include "nrf_data.h"
#include "nrf_phy.h"
#include "BspMemory.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <math.h>

typedef  void (*FunVoidType)(void);

#define DEBUG

//typedef enum {FALSE = 0, TRUE = !FALSE} BOOL;
#define TRUE	1
#define FALSE	0
#define NULL 	0

#define	ON_exti(BITx)	EXTI->IMR|=1<<(BITx)
#define	OFF_exti(BITx)	EXTI->IMR&=~(1<<(BITx))

//ȫжϵĺ
#define ENABLE_INT()	__set_PRIMASK(0)//ʹȫж
#define DISABLE_INT()	__set_PRIMASK(1)//ֹȫж

//ͬ
#define THREAD_LOCK(x)  __set_PRIMASK(x)//ȫж;0ʹ;1ֹ

//λ
//IOڲ궨
#define BITBAND(addr, bitnum) ((addr & 0xF0000000)+0x2000000+((addr &0xFFFFF)<<5)+(bitnum<<2)) 
#define MEM_ADDR(addr)  *((volatile unsigned long  *)(addr)) 
#define BIT_ADDR(addr, bitnum)   MEM_ADDR(BITBAND(addr, bitnum)) 

//IOڵַӳ
#define GPIOA_ODR_Addr (GPIOA_BASE+12) //0x4001080C 
#define GPIOB_ODR_Addr (GPIOB_BASE+12) //0x40010C0C 
#define GPIOC_ODR_Addr (GPIOC_BASE+12) //0x4001100C 

#define GPIOA_IDR_Addr (GPIOA_BASE+8) //0x40010808 
#define GPIOB_IDR_Addr (GPIOB_BASE+8) //0x40010C08 
#define GPIOC_IDR_Addr (GPIOC_BASE+8) //0x40011008 

//IOڲ,ֻԵһIO!
//ȷnֵС16!
#define PAout(n) BIT_ADDR(GPIOA_ODR_Addr,n)// 
#define PBout(n) BIT_ADDR(GPIOB_ODR_Addr,n)
#define PCout(n) BIT_ADDR(GPIOC_ODR_Addr,n)
#define PAin(n)  BIT_ADDR(GPIOA_IDR_Addr,n)// 
#define PBin(n)  BIT_ADDR(GPIOB_IDR_Addr,n) 
#define PCin(n)  BIT_ADDR(GPIOC_IDR_Addr,n)

#define LED		PAout(4)
#define KEY		PAin(5)
//#define KEY	GPIO_ReadInputDataBit(GPIOA,GPIO_Pin_5)//ȡ

#ifdef DEBUG
	#define RELAY_PIN		GPIO_Pin_4
	#define RELAY PAout(4)	//̵=Pin_4
#else
	#define RELAY_PIN		GPIO_Pin_9
	#define RELAY PAout(9)	//̵=Pin_9
#endif

void BspInit(void);
void KeyInit(void);
void LedInit(void);
void BspClose(void);
void SetLed(u8 num,u16 on_time,u16 off_time);
void Led_10mS_Conut(void);//10mS
void MemSet(BYTE * p,BYTE val,u32 length);
void MemCopy(BYTE *dst,BYTE *src,u32 length);
u8 Get_Nid(const u8 val);
u8 cal_crc8(u8 *ptr, u8 len);
u16 cal_crc16(u8 *pData, u16 sLen);
#ifdef DEBUG
	void PrintHex(u8 *buf,u16 len);
#endif	

//Ϊຯ
void WFI_SET(void);		//ִWFIָ
void INTX_DISABLE(void);//رж
void INTX_ENABLE(void);	//ж
void MSR_MSP(u32 addr);	//öջַ

#endif
