#include "bsp.h"
#include "wdg.h"
#include "timer.h"
#include "usart.h"
#include "led.h"
#include "key.h"
#include "esp8266.h"
#include "connect.h"
#include "pro_phy.h"
#include "md5.h"
//#include "aes.h"

time_obj run_time;//ʱṹ
extern void USART1_RecvData(void);
//ϵͳʼ
void BspInit(void)
{
	NVIC_PriorityGroupConfig(NVIC_PriorityGroup_2);//жΪ2,NVICжϷ2:2λռȼ,2λӦȼ(0-3)

	IWDG_Init();
	TIMER_Init();
	TIM_Delay_Init();
	LED_Init();
	KEY_Init();
	UART1_Init(115200);//
	UART2_Init(115200);//ESP8266
	Connect_Init();//ESP8266
	NRF_Init();//ʼЭ
	MemSet((BYTE *)&run_time,0,sizeof(time_obj));//ʼṹ
}

void Idle(void)
{
	u32 main_time=Get_RunTime();
	
	IWDG_Feed();//ι
	Key_Scan();
	USART1_RecvData();
	if (IS_TIMEOUT_10MS(eTimNrf, 1)&&!NRF_GetThreadLockState())//10ms
	{
		NRF_Thread();//ʱ߳,ִЭ
	}
	if(main_time-run_time.time>=100)//1
	{
		run_time.time=main_time;
		run_time.sec++;
		if(run_time.sec>=60)
		{
			run_time.sec=0;
			run_time.min++;
			if(run_time.min>=60)
			{
				run_time.min=0;
				run_time.hour++;
				if(run_time.hour>=24)
				{
					run_time.hour=0;
					run_time.date++;
				}
			}
		}
	}
}

u8 Get_Nid(const u8 val)
{
	char up_id[3]={0};
	char up_id2[1]={0};
	u8 up_nid;
	
	sprintf(up_id,"%d",val);
	if(val<100)//nid
	{
		up_id2[0]=up_id[1];//2λ
		up_nid=atoi(up_id2);
	}
	else
	{
		up_id2[0]=up_id[2];//3λ
		up_nid=atoi(up_id2);
	}
	return up_nid;
}

void GetBody(char *dststr,char *srcstr)//ȡֻ{xxxxxx}ַ
{
	char buff[PAYLOAD_DATA_LEN];
	u16 i,num=0;
	u8 flag=0;

	for(i=0;i<strlen(srcstr);i++)
	{
		if(srcstr[i]=='{')
		{
			flag=1;
		}
		if(flag)
		{
			buff[num++]=srcstr[i];
		}
		if(srcstr[i]=='}'||num>=PAYLOAD_DATA_LEN)
		{
			flag=0;
			break;
		}
	}
	sprintf(dststr,"%s",buff);
}

u16 GetNumber(char *srcstr,u8 start,u8 byte)//{xxxxxx}лȡnum
{
	char buff[10];
	
	if(strstr(srcstr,"{")&&strstr(srcstr,"}")&&strlen(srcstr)>10)
	{
		memcpy(buff,srcstr+start,byte);
		return strtol(buff,NULL,10);
	}
	else 
	{
		return 0;
	}
}

//strеõ//srcstr:ַ;str:ʶ
u32 GetValue(char *srcstr,char *str)	
{	
	while(*srcstr!=*str)//ƫƵʼĵط
	{
		srcstr++;	
		if(*srcstr=='\0')
			return 0;//
	}
	srcstr++;
	//return atoi(srcstr);	
	return strtol(srcstr,NULL,10);
}

//srcstrַ;strʶ;ֵ:; 0,
u8 GetDataLength(char *srcstr,char *str)//xxxxx,xxx//=5
{
	u8 len=0;
	
	while(*srcstr!=*str)//ƫƵʼĵط
	{
		srcstr++;	
		len++;
	}
	return len;
}

//str:ʶ
void CopyString(char *dststr,char *srcstr,char *str)
{
	u8 len=0;
	
	while(1)
	{										   
		if(*srcstr=='\0'||*srcstr=='\r'||*srcstr=='\n'||*srcstr==*str)
		{
			*dststr='\0';
			return;//.
		}
		*dststr=*srcstr;//
		srcstr++;
		dststr++;
		len++;
		if(len>=PAYLOAD_DATA_LEN-1)
		{
			return;
		}
	}
}

void PrintAddr(char *str,u8 *addr)
{
	u8 i;

	printf("%s:",str);
	for(i=0;i<MAC_LEN;i++)
	{
		printf("%02x ",addr[i]);
	}
	printf("\r\n");
}

void PrintHex(u8 *buf,u16 len)
{
	u16 i;
	printf("\r\n");
	for(i=0;i<len;i++)
	{
		printf("%02x ",buf[i]);
	}
	printf("\r\n\r\n");
}

//crcֽЧ//ʽΪX8X2X1
u8 cal_crc8(u8 *ptr, u8 len) 
{
	u8 i,crc=0;
	
	while(len--!=0) 
	{
		for(i=0x80; i!=0; i/=2)
		{
			if((crc&0x80)!=0) 
			{
				crc*=2; 
				crc^=0x07;//ʽCRC2CRC
			}
			else 
				crc*=2;
			if((*ptr&i)!=0) 
				crc^=0x07;//ټϱλCRC
		}
		ptr++;
	}
	return(crc);
}

u16 cal_crc16(u8 *pData, u16 sLen)
{  
   u16 i,crc = 0;
   
   while(sLen--)  //lenҪĳ
   {
       crc = crc^(int)(*pData++) << 8;
       for (i=8; i!=0; i--) 
       {
           if (crc & 0x8000)   
               crc = crc << 1 ^ 0x1021;    
           else
               crc = crc << 1;
       }    
   }
   return crc;
}

//u32 cal_crc32(u32 *ptr, u16 len)
//{
//	u32 crc=0xFFFFFFFF;
//	u16 i,k;

//    for(k=0;k<len;k++)
//    {
//        crc = crc ^ (*ptr++);
//        for (i = 0; i < 32; i++)
//        {
//            if (crc & 0x80000000)
//                crc = (crc << 1) ^ 0x04c11db7;
//            else
//                crc <<= 1;
//        }
//        crc &= 0xFFFFFFFF;
//    }
//    return(crc);
//}

//STM32ӲCRC32 byteݼ,Ƶλ,λFF  
u32 stm32_crc32_byte(u8 *pBuff, u32 len)  
{  
    u32 i;  
    u8 buff[4];  
    u32 *p32 = (u32 *)buff;  
      
	RCC_AHBPeriphClockCmd(RCC_AHBPeriph_CRC, ENABLE);//CRCӲʱ
    CRC->CR = 1; //λCRCĴ  
    buff[0] = buff[1] = buff[2] = buff[3] = 0XFF;  
    for(i = 0;i < len;i ++)  
    {  
        buff[3] = pBuff[i];  
        CRC->DR = *p32;  
    }  
    return CRC->DR;  
}  

//STM32ӲCRC32 u32ݼ  
u32 stm32_crc32(u32 *pBuff, u32 len)  
{  
    u32 i;  
  
	RCC_AHBPeriphClockCmd(RCC_AHBPeriph_CRC, ENABLE);//CRCӲʱ
    CRC->CR = 1; //λCRCĴ  
    for(i = 0;i < len;i ++)  
    {  
        CRC->DR = pBuff[i];  
    }  
    return CRC->DR;  
}  
  
//CRC32 u32ݼ  
u32 crc32(u32 *ptr, u32 len)  
{  
    u32 CRC32=0xFFFFFFFF;  
    u32 xbit,data,bits,i;  
    const u32 dwPolynomial = 0x04c11db7;  
      
    for(i = 0;i < len;i ++)  
    {  
        xbit = (u32)1 << 31;  
        data = ptr[i];  
        for (bits = 0; bits < 32; bits++)   
        {  
            if (CRC32 & 0x80000000) {  
                CRC32 <<= 1;  
                CRC32 ^= dwPolynomial;  
            }  
            else  
                CRC32 <<= 1;  
            if (data & xbit)  
                CRC32 ^= dwPolynomial;  
  
            xbit >>= 1;  
        }  
    }  
    return CRC32;  
}  

//CRC32 byteݼ,Ƶλ,λFF  
u32 crc32_byte(u8 *ptr, u32 len)  
{  
    u32 CRC32=0xFFFFFFFF;//ֵ  
    u32 xbit,bits,data,i;  
    u8 buff[4];  
    u32 *p32 = (u32 *)buff;  
    const u32 dwPolynomial = 0x04c11db7;  
      
    buff[0] = buff[1] = buff[2] = buff[3] = 0XFF;  
    for(i = 0;i < len;i ++)  
    {   
		xbit = (u32)1 << 31;
        buff[3] = ptr[i];  
        data = *p32;  
        for(bits = 0; bits < 32; bits++)   
        {  
            if (CRC32 & 0x80000000) 
			{  
                CRC32 <<= 1;  
                CRC32 ^= dwPolynomial;  
            }  
            else  
                CRC32 <<= 1;  
            if (data & xbit)  
                CRC32 ^= dwPolynomial;  
  
            xbit >>= 1;  
        }  
    }  
    return CRC32;  
}

//void Get_ChipID(u32* ChipID)
//{
//	ChipID[0] = *(__IO u32 *)(0x1FFFF7E8);
//	ChipID[1] = *(__IO u32 *)(0x1FFFF7EC);
//	ChipID[2] = *(__IO u32 *)(0x1FFFF7F0);
//}

u32 Get_NetworkID(void)
{
	u32 addr=0x1FFFF7E8;
//	u16 val1,val2;
	u8 ChipID[12]={0};//Դ96λID
	u8 key[16]={0};
//	u8 tmp[8]={0};
	u8 i;
	
	for(i=0;i<12;i++)//ȡоƬID
	{
		ChipID[i] = *((__IO u32 *)addr++);
	}
	MD5_String(key,(char *)ChipID);
	for(i=0;i<16;i++)//
	{
		 key[i] ^= 0x22;
	}
//	for(i=0;i<8;i++)
//	{
//		tmp[i] = key[i];
//	}
//	MD5_String(key,(char *)tmp);
//	val1=cal_crc16(key, 16);
//	for(i=0;i<8;i++)
//	{
//		tmp[i] = key[i+8];
//	}
//	MD5_String(key,(char *)tmp);
//	val2=cal_crc16(key, 16);
//	sprintf((char *)key,"%05d%05d}",val1,val2);
//	return strtol((char *)key,NULL,10);
//	return cal_crc32(key,16);
	return crc32_byte(key,16);
}

void MemSet(BYTE *p,BYTE val,u32 length)
{
	u32 i=0;
	for(i=0;i<length;i++)
	{
		p[i]=val;
	}
}

void MemCopy(BYTE *dst,BYTE *src,u32 length)
{
	u32 i=0;
	for(i=0;i<length;i++)
	{
		dst[i]=src[i];
	}
}

void NRF_CopyMac(u8 *dstMac,const u8 *srcMac)
{
	u8 i=0;
	for(i=0;i<MAC_LEN;i++)
	{
		dstMac[i]=srcMac[i];
	}
}

BOOL NRF_CmpMac(const u8 *dstMac,const u8 *srcMac)
{
	u8 i=0;
	for(i=0;i<MAC_LEN;i++)
	{
		if(dstMac[i]!=srcMac[i])
		{
			return FALSE;
		}
	}
	return TRUE;
}

//ð
void BubbleSort(u8 *arr, u16 size)
{ 
	u16 i=0,j=0, k=size-1,pos=0;//posѭһνλ    

	for(i=0;i<size-1;i++)//һҪsize-1  
	{  
		//ÿα־λҪΪ0жϺԪǷ˽  
		u8 flag=0;  

		for(j=0;j<k;j++)//ѡֵƶ
		{  
			//if(arr[j]>arr[j+1])//С
			if(arr[j]<arr[j+1])//ӴС
			{
				u8 tmp=arr[j];
				arr[j]=arr[j+1];
				arr[j+1]=tmp;
				flag=1;//ֻҪз˽flagΪ1
				pos=j;//ѭһνλjpos
			}
		}
		k=pos;
		//жϱ־λǷΪ0Ϊ0˵ԪѾ򣬾ֱreturn
		if(flag==0)
		{
			return;
		}
	}
}
