#ifndef _BSP_H
#define _BSP_H

#include "stm32f10x.h"
#include "pro_data.h"

//#define REMOTE //ʹԶ̷,עͱʹñط()
//#define VERSION_STR PRO_VERSION""__DATE__"-"__TIME__""CONFIG_IDENT_STRING;//汾Ϣ
#define	PRO_VERSION "Pro 1.1.6 "
#define	CONFIG_IDENT_STRING ""

//ȫжϵĺ
#define ENABLE_INT()	__set_PRIMASK(0)//ʹȫж
#define DISABLE_INT()	__set_PRIMASK(1)//ֹȫж
//ͬ
#define THREAD_LOCK(x)  __set_PRIMASK(x)//ȫж;0ʹ;1ֹ

//λ
//IOڲ궨
#define BITBAND(addr, bitnum) ((addr & 0xF0000000)+0x2000000+((addr &0xFFFFF)<<5)+(bitnum<<2)) 
#define MEM_ADDR(addr)  *((volatile unsigned long  *)(addr)) 
#define BIT_ADDR(addr, bitnum)   MEM_ADDR(BITBAND(addr, bitnum)) 

//IOڵַӳ
#define GPIOA_ODR_Addr (GPIOA_BASE+12) //0x4001080C 
#define GPIOB_ODR_Addr (GPIOB_BASE+12) //0x40010C0C 
#define GPIOC_ODR_Addr (GPIOC_BASE+12) //0x4001100C 

#define GPIOA_IDR_Addr (GPIOA_BASE+8) //0x40010808 
#define GPIOB_IDR_Addr (GPIOB_BASE+8) //0x40010C08 
#define GPIOC_IDR_Addr (GPIOC_BASE+8) //0x40011008 

//IOڲ,ֻԵһIO!
//ȷnֵС16!
#define PAout(n) BIT_ADDR(GPIOA_ODR_Addr,n)// 
#define PBout(n) BIT_ADDR(GPIOB_ODR_Addr,n)
#define PCout(n) BIT_ADDR(GPIOC_ODR_Addr,n)
#define PAin(n)  BIT_ADDR(GPIOA_IDR_Addr,n)// 
#define PBin(n)  BIT_ADDR(GPIOB_IDR_Addr,n) 
#define PCin(n)  BIT_ADDR(GPIOC_IDR_Addr,n)

typedef struct//ʱṹ
{
	u32 time;
	u16 date;
	u8 sec;
	u8 min;
	u8 hour;
}time_obj;

void BspInit(void);
void Idle(void);
void MemSet(BYTE *p,BYTE val,u32 length);
void MemCopy(BYTE *dst,BYTE *src,u32 length);
void PrintAddr(char *str,u8 *addr);
void PrintHex(u8 *buf,u16 len);
void CopyString(char *dststr,char *srcstr,char *str);
void GetBody(char *dststr,char *srcstr);//ȡֻ{xxxxxx}ַ
void BubbleSort(u8 *arr, u16 size);//ð
void NRF_CopyMac(u8 *dstMac,const u8 *srcMac);
BOOL NRF_CmpMac(const u8 *dstMac,const u8 *srcMac);
u8 cal_crc8(u8 *ptr, u8 len);
u8 GetDataLength(char *srcstr,char *str);
u8 Get_Nid(const u8 val);
u16 cal_crc16(u8 *pData, u16 sLen);
u16 GetNumber(char *srcstr,u8 start,u8 byte);//ȡnumber
u32 GetValue(char *srcstr,char *str);
u32 Get_NetworkID(void);

extern time_obj run_time;

#endif
