#ifndef __CONNECT_H
#define __CONNECT_H

#include "stm32f10x.h"
#include "pro_data.h"

#define LIVE_INTERVAL (3000)	//,λ10ms(60)

//esp8266
enum ESP_MODE{ESP_CLIENT,ESP_SERVER};
enum ESP_STATE{WAIT_LOGIN,LINK,BIND,LIVE,SENSOR_UPDATE,SERVER};
enum ESP_LINKMODE{UPDATE,UPLOAD};

typedef struct
{
	u32 ser_time;
	u32 timer;
	u32 last_http;
	u16 port;
	u8 state;
	u8 mode;
	u8 link;
	u8 bind;
	u8 data;//
	u8 login;
	u8 sensor;
	u8 ishttpget;
}ESP8266_obj;

typedef struct 
{
	u8 addr_a;//ڵַ
	u8 addr_b;
	u8 addr_c;
	u8 addr_d;
	u8 apiKey[18]; 
	u8 server[32];//APIַIP
	u8 ssid[16];//½·ҪssidԼ
	u8 pwd[16];
}Store_obj;

typedef struct 
{
	u8 addr;
	u8 data;
	u8 type;
}msg_obj;

void Connect_Init(void);
void ESP_Connect(void);
void ESP_SensorUpdate(u8 addr,u8 val,u8 type);
//void Msg_Get(u8 *node,u8 *val,u8 *type);
//u8 Msg_Put(u8 node,u8 val,u8 type);
u8 ESP_PostData(char *data);//send the HTTP PUT requestw
void ESP_RecvData(void);
void ESP_HandleServerPackage(void);//Server
void ESP_HandleClientPackage(void);//Client

extern char post_buff[PAYLOAD_DATA_LEN];
extern ESP8266_obj esp8266;
extern Store_obj Store_Data;

#endif
