#include "esp8266.h"
#include "timer.h"
#include "usart.h"
#include "led.h"
#include "bsp.h"

u8 sendDataFlag=0;

/*ESP8266 ģͼ
TXD    ---  PA3/USART2_RX
RXD    ---  PA2/USART2_TX
RST    ---  PA0/IOӲλ
EN     ---  PA1/IOģ;0ʾ,1ʾϵ繤
GPIO15 ---  PAx//ӵػIOΪ,
GPIO2  ---  PAx/3.3VIOΪ,
GPIO0  ---  PAx/IOģʽ;0ϵͳ,1ʾû(ATָ)
VCC    ---  3.3()
GND    ---  GND
ģȱʡ 115200;ֵ֧ķΧ110~460800bps
*/

//GPIO
void ESP_Init(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;

	RCC_APB2PeriphClockCmd(RCC_CH_PD | RCC_RESET,ENABLE);//GPIOʱ

	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;//ģʽ

	GPIO_InitStructure.GPIO_Pin = PIN_CH_PD;
	GPIO_Init(PORT_CH_PD,&GPIO_InitStructure);

	GPIO_InitStructure.GPIO_Pin = PIN_RESET;
	GPIO_Init(PORT_RESET,&GPIO_InitStructure);

	ESP_CH_PD_0();
	ESP_RESET_0();
}

//ESP8266ϵ
void ESP_PowerOn(void)
{
	ESP_CH_PD_1();
}

//ESP8266ػ
void ESP_PowerOff(void)
{
	ESP_CH_PD_0();
}

void ESP_SetSendDataFlag(u8 val)
{
	sendDataFlag=val;
}

u8 ESP_GetSendDataFlag(void)
{
	return sendDataFlag;
}

//ESP8266Ӳλ
void ESP_HardReset(void)
{
	ESP_RESET_0();
	Delay10Ms(100);//1
	ESP_RESET_1();
	if(ESP_WaitResponse("ready",500))//5
	{
		ESP_SendString("ATE0\r\n");//2DMA
		if(ESP_WaitResponse("OK",500))//5
		{
			printf("\r\nESP8266 READY\r\nCLOSE ATE\r\n");
		}
		Delay10Ms(30);//300
		ESP_SendString("AT+CWMODE=1\r\n");//link is builded
		if(ESP_WaitResponse("OK",500))//5
		{
			printf("\r\nSET CWMODE=1\r\n");
		}
		Delay10Ms(30);
	}
	else
	{
		SetLed(0xff,20,20);
		printf("\r\nESP8266ģ鲻ڻ\r\n");
	}
}

//ESP8266λ
void ESP_SoftReset(void)
{
	ESP_SendString("AT+RST\r\n");
	if(ESP_WaitResponse("ready",500))//5
	{
		ESP_SendString("ATE0\r\n");//2DMA
		if(ESP_WaitResponse("OK",500))//5
		{
			printf("\r\nESP8266 READY\r\nCLOSE ATE\r\n");
		}
		Delay10Ms(30);
	}
}

//ȴESP8266ָӦַ,԰ַ
//AckStr:Ӧַ; timeout:ʱʱ,λ10ms; ,1ɹ,0ʧ
u8 ESP_WaitResponse(char *AckStr,u16 timeout)
{
	u32 start;

	start = Get_RunTime();
	while (Get_RunTime()-start<timeout)
	{
		Idle();
		if(USART2_Recv_Flag)
		{
			USART2_Recv_Flag=0;
			//printf("%s",USART2_Recv_Buff);
			USART1_DMA_SendStr(USART2_Recv_Buff);//1DMAͳ
			if(strstr(USART2_Recv_Buff,AckStr))
			{
				return TRUE;
			}
			//else
			//{
			//	return FALSE;
			//}
		}
	}
	return FALSE;
}

//AP;ssid:AP,pwd:,timeout:ʱʱ,λ10ms;1,0K,0ʧ
u8 ESP_JoinAP(char *ssid,char *pwd,u16 timeout)
{
	u32 start;
	char buf[64]={0};

	sprintf(buf,"AT+CWJAP=\"%s\",\"%s\"\r\n",ssid,pwd);
	ESP_SendString(buf);
	start = Get_RunTime();
	while(Get_RunTime()-start<timeout)
	{
		Idle();
		if(USART2_Recv_Flag)
		{
			USART2_Recv_Flag=0;
			printf("%s",USART2_Recv_Buff);
			if(strstr(USART2_Recv_Buff,"WIFI GOT IP"))//ALREADY CONNECTED
			{
				return TRUE;
			}
			if(strstr(USART2_Recv_Buff,"ERROR")||strstr(USART2_Recv_Buff,"FAIL"))
			{
				return FALSE;
			}
		}
	}
	return FALSE;
}

//tcpӻעUDP˿ں(·ģʽ)ӵAP֮
//addr:ַIP; port:TCP ˿ں
//timeout:ʱʱ,λ10ms; 0ʧ,1tcpӳɹ
u8 ESP_StartMux(u8 type,char *addr,u16 port,u16 timeout)
{
	u32 start;
	char cmd_buf[64]={0};

	if(type==TCP) 
	{
		sprintf(cmd_buf,"AT+CIPSTART=\"TCP\",\"%s\",%d\r\n",addr,port);
	}
	if(type==UDP)
	{
		sprintf(cmd_buf,"AT+CIPSTART=\"UDP\",\"%s\",%d\r\n",addr,port);
	}
	//printf(cmd_buf);
	ESP_SendString(cmd_buf);
	start = Get_RunTime();
	while(Get_RunTime()-start<timeout)
	{
		Idle();
		if(USART2_Recv_Flag)
		{
			USART2_Recv_Flag=0;
			printf("%s",USART2_Recv_Buff);
			if(strstr(USART2_Recv_Buff,"CONNECT")||strstr(USART2_Recv_Buff,"ALREADY CONNECTED"))
			{
				return TRUE;
			}
			if(strstr(USART2_Recv_Buff,"ERROR")||strstr(USART2_Recv_Buff,"link is not valid"))//no ipûӵAP
			{
				return FALSE;
			}
		}
	}
	return FALSE;
}

//·ʱ(+CIPMUX=0)TCPUDPݰ
u8 ESP_SendTcpUdp(char *senddata,u16 timeout)
{
	u8 find=0;
	u16 len;
	u32 start;
	char buf[32]={0};

	len=strlen(senddata);
	sprintf(buf,"AT+CIPSEND=%d\r\n",len);
	ESP_SendString(buf);
	if(ESP_WaitResponse(">",300))//3
	{
		find=1;
	}
	if(find) 
	{
		Delay10Ms(1);//10
		ESP_SendString(senddata);
	}
	else 
	{
		return FALSE;
	}

	start = Get_RunTime();
	while(Get_RunTime()-start<timeout)
	{
		Idle();
		if(USART2_Recv_Flag)
		{
			USART2_Recv_Flag=0;
			printf("%s",USART2_Recv_Buff);
			if(strstr(USART2_Recv_Buff,"SEND OK"))
			{
				if(strstr(USART2_Recv_Buff," ok"))
				{
					sendDataFlag=1;//ֹݹ(С10)ʶ
				}
				return TRUE;
			}
			if(strstr(USART2_Recv_Buff,"CLOSED")||strstr(USART2_Recv_Buff,"SEND FAIL"))
			{
				return FALSE;
			}
		}
	}
	return FALSE;
}

//·ʱ(+CIPMUX=1)TCPݰ
u8 ESP_SendTcpMux(u8 chid,char *senddata,u16 timeout)
{
	u8 find=FALSE;
	u16 len;
	u32 start;
	char buf[32]={0};

	len = strlen(senddata);
	sprintf(buf,"AT+CIPSEND=%d,%d\r\n",chid,len);
	ESP_SendString(buf);
	if(ESP_WaitResponse(">",300))//3
	{
		find = TRUE;
	}
	if(find) 
	{
		Delay10Ms(1);//10
		ESP_SendString(senddata);
	}
	else 
	{
		return FALSE;
	}

	start = Get_RunTime();
	while(Get_RunTime()-start<timeout)
	{
		Idle();
		if(USART2_Recv_Flag)
		{
			USART2_Recv_Flag=0;
			printf("%s",USART2_Recv_Buff);
			if(strstr(USART2_Recv_Buff,"SEND OK"))
			{
				sprintf(buf,"AT+CIPCLOSE=%d\r\n",chid);
				ESP_SendString(buf);
				if(ESP_WaitResponse("OK",300))//3
				{
					//sendDataFlag=1;
					return TRUE;
				}
				return FALSE;
			}
			if(strstr(USART2_Recv_Buff,"CLOSED")||strstr(USART2_Recv_Buff,"SEND FAIL"))
			{
				return FALSE;
			}
		}
	}
	return FALSE;
}

u8 ESP_SendData(char *ser,u16 port,char *SendStr)
{
	u8 link_cnt=2;

	while(link_cnt)//ʧʧ˳
	{
		Idle();
		if(ESP_StartMux(TCP,ser,port,300))//tcp//3볬ʱ
		{
			if(ESP_SendTcpUdp(SendStr,1500))//15볬ʱ
			{
				return TRUE;
			}
			return FALSE;
		}
		Delay10Ms(30);//300
		link_cnt--;
	}
	return FALSE;
}

//ΪTCP,clientԶ˳ռһ
//AT+CIPMUX=1ʱܿTCP
u8 ESP_StartServer(u16 port)
{
	char cmd_buf[32]={0};
	u32 start;
	u8 num=3;
	
	Delay10Ms(30);//300
	ESP_SendString("AT+CWMODE=2\r\n");//
	if(ESP_WaitResponse("OK",300))//3볬ʱ
	{
		Delay10Ms(30);//0.3
		while(num)
		{
			Idle();
			ESP_SendString("AT+CIPMUX=1\r\n");//
			start = Get_RunTime();
			while(Get_RunTime()-start<300)//3
			{
				Idle();
				if(USART2_Recv_Flag)
				{
					USART2_Recv_Flag=0;
					printf("%s",USART2_Recv_Buff);
					if(strstr(USART2_Recv_Buff,"OK"))
					{
						Delay10Ms(30);//0.3
						sprintf(cmd_buf,"AT+CIPSERVER=1,%d\r\n",port);//TCP
						ESP_SendString(cmd_buf);
						if(ESP_WaitResponse("OK",300))//3
						{
							Delay10Ms(30);//300
							ESP_SendString("AT+CIPSTO=5\r\n");//óʱ=5
							if(ESP_WaitResponse("OK",300))//3
							{
								printf("\r\nStart Server\r\n");
								return TRUE;
							}
						}
					}
					if(strstr(USART2_Recv_Buff,"ERROR")||strstr(USART2_Recv_Buff,"link is builded"))
					{
						break;
					}
				}
			}
			Delay10Ms(30);//300
			num--;
		}
	}
	return FALSE;
}

//رserver(°治Ҫ)
u8 ESP_CloseServer(void)
{
	Delay10Ms(30);//300
	ESP_SendString("AT+CIPSERVER=0\r\n");
	if(ESP_WaitResponse("OK",300))//3
	{
		Delay10Ms(30);//300
		ESP_SendString("AT+CIPMUX=0\r\n");
		if(ESP_WaitResponse("OK",300))//3
		{
			Delay10Ms(30);//300
			ESP_SendString("AT+CWMODE=1\r\n");//link is builded
			if(ESP_WaitResponse("OK",300))//3
			{
				printf("\r\nClose Server\r\n");
				return TRUE;
			}
		}
	}
	return FALSE;
}
