#ifndef __ESP8266_H
#define __ESP8266_H

#include "stm32f10x.h"

#define UDP 0
#define TCP 1

//#define ESP_SendString(message) USART2_SendStr(message)
#define ESP_SendString(message) USART2_DMA_SendStr(message)

//EN,IOģ,0ʾ; 1ʾϵ繤
#define RCC_CH_PD 		RCC_APB2Periph_GPIOA
#define PORT_CH_PD		GPIOA
#define PIN_CH_PD		GPIO_Pin_1

//RSTλ
#define RCC_RESET 		RCC_APB2Periph_GPIOA
#define PORT_RESET		GPIOA
#define PIN_RESET		GPIO_Pin_0

//ENӲ,3.3Vʼ 
#define ESP_CH_PD_0()	GPIO_ResetBits(PORT_CH_PD,PIN_CH_PD);
#define ESP_CH_PD_1()	GPIO_SetBits(PORT_CH_PD,PIN_CH_PD);

//RSTӲλ
#define ESP_RESET_0()	GPIO_ResetBits(PORT_RESET,PIN_RESET);
#define ESP_RESET_1()	GPIO_SetBits(PORT_RESET,PIN_RESET);

//ⲿõĺ
void ESP_Init(void);
void ESP_HardReset(void);
void ESP_SoftReset(void);
void ESP_PowerOn(void);
void ESP_PowerOff(void);
void ESP_SetSendDataFlag(u8 val);
u8 ESP_GetSendDataFlag(void);
u8 ESP_WaitResponse(char *AckStr, u16 timeout);//ȴESP8266ָӦַ
u8 ESP_JoinAP(char *ssid, char *pwd, u16 timeout);//AP
u8 ESP_StartMux(u8 type, char *addr, u16 port, u16 timeout);//tcpӻעUDP˿ں,·ģʽ
u8 ESP_SendTcpUdp(char *str, u16 timeout);//·ʱ(+CIPMUX=0)TCPUDPݰ
u8 ESP_SendTcpMux(u8 chid, char *senddata, u16 timeout);//·ʱ(+CIPMUX=1)TCPݰ
u8 ESP_SendData(char *_server, u16 port, char *SendStr);//send the HTTP PUT request
u8 ESP_StartServer(u16 port);
u8 ESP_CloseServer(void);

#endif
