#ifndef __KEY_H
#define __KEY_H	 

#include "stm32f10x.h"

#define FILTER_TIME				(3)		//30
#define LEARN_TIME				(300)	//3
#define CLEAR_TIME				(800)	//8
#define NEXT_WAIT_INTERVAL		(80)	//800
#define LEARN_WAIT_INTERVAL		(1000)	//10

#pragma pack(1)
typedef struct
{
	u32 interval_time_a;
	u32 interval_time_b;
	u32 interval_time_c;
	u32 interval_time_d;
	u32 time_x;
	u32 time_a;
	u32 time_b;
	u32 time_c;
	u32 time_d;
	u8 learn_a;
	u8 learn_b;
	u8 learn_c;
	u8 learn_d;
	u8 flag_a;
	u8 flag_b;
	u8 flag_c;
	u8 flag_d;
	u8 flag_x;
}key_obj;
#pragma pack()

//GPIO˿
#define RCC_KEY		RCC_APB2Periph_GPIOA
#define PORT_KEY	GPIOA
#define PIN_KEY		GPIO_Pin_5 

#define RCC_KEY_A	RCC_APB2Periph_GPIOA
#define PORT_KEY_A	GPIOA
#define PIN_KEY_A	GPIO_Pin_6 

#define RCC_KEY_B	RCC_APB2Periph_GPIOA
#define PORT_KEY_B	GPIOA
#define PIN_KEY_B	GPIO_Pin_7 

#define RCC_KEY_C	RCC_APB2Periph_GPIOB
#define PORT_KEY_C	GPIOB
#define PIN_KEY_C	GPIO_Pin_6 

#define RCC_KEY_D	RCC_APB2Periph_GPIOB
#define PORT_KEY_D	GPIOB
#define PIN_KEY_D	GPIO_Pin_7 

//#define KEY0 PBin(5)  //PB5
#define KEY0  GPIO_ReadInputDataBit(PORT_KEY,PIN_KEY)//ȡ
#define KEY_A  GPIO_ReadInputDataBit(PORT_KEY_A,PIN_KEY_A)//ȡ
#define KEY_B  GPIO_ReadInputDataBit(PORT_KEY_B,PIN_KEY_B)//ȡ
#define KEY_C  GPIO_ReadInputDataBit(PORT_KEY_C,PIN_KEY_C)//ȡ
#define KEY_D  GPIO_ReadInputDataBit(PORT_KEY_D,PIN_KEY_D)//ȡ

void KEY_Init(void);//IOʼ
void Key_Scan(void);

extern key_obj Key;

#endif
