#include "pro_hal.h"
#include "pro_data.h"
#include "Pro_interface.h"
#include "timer.h"
#include "usart.h"
#include "bsp.h"
#include "aes.h"

void NRF_Config(const u8 *addr,const u8 channel)
{
	NRF_GPIO_Init();
	NRF_EXTIX_Init();
	TranFinish_flag=FALSE;
	Timeout=FALSE;
	NRF_CE = 0;
	NRF_PowerDown();//ģʽ
	NRF_WriteReg(EN_AA, 0x01);//ʹͨ0ԶӦ
//	NRF_WriteReg(EN_RXADDR, 0x3f);//ʹͨĽյַ 
	NRF_WriteReg(EN_RXADDR, 0x03);//ʹ0,1Ľյַ 
	NRF_WriteReg(SETUP_RETR, 0x71);//ȴ2000us,ط1(250Kbps=2000us)
	NRF_WriteReg(SETUP_AW, 0x03);//ַ5
	NRF_WriteReg(RF_SETUP, 0x27);//TX,0db,250Kbps,濪
//	NRF_WriteReg(RF_SETUP, 0x21);//TX,250Kbps,-18db,濪
	NRF_WriteReg(STATUS, IRQ_ALL);//״̬־
	NRF_ReadReg(FLUSH_RX);//FIFO
	NRF_ReadReg(FLUSH_TX);//巢FIFO
	if((!NRF_ReadReg(FEATRUE))&&(!NRF_ReadReg(DYNPD)))
	{
		SPI_ReadWriteByte(ACTIVATE);
		SPI_ReadWriteByte(0x73);//R_RX_PL_WID,W_ACK_PAYLOAD,W_TX_PAYLOAD_NOACK
	}
	NRF_WriteReg(DYNPD, 0x3f);//ͨʹ̬ܶ
	NRF_WriteReg(FEATRUE, 0x06);//ʹ̬ܶ,ʹӦ
	NRF_WriteBuf(RX_ADDR_P0, addr, MAC_LEN);//дͨ0,RXַ
	NRF_DelayUs(2000);//ģʽ->ģʽǰ뾭1.5msĴģʽ
	NRF_RxMode(addr, channel);//ʼΪģʽ
	NRF_DelayUs(150);//ģʽ->/ģʽ130us
}

u8 NRF_Check(void)
{
	u8 buf[5]={0X95,0X94,0X93,0X92,0X91};
	u8 i;
		 
	NRF_WriteBuf(TX_ADDR,buf,5);//д5ֽڵĵַ.	
	NRF_ReadBuf(TX_ADDR,buf,5); //дĵַ  
	for(i=0;i<5;i++)
	{
		if(buf[i]!=0X95-i)
			break;	
	}		
	if(i!=5)
		return FALSE;	//24L01	
	return TRUE;		//⵽24L01
}

u8 NRF_CheckReg(void)
{
	if(NRF_ReadReg(CONFIG)!=0x0b) 
		return FALSE;
	if(NRF_ReadReg(EN_AA)!=0x01) 
		return FALSE;
	if(NRF_ReadReg(EN_RXADDR)!=0x03) 
		return FALSE;
	if(NRF_ReadReg(SETUP_AW)!=0x03) 
		return FALSE;
	if(NRF_ReadReg(SETUP_RETR)!=0x71) 
		return FALSE;
	if(NRF_ReadReg(RF_SETUP)!=0x27) 
		return FALSE;
	if(NRF_ReadReg(STATUS)!=0x0e) 
		return FALSE;
	if(NRF_ReadReg(FIFO_STATUS)!=0x11) 
		return FALSE;
	return TRUE;
}

//void NRF_SetPipe1To4Mac(const u8 *addr)
//{
//	NRF_CE = 0;
//	NRF_WriteBuf(RX_ADDR_P1, addr, MAC_LEN);//дͨ1,RXַ
//	NRF_WriteReg(RX_ADDR_P2, addr[0]-1);//дͨ2,RXַ
//	NRF_WriteReg(RX_ADDR_P3, addr[0]-2);//дͨ3,RXַ
//	NRF_WriteReg(RX_ADDR_P4, addr[0]-3);//дͨ4,RXַ
//	NRF_WriteReg(CONFIG, 0x0B);//ģʽ
//	NRF_CE = 1;
//}

u8 NRF_SetRfPower(const u8 level)//(0-3)
{
	u8 state,power;
	
	if(level<4)
	{
		NRF_CE = 0;
		power=level;
		state=NRF_ReadReg(RF_SETUP);//
		state&=0XF9;//powerλ(B11111001)
		power&=0x03;//power(B00000011)
		NRF_WriteReg(RF_SETUP, state|(power<<1));//powerλ
		return state;
	}
	return FALSE;
}

u8 NRF_ReadChannel(void)
{
	return NRF_ReadReg(RF_CH);//Ƶ
}

void NRF_SetChannel(const u8 channel)
{
	if(channel<126)
	{
		//NRF_CE = 0;
		NRF_WriteReg(RF_CH, channel);//RFͨƵ
	}
}

//⵱ǰƵⲿźǿ
u8 NRF_DisturbanceDetect(void)
{
	NRF_CE = 0;
	NRF_DelayUs(1);
	NRF_WriteReg(CONFIG, 0x0B);//RCRC:8,ģʽ
	NRF_CE = 1;
	NRF_DelayUs(200);//ģʽ->ģʽ(130us)+40us
	return NRF_ReadReg(CD);
}

//
u8 NRF_SendPayload(const u8 ack,const u8 *addr,const u8 channel,const u8 *buf)
{
	u16 i=1;
	u8 k;
	
	printf("MAC:");
	for(k=0;k<MAC_LEN;k++)
	{
		printf("%02X ",addr[k]);
	}
	printf("\r\n");
	
	NRF_CE = 0;
	NRF_WriteBuf(TX_ADDR, addr, MAC_LEN);//дTXڵַ
	if(ack)
	{
		NRF_WriteBuf(RX_ADDR_P0, addr, MAC_LEN);//дͨ0,RXַ
	}
	NRF_WriteReg(RF_CH, channel);//RFͨƵ
	NRF_WriteReg(STATUS, IRQ_ALL);//״̬־
	NRF_ReadReg(FLUSH_RX);//FIFO
	NRF_ReadReg(FLUSH_TX);//巢FIFO
	NRF_WriteBuf(W_TX_PAYLOAD, buf, PAYLOAD_LEN);
	NRF_WriteReg(CONFIG, 0x0A);//RX_DR,TX_DS,MAX_RTжʹ,CRC:8,POWER_UP,ģʽ
	NRF_CE = 1;//CEΪ,CEߵƽʱСΪ10us
	NRF_DelayUs(10);
	while(i++)
	{
		if(TranFinish_flag)
		{
			TranFinish_flag = FALSE;
			return TRUE;
		}
		if(Timeout)
		{
			Timeout = FALSE;
			return FALSE;
		}
	}
	NRF_ReadReg(FLUSH_TX);//巢FIFO
	NRF_WriteReg(STATUS, IRQ_ALL);//״̬־
	return FALSE;
}

//ģʽ
void NRF_RxMode(const u8 *addr,const u8 channel)
{
	NRF_CE = 0;
	NRF_WriteBuf(RX_ADDR_P0, addr, MAC_LEN);//дRXڵַ
	NRF_WriteReg(RF_CH, channel);//RFͨƵ
	NRF_ReadReg(FLUSH_RX);//FIFO
	NRF_WriteReg(CONFIG, 0x0B);//RX_DR,TX_DS,MAX_RTжʹ,CRC:8,POWER_UP,ģʽ
	NRF_CE = 1;//CEΪ,ģʽ
}

void NRF_PowerDown(void)
{
	NRF_CE = 0;
	NRF_WriteReg(CONFIG, 0x79);//RX_DR,TX_DS,MAX_RTж,CRC:8,POWER_DOWN,ģʽ
}

//void NRF_DelayUs(u16 i)
//{
//	u16 k,j;
//	for(k=0;k<i;k++)
//	{
//		for(j=0;j<9;j++);
//	}
//}
