#ifndef _PRO_HAL_H
#define _PRO_HAL_H

#include "stm32f10x.h"

//NRF24L01Ĵ //SPI commands for nRF24L01
#define R_REGISTER         0x00  //üĴ,5λΪĴַ
#define W_REGISTER         0x20  //дüĴ,5λΪĴַ
#define R_RX_PAYLOAD       0x61  //RXЧ,1~32ֽ
#define W_TX_PAYLOAD       0xA0  //дTXЧ,1~32ֽ
#define FLUSH_TX           0xE1  //TX FIFOĴ.ģʽ
#define FLUSH_RX           0xE2  //RX FIFOĴ.ģʽ
#define REUSE_TX_PL        0xE3  //ʹһ,CEΪ,ݰϷ
#define ACTIVATE	       0x50  //0x73R_RX_PL_WIDW_ACK_PAYLOADW_TX_PAYLOAD_NOACK
								 //ٴʹøͬݣر
#define R_RX_PL_WID        0x60  //յݳ
#define W_ACK_PAYLOAD      0xA8  //дӦ
#define W_TX_PAYLOAD_NOACK 0xB0  //дTX,Ӧ
#define NOP                0xFF  //ղ,״̬Ĵ

//NRF24L01Ĵַ
#define CONFIG        0x00  //üĴ;bit0:1ģʽ,0ģʽ;bit1:ѡ;bit2:CRCģʽ;bit3:CRCʹ;
                            //bit4:жMAX_RT(طж)ʹ;bit5:жTX_DSʹ;bit6:жRX_DRʹ
#define EN_AA         0x01  //ʹԶӦ;bit0~5,Ӧͨ0~5
#define EN_RXADDR     0x02  //յַ;bit0~5,Ӧͨ0~5
#define SETUP_AW      0x03  //õַ(ͨ);bit1:0;00,3ֽ;01,4ֽ;02,5ֽ;
#define SETUP_RETR    0x04  //Զط;bit3:0;Զط;bit7:4,Զطʱ 250*x+86us
#define RF_CH         0x05  //RFͨ;bit6:0;ͨƵ;
#define RF_SETUP      0x06  //RFĴ;bit3:(0:1Mbps,1:2Mbps);bit2:1,书;bit0:Ŵ
#define STATUS        0x07  //״̬Ĵ;bit0:TX FIFO־;bit3:1,ͨ(:6);bit4,ﵽط
                            //bit5:ݷж;bit6:ж;
#define OBSERVE_TX    0x08  //ͼĴ,bit7:4,ݰʧ;bit3:0,ط
#define CD            0x09  //زĴ,bit0,ز;
#define RX_ADDR_P0    0x0A  //ͨ0յַ,󳤶5ֽ,ֽǰ
#define RX_ADDR_P1    0x0B  //ͨ1յַ,󳤶5ֽ,ֽǰ
#define RX_ADDR_P2    0x0C  //ͨ2յַ,ֽڿ,ֽ,ͬRX_ADDR_P1[39:8];
#define RX_ADDR_P3    0x0D  //ͨ3յַ,ֽڿ,ֽ,ͬRX_ADDR_P1[39:8];
#define RX_ADDR_P4    0x0E  //ͨ4յַ,ֽڿ,ֽ,ͬRX_ADDR_P1[39:8];
#define RX_ADDR_P5    0x0F  //ͨ5յַ,ֽڿ,ֽ,ͬRX_ADDR_P1[39:8];
#define TX_ADDR       0x10  //͵ַ(ֽǰ),ShockBurstTMģʽ,RX_ADDR_P0˵ַ
#define RX_PW_P0      0x11  //ͨ0Чݿ(1~32ֽ),Ϊ0Ƿ
#define RX_PW_P1      0x12  //ͨ1Чݿ(1~32ֽ),Ϊ0Ƿ
#define RX_PW_P2      0x13  //ͨ2Чݿ(1~32ֽ),Ϊ0Ƿ
#define RX_PW_P3      0x14  //ͨ3Чݿ(1~32ֽ),Ϊ0Ƿ
#define RX_PW_P4      0x15  //ͨ4Чݿ(1~32ֽ),Ϊ0Ƿ
#define RX_PW_P5      0x16  //ͨ5Чݿ(1~32ֽ),Ϊ0Ƿ
#define FIFO_STATUS   0x17  //FIFO״̬Ĵ;bit0,RX FIFOĴձ־;bit1,RX FIFO־;bit2,3,
                            //bit4,TX FIFOձ־;bit5,TX FIFO־;bit6,1,ѭһݰ.0,ѭ;
#define DYNPD         0x1C  //ʹ̬ܶݳͨ,bit0~5,Ӧͨ0~5
#define FEATRUE       0x1D  //bit2,ʹ̬ܶݳ;bit1,ʹӦ;bit0,ʹݲӦ;

#define MAX_RT        0x10  //ﵽʹж
#define TX_DS         0x20  //TXж
#define RX_DR         0x40  //յж

#define RX_P_NO_MASK  0x0E
#define IRQ_ALL       (TX_DS|RX_DR|MAX_RT)
#define IS_ACK        1
#define NO_ACK        0

#define DataPipe0     0
#define DataPipe1     1
#define DataPipe2     2
#define DataPipe3     3
#define DataPipe4     4
#define DataPipe5     5
#define TxPipe        6

void NRF_PowerDown(void);
void NRF_Config(const u8 *addr,const u8 channel);//ʼ
void NRF_RxMode(const u8 *addr,const u8 channel);//Ϊģʽ
void NRF_SetChannel(const u8 channel);
void NRF_SetPipe1To4Mac(const u8 *addr);
//void NRF_DelayUs(u16 i);
u8 NRF_Check(void);
u8 NRF_CheckReg(void);
u8 NRF_SetRfPower(const u8 level);
u8 NRF_ReadChannel(void);
u8 NRF_SendPayload(const u8 ack,const u8 *addr,const u8 channel,const u8 *buf);//
u8 NRF_DisturbanceDetect(void);//⵱ǰƵⲿźǿ

#endif
