#include "Pro_interface.h"
#include "pro_data.h"
#include "pro_hal.h"
#include "pro_phy.h"
#include "bsp.h"

volatile u8 TranFinish_flag,Timeout;

//ʼ24L01IO
void NRF_GPIO_Init(void)
{ 	
	GPIO_InitTypeDef GPIO_InitStructure;
	SPI_InitTypeDef  SPI_InitStructure;

	RCC_APB2PeriphClockCmd(NRF_CE_GPIO_CLK|NRF_CSN_GPIO_CLK | NRF_SPI_MOSI_GPIO_CLK | NRF_SPI_MISO_GPIO_CLK |
							NRF_SPI_SCK_GPIO_CLK | RCC_APB2Periph_AFIO, ENABLE);
	//RCC_APB2PeriphClockCmd(NRF_SPI_CLK, ENABLE);//SPI1ʱʹ
	RCC_APB1PeriphClockCmd(NRF_SPI_CLK, ENABLE);//SPI2ʱʹ

	GPIO_InitStructure.GPIO_Pin = NRF_SPI_SCK_PIN;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init(NRF_SPI_SCK_GPIO_PORT, &GPIO_InitStructure);

	GPIO_InitStructure.GPIO_Pin = NRF_SPI_MISO_PIN;
	GPIO_Init(NRF_SPI_MISO_GPIO_PORT, &GPIO_InitStructure);

	GPIO_InitStructure.GPIO_Pin = NRF_SPI_MOSI_PIN;
	GPIO_Init(NRF_SPI_MOSI_GPIO_PORT, &GPIO_InitStructure);

	GPIO_InitStructure.GPIO_Pin = NRF_CSN_PIN;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init(NRF_CSN_GPIO_PORT, &GPIO_InitStructure);

	GPIO_InitStructure.GPIO_Pin = NRF_CE_PIN;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init(NRF_CE_GPIO_PORT, &GPIO_InitStructure);

	SPI_Cmd(NRF_SPI, DISABLE);
	SPI_InitStructure.SPI_Direction = SPI_Direction_2Lines_FullDuplex;
	SPI_InitStructure.SPI_Mode = SPI_Mode_Master;
	SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b;
	SPI_InitStructure.SPI_CPOL = SPI_CPOL_Low;
	SPI_InitStructure.SPI_CPHA = SPI_CPHA_1Edge;
	SPI_InitStructure.SPI_NSS = SPI_NSS_Soft;
	SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_16;
	SPI_InitStructure.SPI_FirstBit = SPI_FirstBit_MSB;
	SPI_InitStructure.SPI_CRCPolynomial = 7;
	SPI_Init(NRF_SPI, &SPI_InitStructure);

	SPI_Cmd(NRF_SPI, ENABLE);
	SPI_SetSpeed(SPI_BaudRatePrescaler_8);//spiٶΪ9Mhz24L01SPIʱΪ10Mhz
	
	NRF_CE=0;
	NRF_CSN=1;//SPIƬѡȡ	
}

void NRF_EXTIX_Init(void)
{ 
	EXTI_InitTypeDef EXTI_InitStructure;
	NVIC_InitTypeDef NVIC_InitStructure;
	GPIO_InitTypeDef GPIO_InitStructure;
	 
	RCC_APB2PeriphClockCmd(NRF_IRQ_GPIO_CLK|RCC_APB2Periph_AFIO, ENABLE);

	GPIO_InitStructure.GPIO_Pin = NRF_IRQ_PIN;
	//GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU;//ó
	GPIO_Init(NRF_IRQ_GPIO_PORT, &GPIO_InitStructure);
	GPIO_EXTILineConfig(NRF_IRQ_EXTI_PORT_SOURCE, NRF_IRQ_EXTI_PIN_SOURCE);

	EXTI_InitStructure.EXTI_Line = NRF_IRQ_EXTI_LINE;
	EXTI_InitStructure.EXTI_Mode = EXTI_Mode_Interrupt;
	EXTI_InitStructure.EXTI_Trigger = EXTI_Trigger_Falling;
	EXTI_InitStructure.EXTI_LineCmd = ENABLE;
	EXTI_Init(&EXTI_InitStructure);

	NVIC_InitStructure.NVIC_IRQChannel = NRF_IRQ_EXTI_IRQn;
	NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;//ռȼ
	NVIC_InitStructure.NVIC_IRQChannelSubPriority = 1;//Ӧȼ
	NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
	NVIC_Init(&NVIC_InitStructure); 
}

//SPI ٶú
//SpeedSet:
//SPI_BaudRatePrescaler_2   2Ƶ   
//SPI_BaudRatePrescaler_8   8Ƶ   
//SPI_BaudRatePrescaler_16  16Ƶ  
//SPI_BaudRatePrescaler_256 256Ƶ 
void SPI_SetSpeed(const u8 SPI_BaudRatePrescaler)
{
	assert_param(IS_SPI_BAUDRATE_PRESCALER(SPI_BaudRatePrescaler));
	NRF_SPI->CR1&=0XFFC7;
	NRF_SPI->CR1|=SPI_BaudRatePrescaler;//NRF_SPIٶ 
	SPI_Cmd(NRF_SPI,ENABLE); 
} 

//SPIx дһֽ
//TxData:Ҫдֽ
//ֵ:ȡֽ
u8 SPI_ReadWriteByte(const u8 TxData)
{		
	u8 retry=0;
	
	while(SPI_I2S_GetFlagStatus(NRF_SPI, SPI_I2S_FLAG_TXE) == RESET)//ָSPI־λ:ͻձ־λ
	{
		retry++;
		if(retry>200)
		{
			return 0;
		}
	}			  
	SPI_I2S_SendData(NRF_SPI, TxData);//ͨSPIxһ
	retry=0;

	while(SPI_I2S_GetFlagStatus(NRF_SPI, SPI_I2S_FLAG_RXNE) == RESET)//ָSPI־λ:ܻǿձ־λ
	{
		retry++;
		if(retry>200)
		{
			return 0;
		}
	}
	return SPI_I2S_ReceiveData(NRF_SPI);//ͨSPIxյ
}

//ȡSPIĴֵ
u8 NRF_ReadReg(const u8 reg)
{
	u8 reg_val;
	
 	NRF_CSN = 0;//ʹSPI
	SPI_ReadWriteByte(R_REGISTER|reg);//ͼĴ
	reg_val = SPI_ReadWriteByte(0XFF);//ȡĴ
	NRF_CSN = 1;//ֹSPI
	return(reg_val);//״ֵ̬
}

//SPIдĴ
u8 NRF_WriteReg(const u8 reg,const  u8 value)
{
	u8 status;
	
	NRF_CSN = 0;//ʹSPI
	status = SPI_ReadWriteByte(W_REGISTER|reg);//ͼĴ
	SPI_ReadWriteByte(value);//дĴֵ
	NRF_CSN = 1;//ֹSPI
	return(status);//״ֵ̬
}

//ָλöָȵ
//ض״̬Ĵֵ 
u8 NRF_ReadBuf(const u8 reg, u8 *pBuf, const u8 len)
{
	u8 status,i;
	
	NRF_CSN = 0;//ʹSPI
	status=SPI_ReadWriteByte(R_REGISTER|reg);//ͼĴֵ(λ),ȡ״ֵ̬
 	for(i=0; i<len; i++)
	{
		pBuf[i] = SPI_ReadWriteByte(0XFF);//
	}
	NRF_CSN = 1;//رSPI
	return status;//ض״ֵ̬
}

//ָλдָȵ
//ض״̬Ĵֵ
u8 NRF_WriteBuf(const u8 reg,const u8 *pBuf,const u8 len)
{
	u8 status,i;
	
 	NRF_CSN = 0;//ʹSPI
	status = SPI_ReadWriteByte(W_REGISTER|reg);//ͼĴֵ(λ),ȡ״ֵ̬
	for(i=0; i<len; i++)
	{
		SPI_ReadWriteByte(*pBuf++);//д
	}
	NRF_CSN = 1;//رSPI
	return status;//ض״ֵ̬
}

void NRF_InterruptHandler(void)
{
	u8 status;
	
	status = NRF_ReadReg(STATUS);//״̬Ĵ,жж״̬
	if(status & RX_DR)//յ
	{
		NRF_RecvData();
	}
	if(status & TX_DS)//
	{
		TranFinish_flag=TRUE;
	}
	if(status & MAX_RT)//ط
	{
		Timeout=TRUE;
		NRF_ReadReg(FLUSH_TX);//巢FIFO
	}
	NRF_WriteReg(STATUS, status);//״̬־
}

//ⲿжϷ
void EXTI9_5_IRQHandler(void)
{
	if(EXTI_GetITStatus(EXTI_Line8) != RESET)//RFж
	{
		NRF_InterruptHandler();//жϴ
		EXTI_ClearITPendingBit(EXTI_Line8);
	}
}
