#ifndef _PRO_MEMORY_H
#define _PRO_MEMORY_H

#include "stm32f10x.h"
#include "pro_data.h"

#define FLASH_BASE_ADDR				(0x08000000) //STM32 FLASHʼַ
#define FLASH_SECTOR_SIZE			(1024) //ֽ
#define FLASH_STORE_START_SECTOR	(127) //C8T6(0-127)

#define PRO_STORE_FLAG				0x88993355
#define PRO_STORE_FLASH_ADDRESS		(FLASH_BASE_ADDR+FLASH_SECTOR_SIZE*FLASH_STORE_START_SECTOR)

void NRF_ClearStroreData(const u32 addr);
void EE_FlashRead(u32 addr,u8 *buf,u16 len);
BOOL NRF_IsHaveStoreData(const u32 flag,const u32 addr);
u16 NRF_ReadDataFromStore(const u32 flag,const u32 addr,u8 *buf,u16 len);
u16 NRF_WriteDataToStore(const u32 flag,const u32 addr,const u8 *buf,const u16 len);

#endif
