#include "pro_phy.h"
#include "pro_data.h"
#include "pro_hal.h"
#include "pro_memory.h"
#include "Pro_interface.h"
#include "timer.h"
#include "usart.h"
#include "led.h"
#include "bsp.h"
#include "md5.h"
#include "aes.h"

NODESTATUS NodeStatus;//ڵ״̬
static HeartTable heart_table[MAX_NODE_NUM];
static RoutrTable route_table[MAX_NODE_NUM];
static PathTable path_table[MAX_NODE_NUM];
static LOST_CONNECTION lost_conn[MAX_NODE_NUM];
static HANDLEMULTIPACK IsHandle[DATA_BUF_COUNT];
static DATA_BUF DataBuf[DATA_BUF_COUNT];//ݻ,󳤶PAYLOAD_DATA_LEN
static u8 ThreadLock=0;
//static u8 node_type=NODE;
static u8 pipe1_mac[MAC_LEN]={0x00,0xB9,0x7F,0x55,0xB0};//ͨ1ַ(ڵ)
static u8 pipe2_mac[MAC_LEN]={0xFF,0xB9,0x7F,0x55,0xB0};//ͨ2ַ(нڵ),ַ
static HANDLERECECALLBACK RecvHandler=NULL;
static HANDLESENDCALLBACK SendHandler=NULL;

void NRF_Init(void)//ʼЭ
{
	MemSet((BYTE *)&NodeStatus,0,sizeof(NODESTATUS));//ʼڵ״̬
	MemSet((BYTE *)&DataBuf,0,sizeof(DATA_BUF)*DATA_BUF_COUNT);//ʼΪ״̬
	MemSet((BYTE *)&IsHandle,0,sizeof(HANDLEMULTIPACK)*DATA_BUF_COUNT);
	MemSet((BYTE *)&lost_conn,0,sizeof(LOST_CONNECTION)*MAX_NODE_NUM);
	MemSet((BYTE *)&heart_table,0,sizeof(HeartTable)*MAX_NODE_NUM);
	MemSet((BYTE *)&route_table,0,sizeof(RoutrTable)*MAX_NODE_NUM);
	NodeStatus.addr=0x01;//ʼַ
	NodeStatus.channel=124;//ʼŵ124,ŵ0-124
	NodeStatus.pwd=Get_NetworkID();
	NRF_GetMacAddr(NodeStatus.node_mac,NodeStatus.addr);//ȡmacַ(RX)
	NRF_Config(NodeStatus.node_mac,NodeStatus.channel);//Ӳʼ
	NRF_SetPipe1Mac(pipe1_mac);
//	NRF_SetPipe2Mac(pipe2_mac);
	if(!NRF_Check())
	{
		SetLed(0xff,20,20);
		printf("\r\nNRF24L01+ģ鲻ڻ\r\n");
	}
}

void NRF_SetPipe1Mac(u8 *addr)
{
	NRF_CE = 0;
	NRF_GetMacAddr(addr,0xff);//MACַ
	if(addr[0]==0xFF)
	{
		addr[0]-=1;
	}
	NRF_WriteBuf(RX_ADDR_P1, addr, MAC_LEN);//дͨ1,RXַ
	NRF_WriteReg(CONFIG, 0x0B);//ģʽ
	NRF_CE = 1;
}

//void NRF_SetPipe2Mac(u8 *addr)
//{
//	NRF_CE = 0;
//	NRF_WriteReg(RX_ADDR_P2, addr[0]);//дͨ2,RXַ
//	NRF_WriteReg(CONFIG, 0x0B);//ģʽ
//	NRF_CE = 1;
//}

void NRF_InitRoutrTable(void)//ʼ·ɱ
{
	MemSet((BYTE *)&heart_table,0,sizeof(HeartTable)*MAX_NODE_NUM);
	MemSet((BYTE *)&route_table,0,sizeof(RoutrTable)*MAX_NODE_NUM);
}

void NRF_SetDefaultRecvHandler(HANDLERECECALLBACK pFun)
{
	RecvHandler=pFun;
}

void NRF_SetDefaultSendHandler(HANDLESENDCALLBACK pFun)
{
	SendHandler=pFun;
}

u8 NRF_GetThreadLockState(void)
{
	return ThreadLock;
}

void NRF_SetThreadLockState(u8 val)
{
	ThreadLock=val;
}

void NRF_CalcCols(u8 *col,u8 addr)
{
	u8 i;

	for(i = 5; i > 0; i--)
	{
		*col = (*col << 1) ^ addr;
		col++;
	}
}

void NRF_InvMixColumn(u8 *column,u8 addr)
{
	u8 r[5];

	r[0] = column[1] ^ column[2] ^ column[3] ^ column[4];
	r[1] = column[0] ^ column[2] ^ column[3] ^ column[4];
	r[2] = column[0] ^ column[1] ^ column[3] ^ column[4];
	r[3] = column[0] ^ column[1] ^ column[2] ^ column[4];
	r[4] = column[0] ^ column[1] ^ column[2] ^ column[3];

	NRF_CalcCols(column,addr);

	r[0] ^= column[0] ^ column[1];
	r[1] ^= column[1] ^ column[2];
	r[2] ^= column[2] ^ column[3];
	r[3] ^= column[3] ^ column[4];
	r[4] ^= column[4] ^ column[0];

	NRF_CalcCols(column,addr);

	r[0] ^= column[0] ^ column[2];
	r[1] ^= column[1] ^ column[3];
	r[2] ^= column[2] ^ column[4];
	r[3] ^= column[3] ^ column[0];
	r[4] ^= column[4] ^ column[1];

	NRF_CalcCols(column,addr);

	column[0] ^= column[1] ^ column[2] ^ column[3] ^ column[4];
	r[0] ^= column[0];
	r[1] ^= column[0];
	r[2] ^= column[0];
	r[3] ^= column[0];
	r[4] ^= column[0];
	
	column[0] = r[0];
	column[1] = r[1];
	column[2] = r[2];
	column[3] = r[3];
	column[4] = r[4];
}

void NRF_GetMacAddr(u8 *mac,const u8 addr)
{
	u8 str[5]={0};
	u8 str1[10]={0};
	u8 i;
	
	sprintf((char *)str1,"%d",NodeStatus.pwd);
	if(addr>0&&addr<0xFF)
	{
		for(i=0;i<10;i++)//
		{
			 str1[i] ^= addr;
		}
		if(addr>0&&addr<128)
		{
			str[1]=(str1[0]+str1[1])<<2;
			str[2]=(str1[2]+str1[3])<<2;
			str[3]=(str1[4]+str1[5])<<2;
			str[4]=(str1[6]+str1[7])<<2;
			str[0]=(str1[8]+str1[9])<<2;
		}
		if(addr>=128&&addr<0xFF)
		{
			str[1]=str1[0]+str1[1];
			str[2]=str1[2]+str1[3];
			str[3]=str1[4]+str1[5];
			str[4]=str1[6]+str1[7];
			str[0]=str1[8]+str1[9];
		}
		NRF_InvMixColumn(str,addr);
	}
	else 
	{
		if(addr==0xFF)
		{
			str[0]=cal_crc8(str1, 10);
			str[1]=0xB9;
			str[2]=0x7F;
			str[3]=0x55;
			str[4]=0xB0;
		}
		if(addr==0)
		{
			for(i=0;i<5;i++)
			{
				 str[i] = 0xFF;
			}
		}
	}
	//MemCopy((BYTE *)mac,(BYTE *)str,MAC_LEN);
	NRF_CopyMac(mac,str);
}

void NRF_SendData(const u8 dst_addr,const u8 type,const u8 *buf,HANDLESENDCALLBACK fun)//ݽӿ
{
	static u32 id=0;
	u8 idx;

	if(dst_addr!=NodeStatus.addr)
	{
		idx=NRF_MallocIdleDataBufId();
		if(0xFF==idx)
		{
			return;
		}
		DataBuf[idx].status=WAIT_SEND;
		DataBuf[idx].HandleCallBack=fun;
		DataBuf[idx].payload.header.PID=NodeStatus.pwd;
		DataBuf[idx].payload.header.SID=id++;//ȡΨһID
		DataBuf[idx].payload.header.the_addr=NodeStatus.addr;
		DataBuf[idx].payload.header.src_addr=NodeStatus.addr;
		DataBuf[idx].payload.header.dst_addr=dst_addr;
		DataBuf[idx].payload.header.ass_addr=dst_addr;
		DataBuf[idx].payload.header.hop_addr=0;
		DataBuf[idx].payload.header.hop_count=0;
		DataBuf[idx].payload.header.pack_type=type;
		MemCopy((BYTE *)DataBuf[idx].payload.buf,(BYTE *)buf,PAYLOAD_DATA_LEN);
		if(CHECK_LINK==type) 
			NodeStatus.heart_status=1;
		if(0xFFFFFFFF==id)
		{
			id=0;
		}
	}
}

void NRF_SendCallBack(u8 src_addr,u8 dst_addr,u8 pack_type,u16 pwd,u8 *buf,u8 status)
{
	if(status)
	{
		printf("ID=%d src=%d dst=%d type=%d OK\r\n\r\n",pwd,src_addr,dst_addr,pack_type);
	}
	else
	{
		printf("ID=%d src=%d dst=%d type=%d FAIL\r\n\r\n",pwd,src_addr,dst_addr,pack_type);
	}
}

void NRF_HeartCallBack(u8 src_addr,u8 dst_addr,u8 pack_type,u16 pwd,u8 *buf,u8 status)
{
	NodeStatus.heart_status=0;
	if(status)
	{
		printf("ID=%d Heart To %d ok\r\n\r\n",pwd,dst_addr);
	}
	else
	{
		printf("ID=%d Heart To %d fail\r\n\r\n",pwd,dst_addr);
	}
}

u8 NRF_HeartTableFindValidNode(u8 node)//Чڵ
{
	u8 i;
	
	for(i=0; i<MAX_NODE_NUM; i++)//ڵб
	{
		if(heart_table[i].addr==node)
		{
			return i;
		}
	}
	return 0xFF;
}

//0,бڵѴ; 1,ӳɹ
u8 NRF_AddNodeToHeartTable(u8 node)
{
	u8 i,idx;
	
	idx=NRF_HeartTableFindValidNode(node);
	if(0xFF==idx)//ûҵڵ(ظڵ)
	{
		for(i=0; i<MAX_NODE_NUM; i++)//ڵб
		{
			if(!heart_table[i].addr)//ҿнڵ,ӵ
			{
				heart_table[i].addr=node;
				heart_table[i].link_time=Get_RunTime();
				return TRUE;
			}
		}
		NRF_DelNodePath(node);//ɾڵ
		return FALSE;
	}
	return FALSE;
}

void NRF_UpdateHearTable(void)
{
	u8 i,j,k,pos=0;//posѭһνλ

	for(i=0; i<MAX_NODE_NUM; i++)//·ɱ
	{
		if(route_table[i].addr)//·ɱЧڵ
		{
			NRF_AddNodeToHeartTable(route_table[i].addr);
			for(j=0; j<MAX_HOP_NUM; j++)//·
			{
				if(route_table[i].path[j])//Чַ
				{
					NRF_AddNodeToHeartTable(route_table[i].path[j]);
				}
			}
		}
	}
	//ð
	k=MAX_NODE_NUM-1;
	for(i=0;i<MAX_NODE_NUM-1;i++)//һҪn  
	{  
		//ÿα־λҪΪ0жϺԪǷ˽  
		u8 flag=0;  

		for(j=0;j<k;j++)//ѡֵƶ
		{  
			if(heart_table[j].addr>heart_table[j+1].addr)
			{
				u32 time=heart_table[j].link_time;
				u8 tmp=heart_table[j].addr;

				heart_table[j].link_time=heart_table[j+1].link_time;
				heart_table[j+1].link_time=time;
				heart_table[j].addr=heart_table[j+1].addr;
				heart_table[j+1].addr=tmp;
				flag=1;//ֻҪз˽flagΪ1
				pos=j;//ѭһνλjpos
			}
		}
		k=pos;
		//жϱ־λǷΪ0Ϊ0˵ԪѾ򣬾ֱreturn
		if(flag==0)
		{
			break;
		}
	}
	for(i=0; i<MAX_NODE_NUM; i++)//
	{
		if(!heart_table[i].addr)
		{
			for(j=i+1; j<MAX_NODE_NUM; j++)
			{
				if(heart_table[j].addr)//еַƵǰ
				{
					heart_table[i].addr=heart_table[j].addr;
					heart_table[i].link_time=heart_table[j].link_time;
					heart_table[j].addr=0;
					heart_table[j].link_time=0;
					break;
				}
			}
		}
	}
}

u8 NRF_UpdateHeartTime(u8 node)
{
	u8 id;

	id=NRF_HeartTableFindValidNode(node);
	if(0xFF!=id)
	{
		heart_table[id].link_time=Get_RunTime();
		return TRUE;
	}
	return FALSE;
}

u8 NRF_UpdateToRoutrTablePath(u8 idx,LPayload pPayLoad)//·
{
	u8 k;

	MemCopy((BYTE *)route_table[idx].path,(BYTE *)pPayLoad->buf,sizeof(pPayLoad->buf));
	if(pPayLoad->header.hop_addr)//һַЧ
	{
		if(pPayLoad->header.hop_count<MAX_HOP_NUM)
		{
			for(k=0; k<MAX_HOP_NUM; k++)//·
			{
				if(!route_table[idx].path[k])//ҵλ
				{
					route_table[idx].path[k]=pPayLoad->header.hop_addr;//һַӵ·
					return TRUE;
				}
			}
		}
	}
	return FALSE;
}

//0,б; 1,ӳɹ;
u8 NRF_AddNodeToRoutrTable(LPayload pPayLoad)//1ڵ㵽·ɱ
{
	u8 i;

	for(i=0; i<MAX_NODE_NUM; i++)//·ɱ
	{
		if(route_table[i].addr==pPayLoad->header.the_addr)//ڵѴ
		{
			NRF_UpdateToRoutrTablePath(i,pPayLoad);//·
			NRF_UpdateHearTable();
			return TRUE;
		}
	}
	for(i=0; i<MAX_NODE_NUM; i++)//ûҵַ
	{
		if(!route_table[i].addr)//ҵλ
		{
			route_table[i].addr=pPayLoad->header.the_addr;//ӵ·ɱ
			NRF_UpdateToRoutrTablePath(i,pPayLoad);//·
			NRF_UpdateHearTable();
			return TRUE;
		}
	}
	return FALSE;
}

void NRF_DelNodePath(u8 node)//ɾڵ
{
	u8 i,j,k;
	
	for(i=0; i<MAX_NODE_NUM; i++)//·ɱ
	{
		if(route_table[i].addr)
		{
			if(route_table[i].addr==node)
			{
				MemSet((BYTE *)&route_table[i],0,sizeof(RoutrTable));//·ɱɾ1ڵ
			}
			else
			{
				for(j=0; j<MAX_HOP_NUM; j++)//·ɾ1ڵ
				{
					if(route_table[i].path[j]==node)//ҵڵ
					{
						route_table[i].path[j]=0;//ɾڵ
						for(k=j+1; k<MAX_HOP_NUM; k++)//ɾڵλÿʼ·,нڵ1λ
						{
							route_table[i].path[k-1]=route_table[i].path[k];//
						}
					}
				}
			}
		}
	}
	for(i=0; i<MAX_NODE_NUM; i++)//·ɱ
	{
		if(!route_table[i].addr)
		{
			for(j=i+1; j<MAX_NODE_NUM; j++)//еַƵǰ
			{
				if(route_table[j].addr)
				{
					MemCopy((BYTE *)&route_table[i],(BYTE *)&route_table[j],sizeof(RoutrTable));
					MemSet((BYTE *)&route_table[j],0,sizeof(RoutrTable));//·ɱɾ1ڵ
					break;
				}
			}
		}
	}
	for(i=0; i<MAX_NODE_NUM; i++)//ɾ1ڵ
	{
		if(heart_table[i].addr==node)
		{
			u8 tmp=0;
			
			MemSet((BYTE *)&heart_table[i],0,sizeof(HeartTable));//ɾڵ

			/*******************ͳƵߴ********************/
			for(k=0; k<MAX_NODE_NUM; k++)//бǷڵ
			{
				if(lost_conn[k].addr==node)
				{
					tmp=node;
					break;
				}
			}
			if(tmp)//ڵ
			{
				for(k=0; k<MAX_NODE_NUM; k++)//ߴ+1
				{
					if(lost_conn[k].addr==tmp)
					{
						lost_conn[k].count++;
						if(lost_conn[k].count>=0xFE)
						{
							lost_conn[k].count=0xFE;
						}
						break;
					}
				}
			}
			else//ûڵ㣬ѽڵ㱣浽б
			{
				for(k=0; k<MAX_NODE_NUM; k++)
				{
					if(!lost_conn[k].addr)
					{
						lost_conn[k].addr=node;
						lost_conn[k].count++;
						break;
					}
				}
			}
			/***************************************************/
		}
	}
	for(i=0; i<MAX_NODE_NUM; i++)//
	{
		if(!heart_table[i].addr)
		{
			for(j=i+1; j<MAX_NODE_NUM; j++)
			{
				if(heart_table[j].addr)//еַƵǰ
				{
					heart_table[i].addr=heart_table[j].addr;
					heart_table[i].link_time=heart_table[j].link_time;
					heart_table[j].addr=0;
					heart_table[j].link_time=0;
					break;
				}
			}
		}
	}
	NRF_SendData(node,DEL_NODE,(u8 *)"",SendHandler);//ݽӿ
}

u8 NRF_FindNodePath(u8 node)//ҽڵ·
{
	u8 i,j,k,n,min,addr;

	MemSet((BYTE *)&path_table,0,sizeof(PathTable)*MAX_NODE_NUM);
	for(i=0; i<MAX_NODE_NUM; i++)//ڵб
	{
		if(route_table[i].addr)//ַЧ
		{
			if(route_table[i].addr==node)
			{
				return route_table[i].addr;//· 
			}
			else
			{
				for(j=0; j<MAX_HOP_NUM; j++)//·
				{
					if(route_table[i].path[j]==node)//·ҵַ
					{
						n=0;
						for(k=j+1; k<MAX_HOP_NUM; k++)//nֵ
						{
							if(route_table[i].path[k])//еַ
							{
								n++;//nֵԽԽԶ
							}
						}
						for(k=0; k<MAX_NODE_NUM; k++)//·
						{
							if(!path_table[k].addr)//ҵλ
							{
								path_table[k].idx=n;//nֵ
								path_table[k].addr=route_table[i].addr;//ڵַ
								break;
							}
						}
						break;	
					}
				}
			}
		}
		else//˳ѭ
		{
			break;	
		}
	}
	if(!path_table[0].addr)//ûнڵַ
		return 0xFF;
	min=path_table[0].idx;
	addr=path_table[0].addr;

	for(i=0; i<MAX_NODE_NUM; i++)//·
	{
		if(path_table[i].addr)//нڵַ
		{
			if(path_table[i].idx<min)//С
			{
				min=path_table[i].idx;
				addr=path_table[i].addr;
			}
		}
	}
	return addr;//ؽڵַ(һַ)
}

static void NRF_SendHeartPack(void)//
{
	static u8 timer=0,cnt=0;
	static u8 nCnt=0;
	
	if(!NodeStatus.heart_status)
	{
		timer++;
		if(timer>=HEART_PACK_TIME)//(10*100)ɨ1;(1)
		{
			u32 heart_time;
			u8 i;

			timer=0;
			heart_time=Get_RunTime();
			for(i=0; i<MAX_NODE_NUM; i++)//ڵб
			{
				if(heart_table[i].addr)
				{
					cnt=0;
					nCnt=0;
					if(heart_time-heart_table[i].link_time>HEART_LINK_INTERVAL)
					{
						heart_table[i].link_time=heart_time;
						NRF_SendData(heart_table[i].addr,CHECK_LINK,(u8 *)"",NRF_HeartCallBack);
					}
				}
			}
			cnt++;
			if(cnt>=30)//ûнڵ,30
			{
				cnt=0;
				if(nCnt<3)//ûнڵ,֤3
				{
					if(!NRF_CheckReg())//Ĵ
					{
						NRF_Init();//ʼ
					}
					nCnt++;
				}
				NRF_SendData(0xFF,0xFF,(u8 *)"",NULL);//30NRF1
			}
		}
	}
}

static void NRF_NrfSendData(void)//ݻ״̬,ǰȼ
{
	u8 index;
	
	index=NRF_SearchDataBuf(WAIT_SEND);
	if(0xFF==index)
	{
		index=NRF_SearchDataBuf(WAIT_RETRY);
	}
	if(0xFF==index)
	{
		index=NRF_SearchDataBuf(WAIT_SEND_RETRY);
	}
	if(0xFF!=index)
	{
		if(!NRF_DisturbanceDetect())//Ƿڵڷ
		{
			u8 new_mac[MAC_LEN]={0};
			u8 dst_addr;
			
			dst_addr=NRF_FindNodePath(DataBuf[index].payload.header.dst_addr);//Ѱ·
			if(0xFF==dst_addr)//·ɱûеַ,㲥
			{
				printf("node %d DISCONNECT\r\n",DataBuf[index].payload.header.dst_addr);
				DataBuf[index].isBroadcast=1;
			}
			else 
			{
				NRF_GetMacAddr(new_mac,dst_addr);//ȡMACַ
				printf("send-addr=%d\r\n",dst_addr);
			}
			NodeStatus.shift_failed_count=0;
			NodeStatus.shift_count++;
			if(!DataBuf[index].isBroadcast)
			{
				if(NRF_SendPayload(IS_ACK,new_mac,NodeStatus.channel,(u8* )&DataBuf[index].payload))//ͨ0
				{
					switch(DataBuf[index].payload.header.pack_type)
					{
						case CHECK_LINK:
							DataBuf[index].status=WAIT_ACK;
							break;
						default:
							DataBuf[index].status=SEND_SUCCESS;
							break;
					}
				}
				else
				{
					DataBuf[index].status=WAIT_SEND_RETRY;
					DataBuf[index].send_failed_count++;
				}
			}
			else//㲥
			{
				switch(DataBuf[index].payload.header.pack_type)
				{
					case ASSIGN_ADDR:
						NRF_SendPayload(NO_ACK,pipe2_mac,NodeStatus.channel,(u8* )&DataBuf[index].payload);//ͨ2(нڵ㲥)
						break;
					default:
						NRF_SendPayload(NO_ACK,pipe1_mac,NodeStatus.channel,(u8* )&DataBuf[index].payload);//ͨ1(ڵ㲥)
						break;
				}
				DataBuf[index].status=SEND_FAILED;
			}
			NRF_RxMode(NodeStatus.node_mac, NodeStatus.channel);
		}
		else
		{
			NodeStatus.shift_failed_count++;
			if(NodeStatus.shift_failed_count>300)
			{
				NodeStatus.shift_failed_count=0;
				//NRF_SetChannel(NRF_AppropriateChannelDetect());//ӵ̶͵ŵ
				NRF_Init();
			}
		}
	}
}

static void NRF_RelayPackage(LPayload pPayLoad)//ת
{
	u8 idx;

	if(pPayLoad->header.PID==NodeStatus.pwd)//ǱID
	{
		idx=NRF_MallocIdleDataBufId();
		if(0xFF!=idx)
		{
			DataBuf[idx].status=WAIT_SEND;
			MemCopy((BYTE*)&DataBuf[idx].payload,(BYTE *)pPayLoad,sizeof(Payload));
		}
		printf("***Relay-Package***\r\n");
	}
}

void NRF_RecvData(void)
{
	Payload tmp;
	u8 id,idx,status;
	u8 pipe_num;
	
	NRF_CE = 0;
	MemSet((BYTE *)&tmp,0,sizeof(Payload));
	status=NRF_ReadReg(STATUS);//ȡstatusĴֵ
	pipe_num=(status&RX_P_NO_MASK)>>1;//ȡͨ(0-5)
	NRF_ReadBuf(R_RX_PAYLOAD, (u8 *)&tmp, PAYLOAD_LEN);//յ
	NodeStatus.recv_count++;
//	printf("Pipe%d-Recv\r\n",pipe_num);
	
//	printf("src=%d,dst=%d,type=%d\r\nnid==%d,sid=%d,data=%d\r\nID=%d\r\n",
//			tmp.header.src_addr,tmp.header.dst_addr,tmp.header.pack_type,
//			tmp.header.data_hp,tmp.header.data_hs,tmp.header.data_sd,tmp.header.ID);
	if(tmp.header.src_addr==NodeStatus.addr)//Լ͵İ,
	{
		NRF_RxMode(NodeStatus.node_mac, NodeStatus.channel);
		return;
	}
	if(NodeStatus.pwd==tmp.header.PID)//ǱID
	{
		//10ڴİٴ(ڹ㲥ʱյܶظİ)
		if(!NRF_CmpMultiPack(tmp.header.src_addr,tmp.header.dst_addr,
							 tmp.header.pack_type,tmp.header.SID))
		{
			id=NRF_SearchHandlTimeoutId();
			if(0xFF!=id)
			{
				IsHandle[id].RID=tmp.header.SID;
				IsHandle[id].time=Get_RunTime();
				IsHandle[id].src_addr=tmp.header.src_addr;
				IsHandle[id].dst_addr=tmp.header.dst_addr;
				IsHandle[id].pack_type=tmp.header.pack_type;
				
				if(tmp.header.dst_addr==NodeStatus.addr)//ĿĵַǱڵ
				{
					if(START_LINK==tmp.header.pack_type)
					{
						u8 path[MAX_HOP_NUM]={0};//յ·
						
						NRF_AddNodeToRoutrTable(&tmp);//ӽڵ㵽·ɱ
						NRF_SendData(tmp.header.src_addr,BUILD_LINK,(u8 *)path,SendHandler);//ݽӿ
					}
					switch(tmp.header.pack_type)
					{
						case BUILD_LINK_ACK:
							NRF_UpdateHearTable();//
						break;
						case CHECK_LINK_ACK:
							NRF_UpdateHeartTime(tmp.header.src_addr);//ݵַʱ
							idx=NRF_SearchDataByPackType(tmp.header.src_addr,CHECK_LINK);//addrtype
							if(0xFF!=idx)
							{
								DataBuf[idx].status=SEND_SUCCESS;
							}
						break;
						case NODE_KEY_DATA:
						case ONE_DATA_ACK:
						case WAY_KEY_DATA_ACK:
							idx=NRF_MallocIdleDataBufId();
							if(0xFF!=idx)
							{
								MemCopy((BYTE*)&DataBuf[idx].payload,(BYTE *)&tmp,PAYLOAD_LEN);
								DataBuf[idx].retry_count=pipe_num;
								DataBuf[idx].status=WAIT_HANDLER;
							}
						break;
						default:break;
					}
				}
				else
				{
					NRF_RelayPackage(&tmp);
				}
			}
		}
	}
	NRF_RxMode(NodeStatus.node_mac, NodeStatus.channel);
}

void NRF_HandleBuf(void)//ݻ״̬
{
	u8 i;
	
	for(i=0;i<DATA_BUF_COUNT;i++)
	{
		switch(DataBuf[i].status)
		{
			case WAIT_SEND_RETRY:
				if(DataBuf[i].send_failed_count>=MAX_FAILED_COUNT)//ʧ3,תΪ㲥
				{
					DataBuf[i].isBroadcast=1;
				}
				break;
			case WAIT_ACK:
				DataBuf[i].time_count++;
				if(DataBuf[i].time_count>MAX_ACK_TIME)
				{
					DataBuf[i].time_count=0;
					DataBuf[i].send_failed_count=0;
					DataBuf[i].retry_count++;
					DataBuf[i].status=WAIT_RETRY;
					if(DataBuf[i].retry_count>MAX_RETRY_COUNT)
					{
						DataBuf[i].status=SEND_FAILED;
					}
				}
				break;
			case WAIT_HANDLER:
				//printf("Pipe%d-Recv\r\n",DataBuf[i].retry_count);
				if(RecvHandler)
				{
					RecvHandler(DataBuf[i].payload.header.src_addr,
								DataBuf[i].payload.header.dst_addr,
								DataBuf[i].payload.header.pack_type,
								DataBuf[i].payload.buf);
				}
				NRF_FreeDataBuf(i);
				break;	
			case SEND_SUCCESS:
				if(DataBuf[i].HandleCallBack)//ɻص
				{
					DataBuf[i].HandleCallBack(DataBuf[i].payload.header.src_addr,
												DataBuf[i].payload.header.dst_addr,
												DataBuf[i].payload.header.pack_type,
												DataBuf[i].payload.header.SID,
												DataBuf[i].payload.buf,PACKAGE_SUCCESS);
				}
				NRF_FreeDataBuf(i);
				break;
			case SEND_FAILED:
				if(CHECK_LINK==DataBuf[i].payload.header.pack_type)
				{
					NRF_DelNodePath(DataBuf[i].payload.header.dst_addr);//ɾڵ
				}
				if(DataBuf[i].HandleCallBack)//ʧܻص
				{
					DataBuf[i].HandleCallBack(DataBuf[i].payload.header.src_addr,
												DataBuf[i].payload.header.dst_addr,
												DataBuf[i].payload.header.pack_type,
												DataBuf[i].payload.header.SID,
												DataBuf[i].payload.buf,PACKAGE_FAILED);
				}
				NRF_FreeDataBuf(i);
				break;
		}
	}
}

u8 NRF_AppropriateChannelDetect(void)//ӵ̶͵ŵ
{
	u8 channel,min_disturb_count=11,i,j;
	u8 disturb_count[125]={0};
	
	ThreadLock=1;
	//MemSet((BYTE *)disturb_count,0,125);
	channel=NRF_ReadChannel();
	for(i=0;i<10;i++)
	{
		for(j=0;j<125;j++)
		{
			NRF_SetChannel(i);
			if(NRF_DisturbanceDetect())
			{
				disturb_count[j]++;
			}
		}
	}
	NRF_SetChannel(channel);
	for(i=0;i<125;i++)
	{
		if(disturb_count[i]<min_disturb_count)
		{
			min_disturb_count=disturb_count[i];
			channel=i;
		}
	}
	NRF_ReadReg(FLUSH_RX);//FIFO
	ThreadLock=0;
	return channel;
}

void NRF_Thread(void)//ʱ߳,ִЭ
{
	NRF_SendHeartPack();
	NRF_NrfSendData();
	NRF_HandleBuf();
}

u8 NRF_MallocIdleDataBufId(void)//õһDATABUF,Ϊ
{
	u8 i;
	
	ThreadLock=1;//
	for(i=0;i<DATA_BUF_COUNT;i++)
	{
		if(IDLE==DataBuf[i].status)
		{
			DataBuf[i].status=WAIT_USE;
			ThreadLock=0;//
			return i;
		}
	}
	ThreadLock=0;//
	return 0xFF;
}	

void NRF_FreeDataBuf(u8 id)//ͷűʹõDataBuf,ıΪ״̬
{
	if(id>(DATA_BUF_COUNT-1)||id==0xFF)
	{
		return;
	}
	ThreadLock=1;//
	MemSet((BYTE *)&DataBuf[id],0,sizeof(DATA_BUF));
	ThreadLock=0;//
}

u8 NRF_SearchDataBuf(u8 status)//״̬ΪstatusDataBuf,
{
	u8 i=0;
	
	for(i=0;i<DATA_BUF_COUNT;i++)
	{
		if(status==DataBuf[i].status)
		{
			return i;
		}
	}
	return 0xFF;
}

u8 NRF_SearchDataByPackType(u8 addr,u8 type)//addrtype
{
	u8 i;
	
	for(i=0;i<DATA_BUF_COUNT;i++)
	{
		if(addr==DataBuf[i].payload.header.dst_addr&&
			type==DataBuf[i].payload.header.pack_type)
		{
			return i;
		}
	}
	return 0xFF;
}

u8 NRF_SearchHandlTimeoutId(void)
{
	u8 i;

	for(i=0;i<DATA_BUF_COUNT;i++)
	{
		if(Get_RunTime()-IsHandle[i].time>MULTI_PACK_INTERVAL)
		{
			return i;
		}
	}
	return 0xFF;
}

u8 NRF_CmpMultiPack(const u8 src_addr,const u8 dst_addr,const u8 pack_type,const u16 ID)
{
	u8 i;

	for(i=0;i<DATA_BUF_COUNT;i++)
	{
		if(Get_RunTime()-IsHandle[i].time<MULTI_PACK_INTERVAL)
		{
			if(ID==IsHandle[i].RID&&pack_type==IsHandle[i].pack_type&&
				src_addr==IsHandle[i].src_addr&&dst_addr==IsHandle[i].dst_addr)
			{
				return TRUE;
			}
		}
	}
	return FALSE;
}

u8 PrintRouteTable(void)
{
	u8 i,j,k=0,n=0;
	
	printf("\r\n======== Path List ========\r\n\r\n");
	for(i=0; i<MAX_NODE_NUM; i++)
	{
		if(route_table[i].addr)
		{
			k++;
			printf("node-%d:%d path ",i+1,route_table[i].addr);
			for(j=0; j<MAX_HOP_NUM; j++)//ڵб
			{
				if(route_table[i].path[j])
				{
					n++;
					printf("%d ",route_table[i].path[j]);
				}
			}
			printf("\r\n");
		}
	}
	if(!k)
	{
		printf("no node\r\n");
	}
	printf("\r\n===========================\r\n");
	return k+n;
}

u8 PrintNode(void)
{
	u8 i,j=0,k,tmp;
	
	printf("\r\n======= Node List =======\r\n\r\n");
	for(i=0; i<MAX_NODE_NUM; i++)
	{
		if(heart_table[i].addr)
		{
			tmp=0;
			for(k=0; k<MAX_NODE_NUM; k++)//ͳƵߴ
			{
				if(lost_conn[k].addr==heart_table[i].addr)
				{
					tmp=lost_conn[k].count;
					break;
				}
			}
			printf("node-%02d:%03d lost_conn=%d\r\n",i+1,heart_table[i].addr,tmp);
			j++;
		}
	}
	if(!j)
	{
		printf("no node\r\n");
	}

	printf("\r\n=========================\r\n");
	return j;
}

u8 PrintLost(void)
{
	u8 j=0,k;
	
	printf("\r\n====== Lost List ======\r\n\r\n");

	for(k=0; k<MAX_NODE_NUM; k++)//ͳƵߴ
	{
		if(lost_conn[k].addr)
		{
			printf("node-%03d lost_conn=%d\r\n",lost_conn[k].addr,lost_conn[k].count);
			j++;
		}
	}
	printf("\r\n=======================\r\n");
	
	return j;
}

u8 NRF_GetNodeNumber(void)
{
	u8 i,j=0;
	
	for(i=0; i<MAX_NODE_NUM; i++)//ڵб
	{
		if(heart_table[i].addr)
		{
			j++;
		}
	}
	return j;
}
