#ifndef _NRF24L01_H_
#define _NRF24L01_H_

#include "stm32f10x.h"
#include "nrf24l01_reg.h"
#include "nrf_data.h"
#include "bsp.h"

//ʹSPI2
#define NRF_SPI						SPI2
#define NRF_SPI_CLK					RCC_APB1Periph_SPI2

#define NRF_SPI_SCK_PIN				GPIO_Pin_13				//PB.13
#define NRF_SPI_SCK_GPIO_PORT		GPIOB					//GPIOB
#define NRF_SPI_SCK_GPIO_CLK		RCC_APB2Periph_GPIOB

#define NRF_SPI_MISO_PIN			GPIO_Pin_14				//PB.14
#define NRF_SPI_MISO_GPIO_PORT		GPIOB					//GPIOB
#define NRF_SPI_MISO_GPIO_CLK		RCC_APB2Periph_GPIOB

#define NRF_SPI_MOSI_PIN			GPIO_Pin_15             //PA.15
#define NRF_SPI_MOSI_GPIO_PORT		GPIOB					//GPIOA
#define NRF_SPI_MOSI_GPIO_CLK		RCC_APB2Periph_GPIOB

#define NRF_CSN_PIN					GPIO_Pin_11				//PA.11 
#define NRF_CSN_GPIO_PORT			GPIOA					//GPIOA
#define NRF_CSN_GPIO_CLK			RCC_APB2Periph_GPIOA

#define NRF_CE_PIN					GPIO_Pin_12				//PA.12 
#define NRF_CE_GPIO_PORT			GPIOA					//GPIOA
#define NRF_CE_GPIO_CLK				RCC_APB2Periph_GPIOA

#define NRF_IRQ_PIN					GPIO_Pin_8				//PA.8 
#define NRF_IRQ_EXTI_LINE			EXTI_Line8
#define NRF_IRQ_EXTI_PIN_SOURCE		GPIO_PinSource8
#define NRF_IRQ_GPIO_PORT			GPIOA					//GPIOA
#define NRF_IRQ_GPIO_CLK			RCC_APB2Periph_GPIOA
#define NRF_IRQ_EXTI_PORT_SOURCE	GPIO_PortSourceGPIOA
#define NRF_IRQ_EXTI_IRQn			EXTI9_5_IRQn

//24L01
#define NRF_CE			PAout(12) //24L01Ƭѡź
#define NRF_CSN			PAout(11) //SPIƬѡź	   
#define NRF_IRQ			PAin(8)  //IRQ

#define MAX_RT			0x10  //ﵽʹж
#define TX_DS			0x20  //TXж
#define RX_DR			0x40  //յж

#define RX_P_NO_MASK	0x0E
#define IRQ_ALL			(TX_DS|RX_DR|MAX_RT)
#define ACK				1
#define NO_ACK			0

void NRF_GPIO_Init(void);
void NRF_EXTIX_Init(void);
void SPI_SetSpeed(const u8 SPI_BaudRatePrescaler);
u8 SPI_ReadWriteByte(const u8 TxData);
u8 NRF_ReadReg(const u8 reg);//Ĵ
u8 NRF_WriteReg(const u8 reg,const  u8 value);//дĴ
u8 NRF_ReadBuf(const u8 reg, u8 *pBuf,const  u8 len);//
u8 NRF_WriteBuf(const u8 reg,const u8 *pBuf,const  u8 len);//д

void NRF_GPIO_Init(void);
void NRF_EXTIX_Init(void);
void NRF_PowerDown(void);
void NRF_Config(const u8 *addr,const u8 channel);//ʼ
void NRF_RxMode(const u8 *addr,const u8 channel);//Ϊģʽ
void NRF_SetChannel(const u8 channel);
void NRF_SetPipe1To4Mac(const u8 *addr);
void NRF_DelayUs(u16 i);
void EXTI9_5Close(void);
u8 NRF_SetRfPower(const u8 level);
u8 NRF_ReadChannel(void);
u8 NRF_SendPayload(const u8 ack,const u8 *addr,const u8 channel,const u8 *buf);//
u8 NRF_DisturbanceDetect(void);//⵱ǰƵⲿźǿ

#endif
