#ifndef _NRF_DATA_H_
#define _NRF_DATA_H_

#include "stm32f10x.h"

typedef char    BYTE;
typedef uint8_t BOOL;   

#define MAC_LEN					5
#define PAYLOAD_LEN				32
#define PALYOAD_HEADER_LEN		sizeof(PayloadHeader)
#define PAYLOAD_DATA_LEN		(PAYLOAD_LEN-PALYOAD_HEADER_LEN)
#define DATA_BUF_COUNT			50

#define MAX_FAILED_COUNT		3     //ʧܴ
#define LINK_INTERVAL 			1000  //,λ10ms(10)
#define HEART_LINK_INTERVAL		2200  //,λ10ms(22)

enum NODESTATUS{INVALID,VALID};
enum LINKSTATUS{DISCONNECT,WAIT_CONNECT,CONNECTED,WAIT_CHANGE};
enum PAYLOADSTATUS{IDLE,WAIT_USE,WAIT_SEND,WAIT_SEND_RETRY,SEND_FAILED,SEND_SUCCESS,WAIT_RECV,RECV_FAILED,WAIT_HANDLER};
enum PACKAGETYPE{START_LINK,BUILD_CONNECT,BUILD_CONNECT_ACK,CHECK_LINK,CHECK_LINK_ACK,ONE_DATA,ONE_DATA_ACK,MULTI_DATA};

#define PACKAGE_SUCCESS   0x01
#define PACKAGE_FAILED    0x00

typedef void (*HANDLECALLBACK)(u8 src_addr,u8 dst_addr,u8 pack_type,u16 num,u8 *buf,u8 status);

#pragma pack(1)
typedef struct 
{
	u8 src_addr; //Դַ
	u8 dst_addr; //Ŀĵַ
	u8 pack_type;//payload
	u16 pwd;
	u16 ID;      //payload ID
}PayloadHeader,*LPayloadHeader;//payloadͷṹ

typedef struct
{
	PayloadHeader header;    //payload ͷ
	u8 buf[PAYLOAD_DATA_LEN];//ݻ
}Payload,*LPayload;//payloadṹ 
#pragma pack()

typedef struct
{
	u8 status;         	 //ݰ״̬
	u8 isBroadcast;		 //Ƿ㲥
	u8 send_failed_count;//ʧܴ
	u8 dst_channel;      //ŵ
	u8 dst_mac[MAC_LEN+1];//͵ĿMACַ
	HANDLECALLBACK HandleCallBack;//ص
	Payload payload;     //ݰ
}DATA_BUF,*LPDATA_BUF;//ͬݰ

typedef struct
{
	u8 node_addr;		   //ڵַ
	u8 local_mac[MAC_LEN]; //ڵmac
	u16 pwd;
}NRFSTOREDATA,*LPNRFSTOREDATA;

#pragma pack(1)
typedef struct
{
	u8 node_addr;           //ǰַ
	u8 route_addr;
	u8 channel;             //ǰŵ
	u8 link_status;    		//״̬
	u8 send_failed_count;
	u8 node_mac[MAC_LEN+1];
	u16 pwd;
	u32 shift_failed_count; //лʧܼ
	u32 shift_count;        //лɹ
	u32 recv_count;         //ݰ
}NODESTATUS;//ڵ״̬ṹ
#pragma pack()

typedef struct
{
	u8 src_addr;
	u8 dst_addr;
	u16 RID;
	u32 time;    
}Handl,*LHandl;

#endif
