#include "timer.h"
#include "led.h"

volatile int g_Tim2Array[(u16)eTimMax] = {0};
volatile u32 sys_time;
volatile u16 Timerx;

//ʱ2ʼ
void TIMER_Init(void)
{
	TIM_TimeBaseInitTypeDef TIM_BaseInitStructure;//һʱṹ
	NVIC_InitTypeDef NVIC_InitStructure;

	RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM2, ENABLE);//ʹܶʱ2,Ҫ
	TIM_DeInit(TIM2);//IM2ʱʼλλֵ
	TIM_InternalClockConfig(TIM2);//TIM2ڲʱ
	TIM_BaseInitStructure.TIM_Period = 10000;//ϼ1000¼,ֵ,1MS¼һ
											 //TIM_Period(TIM1_ARR)=1000,1000000/1000=1000us=1ms
	//TIM_BaseInitStructure.TIM_Prescaler = RCC_Clocks.PCLK1_Frequency / 1000000;//1MHz
	TIM_BaseInitStructure.TIM_Prescaler = 71;//ԶԤƵϵ,APB1=72M,TIM1_CLK=72/72=1MHz 
	TIM_BaseInitStructure.TIM_ClockDivision = TIM_CKD_DIV1;//ʱӷָΪ0
	TIM_BaseInitStructure.TIM_CounterMode = TIM_CounterMode_Up;//TIMϼģʽ 0ʼϼ1000¼
	//TIM_BaseInitStructure.TIM_RepetitionCounter = 0;//˲ֻʺTIM1TIM8
	TIM_TimeBaseInit(TIM2, &TIM_BaseInitStructure);//ָʼTIMʱĴ
	TIM_ClearFlag(TIM2, TIM_FLAG_Update);//жϣһжϺж 
	TIM_ARRPreloadConfig(TIM2, DISABLE);//ֹARR Ԥװػ
	TIM_ITConfig(TIM2, TIM_IT_Update, ENABLE);//ʹTIM2жԴ 
	TIM_Cmd(TIM2, ENABLE);//TIM2ܿأ 

	NVIC_PriorityGroupConfig(NVIC_PriorityGroup_2);//жΪ2,NVICжϷ2:2λռȼ,2λӦȼ
	NVIC_InitStructure.NVIC_IRQChannel = TIM2_IRQn;//ж¼ΪTIM2
	NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 2;//ռȼ2
	NVIC_InitStructure.NVIC_IRQChannelSubPriority = 2;//Ӧȼ2
	NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;//ж 
	NVIC_Init(&NVIC_InitStructure);//ָʼжϼĴ
	
	sys_time=0;
}

//ʱ2жϴ
void TIM2_IRQHandler(void)//λ10ms
{
	u16 i = 0;
	if(TIM_GetITStatus(TIM2, TIM_IT_Update) != RESET)//жжϱ־λǷΪ1:Ϊ1жӦ,0û
	{
		TIM_ClearITPendingBit(TIM2, TIM_IT_Update);//жϹλ
		sys_time++;
		Led_10mS_Conut();//10mS
//		if(!ThreadLock)
//		{
//			NRF_Thread();//Э߳
//		}
		if(Timerx)
		{
			Timerx--;
		}
		for(i = 0; i < (u16)eTimMax; i++)
		{
			g_Tim2Array[i]++;
		}
	}
}

void TIM_Delay_Init(void)//ʱʱ
{
	TIM_TimeBaseInitTypeDef  TIM_TimeBaseStructure;

	RCC_APB1PeriphClockCmd(DELAY_TIMER_CLK, ENABLE); 
	
	TIM_DeInit(DELAY_TIMER);//ʼλλֵ
	TIM_InternalClockConfig(DELAY_TIMER);//ڲʱ
	TIM_TimeBaseStructure.TIM_Period = 0xffff;//Զװֵ;ϼ0xffff,ֵ,5000Ϊ5ms
	TIM_TimeBaseStructure.TIM_Prescaler =71;//ԤƵֵ,1MhzļƵ
	TIM_TimeBaseStructure.TIM_ClockDivision = 0;//ʱӷָΪ0
	TIM_TimeBaseStructure.TIM_CounterMode = TIM_CounterMode_Up;//TIMϼģʽ
	TIM_TimeBaseInit(DELAY_TIMER, &TIM_TimeBaseStructure);//ʼTIMxʱλ
	TIM_Cmd(DELAY_TIMER, DISABLE);
}

void NRF_DelayUs(u16 i)//1~65535usʱ	  
{
	u16 TIMCounter = 0;
	TIM_SetCounter(DELAY_TIMER, TIMCounter);
	TIM_Cmd(DELAY_TIMER, ENABLE);
	while (TIMCounter<i)
	{
		TIMCounter = TIM_GetCounter(DELAY_TIMER);
	}
	TIM_Cmd(DELAY_TIMER, DISABLE);
}

//#ifdef DEBUG
//void TIM_MeasureStart(void)
//{
//	TIM3->CNT=0;
//	//TIM_SetCounter(TIM3, 0);
//	TIM_Cmd(TIM3,ENABLE );//ʹܶʱ
//}

//void TIM_MeasureStop(void)
//{
//	u16 TIM_Count;
//	TIM_Cmd(TIM3,DISABLE );//رնʱ
//	//TIM_Count=TIM_GetCounter(TIM3);//ȡǰֵ
//	TIM_Count=TIM3->CNT;//ȡǰֵ

//	printf("Used time:%d us\r\n",TIM_Count);
//}
//#endif

extern void Idle(void);
//ע:Ҫжеñ,.ȫж,Ҫʹô˺
void Delay10Ms(u16 dly_10ms)
{
	Timerx=dly_10ms;
	while(Timerx)
	{
		Idle();
	}
}

//void NRF_DelayUs(u16 i)
//{
//	u16 k,j;
//	for(k=0;k<i;k++)
//		for(j=0;j<9;j++);
//}

//ȡCPUʱ,λ10ms.Աʾ497,ʱ䳬,뿼
u32 Get_RunTime(void)
{
	return sys_time;
}
