#ifndef __TIMER_H
#define __TIMER_H

#include "stm32f10x.h"

enum {
	eTim1,
	eTim2,
	eTim3,
	eTim4,
	eTimLed,
	eTimNrf,
	eTimNrfThread,
//	eTimUpdata,
	eTimYModem,
	eTimMax,
};

//indexӦʱ䳬ʱ㲢1δʱ0
#define IS_TIMEOUT_10MS(index, count)	((g_Tim2Array[(u16)(index)] >= (count))?  \
										((g_Tim2Array[(u16)(index)] = 0) == 0): 0)

#define DELAY_TIMER			TIM3
#define DELAY_TIMER_CLK		RCC_APB1Periph_TIM3

void TIMER_Init(void);
void TIM_Delay_Init(void);
void TIM_MeasureStart(void);
void TIM_MeasureStop(void);
void Delay10Ms(u16 dly_10ms);
void NRF_DelayUs(u16 i);
u32 Get_RunTime(void);

extern volatile int g_Tim2Array[(u16)eTimMax];

#endif
