#ifndef __USART_H
#define __USART_H

#include "stm32f10x.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <math.h>

#define EN_USART1	1	//1ʹ;0ֹ;ʹܴ1
#define EN_USART2	1	//ʹܴ2
#define EN_USART3	0	

#define USART1_SEND_LEN	512	//DMAֽ
#define USART2_SEND_LEN	512
#define USART3_SEND_LEN	512
#define USART1_RECV_LEN	512	//DMAͽջֽ
#define USART2_RECV_LEN	1024
#define USART3_RECV_LEN	512	

extern char USART1_Recv_Buff[USART1_RECV_LEN];//ջ,USART1_Recv_Buffֽ
extern char USART2_Recv_Buff[USART2_RECV_LEN];
extern char USART3_Recv_Buff[USART3_RECV_LEN];
extern u8 USART1_Recv_Flag;//״̬	
extern u8 USART2_Recv_Flag;
extern u8 USART3_Recv_Flag;
extern u32 USART1_ReceDatalen;

void UART1_Init(u32 bound);
void UART2_Init(u32 bound);
void UART3_Init(u32 bound);
void USART1_DMA_SendStr(char *senddata);//1DMAͳ
void USART2_DMA_SendStr(char *senddata);//2DMAͳ
void USART3_DMA_SendStr(char *senddata);//3DMAͳ
void USART1_SendByte(unsigned char c);//1һַ
void USART1_SendStr(char * str);//1ַ
void USART2_SendByte(unsigned char c);//2һַ
void USART2_SendStr(char * str);//2ַ
void USART3_SendByte(unsigned char c);//3һַ
void USART3_SendStr(char * str);//3ַ
void my_printf(USART_TypeDef* USARTx, char *Data,...);
int SendChar (int ch);

#endif
