#include "BspMemory.h"

//addrΪҳ׵ַ
u16 EE_FlashWrite(const u32 flag,const u32 addr,const u8 *buf,const u16 len)//д1ҳflash
{
	u32 tmp;
	u32 address;
	u16 word_count=0;
	u8 last_count=0;
	if(len==0||len>FLASH_SECTOR_SIZE)
	{
		return 0;
	}
	//__set_PRIMASK(1);//ж
	word_count=len/4;
	last_count=len%4;
	FLASH_Unlock();//FLASH
	FLASH_ClearFlag(FLASH_FLAG_BSY|FLASH_FLAG_EOP|FLASH_FLAG_PGERR|FLASH_FLAG_WRPRTERR);//־λ
	FLASH_ErasePage(addr);
	address=addr;
	if(flag!=0)
	{
		FLASH_ProgramWord(address,flag);
		address+=4;
	}
	while(word_count--)
	{
		tmp=*(buf++);
		tmp|=*(buf++)<<8;
		tmp|=*(buf++)<<16;
		tmp|=*(buf++)<<24;
		FLASH_ProgramWord(address, tmp);
		address+=4;
	}
	if(last_count)
	{
		tmp=0;
		switch(last_count)
		{
			case 1:
				tmp=*(buf++);
				break;
			case 2:
				tmp=*(buf++);
				tmp|=*(buf++)<<8;
				break;
			case 3:
				tmp=*(buf++);
				tmp|=*(buf++)<<8;
				tmp|=*(buf++)<<16;
				break;
			default:break;
		}
		FLASH_ProgramWord(address, tmp);
	}
	FLASH_Lock();//
	//__set_PRIMASK(0);//ж

	return len;
}

u16 EE_FlashReadFlag(const u32 flag,const u32 addr,u8 *buf,u16 len)
{
	u32 address=addr;
	if(NRF_IsHaveStoreData(flag,address))
	{
		address+=4;
		while(len--)
		{
			*(buf++)=*((u8*)address++);
		}
	}
	return len;
}

void EE_FlashRead(u32 addr,u8 *buf,u16 len)
{
	while(len--)
	{
		*(buf++)=*((u8*)addr++);
	}
}

BOOL NRF_IsHaveStoreData(const u32 flag,const u32 addr)
{
	u32 address=addr;
	if((*(u32*)address)==(u32)flag)
	{
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}

void NRF_ClearStroreData(const u32 addr)
{
	FLASH_Unlock();
	FLASH_ClearFlag(FLASH_FLAG_EOP|FLASH_FLAG_PGERR); 
	FLASH_ErasePage(addr);
	FLASH_Lock();
}
