#ifndef _BSPMEMORY_H_
#define _BSPMEMORY_H_

#include "bsp.h"

#define FLASH_BASE_ADDR		(0x08000000)	//STM32 FLASHʼַ
#define FLASH_SECTOR_SIZE	(1024)			//ֽ
#define PAGE_SIZE			(0x400)			//1Kbyte

#define APP_FLAG			0x88999955
#define APP_FLAG_ADDRESS	(FLASH_BASE_ADDR+FLASH_SECTOR_SIZE*63)
#define APP_ADDRESS			(0x08003C00)	//APP׵ַ

#define NRF_STORE_SECTOR	(62)			//C8T6(0-63)
#define NRF_STORE_FLAG		0x88993355
#define NRF_STORE_ADDRESS	(FLASH_BASE_ADDR+FLASH_SECTOR_SIZE*NRF_STORE_SECTOR)

BOOL NRF_IsHaveStoreData(const u32 flag,const u32 addr);
void NRF_ClearStroreData(const u32 addr);
void EE_FlashRead(u32 addr,u8 *buf,u16 len);
u16 EE_FlashReadFlag(const u32 flag,const u32 addr,u8 *buf,u16 len);
u16 EE_FlashWrite(const u32 flag,const u32 addr,const u8 *buf,const u16 len);
u32 FLASH_WriteBank(u8 *pData, u32 addr, u16 size);

#endif
