#include "bsp.h"

static volatile u8 TranFinish_flag,Timeout;

//ʼ24L01IO
void NRF_GPIO_Init(void)
{ 	
	GPIO_InitTypeDef GPIO_InitStructure;
	SPI_InitTypeDef  SPI_InitStructure;

	RCC_APB2PeriphClockCmd(NRF_CE_GPIO_CLK|NRF_CSN_GPIO_CLK | NRF_SPI_MOSI_GPIO_CLK | NRF_SPI_MISO_GPIO_CLK |
							NRF_SPI_SCK_GPIO_CLK | RCC_APB2Periph_AFIO, ENABLE);
	//RCC_APB2PeriphClockCmd(NRF_SPI_CLK, ENABLE);//SPI1ʱʹ
	RCC_APB1PeriphClockCmd(NRF_SPI_CLK, ENABLE);//SPI2ʱʹ

	GPIO_InitStructure.GPIO_Pin = NRF_SPI_SCK_PIN;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init(NRF_SPI_SCK_GPIO_PORT, &GPIO_InitStructure);

	GPIO_InitStructure.GPIO_Pin = NRF_SPI_MISO_PIN;
	GPIO_Init(NRF_SPI_MISO_GPIO_PORT, &GPIO_InitStructure);

	GPIO_InitStructure.GPIO_Pin = NRF_SPI_MOSI_PIN;
	GPIO_Init(NRF_SPI_MOSI_GPIO_PORT, &GPIO_InitStructure);

	GPIO_InitStructure.GPIO_Pin = NRF_CSN_PIN;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init(NRF_CSN_GPIO_PORT, &GPIO_InitStructure);

	GPIO_InitStructure.GPIO_Pin = NRF_CE_PIN;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init(NRF_CE_GPIO_PORT, &GPIO_InitStructure);

	SPI_Cmd(NRF_SPI, DISABLE);
	SPI_InitStructure.SPI_Direction = SPI_Direction_2Lines_FullDuplex;
	SPI_InitStructure.SPI_Mode = SPI_Mode_Master;
	SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b;
	SPI_InitStructure.SPI_CPOL = SPI_CPOL_Low;
	SPI_InitStructure.SPI_CPHA = SPI_CPHA_1Edge;
	SPI_InitStructure.SPI_NSS = SPI_NSS_Soft;
	SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_16;
	SPI_InitStructure.SPI_FirstBit = SPI_FirstBit_MSB;
	SPI_InitStructure.SPI_CRCPolynomial = 7;
	SPI_Init(NRF_SPI, &SPI_InitStructure);

	SPI_Cmd(NRF_SPI, ENABLE);
	SPI_SetSpeed(SPI_BaudRatePrescaler_8);//spiٶΪ9Mhz24L01SPIʱΪ10Mhz
	
	NRF_CE=0;
	NRF_CSN=1;//SPIƬѡȡ	
}

void NRF_EXTIX_Init(void)
{ 
	EXTI_InitTypeDef EXTI_InitStructure;
	NVIC_InitTypeDef NVIC_InitStructure;
	GPIO_InitTypeDef GPIO_InitStructure;
	 
	RCC_APB2PeriphClockCmd(NRF_IRQ_GPIO_CLK|RCC_APB2Periph_AFIO, ENABLE);

	GPIO_InitStructure.GPIO_Pin = NRF_IRQ_PIN;
	//GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU;//ó
	GPIO_Init(NRF_IRQ_GPIO_PORT, &GPIO_InitStructure);
	GPIO_EXTILineConfig(NRF_IRQ_EXTI_PORT_SOURCE, NRF_IRQ_EXTI_PIN_SOURCE);

	EXTI_InitStructure.EXTI_Line = NRF_IRQ_EXTI_LINE;
	EXTI_InitStructure.EXTI_Mode = EXTI_Mode_Interrupt;
	EXTI_InitStructure.EXTI_Trigger = EXTI_Trigger_Falling;
	EXTI_InitStructure.EXTI_LineCmd = ENABLE;
	EXTI_Init(&EXTI_InitStructure);

	NVIC_InitStructure.NVIC_IRQChannel = NRF_IRQ_EXTI_IRQn;
	NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;//ռȼ
	NVIC_InitStructure.NVIC_IRQChannelSubPriority = 1;//Ӧȼ
	NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
	NVIC_Init(&NVIC_InitStructure); 
}

//SPI ٶú
//SpeedSet:
//SPI_BaudRatePrescaler_2   2Ƶ   
//SPI_BaudRatePrescaler_8   8Ƶ   
//SPI_BaudRatePrescaler_16  16Ƶ  
//SPI_BaudRatePrescaler_256 256Ƶ 
void SPI_SetSpeed(const u8 SPI_BaudRatePrescaler)
{
	assert_param(IS_SPI_BAUDRATE_PRESCALER(SPI_BaudRatePrescaler));
	NRF_SPI->CR1&=0XFFC7;
	NRF_SPI->CR1|=SPI_BaudRatePrescaler;//NRF_SPIٶ 
	SPI_Cmd(NRF_SPI,ENABLE); 
} 

//SPIx дһֽ
//TxData:Ҫдֽ
//ֵ:ȡֽ
u8 SPI_ReadWriteByte(const u8 TxData)
{		
	u8 retry=0;	
	
	while(SPI_I2S_GetFlagStatus(NRF_SPI, SPI_I2S_FLAG_TXE) == RESET)//ָSPI־λ:ͻձ־λ
	{
		retry++;
		if(retry>200)
		{
			return 0;
		}
	}			  
	SPI_I2S_SendData(NRF_SPI, TxData);//ͨSPIxһ
	retry=0;

	while(SPI_I2S_GetFlagStatus(NRF_SPI, SPI_I2S_FLAG_RXNE) == RESET)//ָSPI־λ:ܻǿձ־λ
	{
		retry++;
		if(retry>200)
		{
			return 0;
		}
	}
	return SPI_I2S_ReceiveData(NRF_SPI);//ͨSPIxյ
}

//ȡSPIĴֵ
u8 NRF_ReadReg(const u8 reg)
{
	u8 reg_val;
	
 	NRF_CSN = 0;//ʹSPI
	SPI_ReadWriteByte(R_REGISTER|reg);//ͼĴ
	reg_val = SPI_ReadWriteByte(0XFF);//ȡĴ
	NRF_CSN = 1;//ֹSPI
	return(reg_val);//״ֵ̬
}

//SPIдĴ
u8 NRF_WriteReg(const u8 reg,const u8 value)
{
	u8 status;
	
	//NRF_CE = 0;
	NRF_CSN = 0;//ʹSPI
	status = SPI_ReadWriteByte(W_REGISTER|reg);//ͼĴ
	SPI_ReadWriteByte(value);//дĴֵ
	NRF_CSN = 1;//ֹSPI
	return(status);//״ֵ̬
}

//ָλöָȵ
//ض״̬Ĵֵ 
u8 NRF_ReadBuf(const u8 reg, u8 *pBuf, const u8 len)
{
	u8 status,i;
	
	NRF_CSN = 0;//ʹSPI
	status=SPI_ReadWriteByte(R_REGISTER|reg);//ͼĴֵ(λ),ȡ״ֵ̬
 	for(i=0; i<len; i++)
	{
		pBuf[i] = SPI_ReadWriteByte(0XFF);//
	}
	NRF_CSN = 1;//رSPI
	return status;//ض״ֵ̬
}

//ָλдָȵ
//ض״̬Ĵֵ
u8 NRF_WriteBuf(const u8 reg,const u8 *pBuf,const u8 len)
{
	u8 status,i;
	
	//NRF_CE = 0;
 	NRF_CSN = 0;//ʹSPI
	status = SPI_ReadWriteByte(W_REGISTER|reg);//ͼĴֵ(λ),ȡ״ֵ̬
	for(i=0; i<len; i++)
	{
		SPI_ReadWriteByte(*pBuf++);//д
	}
	NRF_CSN = 1;//رSPI
	return status;//ض״ֵ̬
}

void NRF_Config(const u8 *addr,const u8 channel)
{
	NRF_GPIO_Init();
	NRF_EXTIX_Init();
	TranFinish_flag=0;
	Timeout=0;
	NRF_CE = 0;
	NRF_PowerDown();//ģʽ
	NRF_WriteReg(EN_AA, 0x01);//ʹͨ0ԶӦ
//	NRF_WriteReg(EN_RXADDR, 0x3f);//ʹͨĽյַ 
	NRF_WriteReg(EN_RXADDR, 0x07);//ʹ0,1,2ͨĽյַ 
	NRF_WriteReg(SETUP_RETR, 0x71);//ȴ2000us,ط1(250Kbps=2000us)
	NRF_WriteReg(SETUP_AW, 0x03);//ַ5
	NRF_WriteReg(RF_SETUP, 0x27);//TX,250Kbps,0db,濪
	//NRF_WriteReg(RF_SETUP, 0x21);//TX,250Kbps,-18db,濪
	NRF_WriteReg(STATUS, IRQ_ALL);//״̬־
	NRF_ReadReg(FLUSH_RX);//FIFO
	NRF_ReadReg(FLUSH_TX);//巢FIFO
	if((!NRF_ReadReg(FEATRUE))&&(!NRF_ReadReg(DYNPD)))
	{
		SPI_ReadWriteByte(ACTIVATE);
		SPI_ReadWriteByte(0x73);//R_RX_PL_WID,W_ACK_PAYLOAD,W_TX_PAYLOAD_NOACK
	}
	NRF_WriteReg(DYNPD, 0x3f);//ͨʹ̬ܶ
	NRF_WriteReg(FEATRUE, 0x06);//ʹ̬ܶ,ʹӦ
	NRF_WriteBuf(RX_ADDR_P0, addr, MAC_LEN);//дͨ0,RXַ
	NRF_DelayUs(2000);//ģʽ->ģʽǰ뾭1.5msĴģʽ
	NRF_RxMode(addr, channel);//ʼΪģʽ
	NRF_DelayUs(150);//ģʽ->/ģʽ130us
}

u8 NRF_Check(void)
{
	u8 buf[5]={0X95,0X94,0X93,0X92,0X91};
	u8 i;
		 
	NRF_WriteBuf(TX_ADDR,buf,5);//д5ֽڵĵַ.	
	NRF_ReadBuf(TX_ADDR,buf,5); //дĵַ  
	for(i=0;i<5;i++)
	{
		if(buf[i]!=0X95-i)
			break;	
	}		
	if(i!=5)
		return FALSE;//24L01	
	return TRUE;//⵽24L01
}

u8 NRF_CheckReg(void)//֤Ĵ״̬
{
	if(NRF_ReadReg(CONFIG)!=0x0b) 
		return FALSE;
	if(NRF_ReadReg(EN_AA)!=0x01) 
		return FALSE;
	if(NRF_ReadReg(EN_RXADDR)!=0x07) 
		return FALSE;
	if(NRF_ReadReg(SETUP_AW)!=0x03) 
		return FALSE;
	if(NRF_ReadReg(SETUP_RETR)!=0x71) 
		return FALSE;
	if(NRF_ReadReg(RF_SETUP)!=0x27) 
		return FALSE;
	if(NRF_ReadReg(STATUS)!=0x0e) 
		return FALSE;
	if(NRF_ReadReg(FIFO_STATUS)!=0x11) 
		return FALSE;
	 return TRUE;
}

//u8 NRF_SetRfPower(const u8 level)//(0-3)
//{
//	u8 state,power;
//	
//	if(level<4)
//	{
//		NRF_CE = 0;
//		power=level;
//		state=NRF_ReadReg(RF_SETUP);//
//		state&=0XF9;//powerλ(B11111001)
//		power&=0x03;//power(B00000011)
//		NRF_WriteReg(RF_SETUP, state|(power<<1));//powerλ
//		return state;
//	}
//	return 0;
//}

u8 NRF_ReadChannel(void)
{
	return NRF_ReadReg(RF_CH);//Ƶ
}

void NRF_SetChannel(const u8 channel)
{
	if(channel<125)
	{
		//NRF_CE = 0;
		NRF_WriteReg(RF_CH, channel);//RFͨƵ
	}
}

//⵱ǰƵⲿźǿ
u8 NRF_DisturbanceDetect(void)
{
	NRF_CE = 0;
	NRF_DelayUs(1);
	NRF_WriteReg(CONFIG, 0x0B);//RCRC:8,ģʽ
	NRF_CE = 1;
	NRF_DelayUs(200);//ģʽ->ģʽ(130us)+40us
	return NRF_ReadReg(CD);
}

//
u8 NRF_SendPayload(const u8 ack,const u8 *addr,const u8 channel,const u8 *buf)
{
	u16 i=1;

#ifdef DEBUG
	u8 k;
	printf("MAC:");
	for(k=0;k<MAC_LEN;k++)
	{
		printf("%02X ",addr[k]);
	}
	printf("\r\n");
	//printf("dst=%d,type=%d\r\n",buf[10],buf[14]);
#endif

	NRF_CE = 0;
	NRF_WriteBuf(TX_ADDR, addr, MAC_LEN);//дTXڵַ
	if(ack)
	{
		NRF_WriteBuf(RX_ADDR_P0, addr, MAC_LEN);//дͨ0,RXַ
	}
	NRF_WriteReg(RF_CH, channel);//RFͨƵ
	NRF_WriteReg(STATUS, IRQ_ALL);//״̬־
	NRF_ReadReg(FLUSH_RX);//FIFO
	NRF_ReadReg(FLUSH_TX);//巢FIFO
	NRF_WriteBuf(W_TX_PAYLOAD, buf, PAYLOAD_LEN);
	NRF_WriteReg(CONFIG, 0x0A);//RX_DR,TX_DS,MAX_RTжʹ,CRC:8,POWER_UP,ģʽ
	NRF_CE = 1;//CEΪ,CEߵƽʱСΪ10us
	NRF_DelayUs(10);
	while(i++)
	{
		if(TranFinish_flag)
		{
			TranFinish_flag = FALSE;
			return TRUE;
		}
		if(Timeout)
		{
			Timeout = FALSE;
			return FALSE;
		}
	}
	NRF_ReadReg(FLUSH_TX);//巢FIFO
	NRF_WriteReg(STATUS, IRQ_ALL);//״̬־
	return FALSE;
}

//ģʽ
void NRF_RxMode(const u8 *addr,const u8 channel)
{
	NRF_CE = 0;
	NRF_WriteBuf(RX_ADDR_P0, addr, MAC_LEN);//дRXڵַ
	NRF_WriteReg(RF_CH, channel);//RFͨƵ
	NRF_ReadReg(FLUSH_RX);//FIFO
	NRF_WriteReg(CONFIG, 0x0B);//RX_DR,TX_DS,MAX_RTжʹ,CRC:8,POWER_UP,ģʽ
	NRF_CE = 1;//CEΪ,ģʽ
}

void NRF_WriteAckPayload(u8 pipe, u8 *pBuf, u8 len)
{
	NRF_CE = 0;
	NRF_WriteBuf(W_ACK_PAYLOAD|pipe,pBuf,len);
	NRF_CE = 0;
}

void NRF_PowerDown(void)
{
	NRF_CE = 0;
	NRF_WriteReg(CONFIG, 0x79);//RX_DR,TX_DS,MAX_RTж,CRC:8,POWER_DOWN,ģʽ
}

void NRF_InterruptHandler(void)
{
	u8 status;
	
	status = NRF_ReadReg(STATUS);//״̬Ĵ,жж״̬
	if(status & RX_DR)//յ
	{
		NRF_RecvData();
	}
	if(status & TX_DS)//
	{
		TranFinish_flag=TRUE;
	}
	if(status & MAX_RT)//ط
	{
		Timeout=TRUE;
		NRF_ReadReg(FLUSH_TX);//巢FIFO
	}
	NRF_WriteReg(STATUS, status);//״̬־
}

//ⲿжϷ
void EXTI9_5_IRQHandler(void)
{
	if(EXTI_GetITStatus(EXTI_Line8) != RESET)//RFж
	{
		NRF_InterruptHandler();//жϴ
		EXTI_ClearITPendingBit(EXTI_Line8);
	}
}

void EXTI9_5Close(void)
{
	EXTI_InitTypeDef EXTI_InitStructure;
	NVIC_InitTypeDef NVIC_InitStructure;

	EXTI_InitStructure.EXTI_Line = NRF_IRQ_EXTI_LINE;
	EXTI_InitStructure.EXTI_LineCmd = DISABLE;
	EXTI_Init(&EXTI_InitStructure);

	NVIC_InitStructure.NVIC_IRQChannel = NRF_IRQ_EXTI_IRQn;
	NVIC_InitStructure.NVIC_IRQChannelCmd = DISABLE;
	NVIC_Init(&NVIC_InitStructure);

    EXTI_ClearITPendingBit(EXTI_Line8);
}

void NRF_DelayUs(u16 i)
{
	TIM_DelayUs(i);//1~65535usʱ	
}

//void NRF_DelayUs(u16 i)
//{
//	u16 k,j;
//	for(k=0;k<i;k++)
//		for(j=0;j<10;j++);
//}
