#ifndef _NRF_DATA_H_
#define _NRF_DATA_H_

#include "stm32f10x.h"

typedef char    BYTE;
typedef uint8_t BOOL;   

#define MAC_LEN					(5)
#define PAYLOAD_LEN				(32)
#define PALYOAD_HEADER_LEN		(sizeof(PayloadHeader))
#define PAYLOAD_DATA_LEN		(PAYLOAD_LEN-PALYOAD_HEADER_LEN)

#define DATA_BUF_COUNT			(50)
#define MAX_NODE_NUM			(32)	//ڵ
#define MAX_HOP_NUM				(MAX_NODE_NUM)

#define MAX_FAILED_COUNT		(3)     //ʧܴ
#define MAX_RETRY_COUNT			(3)
#define SEND_HEART_COUNT		(1)		//ʹ
#define MAX_ACK_TIME			(300)
#define HEART_PACK_TIME			(100)	//ɨ(10ms*100)

#define MULTI_PACK_INTERVAL		(1000)  //,λ10ms(10)
#define HEART_LINK_INTERVAL		(2500)  //ȴ,λ10ms(25)
#define WAIT_CONNECT_INTERVAL	(2000)  //ȴӼ,λ10ms(20)

enum NODESTATUS{INVALID,VALID};
enum LINKSTATUS{DISCONNECT,WAIT_CONNECT,CONNECTED,WAIT_CHANGE};
enum PAYLOADSTATUS{IDLE,WAIT_USE,WAIT_SEND,WAIT_RETRY,WAIT_SEND_RETRY,SEND_FAILED,SEND_SUCCESS,WAIT_ACK,WAIT_RECV,RECV_FAILED,WAIT_HANDLER};
enum PACKAGETYPE{DEL_NODE,ASSIGN_ADDR,START_LINK,BUILD_LINK,BUILD_LINK_ACK,CHECK_LINK,CHECK_LINK_ACK,ONE_DATA,ONE_DATA_ACK,NODE_KEY_DATA,NODE_KEY_DATA_ACK,WAY_KEY_DATA,WAY_KEY_DATA_ACK};

#define PACKAGE_SUCCESS   0x01
#define PACKAGE_FAILED    0x00

typedef void (*HANDLESENDCALLBACK)(u8 src_addr,u8 dst_addr,u8 pack_type,u16 num,u8 *buf,u8 status);
typedef void (*HANDLERECECALLBACK)(u8 src_addr,u8 dst_addr,u8 pack_type,u8 *buf);

#pragma pack(1)
typedef struct 
{
	u32 PID;     //ID
	u32 SID;     //payload ID
	u8 the_addr; //η͵ַ
	u8 src_addr; //Դ͵ַ
	u8 dst_addr; //Ŀĵַ
	u8 ass_addr; //ַ
	u8 hop_addr; //һַ
	u8 hop_count;//Ծ
	u8 pack_type;//ݰ
	u8 data;     //
}PayloadHeader,*LPayloadHeader;//payloadͷṹ,Ϊ16

typedef struct
{
	PayloadHeader header;    //payloadͷ
	u8 buf[PAYLOAD_DATA_LEN];//ݻ
}Payload,*LPayload;//payloadṹ 
#pragma pack()

typedef struct
{
	u8 status;         	 //ݰ״̬
	u8 isBroadcast;		 //Ƿ㲥
	u8 send_failed_count;//ʧܴ
	u8 retry_count;		 //ǰݰط
	u16 time_count;		 //ʱ
//	u8 dst_channel;      //ŵ
//	u8 dst_mac[MAC_LEN]; //͵ĿMACַ
	HANDLESENDCALLBACK HandleCallBack;//ص
	Payload payload;     //ݰ
}DATA_BUF,*LPDATA_BUF;//ͬݰ

typedef struct
{
	u32 pwd;
	u8 addr;		   		//ڵַ
	u8 local_mac[MAC_LEN];	//ڵmac
}NRFSTOREDATA,*LPNRFSTOREDATA;

#pragma pack(1)
typedef struct
{
	u32 shift_failed_count; //лʧܼ
	u32 shift_count;        //лɹ
	u32 recv_count;         //ݰ
	u32 pwd;
	u8 addr;           		//ǰַ
	u8 route_addr;
	u8 channel;             //ǰŵ
	u8 link_status;    		//״̬
	u8 send_failed_count;
	u8 node_mac[MAC_LEN];
}NODESTATUS;//ڵ״̬ṹ
#pragma pack()

typedef struct 
{
	u8 addr;	//ڵַ
	u8 path[MAX_HOP_NUM];
}RoutrTable,*LRoutrTable;

typedef struct
{
	u32 time;  
	u16 RID;
	u8 src_addr;
	u8 dst_addr;
	u8 pack_type;
}HANDLEMULTIPACK;//ظİ

typedef struct 
{
	u8 idx;
	u8 addr;
}PathTable;

#endif
