#include "bsp.h"

NODESTATUS NodeStatus;//ڵ״̬
static RoutrTable route_table[MAX_NODE_NUM];
static PathTable path_table[MAX_NODE_NUM];
static HANDLEMULTIPACK IsHandle[DATA_BUF_COUNT];
static DATA_BUF DataBuf[DATA_BUF_COUNT];//ݻ,󳤶PAYLOAD_DATA_LEN
static u32 heart_time=0,wait_time=0;
static u16 link_time=0;
static u8 ThreadLock=0,isLink=0;
static u8 pipe1_mac[MAC_LEN]={0x00,0xB9,0x7F,0x55,0xB0};//ͨ1ַ(ڵ)
static u8 pipe2_mac[MAC_LEN]={0xFF,0xB9,0x7F,0x55,0xB0};//ͨ2ַ(нڵ),ַ
static HANDLERECECALLBACK RecvHandler=NULL;
static HANDLESENDCALLBACK SendHandler=NULL;

void NRF_Init(void)//ʼЭ
{
	MemSet((BYTE *)&DataBuf,0,sizeof(DATA_BUF)*DATA_BUF_COUNT);//ʼΪ״̬
	MemSet((BYTE *)&IsHandle,0,sizeof(HANDLEMULTIPACK)*DATA_BUF_COUNT);
	MemSet((BYTE *)&route_table,0,sizeof(RoutrTable)*MAX_NODE_NUM);//ʼڵ״̬
	MemSet((BYTE *)&NodeStatus,0,sizeof(NODESTATUS));//ʼڵ״̬
	if(NRF_IsHaveStoreData(NRF_STORE_FLAG,NRF_STORE_ADDRESS))
	{
		NRF_ReadParam();
	}
	NodeStatus.route_addr=0x01;
	NodeStatus.channel=124;//ʼŵ124,ŵ0~124
	NodeStatus.link_status=DISCONNECT;
	NRF_Config(NodeStatus.node_mac,NodeStatus.channel);//Ӳʼ
	NRF_SetPipe1Mac(pipe1_mac);
	NRF_SetPipe2Mac(pipe2_mac);
	IS_TIMEOUT_10MS(eTim3, 0);
}

void NRF_SetPipe1Mac(u8 *addr)
{
	NRF_CE = 0;
	NRF_GetMacAddr(addr,0xff);//MACַ
	if(addr[0]==0xFF)
	{
		addr[0]-=1;
	}
	NRF_WriteBuf(RX_ADDR_P1, addr, MAC_LEN);//дͨ1,RXַ
	NRF_WriteReg(CONFIG, 0x0B);//ģʽ
	NRF_CE = 1;
}

void NRF_SetPipe2Mac(u8 *addr)
{
	NRF_CE = 0;
	NRF_WriteReg(RX_ADDR_P2, addr[0]);//дͨ2,RXַ
	NRF_WriteReg(CONFIG, 0x0B);//ģʽ
	NRF_CE = 1;
}

void NRF_SetDefaultRecvHandler(HANDLERECECALLBACK pFun)
{
	RecvHandler=pFun;
}

void NRF_SetDefaultSendHandler(HANDLESENDCALLBACK pFun)
{
	SendHandler=pFun;
}

void NRF_SetWaitLinkTime(u32 time)
{
	wait_time=time;
}

u8 NRF_GetThreadLockState(void)
{
	return ThreadLock;
}

void NRF_WaitDistributionAddr(void)
{
	NRF_ClearStroreData(NRF_STORE_ADDRESS);
	MemSet((BYTE *)&NodeStatus.node_mac,0,MAC_LEN);//ʼmacַ
	NodeStatus.addr=0;
}

void NRF_StoreParam(void)
{
	NRFSTOREDATA store_data;
	MemSet((BYTE *)&store_data,0,sizeof(NRFSTOREDATA));
	store_data.addr=NodeStatus.addr;
	store_data.pwd=NodeStatus.pwd;
	MemCopy((BYTE *)store_data.local_mac,(BYTE *)NodeStatus.node_mac,MAC_LEN);
	EE_FlashWrite(NRF_STORE_FLAG,NRF_STORE_ADDRESS,(u8 *)&store_data,sizeof(NRFSTOREDATA));//д1ҳflash
	NRF_SetPipe1Mac(pipe1_mac);
}

static void NRF_ReadParam(void)
{
	if(NRF_IsHaveStoreData(NRF_STORE_FLAG,NRF_STORE_ADDRESS))
	{
		NRFSTOREDATA store_data;

		MemSet((BYTE *)&store_data,0,sizeof(NRFSTOREDATA));
		EE_FlashReadFlag(NRF_STORE_FLAG,NRF_STORE_ADDRESS,(u8 *)&store_data,sizeof(NRFSTOREDATA));
		NodeStatus.addr=store_data.addr;
		NodeStatus.pwd=store_data.pwd;
		MemCopy((BYTE *)NodeStatus.node_mac,(BYTE *)store_data.local_mac,MAC_LEN);
	}
}

void NRF_CalcCols(u8 *col,u8 addr)
{
	u8 i;

	for(i = 5; i > 0; i--)
	{
		*col = (*col << 1) ^ addr;
		col++;
	}
}

void NRF_InvMixColumn(u8 *column,u8 addr)
{
	u8 r[5];

	r[0] = column[1] ^ column[2] ^ column[3] ^ column[4];
	r[1] = column[0] ^ column[2] ^ column[3] ^ column[4];
	r[2] = column[0] ^ column[1] ^ column[3] ^ column[4];
	r[3] = column[0] ^ column[1] ^ column[2] ^ column[4];
	r[4] = column[0] ^ column[1] ^ column[2] ^ column[3];

	NRF_CalcCols(column,addr);

	r[0] ^= column[0] ^ column[1];
	r[1] ^= column[1] ^ column[2];
	r[2] ^= column[2] ^ column[3];
	r[3] ^= column[3] ^ column[4];
	r[4] ^= column[4] ^ column[0];

	NRF_CalcCols(column,addr);

	r[0] ^= column[0] ^ column[2];
	r[1] ^= column[1] ^ column[3];
	r[2] ^= column[2] ^ column[4];
	r[3] ^= column[3] ^ column[0];
	r[4] ^= column[4] ^ column[1];

	NRF_CalcCols(column,addr);

	column[0] ^= column[1] ^ column[2] ^ column[3] ^ column[4];
	r[0] ^= column[0];
	r[1] ^= column[0];
	r[2] ^= column[0];
	r[3] ^= column[0];
	r[4] ^= column[0];
	
	column[0] = r[0];
	column[1] = r[1];
	column[2] = r[2];
	column[3] = r[3];
	column[4] = r[4];
}

void NRF_GetMacAddr(u8 *mac,const u8 addr)
{
	u8 str[5]={0};
	u8 str1[10]={0};
	u8 i;
	
	sprintf((char *)str1,"%d",NodeStatus.pwd);
	if(addr>0&&addr<0xFF)
	{
		for(i=0;i<10;i++)//
		{
			 str1[i] ^= addr;
		}
		if(addr>0&&addr<128)
		{
			str[1] = (str1[0]+str1[1])<<2;
			str[2] = (str1[2]+str1[3])<<2;
			str[3] = (str1[4]+str1[5])<<2;
			str[4] = (str1[6]+str1[7])<<2;
			str[0] = (str1[8]+str1[9])<<2;
		}
		if(addr>=128&&addr<0xFF)
		{
			str[1] = (str1[0]+str1[1]);
			str[2] = (str1[2]+str1[3]);
			str[3] = (str1[4]+str1[5]);
			str[4] = (str1[6]+str1[7]);
			str[0] = (str1[8]+str1[9]);
		}
		NRF_InvMixColumn(str,addr);
	}
	else 
	{
		if(addr==0xFF)
		{
			str[0]=cal_crc8(str1, 10);
			str[1]=0xB9;
			str[2]=0x7F;
			str[3]=0x55;
			str[4]=0xB0;
		}
		if(addr==0)
		{
			for(i=0;i<5;i++)
			{
				 str[i] = 0xFF;
			}
		}
	}
	MemCopy((BYTE *)mac,(BYTE *)str,MAC_LEN);
}

void NRF_SendData(const u8 dst_addr,const u8 type,const u8 *buf,HANDLESENDCALLBACK fun)//ݽӿ
{
	static u32 id=0;
	u8 idx;

	if(dst_addr!=NodeStatus.addr)
	{
		idx=NRF_MallocIdleDataBufId();
		if(0xFF==idx)
		{
			return;
		}
		DataBuf[idx].status=WAIT_SEND;
		DataBuf[idx].HandleCallBack=fun;
		DataBuf[idx].payload.header.PID=NodeStatus.pwd;
		DataBuf[idx].payload.header.SID=id++;//ȡΨһID
		DataBuf[idx].payload.header.the_addr=NodeStatus.addr;
		DataBuf[idx].payload.header.src_addr=NodeStatus.addr;
		DataBuf[idx].payload.header.dst_addr=dst_addr;
		DataBuf[idx].payload.header.ass_addr=dst_addr;
		DataBuf[idx].payload.header.hop_addr=0;
		DataBuf[idx].payload.header.hop_count=0;
		DataBuf[idx].payload.header.pack_type=type;
		MemCopy((BYTE *)DataBuf[idx].payload.buf,(BYTE *)buf,PAYLOAD_DATA_LEN);
		//if(CHECK_LINK==type) NodeStatus.heart_status=1;
		if(0xFFFFFFFF==id)
		{
			id=0;
		}
	}
}

static void NRF_AutoLink(void)//Զ
{
	static u8 iFlag=0;
	static u8 nCnt=0;
	
	switch(NodeStatus.link_status)
	{
		case DISCONNECT:
			if(NodeStatus.addr>=30&&NodeStatus.addr<0xFF)
			{
				link_time++;
				if(link_time>500)//5
				{
					u8 path[MAX_HOP_NUM]={0};
					
					NRF_SendData(NodeStatus.route_addr,START_LINK,path,SendHandler);//ݽӿ
					link_time=0;
				}
				if(IS_TIMEOUT_10MS(eTim3, 3000)&&!iFlag)//30s
				{
					if(nCnt<3)
					{
						if(!NRF_CheckReg())
						{
							SetLed(0xff,300,20);
							NRF_Init();
							iFlag=1;
						}
						else
						{
							nCnt++;
						}
					}
				}
			}
			break;
		case WAIT_CONNECT:
			if(Get_RunTime()-wait_time>=WAIT_CONNECT_INTERVAL)//20
			{
				NodeStatus.link_status=DISCONNECT;
				link_time=500;
				IS_TIMEOUT_10MS(eTim3, 0);
				if(NodeStatus.addr>=30&&NodeStatus.addr<0xFF)
				{
					SetLed(0xff,100,100);
				}
				else
				{
					SetLed(0xff,18,18);
				}
			}
			break;
		case CONNECTED:
			if(isLink)
			{
				if(Get_RunTime()-heart_time>=300)//Ӻȴ3뷢ͱ״̬·ɽڵ
				{
					char cmd_buf[PAYLOAD_DATA_LEN]={0};

					isLink=0;
					sprintf(cmd_buf,"{ck%03d%03d%d}",NodeStatus.addr/10,Get_Nid(NodeStatus.addr),
														GPIO_ReadInputDataBit(GPIOA,RELAY_PIN));
					NRF_SendData(NodeStatus.route_addr,NODE_KEY_DATA,(u8 *)cmd_buf,SendHandler);
				}
			}
			if(Get_RunTime()-heart_time>HEART_LINK_INTERVAL)//25;1
			{
				nCnt=0;
				iFlag=0;
				IS_TIMEOUT_10MS(eTim3, 0);
				NodeStatus.link_status=DISCONNECT;
				link_time=500;
				SetLed(0xff,100,100);
			}				
			break;
		default:break;
	}
}

u8 NRF_UpdateToRoutrTablePath(u8 idx,LPayload pPayLoad)//·
{
	u8 k;
	
	MemCopy((BYTE *)route_table[idx].path,(BYTE *)pPayLoad->buf,sizeof(pPayLoad->buf));
	if(pPayLoad->header.hop_addr)//һַЧ
	{
		for(k=0; k<MAX_HOP_NUM; k++)//·
		{
			if(!route_table[idx].path[k])//ҵλ
			{
				route_table[idx].path[k]=pPayLoad->header.hop_addr;//һַӵ·
				return TRUE;
			}
		}
	}
	return FALSE;
}

//0,б; 1,ӳɹ;
u8 NRF_AddNodeToRoutrTable(LPayload pPayLoad)//1ڵ㵽·ɱ
{
	u8 i;

	for(i=0; i<MAX_NODE_NUM; i++)//·ɱ
	{
		if(route_table[i].addr==pPayLoad->header.the_addr)//ڵѴ
		{
			NRF_UpdateToRoutrTablePath(i,pPayLoad);//·
			return TRUE;
		}
	}
	for(i=0; i<MAX_NODE_NUM; i++)//ûҵַ
	{
		if(!route_table[i].addr)//ҵλ
		{
			route_table[i].addr=pPayLoad->header.the_addr;//ӵ·ɱ
			NRF_UpdateToRoutrTablePath(i,pPayLoad);//·
			return TRUE;
		}
	}
	return FALSE;
}

void NRF_DelNodePath(u8 node)//ɾڵ
{
	u8 i,j,k;

	for(i=0; i<MAX_NODE_NUM; i++)//·ɱ
	{
		if(route_table[i].addr)
		{
			if(route_table[i].addr==node)
			{
				MemSet((BYTE *)&route_table[i],0,sizeof(RoutrTable));//·ɱɾ1ڵ
			}
			else
			{
				for(j=0; j<MAX_HOP_NUM; j++)//·
				{
					if(route_table[i].path[j]==node)//ҵڵ
					{
						route_table[i].path[j]=0;//ɾڵ
						for(k=j+1; k<MAX_HOP_NUM; k++)//ɾڵλÿʼ·,нڵ1λ
						{
							route_table[i].path[k-1]=route_table[i].path[k];//
						}
					}
				}
			}
		}
	}
	for(i=0; i<MAX_NODE_NUM; i++)//·ɱ
	{
		if(!route_table[i].addr)
		{
			for(j=i+1; j<MAX_NODE_NUM; j++)
			{
				if(route_table[j].addr)//еַƵǰ
				{
					route_table[i].addr=route_table[j].addr;
					MemCopy((BYTE *)route_table[i].path,(BYTE *)route_table[j].path,sizeof(route_table[i].path));
					MemSet((BYTE *)&route_table[j],0,sizeof(RoutrTable));//·ɱɾ1ڵ
					break;
				}
			}
		}
	}
}

u8 NRF_FindNodePath(u8 node)//ҽڵ·
{
	u8 i,j,k,n,min,addr;

	MemSet((BYTE *)&path_table,0,sizeof(PathTable)*MAX_NODE_NUM);
	for(i=0; i<MAX_NODE_NUM; i++)//ڵб
	{
		if(route_table[i].addr)
		{
			if(route_table[i].addr==node)
			{
				return route_table[i].addr;//· 
			}
			else
			{
				for(j=0; j<MAX_HOP_NUM; j++)//·
				{
					if(route_table[i].path[j]==node)//·ҵַ
					{
						n=0;
						for(k=j+1; k<MAX_HOP_NUM; k++)//nֵ
						{
							if(route_table[i].path[k])//еַ
							{
								n++;//nֵԽԽԶ
							}
						}
						for(k=0; k<MAX_NODE_NUM; k++)//·
						{
							if(!path_table[k].addr)//ҵλ
							{
								path_table[k].idx=n;//nֵ
								path_table[k].addr=route_table[i].addr;//ڵַ
								break;
							}
						}
						break;	
					}
				}
			}
		}
	}
	if(!path_table[0].addr)//ûнڵַ
		return 0xFF;
	
	min=path_table[0].idx;
	addr=path_table[0].addr;
	for(i=0; i<MAX_NODE_NUM; i++)//·
	{
		if(path_table[i].addr)//нڵַ
		{
			if(path_table[i].idx<min)//С
			{
				min=path_table[i].idx;
				addr=path_table[i].addr;
			}
		}
	}
	return addr;//ؽڵַ(һַ)
}

static void NRF_NrfSendData(void)//ݻ״̬,ǰȼ
{
	u8 index;
	
	index=NRF_SearchDataBuf(WAIT_SEND);
	if(0xFF==index)
	{
		index=NRF_SearchDataBuf(WAIT_SEND_RETRY);
	}
	if(0xFF!=index)//ݻд
	{
		if(!NRF_DisturbanceDetect())//Ƿڵڷ
		{
			u8 send_mac[MAC_LEN]={0};
			u8 dst_addr;
			
			switch(DataBuf[index].payload.header.pack_type)
			{
				case ASSIGN_ADDR:
				case DEL_NODE:
					DataBuf[index].isBroadcast=1;
				break;
				default:
					dst_addr=NRF_FindNodePath(DataBuf[index].payload.header.dst_addr);//Ѱ·
					if(0xFF!=dst_addr)
					{
						NRF_GetMacAddr(send_mac,dst_addr);//ȡMACַ
					}
					else//·ɱûеַ,㲥
					{
						DataBuf[index].isBroadcast=1;
					}
				break;
			}
			NodeStatus.shift_failed_count=0;
			NodeStatus.shift_count++;
			if(!DataBuf[index].isBroadcast)
			{
				if(NRF_SendPayload(ACK,send_mac,NodeStatus.channel,
									(u8 *)&DataBuf[index].payload))//ͨ0
				{	
					DataBuf[index].status=SEND_SUCCESS;
				}
				else
				{
					DataBuf[index].status=WAIT_SEND_RETRY;
					DataBuf[index].send_failed_count++;
				}
			}
			else//㲥
			{
				switch(DataBuf[index].payload.header.pack_type)
				{
					case ASSIGN_ADDR:
						NRF_SendPayload(NO_ACK,pipe2_mac,NodeStatus.channel,
										(u8 *)&DataBuf[index].payload);//ͨ2(нڵ㲥)
					break;
					default:
						NRF_SendPayload(NO_ACK,pipe1_mac,NodeStatus.channel,
										(u8 *)&DataBuf[index].payload);//ͨ1(ڵ㲥)
					break;
				}
				DataBuf[index].status=SEND_FAILED;
			}
			NRF_RxMode(NodeStatus.node_mac,NodeStatus.channel);
		}
		else
		{
			NodeStatus.shift_failed_count++;
			if(NodeStatus.shift_failed_count>300)
			{
				NodeStatus.shift_failed_count=0;
				//NRF_SetChannel(Pro_AppropriateChannelDetect());//ӵ̶͵ŵ
				NRF_Init();
			}
		}
	}
}

static void NRF_RelayPackage(LPayload pPayLoad)//ת
{
	u8 idx;
	
	if(pPayLoad->header.PID==NodeStatus.pwd)//ID
	{
		idx=NRF_MallocIdleDataBufId();
		if(0xFF!=idx)
		{
			DataBuf[idx].status=WAIT_SEND;
			MemCopy((BYTE*)&DataBuf[idx].payload,(BYTE *)pPayLoad,sizeof(Payload));
			switch(pPayLoad->header.pack_type)
			{
				case ASSIGN_ADDR:
				case BUILD_LINK:
				case START_LINK:
					DataBuf[idx].payload.header.hop_count+=1;//Ծ1
					DataBuf[idx].payload.header.hop_addr=DataBuf[idx].payload.header.the_addr;//һַ=ݰķ͵ַ
					DataBuf[idx].payload.header.the_addr=NodeStatus.addr;//η͵ַ=ڵַ
					break;
				default:
					break;
			}
		}
#ifdef DEBUG
		//printf("\r\n***Relay-Package***\r\n");
#endif
	}
}

static void NRF_HandlePackage(LPayload pPayLoad)
{
	switch(pPayLoad->header.pack_type)
	{
		case START_LINK://ڵ-> ·
			NRF_AddNodeToRoutrTable(pPayLoad);//ӽڵ㵽·ɱ
			NRF_RelayPackage(pPayLoad);//ת
			break;
		case ASSIGN_ADDR://->ڵ ·
			NRF_AddNodeToRoutrTable(pPayLoad);//ӽڵ㵽·ɱ
			if(WAIT_CONNECT==NodeStatus.link_status)
			{
				if(pPayLoad->header.ass_addr>=30&&pPayLoad->header.ass_addr<0xFF)//Ϸַ
				{
					NodeStatus.addr=pPayLoad->header.ass_addr;//ȡַ
					NodeStatus.pwd=pPayLoad->header.PID;//ȡID
					NRF_GetMacAddr(NodeStatus.node_mac,NodeStatus.addr);//MACַ
					NRF_StoreParam();//浽FLASH
					NodeStatus.link_status=DISCONNECT;
					link_time=500;
					IS_TIMEOUT_10MS(eTim3, 0);
					SetLed(0xff,100,100);
				}
			}
			else
			{
				NRF_RelayPackage(pPayLoad);//ת
			}
			break;
		case DEL_NODE:
			NRF_DelNodePath(pPayLoad->header.ass_addr);//ɾڵ
			NRF_RelayPackage(pPayLoad);//ת
			if(pPayLoad->header.ass_addr==NodeStatus.addr)
			{
				NodeStatus.link_status=DISCONNECT;
				link_time=500;
				IS_TIMEOUT_10MS(eTim3, 0);
				SetLed(0xff,100,100);
			}
			break;
		default:
			if(pPayLoad->header.dst_addr==NodeStatus.addr)
			{
				u8 idx;
				switch(pPayLoad->header.pack_type)
				{
					case CHECK_LINK:
						heart_time=Get_RunTime();
						NRF_SendData(NodeStatus.route_addr,CHECK_LINK_ACK,(u8 *)"",SendHandler);//ݽӿ
						break;
					case BUILD_LINK:
						NRF_AddNodeToRoutrTable(pPayLoad);//ӽڵ㵽·ɱ
						heart_time=Get_RunTime();
						NodeStatus.link_status=CONNECTED;
						isLink=1;
						NRF_SendData(NodeStatus.route_addr,BUILD_LINK_ACK,(u8 *)"",SendHandler);//ݽӿ
					case ONE_DATA:
					case WAY_KEY_DATA:
					case NODE_KEY_DATA_ACK:
						idx=NRF_MallocIdleDataBufId();
						if(0xFF!=idx)
						{
							MemCopy((BYTE*)&DataBuf[idx].payload,(BYTE *)pPayLoad,PAYLOAD_LEN);
							DataBuf[idx].status=WAIT_HANDLER;
						}
						break;
					default:break;
				}
			}
			else
			{
				NRF_RelayPackage(pPayLoad);//ת
			}
			break;
	}
}

void NRF_RecvData(void)
{
	Payload tmp;
	u8 id;
#ifdef DEBUG	
	u8 status,pipe_num;

	status=NRF_ReadReg(STATUS);//ȡstatusĴֵ
	pipe_num=(status&RX_P_NO_MASK)>>1;
	printf("Pipe%d-Recv\r\n",pipe_num);
#endif	
	MemSet((BYTE *)&tmp,0,sizeof(Payload));
	NRF_ReadBuf(R_RX_PAYLOAD, (u8 *)&tmp, PAYLOAD_LEN);//յ
	NodeStatus.recv_count++;
	if(tmp.header.src_addr==NodeStatus.addr)//Լİ
	{
		NRF_RxMode(NodeStatus.node_mac, NodeStatus.channel);
		return;
	}
	if(ASSIGN_ADDR==tmp.header.pack_type||tmp.header.PID==NodeStatus.pwd)
	{
		//10ڴİٴ(ڹ㲥ʱյܶظİ)
		if(!NRF_CmpMultiPack(tmp.header.src_addr,tmp.header.dst_addr,
							 tmp.header.pack_type,tmp.header.SID))
		{
			id=NRF_SearchHandleTimeoutId();
			if(0xFF!=id)
			{
				IsHandle[id].RID=tmp.header.SID;
				IsHandle[id].time=Get_RunTime();
				IsHandle[id].src_addr=tmp.header.src_addr;
				IsHandle[id].dst_addr=tmp.header.dst_addr;
				IsHandle[id].pack_type=tmp.header.pack_type;
				//BspTim2SetCounter(0);
				NRF_HandlePackage(&tmp);
			}
		}
	}
	NRF_RxMode(NodeStatus.node_mac, NodeStatus.channel);
}

void NRF_HandleBuf(void)//ݻ״̬
{
	u8 i;
	
	for(i=0;i<DATA_BUF_COUNT;i++)
	{
		switch(DataBuf[i].status)
		{
			case WAIT_SEND_RETRY:
				if(DataBuf[i].send_failed_count>=MAX_FAILED_COUNT)
				{
					DataBuf[i].isBroadcast=1;
				}
				break;
			case WAIT_HANDLER:
				if(RecvHandler)
				{
					RecvHandler(DataBuf[i].payload.header.src_addr,
								DataBuf[i].payload.header.dst_addr,
								DataBuf[i].payload.header.pack_type,
								DataBuf[i].payload.buf);
				}
				NRF_FreeDataBuf(i);
				break;
			case SEND_SUCCESS:
				if(DataBuf[i].HandleCallBack)
				{
					DataBuf[i].HandleCallBack(DataBuf[i].payload.header.src_addr,
												DataBuf[i].payload.header.dst_addr,
												DataBuf[i].payload.header.pack_type,
												DataBuf[i].payload.header.SID,
												DataBuf[i].payload.buf,PACKAGE_SUCCESS);
				}
				NRF_FreeDataBuf(i);
				break;
			case SEND_FAILED:
				if(DataBuf[i].HandleCallBack)
				{
					DataBuf[i].HandleCallBack(DataBuf[i].payload.header.src_addr,
												DataBuf[i].payload.header.dst_addr,
												DataBuf[i].payload.header.pack_type,
												DataBuf[i].payload.header.SID,
												DataBuf[i].payload.buf,PACKAGE_FAILED);
				}
				NRF_FreeDataBuf(i);
				break;
			default:
				break;
		}
	}
}

u8 NRF_AppropriateChannelDetect(void)//ӵ̶͵ŵ
{
	u8 channel,min_disturb_count=11,i,j;
	u8 disturb_count[125]={0};

	ThreadLock=1;
	//MemSet((BYTE *)disturb_count,0,125);
	channel=NRF_ReadChannel();
	for(i=0;i<10;i++)
	{
		for(j=0;j<125;j++)
		{
			NRF_SetChannel(i);
			if(NRF_DisturbanceDetect())
			{
				disturb_count[j]++;
			}
		}
	}
	NRF_SetChannel(channel);
	for(i=0;i<125;i++)
	{
		if(disturb_count[i]<min_disturb_count)
		{
			min_disturb_count=disturb_count[i];
			channel=i;
		}
	}
	NRF_ReadReg(FLUSH_RX);//FIFO
	ThreadLock=0;
	return channel;
}

void NRF_Thread(void)//ʱ߳,ִЭ
{
	NRF_AutoLink();
//	NRF_SendHeartPack();
	NRF_NrfSendData();
	NRF_HandleBuf();
}

u8 NRF_MallocIdleDataBufId(void)//õһDATABUF,Ϊ
{
	u8 i;
	
	ThreadLock=1;//
	for(i=0;i<DATA_BUF_COUNT;i++)
	{
		if(IDLE==DataBuf[i].status)
		{
			DataBuf[i].status=WAIT_USE;
			ThreadLock=0;//
			return i;
		}
	}
	ThreadLock=0;//
	return 0xFF;
}	

void NRF_FreeDataBuf(const u8 id)//ͷűʹõDATABUF,ıΪ״̬
{
	if(id>(DATA_BUF_COUNT-1)||id==0xFF)
	{
		return;
	}
	ThreadLock=1;//
	MemSet((BYTE *)&DataBuf[id],0,sizeof(DATA_BUF));
	ThreadLock=0;//
}

u8 NRF_SearchDataByID(u16 ID)//ID
{
	u8 i;

	for(i=0;i<DATA_BUF_COUNT;i++)
	{
		if(IDLE!=DataBuf[i].status&&ID==DataBuf[i].payload.header.SID)
		{
			return i;
		}
	}
	return 0xFF;
}

u8 NRF_SearchDataBuf(const u8 status)//״̬ΪstatusDataBuf,
{
	u8 i;
	
	for(i=0;i<DATA_BUF_COUNT;i++)
	{
		if(status==DataBuf[i].status)
		{
			return i;
		}
	}
	return 0xFF;
}

u8 NRF_SearchHandleTimeoutId(void)
{
	u8 i;
	
	for(i=0;i<DATA_BUF_COUNT;i++)
	{
		if(Get_RunTime()-IsHandle[i].time>MULTI_PACK_INTERVAL)
		{
			return i;
		}
	}
	return 0xFF;
}

u8 NRF_CmpMultiPack(const u8 src_addr,const u8 dst_addr,const u8 pack_type,const u16 ID)
{
	u8 i;

	for(i=0;i<DATA_BUF_COUNT;i++)
	{
		if(Get_RunTime()-IsHandle[i].time<MULTI_PACK_INTERVAL)
		{
			if(ID==IsHandle[i].RID&&pack_type==IsHandle[i].pack_type&&
				src_addr==IsHandle[i].src_addr&&dst_addr==IsHandle[i].dst_addr)
			{
				return TRUE;
			}
		}
	}
	return FALSE;
}
