/*
*********************************************************************************************************
* Copyright (C) 2009,ɽѧCSCEʵ
All rights reserved.
                                
* ļ      : app.c
*           :wangxuewei
* ժҪ          :Ӧó

* ǰ汾      :v1.0
*       :20090928
*********************************************************************************************************
*/
/*
*********************************************************************************************************
*                                             INCLUDE FILES
*********************************************************************************************************
*/

#include <includes.h>

/*
*********************************************************************************************************
*                                         LOCAL GLOBAL VARIABLES
*********************************************************************************************************
*/


/*
*********************************************************************************************************
*                                       LOCAL GLOBAL VARIABLES
*********************************************************************************************************
*/
/* ----------------- APPLICATION GLOBALS ------------------ */

/* -------- uC/OS-II APPLICATION TASK STACKS -------------- */
static  OS_STK         App_TaskStartStk[APP_CFG_TASK_START_STK_SIZE];
static  OS_STK         App_TaskLed1Stk[APP_CFG_TASK_LED1_STK_SIZE];
static  OS_STK         App_TaskLed2Stk[APP_CFG_TASK_LED2_STK_SIZE];
static  OS_STK         App_TaskKey1Stk[APP_CFG_TASK_KEY1_STK_SIZE];
static  OS_STK         App_TaskKey2Stk[APP_CFG_TASK_KEY2_STK_SIZE];
/*
*********************************************************************************************************
*                                      LOCAL FUNCTION PROTOTYPES
*********************************************************************************************************
*/

static void  App_EventCreate      (void);
//static  void  App_EventCreate2   (void);
static  void  App_TaskCreate    (void);
static  void  App_TaskStart     (void *p_arg);
static  void  App_TaskLed1     (void *p_arg);
static  void  App_TaskLed2     (void *p_arg);
static  void  App_TaskKey1     (void *p_arg);
static  void  App_TaskKey2     (void *p_arg);
//static  OS_FLAG_GRP *App_SLEDFLAG1;
//static  OS_FLAG_GRP *App_SLEDFLAG2;
static OS_EVENT *App_LEDSem1;
//static OS_EVENT *App_LEDSem2;
static OS_EVENT *App_LEDMbox;
/*
static  void  App_FormatDec     (CPU_INT08U  *s, 
                                  CPU_INT32U  value, 
                                  CPU_INT08U  digits)
*/
/*
*********************************************************************************************************
* main().ʼuC/OSһ񣬲ʼ
* 
* 
*ֵ   
*********************************************************************************************************
*/
int  main (void)
{
#if (OS_TASK_NAME_SIZE > 5)
    CPU_INT08U  err;
#endif

    BSP_IntDisAll();                                            /* Disable all interrupts until we are ready to accept them */

    OSInit();                                                   /* Initialize "uC/OS-II, The Real-Time Kernel"              */

    OSTaskCreateExt((void (*)(void *)) App_TaskStart,           /* Create the start task                                    */
                    (void           *) 0,
                    (OS_STK         *)&App_TaskStartStk[APP_CFG_TASK_START_STK_SIZE - 1],
                    (INT8U           ) APP_CFG_TASK_START_PRIO,
                    (INT16U          ) APP_CFG_TASK_START_PRIO,
                    (OS_STK         *)&App_TaskStartStk[0],
                    (INT32U          ) APP_CFG_TASK_START_STK_SIZE,
                    (void           *) 0,
                    (INT16U          )(OS_TASK_OPT_STK_CHK | OS_TASK_OPT_STK_CLR));

#if (OS_TASK_NAME_SIZE > 5)
    OSTaskNameSet(APP_CFG_TASK_START_PRIO, "Start", &err);
#endif

    OSStart();                                                  /* Start multitasking (i.e. give control to uC/OS-II)       */
}

/*
*********************************************************************************************************
* App_TaskStart().ʼãصѹ
* 
* 
*ֵ   
*********************************************************************************************************
*/
static  void  App_TaskStart (void *p_arg)
{        
    (void)p_arg;                                                /* See Note #1                                              */

    BSP_Init();                                                 /* Initialize BSP functions                                 */
    OS_CPU_SysTickInit();                                       /* Initialize the SysTick.                              */

#if (OS_TASK_STAT_EN > 0)
    OSStatInit();                                               /* Determine CPU capacity                                   */
#endif

     App_EventCreate();                                          /* Create application events.                           */
     App_TaskCreate();                                           /* Create application tasks.                            */
    
     /* Task init code  */    

    while (DEF_TRUE) 
    {                                          /* Task body, always written as an infinite loop.            */
      //OSTimeDly(OS_TICKS_PER_SEC);
      OSTimeDlyHMSM(0,0,5,0);
    }
}

/*
*********************************************************************************************************
* ¼壬䣬־λ
* 
* 
*ֵ   
*********************************************************************************************************
*/
static  void  App_EventCreate (void)
{
#if (OS_EVENT_NAME_SIZE > 9)  
    CPU_INT08U  os_err;
#endif    
  App_LEDSem1=OSSemCreate(1);
 // App_LEDSem2=OSSemCreate(1);
    App_LEDMbox=OSMboxCreate((void *)0);
#if (OS_TASK_NAME_SIZE > 4)
    OSEventNameSet(App_LEDMbox, "User IF Mbox", &os_err);
#endif

}
/*
*********************************************************************************************************
* 񣬸
* 
* 
*ֵ   
*********************************************************************************************************
*/
static  void  App_TaskCreate (void)
{
#if (OS_TASK_NAME_SIZE > 8)        
    CPU_INT08U      err;
#endif
 OSTaskCreateExt((void (*)(void *)) App_TaskLed1,           /* Create the start task                                    */
                    (void           *) 0,
                    (OS_STK         *)&App_TaskLed1Stk[APP_CFG_TASK_LED1_STK_SIZE - 1],
                    (INT8U           ) APP_CFG_TASK_LED1_PRIO,
                    (INT16U          ) APP_CFG_TASK_LED1_PRIO,
                    (OS_STK         *)&App_TaskLed1Stk[0],
                    (INT32U          ) APP_CFG_TASK_LED1_STK_SIZE,
                    (void           *) 0,
                    (INT16U          )(OS_TASK_OPT_STK_CHK | OS_TASK_OPT_STK_CLR));

#if (OS_TASK_NAME_SIZE > 4)
    OSTaskNameSet(APP_CFG_TASK_LED1_PRIO, "LED1", &err);
#endif   
 OSTaskCreateExt((void (*)(void *)) App_TaskLed2,           /* Create the start task                                    */
                    (void           *) 0,
                    (OS_STK         *)&App_TaskLed2Stk[APP_CFG_TASK_LED2_STK_SIZE - 1],
                    (INT8U           ) APP_CFG_TASK_LED2_PRIO,
                    (INT16U          ) APP_CFG_TASK_LED2_PRIO,
                    (OS_STK         *)&App_TaskLed2Stk[0],
                    (INT32U          ) APP_CFG_TASK_LED2_STK_SIZE,
                    (void           *) 0,
                    (INT16U          )(OS_TASK_OPT_STK_CHK | OS_TASK_OPT_STK_CLR));

#if (OS_TASK_NAME_SIZE > 4)
    OSTaskNameSet(APP_CFG_TASK_LED2_PRIO, "LED2", &err);
#endif
    OSTaskCreateExt((void (*)(void *)) App_TaskKey1,           /* Create the start task                                    */
                    (void           *) 0,
                    (OS_STK         *)&App_TaskKey1Stk[APP_CFG_TASK_KEY1_STK_SIZE - 1],
                    (INT8U           ) APP_CFG_TASK_KEY1_PRIO,
                    (INT16U          ) APP_CFG_TASK_KEY1_PRIO,
                    (OS_STK         *)&App_TaskKey1Stk[0],
                    (INT32U          ) APP_CFG_TASK_KEY1_STK_SIZE,
                    (void           *) 0,
                    (INT16U          )(OS_TASK_OPT_STK_CHK | OS_TASK_OPT_STK_CLR));

#if (OS_TASK_NAME_SIZE > 3)
    OSTaskNameSet(APP_CFG_TASK_KEY1_PRIO, "Key1", &err);
#endif
       OSTaskCreateExt((void (*)(void *)) App_TaskKey2,           /* Create the start task                                    */
                    (void           *) 0,
                    (OS_STK         *)&App_TaskKey2Stk[APP_CFG_TASK_KEY2_STK_SIZE - 1],
                    (INT8U           ) APP_CFG_TASK_KEY2_PRIO,
                    (INT16U          ) APP_CFG_TASK_KEY2_PRIO,
                    (OS_STK         *)&App_TaskKey2Stk[0],
                    (INT32U          ) APP_CFG_TASK_KEY2_STK_SIZE,
                    (void           *) 0,
                    (INT16U          )(OS_TASK_OPT_STK_CHK | OS_TASK_OPT_STK_CLR));

#if (OS_TASK_NAME_SIZE >3)
    OSTaskNameSet(APP_CFG_TASK_KEY2_PRIO, "Key2", &err);
#endif
}



void  App_TaskLed1     (void *p_arg)
{(void)p_arg;
  u32 i;
   while (DEF_TRUE) 
    {  
      OSSemPost(App_LEDSem1);
      OPENA(GPIO_Pin_1);
      //OSTimeDlyHMSM(0,0,3,0);
      for(i=0;i<65536;i++);
      CLOSEC(GPIO_Pin_5);
      //OSTimeDlyHMSM(0,0,3,0);
      for(i=0;i<65536;i++);
    }    
}
void  App_TaskLed2     (void *p_arg)
{   (void)p_arg;
    CPU_INT08U os_err;
    u32 j;
   while (DEF_TRUE) 
    {  
      OSSemPend(App_LEDSem1,0,&os_err);
      OPENC(GPIO_Pin_5);
      //OSTimeDlyHMSM(0,0,3,0);
      for(j=0;j<65536;j++);
      CLOSEA(GPIO_Pin_1);
      for(j=0;j<65536;j++);
     // OSTimeDlyHMSM(0,0,3,0);
    }    
}

void  App_TaskKey1     (void *p_arg)
{
  (void)p_arg;
   
   while (DEF_TRUE) 
   {
      u32 k;
      OPENC(GPIO_Pin_6);
      //OSTimeDlyHMSM(0,0,0,1);
      for(k=0;k<65536;k++);
      CLOSEC(GPIO_Pin_7);
      //OSTimeDlyHMSM(0,0,0,1);
      for(k=0;k<65536;k++);
      OSMboxPost(App_LEDMbox,(void*)Appled);
   }
}
void  App_TaskKey2     (void *p_arg)
{
   CPU_INT08U os_err;
  
   while (DEF_TRUE) 
   {   
      
      OSMboxPend(App_LEDMbox,0 ,&os_err);
      if(os_err==OS_NO_ERR&&OSMboxPend(App_LEDMbox,0 ,&os_err)!=(void*)0)
    {  
       u32 m;
      CLOSEC(GPIO_Pin_6);
      //OSTimeDlyHMSM(0,0,0,1);
      for(m=0;m<65536;m++);
      OPENC(GPIO_Pin_7);
     // OSTimeDlyHMSM(0,0,0,1);
      for(m=0;m<65536;m++);
    }
    
   }
 
}


/*
*********************************************************************************************************
*                                      App_FormatDec()
*
* Description: This function converts a decimal value to ASCII (with leading zeros)
*
* Arguments  : s       is a pointer to the destination ASCII string
*              value   is the value to convert (assumes an unsigned value)
*              digits  is the desired number of digits
*
* Return(s)  : none.
*
* Caller(s)  : Application.
*
* Note(s)    : none.
*********************************************************************************************************
*/
/*
static  void  App_FormatDec (CPU_INT08U  *s, 
                             CPU_INT32U  value, 
                             CPU_INT08U  digits)
{
    CPU_INT08U      i;
    CPU_INT32U      mult;


    mult = 1;
    for (i = 0; i < (digits - 1); i++) {
        mult *= 10;
    }
    while (mult > 0) {
        *s++   = value / mult + '0';
        value %= mult;
        mult  /= 10;
    }
}

*/
/*
*********************************************************************************************************
*********************************************************************************************************
**                                         uC/OS-II APP HOOKS
*********************************************************************************************************
*********************************************************************************************************
*/

#if (OS_APP_HOOKS_EN > 0)
/*
*********************************************************************************************************
*                                      TASK CREATION HOOK (APPLICATION)
*
* Description : This function is called when a task is created.
*
* Argument(s) : ptcb   is a pointer to the task control block of the task being created.
*
* Note(s)     : (1) Interrupts are disabled during this call.
*********************************************************************************************************
*/

void  App_TaskCreateHook (OS_TCB *ptcb)
{
#if (APP_CFG_PROBE_OS_PLUGIN_EN == DEF_ENABLED) && (OS_PROBE_HOOKS_EN > 0)
    OSProbe_TaskCreateHook(ptcb);
#endif
}

/*
*********************************************************************************************************
*                                    TASK DELETION HOOK (APPLICATION)
*
* Description : This function is called when a task is deleted.
*
* Argument(s) : ptcb   is a pointer to the task control block of the task being deleted.
*
* Note(s)     : (1) Interrupts are disabled during this call.
*********************************************************************************************************
*/

void  App_TaskDelHook (OS_TCB *ptcb)
{
    (void)ptcb;
}

/*
*********************************************************************************************************
*                                      IDLE TASK HOOK (APPLICATION)
*
* Description : This function is called by OSTaskIdleHook(), which is called by the idle task.  This hook
*               has been added to allow you to do such things as STOP the CPU to conserve power.
*
* Argument(s) : none.
*
* Note(s)     : (1) Interrupts are enabled during this call.
*********************************************************************************************************
*/

#if OS_VERSION >= 251
void  App_TaskIdleHook (void)
{
}
#endif

/*
*********************************************************************************************************
*                                        STATISTIC TASK HOOK (APPLICATION)
*
* Description : This function is called by OSTaskStatHook(), which is called every second by uC/OS-II's
*               statistics task.  This allows your application to add functionality to the statistics task.
*
* Argument(s) : none.
*********************************************************************************************************
*/

void  App_TaskStatHook (void)
{
}

/*
*********************************************************************************************************
*                                        TASK SWITCH HOOK (APPLICATION)
*
* Description : This function is called when a task switch is performed.  This allows you to perform other
*               operations during a context switch.
*
* Argument(s) : none.
*
* Note(s)     : (1) Interrupts are disabled during this call.
*
*               (2) It is assumed that the global pointer 'OSTCBHighRdy' points to the TCB of the task that
*                   will be 'switched in' (i.e. the highest priority task) and, 'OSTCBCur' points to the
*                  task being switched out (i.e. the preempted task).
*********************************************************************************************************
*/

#if OS_TASK_SW_HOOK_EN > 0
void  App_TaskSwHook (void)
{
#if (APP_CFG_PROBE_OS_PLUGIN_EN == DEF_ENABLED) && (OS_PROBE_HOOKS_EN > 0)
    OSProbe_TaskSwHook();
#endif
}
#endif

/*
*********************************************************************************************************
*                                     OS_TCBInit() HOOK (APPLICATION)
*
* Description : This function is called by OSTCBInitHook(), which is called by OS_TCBInit() after setting
*               up most of the TCB.
*
* Argument(s) : ptcb    is a pointer to the TCB of the task being created.
*
* Note(s)     : (1) Interrupts may or may not be ENABLED during this call.
*********************************************************************************************************
*/

#if OS_VERSION >= 204
void  App_TCBInitHook (OS_TCB *ptcb)
{
    (void)ptcb;
}
#endif

/*
*********************************************************************************************************
*                                        TICK HOOK (APPLICATION)
*
* Description : This function is called every tick.
*
* Argument(s) : none.
*
* Note(s)     : (1) Interrupts may or may not be ENABLED during this call.
*********************************************************************************************************
*/

#if OS_TIME_TICK_HOOK_EN > 0
void  App_TimeTickHook (void)
{

}
#endif
#endif
