/*
*********************************************************************************************************
* Copyright (C) 2009,ɽѧCSCEʵ
All rights reserved.
                                
* ļ      : bsp.c
*           :wangxuewei
* ժҪ          :оƬΧ豸͵ײʼ

* ǰ汾      :v1.0
*       :20090928
*********************************************************************************************************
*/
/*
*********************************************************************************************************
*                                             INCLUDE FILES
*********************************************************************************************************
*/

#define  BSP_MODULE
#include <bsp.h>


/*
*********************************************************************************************************
*                                            LOCAL DEFINES
*********************************************************************************************************
*/

/* ------------ Max Timeout for RCC register ------------*/
#define  BSP_RCC_TO_VAL                  0x00000FFF           /* Max Timeout for RCC register          */

/* ------------------ жȼ趨 --------------------*/
#define     BSP_INT_ID_USB_LP_CAN_RX0_PRIO        12

/* ---------------------- chip configuration ---------------------- */

#define   ADC1_DR_Address         ((u32)0x4001244C)
#define   USART1_DR_Base          0x40013804
#define   USART2_DR_Base          0x40004404
#define   USART3_DR_Base          0x40004804    

/*
*********************************************************************************************************
*                                           EXTERNAL FUNCTIONS
*********************************************************************************************************
*/

/*
*********************************************************************************************************
*                                          LOCAL DATA TYPES
*********************************************************************************************************
*/

/*
*********************************************************************************************************
*                                      غ
*********************************************************************************************************
*/

static  void  BSP_RCC_Init      (void);
static  void  BSP_GPIO_Init     (void);

/*static void OPENA(u16 pinx);
static void OPENC(u16 pinx);
static void CLOSEA(u16 pinx);
static void CLOSEC(u16 pinx);*/
/*
*********************************************************************************************************
* BSPʼ
* 
* 
*ֵ   
*********************************************************************************************************
*/
void  BSP_Init (void)
{    
    BSP_RCC_Init();                                             /* Initialize the Reset and Control (RCC) module             */
    
    BSP_IntInit();
BSP_GPIO_Init();
}
/*
*********************************************************************************************************
* ȡCPUƵ
* 
* CPUƵʣλKHz
*ֵ   CPUƵʣλKHz
*********************************************************************************************************
*/
CPU_INT32U  BSP_CPU_ClkFreq (void)
{
    static  RCC_ClocksTypeDef  rcc_clocks;

    RCC_GetClocksFreq(&rcc_clocks);

    return ((CPU_INT32U)rcc_clocks.HCLK_Frequency);
}
/*
*********************************************************************************************************
* SystickʱжƵ
* 
* SystickʱжƵʣλKHz
*ֵ   SystickʱжƵʣλKHz
*********************************************************************************************************
*/
INT32U  OS_CPU_SysTickClkFreq (void)
{
    INT32U  freq;


    freq = BSP_CPU_ClkFreq();
    return (freq);
}
/*
*********************************************************************************************************
* RCCʼ
* 
* 
*ֵ   
*********************************************************************************************************
*/
static  void  BSP_RCC_Init (void) 
{    
 RCC_DeInit();
    RCC_HSEConfig(RCC_HSE_ON);
    RCC_WaitForHSEStartUp();


    RCC_HCLKConfig(RCC_SYSCLK_Div1);
    RCC_PCLK2Config(RCC_HCLK_Div1);
    RCC_PCLK1Config(RCC_HCLK_Div2);
    RCC_ADCCLKConfig(RCC_PCLK2_Div6);
    FLASH_SetLatency(FLASH_Latency_2);
    FLASH_PrefetchBufferCmd(FLASH_PrefetchBuffer_Enable);
    RCC_PLLConfig(RCC_PLLSource_HSE_Div1, RCC_PLLMul_9);
    RCC_PLLCmd(ENABLE);

    while (RCC_GetFlagStatus(RCC_FLAG_PLLRDY) == RESET) {
        ;
    }

    RCC_SYSCLKConfig(RCC_SYSCLKSource_PLLCLK);

    while (RCC_GetSYSCLKSource() != 0x08) {
        ;
    }
    
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA | RCC_APB2Periph_AFIO, ENABLE);//ʹܻʧ APB2 ʱ
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB, ENABLE);
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOC, ENABLE);
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOD, ENABLE);
  
}

void BSP_GPIO_Init(void)
{
  GPIO_InitTypeDef BSP_GPIO_Init;
  BSP_GPIO_Init.GPIO_Pin = GPIO_Pin_7|GPIO_Pin_6|GPIO_Pin_5;
  BSP_GPIO_Init.GPIO_Speed = GPIO_Speed_50MHz;
  BSP_GPIO_Init.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_Init(GPIOC, &BSP_GPIO_Init);
  
  BSP_GPIO_Init.GPIO_Pin = GPIO_Pin_1;
  BSP_GPIO_Init.GPIO_Speed = GPIO_Speed_50MHz;
  BSP_GPIO_Init.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_Init(GPIOA, &BSP_GPIO_Init);
  
  BSP_GPIO_Init.GPIO_Pin = GPIO_Pin_13|GPIO_Pin_14;
  BSP_GPIO_Init.GPIO_Speed = GPIO_Speed_50MHz;
  BSP_GPIO_Init.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_Init(GPIOD, &BSP_GPIO_Init);
 
  GPIO_ResetBits(GPIOD, GPIO_Pin_13 | GPIO_Pin_14);
  
  GPIO_SetBits(GPIOA, GPIO_Pin_1);
  GPIO_SetBits(GPIOC, GPIO_Pin_7|GPIO_Pin_6 | GPIO_Pin_5);
}

void OPENA(u16 pinx)
{
  GPIO_ResetBits(GPIOA,pinx);
}
void OPENC(u16 pinx)
{
  GPIO_ResetBits(GPIOC,pinx);
}
void CLOSEA(u16 pinx)
{
  GPIO_SetBits(GPIOA,pinx);
}
void CLOSEC(u16 pinx)
{
  GPIO_SetBits(GPIOC,pinx);
}