/*
*********************************************************************************************************
*                                                uC/GUI
*                        Universal graphic software for embedded applications
*
*                       (c) Copyright 2002, Micrium Inc., Weston, FL
*                       (c) Copyright 2002, SEGGER Microcontroller Systeme GmbH
*
*              C/GUI is protected by international copyright laws. Knowledge of the
*              source code may not be used to write a similar product. This file may
*              only be used in accordance with a license and should not be redistributed
*              in any way. We appreciate your understanding and fairness.
*
----------------------------------------------------------------------
File        : F13HB_1.C
Purpose     : ISO 8859-1, West European Character Set, bold, high
Height      : 13
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI_FontIntern.h"


/* Start of unicode area <Latin-1 Supplement> */
GUI_CONST_STORAGE unsigned char acFont13HB_1_00A0[ 13] = { /* code 00A0 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00A1[ 13] = { /* code 00A1 */
  ________,
  ________,
  _XX_____,
  _XX_____,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00A2[ 13] = { /* code 00A2 */
  ________,
  ________,
  ____X___,
  ____X___,
  __XXXX__,
  _XX_X_X_,
  _XX_X___,
  _XX_X___,
  _XX_X___,
  _XX_X_X_,
  __XXXX__,
  ____X___,
  ____X___};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00A3[ 13] = { /* code 00A3 */
  ________,
  ________,
  ___XXX__,
  __XX__X_,
  __XX____,
  __XX____,
  _XXXXX__,
  __XX____,
  __XX____,
  _XX_____,
  _XXXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00A4[ 13] = { /* code 00A4 */
  ________,
  ________,
  ________,
  X_____X_,
  _XXXXX__,
  _X___X__,
  _X___X__,
  _X___X__,
  _XXXXX__,
  X_____X_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00A5[ 13] = { /* code 00A5 */
  ________,
  ________,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  __XXXX__,
  ___XX___,
  _XXXXXX_,
  ___XX___,
  ___XX___,
  ___XX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00A6[ 13] = { /* code 00A6 */
  ________,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  ________,
  ________,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00A7[ 13] = { /* code 00A7 */
  ________,
  ________,
  _XXXXX__,
  XX____X_,
  XX______,
  _XXXXX__,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  _XXXXX__,
  _____XX_,
  X____XX_,
  _XXXXX__};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00A8[ 13] = { /* code 00A8 */
  ________,
  _XX_XX__,
  _XX_XX__,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00A9[ 26] = { /* code 00A9 */
  ________,________,
  ________,________,
  ___XXXXX,________,
  __X_____,X_______,
  _X______,_X______,
  X___XXXX,__X_____,
  X__XX___,__X_____,
  X__XX___,__X_____,
  X__XX___,__X_____,
  X___XXXX,__X_____,
  _X______,_X______,
  __X_____,X_______,
  ___XXXXX,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00AA[ 13] = { /* code 00AA */
  ________,
  ________,
  _XXXX___,
  ____XX__,
  _XXXXX__,
  XX__XX__,
  XX__XX__,
  _XXXXX__,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00AB[ 26] = { /* code 00AB */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___X___X,________,
  __XX__XX,________,
  _XX__XX_,________,
  _XX__XX_,________,
  __XX__XX,________,
  ___X___X,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00AC[ 26] = { /* code 00AC */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,X_______,
  ________,X_______,
  ________,X_______,
  ________,X_______,
  ________,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00AD[ 13] = { /* code 00AD */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  XXXXX___,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00AE[ 26] = { /* code 00AE */
  ________,________,
  ________,________,
  ___XXXXX,________,
  __X_____,X_______,
  _X______,_X______,
  X__XXXX_,__X_____,
  X__XX_XX,__X_____,
  X__XXXX_,__X_____,
  X__XX_XX,__X_____,
  X__XX__X,X_X_____,
  _X______,_X______,
  __X_____,X_______,
  ___XXXXX,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00AF[ 13] = { /* code 00AF */
  XXXXXXXX,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00B0[ 13] = { /* code 00B0 */
  ________,
  ________,
  __XXX___,
  _X___X__,
  _X___X__,
  _X___X__,
  __XXX___,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00B1[ 26] = { /* code 00B1 */
  ________,________,
  ________,________,
  ________,________,
  _____X__,________,
  _____X__,________,
  _____X__,________,
  __XXXXXX,X_______,
  _____X__,________,
  _____X__,________,
  _____X__,________,
  __XXXXXX,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00B2[ 13] = { /* code 00B2 */
  ________,
  ________,
  __XXX___,
  _X__XX__,
  ____XX__,
  ___XX___,
  __XX____,
  _XXXXX__,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00B3[ 13] = { /* code 00B3 */
  ________,
  ________,
  __XXX___,
  _X__XX__,
  ___XX___,
  ____XX__,
  _X__XX__,
  __XXX___,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00B4[ 13] = { /* code 00B4 */
  ________,
  ___XX___,
  __XX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00B5[ 13] = { /* code 00B5 */
  ________,
  ________,
  ________,
  ________,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX__XXX_,
  XXXX_XX_,
  XX______,
  XX______};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00B6[ 13] = { /* code 00B6 */
  ________,
  ________,
  _XXXXXX_,
  XXXXX_X_,
  XXXXX_X_,
  XXXXX_X_,
  XXXXX_X_,
  _XXXX_X_,
  ____X_X_,
  ____X_X_,
  ____X_X_,
  ____X_X_,
  ____X_X_};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00B7[ 13] = { /* code 00B7 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00B8[ 13] = { /* code 00B8 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ____X___,
  __XX____};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00B9[ 13] = { /* code 00B9 */
  ________,
  ________,
  ___XX___,
  __XXX___,
  ___XX___,
  ___XX___,
  ___XX___,
  __XXXX__,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00BA[ 13] = { /* code 00BA */
  ________,
  ________,
  _XXXX___,
  XX__XX__,
  XX__XX__,
  XX__XX__,
  XX__XX__,
  _XXXX___,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00BB[ 26] = { /* code 00BB */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _X___X__,________,
  _XX__XX_,________,
  __XX__XX,________,
  __XX__XX,________,
  _XX__XX_,________,
  _X___X__,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00BC[ 26] = { /* code 00BC */
  ________,________,
  ________,________,
  __XX____,_X______,
  _XXX____,X_______,
  __XX___X,________,
  __XX___X,___XX___,
  __XX__X_,__XXX___,
  __XX_X__,_X_XX___,
  _____X__,X__XX___,
  ____X___,XXXXXX__,
  ___X____,___XX___,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00BD[ 26] = { /* code 00BD */
  ________,________,
  ________,________,
  __XX____,_X______,
  _XXX____,X_______,
  __XX___X,________,
  __XX___X,__XXX___,
  __XX__X_,_X__XX__,
  __XX_X__,____XX__,
  _____X__,___XX___,
  ____X___,__XX____,
  ___X____,_XXXXX__,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00BE[ 26] = { /* code 00BE */
  ________,________,
  ________,________,
  __XXX___,__X_____,
  _X__XX__,_X______,
  ___XX___,X_______,
  ____XX__,X__XX___,
  _X__XX_X,__XXX___,
  __XXX_X_,_X_XX___,
  ______X_,X__XX___,
  _____X__,XXXXXX__,
  ____X___,___XX___,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00BF[ 13] = { /* code 00BF */
  ________,
  ________,
  __XX____,
  __XX____,
  ________,
  __XX____,
  __XX____,
  _XX_____,
  XX______,
  XX___X__,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00C0[ 26] = { /* code 00C0 */
  __XX____,________,
  ___XX___,________,
  ___XXX__,________,
  ___XXX__,________,
  __XX_XX_,________,
  __XX_XX_,________,
  _XX___XX,________,
  _XXXXXXX,________,
  _XX___XX,________,
  XX_____X,X_______,
  XX_____X,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00C1[ 26] = { /* code 00C1 */
  _____XX_,________,
  ____XX__,________,
  ___XXX__,________,
  ___XXX__,________,
  __XX_XX_,________,
  __XX_XX_,________,
  _XX___XX,________,
  _XXXXXXX,________,
  _XX___XX,________,
  XX_____X,X_______,
  XX_____X,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00C2[ 26] = { /* code 00C2 */
  ___XXX__,________,
  __XX_XX_,________,
  ___XXX__,________,
  ___XXX__,________,
  __XX_XX_,________,
  __XX_XX_,________,
  _XX___XX,________,
  _XXXXXXX,________,
  _XX___XX,________,
  XX_____X,X_______,
  XX_____X,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00C3[ 26] = { /* code 00C3 */
  ___XX__X,________,
  __X__XX_,________,
  ___XXX__,________,
  ___XXX__,________,
  __XX_XX_,________,
  __XX_XX_,________,
  _XX___XX,________,
  _XXXXXXX,________,
  _XX___XX,________,
  XX_____X,X_______,
  XX_____X,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00C4[ 26] = { /* code 00C4 */
  __XX_XX_,________,
  __XX_XX_,________,
  ___XXX__,________,
  ___XXX__,________,
  __XX_XX_,________,
  __XX_XX_,________,
  _XX___XX,________,
  _XXXXXXX,________,
  _XX___XX,________,
  XX_____X,X_______,
  XX_____X,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00C5[ 26] = { /* code 00C5 */
  ___XXX__,________,
  __X___X_,________,
  __XXXXX_,________,
  ___XXX__,________,
  __XX_XX_,________,
  __XX_XX_,________,
  _XX___XX,________,
  _XXXXXXX,________,
  _XX___XX,________,
  XX_____X,X_______,
  XX_____X,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00C6[ 26] = { /* code 00C6 */
  ________,________,
  ________,________,
  ___XXXXX,XXXX____,
  __XX__XX,________,
  __XX__XX,________,
  __XX__XX,________,
  _XX___XX,XXXX____,
  _XXXXXXX,________,
  _XX___XX,________,
  XX____XX,________,
  XX____XX,XXXX____,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00C7[ 13] = { /* code 00C7 */
  ________,
  ________,
  _XXXXX__,
  XX____X_,
  XX____X_,
  XX______,
  XX______,
  XX______,
  XX____X_,
  XX____X_,
  _XXXXX__,
  ____X___,
  __XX____};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00C8[ 13] = { /* code 00C8 */
  _XX_____,
  __XX____,
  XXXXXX__,
  XX______,
  XX______,
  XX______,
  XXXXX___,
  XX______,
  XX______,
  XX______,
  XXXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00C9[ 13] = { /* code 00C9 */
  ___XX___,
  __XX____,
  XXXXXX__,
  XX______,
  XX______,
  XX______,
  XXXXX___,
  XX______,
  XX______,
  XX______,
  XXXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00CA[ 13] = { /* code 00CA */
  __XXX___,
  _XX_XX__,
  XXXXXX__,
  XX______,
  XX______,
  XX______,
  XXXXX___,
  XX______,
  XX______,
  XX______,
  XXXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00CB[ 13] = { /* code 00CB */
  _XX_XX__,
  _XX_XX__,
  XXXXXX__,
  XX______,
  XX______,
  XX______,
  XXXXX___,
  XX______,
  XX______,
  XX______,
  XXXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00CC[ 13] = { /* code 00CC */
  XX______,
  _XX_____,
  XXXX____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  XXXX____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00CD[ 13] = { /* code 00CD */
  __XX____,
  _XX_____,
  XXXX____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  XXXX____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00CE[ 13] = { /* code 00CE */
  _XXX____,
  XX_XX___,
  XXXX____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  XXXX____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00CF[ 13] = { /* code 00CF */
  X__XX___,
  X__XX___,
  XXXX____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  XXXX____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00D0[ 26] = { /* code 00D0 */
  ________,________,
  ________,________,
  _XXXXXX_,________,
  _XX___XX,________,
  _XX____X,X_______,
  _XX____X,X_______,
  XXXXX__X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX___XX,________,
  _XXXXXX_,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00D1[ 13] = { /* code 00D1 */
  __XX__X_,
  _X__XX__,
  XXX___X_,
  XXX___X_,
  X_XX__X_,
  X_XX__X_,
  X__XX_X_,
  X__XX_X_,
  X___XXX_,
  X___XXX_,
  X____XX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00D2[ 26] = { /* code 00D2 */
  __XX____,________,
  ___XX___,________,
  _XXXXXX_,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  _XXXXXX_,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00D3[ 26] = { /* code 00D3 */
  ____XX__,________,
  ___XX___,________,
  _XXXXXX_,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  _XXXXXX_,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00D4[ 26] = { /* code 00D4 */
  ___XXX__,________,
  __XX_XX_,________,
  _XXXXXX_,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  _XXXXXX_,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00D5[ 26] = { /* code 00D5 */
  __XX__X_,________,
  _X__XX__,________,
  _XXXXXX_,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  _XXXXXX_,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00D6[ 26] = { /* code 00D6 */
  _XX__XX_,________,
  _XX__XX_,________,
  _XXXXXX_,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  _XXXXXX_,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00D7[ 26] = { /* code 00D7 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___X___X,________,
  ____X_X_,________,
  _____X__,________,
  ____X_X_,________,
  ___X___X,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00D8[ 26] = { /* code 00D8 */
  ________,________,
  _______X,________,
  _XXXXXX_,________,
  XX___XXX,________,
  XX__X_XX,________,
  XX__X_XX,________,
  XX_X__XX,________,
  XX_X__XX,________,
  XX_X__XX,________,
  XXX___XX,________,
  _XXXXXX_,________,
  X_______,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00D9[ 13] = { /* code 00D9 */
  __XX____,
  ___XX___,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  _XXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00DA[ 13] = { /* code 00DA */
  ___XX___,
  __XX____,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  _XXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00DB[ 13] = { /* code 00DB */
  __XXX___,
  _XX_XX__,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  _XXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00DC[ 13] = { /* code 00DC */
  _XX_XX__,
  _XX_XX__,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  _XXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00DD[ 26] = { /* code 00DD */
  ____XX__,________,
  ___XX___,________,
  XX____XX,________,
  XX____XX,________,
  _XX__XX_,________,
  _XX__XX_,________,
  __XXXX__,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00DE[ 26] = { /* code 00DE */
  ________,________,
  ________,________,
  XX______,________,
  XXXXXXX_,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XX____XX,________,
  XXXXXXX_,________,
  XX______,________,
  XX______,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00DF[ 13] = { /* code 00DF */
  ________,
  _XXXX___,
  XX__XX__,
  XX__XX__,
  XX__XX__,
  XX_XXX__,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX_XXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00E0[ 13] = { /* code 00E0 */
  ________,
  __XX____,
  ___XX___,
  ________,
  __XXXX__,
  _X___XX_,
  _____XX_,
  _XXXXXX_,
  XX___XX_,
  XX___XX_,
  _XXXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00E1[ 13] = { /* code 00E1 */
  ________,
  ____XX__,
  ___XX___,
  ________,
  __XXXX__,
  _X___XX_,
  _____XX_,
  _XXXXXX_,
  XX___XX_,
  XX___XX_,
  _XXXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00E2[ 13] = { /* code 00E2 */
  ________,
  __XXX___,
  _XX_XX__,
  ________,
  __XXXX__,
  _X___XX_,
  _____XX_,
  _XXXXXX_,
  XX___XX_,
  XX___XX_,
  _XXXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00E3[ 13] = { /* code 00E3 */
  ________,
  __XX__X_,
  _X__XX__,
  ________,
  __XXXX__,
  _X___XX_,
  _____XX_,
  _XXXXXX_,
  XX___XX_,
  XX___XX_,
  _XXXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00E4[ 13] = { /* code 00E4 */
  ________,
  _XX_XX__,
  _XX_XX__,
  ________,
  __XXXX__,
  _X___XX_,
  _____XX_,
  _XXXXXX_,
  XX___XX_,
  XX___XX_,
  _XXXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00E5[ 13] = { /* code 00E5 */
  ___XX___,
  __X__X__,
  __X__X__,
  ___XX___,
  __XXXX__,
  _X___XX_,
  _____XX_,
  _XXXXXX_,
  XX___XX_,
  XX___XX_,
  _XXXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00E6[ 26] = { /* code 00E6 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXX_XX,XX______,
  _X__XX__,_XX_____,
  ____XX__,_XX_____,
  _XXXXXXX,XXX_____,
  XX__XX__,________,
  XX__XX__,__X_____,
  _XXX__XX,XX______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00E7[ 13] = { /* code 00E7 */
  ________,
  ________,
  ________,
  ________,
  _XXXX___,
  XX___X__,
  XX______,
  XX______,
  XX______,
  XX___X__,
  _XXXX___,
  ____X___,
  __XX____};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00E8[ 13] = { /* code 00E8 */
  ________,
  _XX_____,
  __XX____,
  ________,
  _XXXXX__,
  XX___XX_,
  XX___XX_,
  XXXXXXX_,
  XX______,
  XX____X_,
  _XXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00E9[ 13] = { /* code 00E9 */
  ________,
  ____XX__,
  ___XX___,
  ________,
  _XXXXX__,
  XX___XX_,
  XX___XX_,
  XXXXXXX_,
  XX______,
  XX____X_,
  _XXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00EA[ 13] = { /* code 00EA */
  ________,
  __XXX___,
  _XX_XX__,
  ________,
  _XXXXX__,
  XX___XX_,
  XX___XX_,
  XXXXXXX_,
  XX______,
  XX____X_,
  _XXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00EB[ 13] = { /* code 00EB */
  ________,
  _XX_XX__,
  _XX_XX__,
  ________,
  _XXXXX__,
  XX___XX_,
  XX___XX_,
  XXXXXXX_,
  XX______,
  XX____X_,
  _XXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00EC[ 13] = { /* code 00EC */
  ________,
  X_______,
  XX______,
  ________,
  XX______,
  XX______,
  XX______,
  XX______,
  XX______,
  XX______,
  XX______,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00ED[ 13] = { /* code 00ED */
  ________,
  _XX_____,
  XX______,
  ________,
  XX______,
  XX______,
  XX______,
  XX______,
  XX______,
  XX______,
  XX______,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00EE[ 13] = { /* code 00EE */
  ________,
  XX______,
  __X_____,
  ________,
  XX______,
  XX______,
  XX______,
  XX______,
  XX______,
  XX______,
  XX______,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00EF[ 13] = { /* code 00EF */
  ________,
  __X_____,
  __X_____,
  ________,
  XX______,
  XX______,
  XX______,
  XX______,
  XX______,
  XX______,
  XX______,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00F0[ 13] = { /* code 00F0 */
  ________,
  __XX_X__,
  ___XX___,
  __X_XX__,
  _____XX_,
  _XXXXXX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  _XXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00F1[ 13] = { /* code 00F1 */
  ________,
  __XX__X_,
  _X__XX__,
  ________,
  XX_XXX__,
  XXX__XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00F2[ 13] = { /* code 00F2 */
  ________,
  _XX_____,
  __XX____,
  ________,
  _XXXXX__,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  _XXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00F3[ 13] = { /* code 00F3 */
  ________,
  ____XX__,
  ___XX___,
  ________,
  _XXXXX__,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  _XXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00F4[ 13] = { /* code 00F4 */
  ________,
  __XXX___,
  _XX_XX__,
  ________,
  _XXXXX__,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  _XXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00F5[ 13] = { /* code 00F5 */
  ________,
  __XX__X_,
  _X__XX__,
  ________,
  _XXXXX__,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  _XXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00F6[ 13] = { /* code 00F6 */
  ________,
  _XX_XX__,
  _XX_XX__,
  ________,
  _XXXXX__,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  _XXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00F7[ 26] = { /* code 00F7 */
  ________,________,
  ________,________,
  ________,________,
  ____XX__,________,
  ____XX__,________,
  ________,________,
  _XXXXXXX,X_______,
  ________,________,
  ____XX__,________,
  ____XX__,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00F8[ 13] = { /* code 00F8 */
  ________,
  ________,
  ________,
  ______X_,
  _XXXXX__,
  XX__XXX_,
  XX__XXX_,
  XX_X_XX_,
  XXX__XX_,
  XXX__XX_,
  _XXXXX__,
  X_______,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00F9[ 13] = { /* code 00F9 */
  ________,
  _XX_____,
  __XX____,
  ________,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX__XXX_,
  _XXX_XX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00FA[ 13] = { /* code 00FA */
  ________,
  ____XX__,
  ___XX___,
  ________,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX__XXX_,
  _XXX_XX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00FB[ 13] = { /* code 00FB */
  ________,
  __XXX___,
  _XX_XX__,
  ________,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX__XXX_,
  _XXX_XX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00FC[ 13] = { /* code 00FC */
  ________,
  _XX_XX__,
  _XX_XX__,
  ________,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX__XXX_,
  _XXX_XX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00FD[ 13] = { /* code 00FD */
  ________,
  ____XX__,
  ___XX___,
  ________,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  _XX_XX__,
  _XX_XX__,
  __XXX___,
  __XXX___,
  ___XX___,
  __XX____};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00FE[ 13] = { /* code 00FE */
  ________,
  XX______,
  XX______,
  XX______,
  XX_XXX__,
  XXX__XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XXXXXX__,
  XX______,
  XX______};

GUI_CONST_STORAGE unsigned char acFont13HB_1_00FF[ 13] = { /* code 00FF */
  ________,
  _XX_XX__,
  _XX_XX__,
  ________,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  _XX_XX__,
  _XX_XX__,
  __XXX___,
  __XXX___,
  ___XX___,
  __XX____};

GUI_CONST_STORAGE GUI_CHARINFO GUI_Font13HB_1_CharInfo[96] = {
   {   4,   4,  1, acFont13HB_1_00A0 } /* code 00A0 */
  ,{   5,   5,  1, acFont13HB_1_00A1 } /* code 00A1 */
  ,{   8,   8,  1, acFont13HB_1_00A2 } /* code 00A2 */
  ,{   8,   8,  1, acFont13HB_1_00A3 } /* code 00A3 */
  ,{   8,   8,  1, acFont13HB_1_00A4 } /* code 00A4 */
  ,{   8,   8,  1, acFont13HB_1_00A5 } /* code 00A5 */
  ,{   7,   7,  1, acFont13HB_1_00A6 } /* code 00A6 */
  ,{   8,   8,  1, acFont13HB_1_00A7 } /* code 00A7 */
  ,{   7,   7,  1, acFont13HB_1_00A8 } /* code 00A8 */
  ,{  12,  12,  2, acFont13HB_1_00A9 } /* code 00A9 */
  ,{   7,   7,  1, acFont13HB_1_00AA } /* code 00AA */
  ,{   9,   9,  2, acFont13HB_1_00AB } /* code 00AB */
  ,{  11,  11,  2, acFont13HB_1_00AC } /* code 00AC */
  ,{   6,   6,  1, acFont13HB_1_00AD } /* code 00AD */
  ,{  12,  12,  2, acFont13HB_1_00AE } /* code 00AE */
  ,{   8,   8,  1, acFont13HB_1_00AF } /* code 00AF */
  ,{   7,   7,  1, acFont13HB_1_00B0 } /* code 00B0 */
  ,{  11,  11,  2, acFont13HB_1_00B1 } /* code 00B1 */
  ,{   7,   7,  1, acFont13HB_1_00B2 } /* code 00B2 */
  ,{   7,   7,  1, acFont13HB_1_00B3 } /* code 00B3 */
  ,{   7,   7,  1, acFont13HB_1_00B4 } /* code 00B4 */
  ,{   8,   8,  1, acFont13HB_1_00B5 } /* code 00B5 */
  ,{   8,   8,  1, acFont13HB_1_00B6 } /* code 00B6 */
  ,{   4,   4,  1, acFont13HB_1_00B7 } /* code 00B7 */
  ,{   7,   7,  1, acFont13HB_1_00B8 } /* code 00B8 */
  ,{   7,   7,  1, acFont13HB_1_00B9 } /* code 00B9 */
  ,{   7,   7,  1, acFont13HB_1_00BA } /* code 00BA */
  ,{   9,   9,  2, acFont13HB_1_00BB } /* code 00BB */
  ,{  15,  15,  2, acFont13HB_1_00BC } /* code 00BC */
  ,{  15,  15,  2, acFont13HB_1_00BD } /* code 00BD */
  ,{  15,  15,  2, acFont13HB_1_00BE } /* code 00BE */
  ,{   7,   7,  1, acFont13HB_1_00BF } /* code 00BF */
  ,{  10,  10,  2, acFont13HB_1_00C0 } /* code 00C0 */
  ,{  10,  10,  2, acFont13HB_1_00C1 } /* code 00C1 */
  ,{  10,  10,  2, acFont13HB_1_00C2 } /* code 00C2 */
  ,{  10,  10,  2, acFont13HB_1_00C3 } /* code 00C3 */
  ,{  10,  10,  2, acFont13HB_1_00C4 } /* code 00C4 */
  ,{  10,  10,  2, acFont13HB_1_00C5 } /* code 00C5 */
  ,{  13,  13,  2, acFont13HB_1_00C6 } /* code 00C6 */
  ,{   8,   8,  1, acFont13HB_1_00C7 } /* code 00C7 */
  ,{   7,   7,  1, acFont13HB_1_00C8 } /* code 00C8 */
  ,{   7,   7,  1, acFont13HB_1_00C9 } /* code 00C9 */
  ,{   7,   7,  1, acFont13HB_1_00CA } /* code 00CA */
  ,{   7,   7,  1, acFont13HB_1_00CB } /* code 00CB */
  ,{   5,   5,  1, acFont13HB_1_00CC } /* code 00CC */
  ,{   5,   5,  1, acFont13HB_1_00CD } /* code 00CD */
  ,{   5,   5,  1, acFont13HB_1_00CE } /* code 00CE */
  ,{   5,   5,  1, acFont13HB_1_00CF } /* code 00CF */
  ,{  10,  10,  2, acFont13HB_1_00D0 } /* code 00D0 */
  ,{   8,   8,  1, acFont13HB_1_00D1 } /* code 00D1 */
  ,{   9,   9,  2, acFont13HB_1_00D2 } /* code 00D2 */
  ,{   9,   9,  2, acFont13HB_1_00D3 } /* code 00D3 */
  ,{   9,   9,  2, acFont13HB_1_00D4 } /* code 00D4 */
  ,{   9,   9,  2, acFont13HB_1_00D5 } /* code 00D5 */
  ,{   9,   9,  2, acFont13HB_1_00D6 } /* code 00D6 */
  ,{  11,  11,  2, acFont13HB_1_00D7 } /* code 00D7 */
  ,{   9,   9,  2, acFont13HB_1_00D8 } /* code 00D8 */
  ,{   8,   8,  1, acFont13HB_1_00D9 } /* code 00D9 */
  ,{   8,   8,  1, acFont13HB_1_00DA } /* code 00DA */
  ,{   8,   8,  1, acFont13HB_1_00DB } /* code 00DB */
  ,{   8,   8,  1, acFont13HB_1_00DC } /* code 00DC */
  ,{   9,   9,  2, acFont13HB_1_00DD } /* code 00DD */
  ,{   9,   9,  2, acFont13HB_1_00DE } /* code 00DE */
  ,{   8,   8,  1, acFont13HB_1_00DF } /* code 00DF */
  ,{   8,   8,  1, acFont13HB_1_00E0 } /* code 00E0 */
  ,{   8,   8,  1, acFont13HB_1_00E1 } /* code 00E1 */
  ,{   8,   8,  1, acFont13HB_1_00E2 } /* code 00E2 */
  ,{   8,   8,  1, acFont13HB_1_00E3 } /* code 00E3 */
  ,{   8,   8,  1, acFont13HB_1_00E4 } /* code 00E4 */
  ,{   8,   8,  1, acFont13HB_1_00E5 } /* code 00E5 */
  ,{  12,  12,  2, acFont13HB_1_00E6 } /* code 00E6 */
  ,{   7,   7,  1, acFont13HB_1_00E7 } /* code 00E7 */
  ,{   8,   8,  1, acFont13HB_1_00E8 } /* code 00E8 */
  ,{   8,   8,  1, acFont13HB_1_00E9 } /* code 00E9 */
  ,{   8,   8,  1, acFont13HB_1_00EA } /* code 00EA */
  ,{   8,   8,  1, acFont13HB_1_00EB } /* code 00EB */
  ,{   3,   3,  1, acFont13HB_1_00EC } /* code 00EC */
  ,{   3,   3,  1, acFont13HB_1_00ED } /* code 00ED */
  ,{   3,   3,  1, acFont13HB_1_00EE } /* code 00EE */
  ,{   3,   3,  1, acFont13HB_1_00EF } /* code 00EF */
  ,{   8,   8,  1, acFont13HB_1_00F0 } /* code 00F0 */
  ,{   8,   8,  1, acFont13HB_1_00F1 } /* code 00F1 */
  ,{   8,   8,  1, acFont13HB_1_00F2 } /* code 00F2 */
  ,{   8,   8,  1, acFont13HB_1_00F3 } /* code 00F3 */
  ,{   8,   8,  1, acFont13HB_1_00F4 } /* code 00F4 */
  ,{   8,   8,  1, acFont13HB_1_00F5 } /* code 00F5 */
  ,{   8,   8,  1, acFont13HB_1_00F6 } /* code 00F6 */
  ,{  11,  11,  2, acFont13HB_1_00F7 } /* code 00F7 */
  ,{   8,   8,  1, acFont13HB_1_00F8 } /* code 00F8 */
  ,{   8,   8,  1, acFont13HB_1_00F9 } /* code 00F9 */
  ,{   8,   8,  1, acFont13HB_1_00FA } /* code 00FA */
  ,{   8,   8,  1, acFont13HB_1_00FB } /* code 00FB */
  ,{   8,   8,  1, acFont13HB_1_00FC } /* code 00FC */
  ,{   8,   8,  1, acFont13HB_1_00FD } /* code 00FD */
  ,{   8,   8,  1, acFont13HB_1_00FE } /* code 00FE */
  ,{   8,   8,  1, acFont13HB_1_00FF } /* code 00FF */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_Font13HB_1_Prop2 = {
   0x00A0                       /* first character */
  ,0x00FF                       /* last character  */
  ,&GUI_Font13HB_1_CharInfo[0]  /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP*)0      /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_Font13HB_1_Prop1 = {
   0x0020                           /* first character */
  ,0x007E                           /* last character  */
  ,&GUI_Font13HB_ASCII_CharInfo[0]  /* address of first character */
  ,&GUI_Font13HB_1_Prop2            /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_Font13HB_1 = {
   GUI_FONTTYPE_PROP      /* type of font    */
  ,13                     /* height of font  */
  ,13                     /* space of font y */
  ,1                      /* magnification x */
  ,1                      /* magnification y */
  ,{&GUI_Font13HB_1_Prop1}
  , 11, 7, 9
};

