/*
*********************************************************************************************************
*                                                uC/GUI
*                        Universal graphic software for embedded applications
*
*                       (c) Copyright 2002, Micrium Inc., Weston, FL
*                       (c) Copyright 2002, SEGGER Microcontroller Systeme GmbH
*
*              C/GUI is protected by international copyright laws. Knowledge of the
*              source code may not be used to write a similar product. This file may
*              only be used in accordance with a license and should not be redistributed
*              in any way. We appreciate your understanding and fairness.
*
----------------------------------------------------------------------
File        : F13H_1.C
Purpose     : ISO 8859-1, West European Character Set
Height      : 13
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI_FontIntern.h"

/* Start of unicode area <Latin-1 Supplement> */
GUI_CONST_STORAGE unsigned char acFont13H_1_00A0[ 13] = { /* code 00A0 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00A1[ 13] = { /* code 00A1 */
  ________,
  ________,
  _X______,
  _X______,
  ________,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00A2[ 13] = { /* code 00A2 */
  ________,
  ________,
  ___X____,
  ___X____,
  __XXXX__,
  _X_X____,
  _X_X____,
  _X_X____,
  _X_X____,
  _X_X____,
  __XXXX__,
  ___X____,
  ___X____};

GUI_CONST_STORAGE unsigned char acFont13H_1_00A3[ 13] = { /* code 00A3 */
  ________,
  ________,
  ___XXX__,
  __X___X_,
  __X_____,
  __X_____,
  _XXXXX__,
  __X_____,
  __X_____,
  _X______,
  _XXXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00A4[ 13] = { /* code 00A4 */
  ________,
  ________,
  ________,
  ________,
  X____X__,
  _XXXX___,
  _X__X___,
  _X__X___,
  _XXXX___,
  X____X__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00A5[ 13] = { /* code 00A5 */
  ________,
  ________,
  X_____X_,
  _X___X__,
  __X_X___,
  __X_X___,
  ___X____,
  _XXXXX__,
  ___X____,
  ___X____,
  ___X____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00A6[ 13] = { /* code 00A6 */
  ________,
  __X_____,
  __X_____,
  __X_____,
  __X_____,
  __X_____,
  ________,
  ________,
  __X_____,
  __X_____,
  __X_____,
  __X_____,
  __X_____};

GUI_CONST_STORAGE unsigned char acFont13H_1_00A7[ 13] = { /* code 00A7 */
  ________,
  ________,
  _XXXX___,
  X____X__,
  X_______,
  _XXX____,
  X___X___,
  X____X__,
  _X___X__,
  __XXX___,
  _____X__,
  X____X__,
  _XXXX___};

GUI_CONST_STORAGE unsigned char acFont13H_1_00A8[ 13] = { /* code 00A8 */
  ________,
  ________,
  __X__X__,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00A9[ 26] = { /* code 00A9 */
  ________,________,
  ________,________,
  ___XXXXX,________,
  __X_____,X_______,
  _X__XXX_,_X______,
  X__X___X,__X_____,
  X__X____,__X_____,
  X__X____,__X_____,
  X__X____,__X_____,
  X__X___X,__X_____,
  _X__XXX_,_X______,
  __X_____,X_______,
  ___XXXXX,________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00AA[ 13] = { /* code 00AA */
  ________,
  ________,
  _XXX____,
  ____X___,
  _XXXX___,
  X___X___,
  X___X___,
  _XXXX___,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00AB[ 13] = { /* code 00AB */
  ________,
  ________,
  ________,
  ________,
  __X__X__,
  _X__X___,
  X__X____,
  X__X____,
  _X__X___,
  __X__X__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00AC[ 26] = { /* code 00AC */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,________,
  _______X,________,
  _______X,________,
  _______X,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00AD[ 13] = { /* code 00AD */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  XXXX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00AE[ 26] = { /* code 00AE */
  ________,________,
  ________,________,
  ___XXXXX,________,
  __X_____,X_______,
  _X_XXXX_,_X______,
  X__X___X,__X_____,
  X__X___X,__X_____,
  X__XXXX_,__X_____,
  X__X__X_,__X_____,
  X__X___X,__X_____,
  _X_X___X,_X______,
  __X_____,X_______,
  ___XXXXX,________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00AF[ 13] = { /* code 00AF */
  XXXXXXX_,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00B0[ 13] = { /* code 00B0 */
  ________,
  ________,
  _XXX____,
  X___X___,
  X___X___,
  X___X___,
  _XXX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00B1[ 13] = { /* code 00B1 */
  ________,
  ________,
  ___X____,
  ___X____,
  ___X____,
  XXXXXXX_,
  ___X____,
  ___X____,
  ___X____,
  XXXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00B2[ 13] = { /* code 00B2 */
  ________,
  ________,
  __XX____,
  _X__X___,
  ____X___,
  ___X____,
  __X_____,
  _XXXX___,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00B3[ 13] = { /* code 00B3 */
  ________,
  ________,
  _XXX____,
  ____X___,
  __XX____,
  ____X___,
  ____X___,
  _XXX____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00B4[ 13] = { /* code 00B4 */
  ________,
  ____X___,
  ___X____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00B5[ 13] = { /* code 00B5 */
  ________,
  ________,
  ________,
  ________,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X___XX__,
  XXXX_X__,
  X_______,
  X_______};

GUI_CONST_STORAGE unsigned char acFont13H_1_00B6[ 13] = { /* code 00B6 */
  ________,
  ________,
  _XXXXX__,
  XXXX_X__,
  XXXX_X__,
  XXXX_X__,
  XXXX_X__,
  _XXX_X__,
  ___X_X__,
  ___X_X__,
  ___X_X__,
  ___X_X__,
  ___X_X__};

GUI_CONST_STORAGE unsigned char acFont13H_1_00B7[ 13] = { /* code 00B7 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _X______,
  _X______,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00B8[ 13] = { /* code 00B8 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ____X___,
  __XX____};

GUI_CONST_STORAGE unsigned char acFont13H_1_00B9[ 13] = { /* code 00B9 */
  ________,
  ________,
  ___X____,
  __XX____,
  ___X____,
  ___X____,
  ___X____,
  __XXX___,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00BA[ 13] = { /* code 00BA */
  ________,
  ________,
  _XXX____,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  _XXX____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00BB[ 13] = { /* code 00BB */
  ________,
  ________,
  ________,
  ________,
  X__X____,
  _X__X___,
  __X__X__,
  __X__X__,
  _X__X___,
  X__X____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00BC[ 26] = { /* code 00BC */
  ________,________,
  ________,________,
  __X_____,X_______,
  _XX____X,________,
  __X____X,________,
  __X___X_,__X_____,
  __X___X_,_XX_____,
  __X__X__,X_X_____,
  ____X__X,__X_____,
  ____X__X,XXXX____,
  ___X____,__X_____,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00BD[ 26] = { /* code 00BD */
  ________,________,
  ________,________,
  __X____X,________,
  _XX____X,________,
  __X___X_,________,
  __X___X_,_XX_____,
  __X__X__,X__X____,
  __X__X__,___X____,
  ____X___,__X_____,
  ____X___,_X______,
  ___X____,XXXX____,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00BE[ 26] = { /* code 00BE */
  ________,________,
  ________,________,
  _XXX____,_X______,
  ____X___,X_______,
  __XX____,X_______,
  ____X__X,__X_____,
  ____X__X,_XX_____,
  _XXX__X_,X_X_____,
  _____X_X,__X_____,
  _____X_X,XXXX____,
  ____X___,__X_____,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00BF[ 13] = { /* code 00BF */
  ________,
  ________,
  ___X____,
  ___X____,
  ________,
  ___X____,
  __X_____,
  _X______,
  X_______,
  X___X___,
  _XXX____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00C0[ 13] = { /* code 00C0 */
  __X_____,
  ___X____,
  ___X____,
  ___X____,
  __X_X___,
  __X_X___,
  _X___X__,
  _X___X__,
  _XXXXX__,
  X_____X_,
  X_____X_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00C1[ 13] = { /* code 00C1 */
  ____X___,
  ___X____,
  ___X____,
  ___X____,
  __X_X___,
  __X_X___,
  _X___X__,
  _X___X__,
  _XXXXX__,
  X_____X_,
  X_____X_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00C2[ 13] = { /* code 00C2 */
  ___XX___,
  __X__X__,
  ___X____,
  ___X____,
  __X_X___,
  __X_X___,
  _X___X__,
  _X___X__,
  _XXXXX__,
  X_____X_,
  X_____X_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00C3[ 13] = { /* code 00C3 */
  __XX_X__,
  _X_XX___,
  ___X____,
  ___X____,
  __X_X___,
  __X_X___,
  _X___X__,
  _X___X__,
  _XXXXX__,
  X_____X_,
  X_____X_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00C4[ 13] = { /* code 00C4 */
  _X___X__,
  ________,
  ___X____,
  ___X____,
  __X_X___,
  __X_X___,
  _X___X__,
  _X___X__,
  _XXXXX__,
  X_____X_,
  X_____X_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00C5[ 13] = { /* code 00C5 */
  ___X____,
  __X_X___,
  ___X____,
  ___X____,
  __X_X___,
  __X_X___,
  _X___X__,
  _X___X__,
  _XXXXX__,
  X_____X_,
  X_____X_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00C6[ 26] = { /* code 00C6 */
  ________,________,
  ________,________,
  ___XXXXX,XXX_____,
  ___X__X_,________,
  __X___X_,________,
  __X___X_,________,
  __X___XX,XXX_____,
  _XXXXXX_,________,
  _X____X_,________,
  _X____X_,________,
  X_____XX,XXX_____,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00C7[ 13] = { /* code 00C7 */
  ________,
  ________,
  __XXXX__,
  _X____X_,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  _X____X_,
  __XXXX__,
  _____X__,
  ___XX___};

GUI_CONST_STORAGE unsigned char acFont13H_1_00C8[ 13] = { /* code 00C8 */
  __X_____,
  ___X____,
  XXXXXX__,
  X_______,
  X_______,
  X_______,
  XXXXXX__,
  X_______,
  X_______,
  X_______,
  XXXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00C9[ 13] = { /* code 00C9 */
  ____X___,
  ___X____,
  XXXXXX__,
  X_______,
  X_______,
  X_______,
  XXXXXX__,
  X_______,
  X_______,
  X_______,
  XXXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00CA[ 13] = { /* code 00CA */
  __XX____,
  _X__X___,
  XXXXXX__,
  X_______,
  X_______,
  X_______,
  XXXXXX__,
  X_______,
  X_______,
  X_______,
  XXXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00CB[ 13] = { /* code 00CB */
  _X__X___,
  ________,
  XXXXXX__,
  X_______,
  X_______,
  X_______,
  XXXXXX__,
  X_______,
  X_______,
  X_______,
  XXXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00CC[ 13] = { /* code 00CC */
  X_______,
  _X______,
  XXX_____,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  XXX_____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00CD[ 13] = { /* code 00CD */
  __X_____,
  _X______,
  XXX_____,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  XXX_____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00CE[ 13] = { /* code 00CE */
  _XX_____,
  X__X____,
  XXX_____,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  XXX_____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00CF[ 13] = { /* code 00CF */
  X_X_____,
  ________,
  XXX_____,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  XXX_____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00D0[ 26] = { /* code 00D0 */
  ________,________,
  ________,________,
  _XXXXX__,________,
  _X____X_,________,
  _X_____X,________,
  _X_____X,________,
  XXXX___X,________,
  _X_____X,________,
  _X_____X,________,
  _X____X_,________,
  _XXXXX__,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00D1[ 13] = { /* code 00D1 */
  __XX_X__,
  _X_XX___,
  XX____X_,
  XX____X_,
  X_X___X_,
  X_X___X_,
  X__X__X_,
  X___X_X_,
  X___X_X_,
  X____XX_,
  X____XX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00D2[ 26] = { /* code 00D2 */
  ___X____,________,
  ____X___,________,
  __XXXX__,________,
  _X____X_,________,
  X______X,________,
  X______X,________,
  X______X,________,
  X______X,________,
  X______X,________,
  _X____X_,________,
  __XXXX__,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00D3[ 26] = { /* code 00D3 */
  ____X___,________,
  ___X____,________,
  __XXXX__,________,
  _X____X_,________,
  X______X,________,
  X______X,________,
  X______X,________,
  X______X,________,
  X______X,________,
  _X____X_,________,
  __XXXX__,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00D4[ 26] = { /* code 00D4 */
  ___XX___,________,
  __X__X__,________,
  __XXXX__,________,
  _X____X_,________,
  X______X,________,
  X______X,________,
  X______X,________,
  X______X,________,
  X______X,________,
  _X____X_,________,
  __XXXX__,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00D5[ 26] = { /* code 00D5 */
  ___XX_X_,________,
  __X_XX__,________,
  __XXXX__,________,
  _X____X_,________,
  X______X,________,
  X______X,________,
  X______X,________,
  X______X,________,
  X______X,________,
  _X____X_,________,
  __XXXX__,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00D6[ 26] = { /* code 00D6 */
  __X__X__,________,
  ________,________,
  __XXXX__,________,
  _X____X_,________,
  X______X,________,
  X______X,________,
  X______X,________,
  X______X,________,
  X______X,________,
  _X____X_,________,
  __XXXX__,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00D7[ 26] = { /* code 00D7 */
  ________,________,
  ________,________,
  ________,________,
  _X_____X,________,
  __X___X_,________,
  ___X_X__,________,
  ____X___,________,
  ___X_X__,________,
  __X___X_,________,
  _X_____X,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00D8[ 26] = { /* code 00D8 */
  ________,________,
  ________,________,
  __XXXX_X,________,
  _X____X_,________,
  X____X_X,________,
  X___X__X,________,
  X__X___X,________,
  X__X___X,________,
  X_X____X,________,
  _X____X_,________,
  X_XXXX__,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00D9[ 13] = { /* code 00D9 */
  __X_____,
  ___X____,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  _X___X__,
  __XXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00DA[ 13] = { /* code 00DA */
  ____X___,
  ___X____,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  _X___X__,
  __XXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00DB[ 13] = { /* code 00DB */
  ___XX___,
  __X__X__,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  _X___X__,
  __XXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00DC[ 13] = { /* code 00DC */
  _X___X__,
  ________,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  _X___X__,
  __XXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00DD[ 13] = { /* code 00DD */
  ____X___,
  ___X____,
  X_____X_,
  _X___X__,
  _X___X__,
  __X_X___,
  ___X____,
  ___X____,
  ___X____,
  ___X____,
  ___X____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00DE[ 13] = { /* code 00DE */
  ________,
  ________,
  X_______,
  X_______,
  XXXXX___,
  X____X__,
  X____X__,
  X____X__,
  XXXXX___,
  X_______,
  X_______,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00DF[ 13] = { /* code 00DF */
  ________,
  _XXX____,
  X___X___,
  X___X___,
  X___X___,
  X_XX____,
  X___X___,
  X____X__,
  X____X__,
  X___X___,
  X_XX____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00E0[ 13] = { /* code 00E0 */
  ________,
  __X_____,
  ___X____,
  ________,
  _XXXX___,
  _____X__,
  _____X__,
  _XXXXX__,
  X____X__,
  X___XX__,
  _XXX_X__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00E1[ 13] = { /* code 00E1 */
  ________,
  ____X___,
  ___X____,
  ________,
  _XXXX___,
  _____X__,
  _____X__,
  _XXXXX__,
  X____X__,
  X___XX__,
  _XXX_X__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00E2[ 13] = { /* code 00E2 */
  ________,
  __XX____,
  _X__X___,
  ________,
  _XXXX___,
  _____X__,
  _____X__,
  _XXXXX__,
  X____X__,
  X___XX__,
  _XXX_X__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00E3[ 13] = { /* code 00E3 */
  ________,
  __XX_X__,
  _X_XX___,
  ________,
  _XXXX___,
  _____X__,
  _____X__,
  _XXXXX__,
  X____X__,
  X___XX__,
  _XXX_X__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00E4[ 13] = { /* code 00E4 */
  ________,
  ________,
  _X__X___,
  ________,
  _XXXX___,
  _____X__,
  _____X__,
  _XXXXX__,
  X____X__,
  X___XX__,
  _XXX_X__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00E5[ 13] = { /* code 00E5 */
  __XX____,
  _X__X___,
  _X__X___,
  __XX____,
  _XXXX___,
  _____X__,
  _____X__,
  _XXXXX__,
  X____X__,
  X___XX__,
  _XXX_X__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00E6[ 26] = { /* code 00E6 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX__XX,________,
  ____XX__,X_______,
  ____X___,_X______,
  _XXXXXXX,XX______,
  X___X___,________,
  X___XX__,_X______,
  _XXX__XX,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00E7[ 13] = { /* code 00E7 */
  ________,
  ________,
  ________,
  ________,
  _XXXX___,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  _XXXX___,
  ___X____,
  _XX_____};

GUI_CONST_STORAGE unsigned char acFont13H_1_00E8[ 13] = { /* code 00E8 */
  ________,
  __X_____,
  ___X____,
  ________,
  _XXXX___,
  X____X__,
  X____X__,
  XXXXXX__,
  X_______,
  X____X__,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00E9[ 13] = { /* code 00E9 */
  ________,
  ___X____,
  __X_____,
  ________,
  _XXXX___,
  X____X__,
  X____X__,
  XXXXXX__,
  X_______,
  X____X__,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00EA[ 13] = { /* code 00EA */
  ________,
  __XX____,
  _X__X___,
  ________,
  _XXXX___,
  X____X__,
  X____X__,
  XXXXXX__,
  X_______,
  X____X__,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00EB[ 13] = { /* code 00EB */
  ________,
  ________,
  _X__X___,
  ________,
  _XXXX___,
  X____X__,
  X____X__,
  XXXXXX__,
  X_______,
  X____X__,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00EC[ 13] = { /* code 00EC */
  ________,
  X_______,
  _X______,
  ________,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00ED[ 13] = { /* code 00ED */
  ________,
  __X_____,
  _X______,
  ________,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00EE[ 13] = { /* code 00EE */
  ________,
  _X______,
  X_X_____,
  ________,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00EF[ 13] = { /* code 00EF */
  ________,
  ________,
  X_X_____,
  ________,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00F0[ 13] = { /* code 00F0 */
  ________,
  ________,
  __X_X___,
  ___X____,
  _XX_X___,
  _____X__,
  _XXXXX__,
  X____X__,
  X____X__,
  X____X__,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00F1[ 13] = { /* code 00F1 */
  ________,
  __XX_X__,
  _X_XX___,
  ________,
  X_XXX___,
  XX___X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00F2[ 13] = { /* code 00F2 */
  ________,
  __X_____,
  ___X____,
  ________,
  _XXXX___,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00F3[ 13] = { /* code 00F3 */
  ________,
  ____X___,
  ___X____,
  ________,
  _XXXX___,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00F4[ 13] = { /* code 00F4 */
  ________,
  __XX____,
  _X__X___,
  ________,
  _XXXX___,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00F5[ 13] = { /* code 00F5 */
  ________,
  __XX_X__,
  _X_XX___,
  ________,
  _XXXX___,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00F6[ 13] = { /* code 00F6 */
  ________,
  ________,
  _X__X___,
  ________,
  _XXXX___,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00F7[ 26] = { /* code 00F7 */
  ________,________,
  ________,________,
  ________,________,
  ___X____,________,
  ___X____,________,
  ________,________,
  XXXXXXX_,________,
  ________,________,
  ___X____,________,
  ___X____,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00F8[ 13] = { /* code 00F8 */
  ________,
  ________,
  ________,
  _____X__,
  __XXX___,
  _X__X___,
  X__X_X__,
  X_X__X__,
  X_X__X__,
  _X__X___,
  _XXX____,
  X_______,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00F9[ 13] = { /* code 00F9 */
  ________,
  __X_____,
  ___X____,
  ________,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X___XX__,
  _XXX_X__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00FA[ 13] = { /* code 00FA */
  ________,
  ___X____,
  __X_____,
  ________,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X___XX__,
  _XXX_X__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00FB[ 13] = { /* code 00FB */
  ________,
  __XX____,
  _X__X___,
  ________,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X___XX__,
  _XXX_X__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00FC[ 13] = { /* code 00FC */
  ________,
  ________,
  _X__X___,
  ________,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X___XX__,
  _XXX_X__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13H_1_00FD[ 13] = { /* code 00FD */
  ________,
  ___X____,
  __X_____,
  ________,
  X___X___,
  X___X___,
  _X_X____,
  _X_X____,
  _X_X____,
  __X_____,
  __X_____,
  __X_____,
  _X______};

GUI_CONST_STORAGE unsigned char acFont13H_1_00FE[ 13] = { /* code 00FE */
  ________,
  X_______,
  X_______,
  X_______,
  X_XXX___,
  XX___X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  XXXXX___,
  X_______,
  X_______};

GUI_CONST_STORAGE unsigned char acFont13H_1_00FF[ 13] = { /* code 00FF */
  ________,
  ________,
  _X__X___,
  ________,
  X___X___,
  X___X___,
  _X_X____,
  _X_X____,
  _X_X____,
  __X_____,
  __X_____,
  __X_____,
  _X______};

GUI_CONST_STORAGE GUI_CHARINFO GUI_Font13H_1_CharInfo[96] = {
   {   4,   4,  1, acFont13H_1_00A0 } /* code 00A0 */
  ,{   4,   4,  1, acFont13H_1_00A1 } /* code 00A1 */
  ,{   7,   7,  1, acFont13H_1_00A2 } /* code 00A2 */
  ,{   7,   7,  1, acFont13H_1_00A3 } /* code 00A3 */
  ,{   7,   7,  1, acFont13H_1_00A4 } /* code 00A4 */
  ,{   7,   7,  1, acFont13H_1_00A5 } /* code 00A5 */
  ,{   5,   5,  1, acFont13H_1_00A6 } /* code 00A6 */
  ,{   7,   7,  1, acFont13H_1_00A7 } /* code 00A7 */
  ,{   7,   7,  1, acFont13H_1_00A8 } /* code 00A8 */
  ,{  12,  12,  2, acFont13H_1_00A9 } /* code 00A9 */
  ,{   6,   6,  1, acFont13H_1_00AA } /* code 00AA */
  ,{   7,   7,  1, acFont13H_1_00AB } /* code 00AB */
  ,{   9,   9,  2, acFont13H_1_00AC } /* code 00AC */
  ,{   5,   5,  1, acFont13H_1_00AD } /* code 00AD */
  ,{  12,  12,  2, acFont13H_1_00AE } /* code 00AE */
  ,{   7,   7,  1, acFont13H_1_00AF } /* code 00AF */
  ,{   6,   6,  1, acFont13H_1_00B0 } /* code 00B0 */
  ,{   8,   8,  1, acFont13H_1_00B1 } /* code 00B1 */
  ,{   6,   6,  1, acFont13H_1_00B2 } /* code 00B2 */
  ,{   6,   6,  1, acFont13H_1_00B3 } /* code 00B3 */
  ,{   7,   7,  1, acFont13H_1_00B4 } /* code 00B4 */
  ,{   7,   7,  1, acFont13H_1_00B5 } /* code 00B5 */
  ,{   7,   7,  1, acFont13H_1_00B6 } /* code 00B6 */
  ,{   4,   4,  1, acFont13H_1_00B7 } /* code 00B7 */
  ,{   7,   7,  1, acFont13H_1_00B8 } /* code 00B8 */
  ,{   6,   6,  1, acFont13H_1_00B9 } /* code 00B9 */
  ,{   6,   6,  1, acFont13H_1_00BA } /* code 00BA */
  ,{   7,   7,  1, acFont13H_1_00BB } /* code 00BB */
  ,{  13,  13,  2, acFont13H_1_00BC } /* code 00BC */
  ,{  13,  13,  2, acFont13H_1_00BD } /* code 00BD */
  ,{  13,  13,  2, acFont13H_1_00BE } /* code 00BE */
  ,{   6,   6,  1, acFont13H_1_00BF } /* code 00BF */
  ,{   8,   8,  1, acFont13H_1_00C0 } /* code 00C0 */
  ,{   8,   8,  1, acFont13H_1_00C1 } /* code 00C1 */
  ,{   8,   8,  1, acFont13H_1_00C2 } /* code 00C2 */
  ,{   8,   8,  1, acFont13H_1_00C3 } /* code 00C3 */
  ,{   8,   8,  1, acFont13H_1_00C4 } /* code 00C4 */
  ,{   8,   8,  1, acFont13H_1_00C5 } /* code 00C5 */
  ,{  12,  12,  2, acFont13H_1_00C6 } /* code 00C6 */
  ,{   8,   8,  1, acFont13H_1_00C7 } /* code 00C7 */
  ,{   7,   7,  1, acFont13H_1_00C8 } /* code 00C8 */
  ,{   7,   7,  1, acFont13H_1_00C9 } /* code 00C9 */
  ,{   7,   7,  1, acFont13H_1_00CA } /* code 00CA */
  ,{   7,   7,  1, acFont13H_1_00CB } /* code 00CB */
  ,{   4,   4,  1, acFont13H_1_00CC } /* code 00CC */
  ,{   4,   4,  1, acFont13H_1_00CD } /* code 00CD */
  ,{   4,   4,  1, acFont13H_1_00CE } /* code 00CE */
  ,{   4,   4,  1, acFont13H_1_00CF } /* code 00CF */
  ,{   9,   9,  2, acFont13H_1_00D0 } /* code 00D0 */
  ,{   8,   8,  1, acFont13H_1_00D1 } /* code 00D1 */
  ,{   9,   9,  2, acFont13H_1_00D2 } /* code 00D2 */
  ,{   9,   9,  2, acFont13H_1_00D3 } /* code 00D3 */
  ,{   9,   9,  2, acFont13H_1_00D4 } /* code 00D4 */
  ,{   9,   9,  2, acFont13H_1_00D5 } /* code 00D5 */
  ,{   9,   9,  2, acFont13H_1_00D6 } /* code 00D6 */
  ,{   9,   9,  2, acFont13H_1_00D7 } /* code 00D7 */
  ,{   9,   9,  2, acFont13H_1_00D8 } /* code 00D8 */
  ,{   8,   8,  1, acFont13H_1_00D9 } /* code 00D9 */
  ,{   8,   8,  1, acFont13H_1_00DA } /* code 00DA */
  ,{   8,   8,  1, acFont13H_1_00DB } /* code 00DB */
  ,{   8,   8,  1, acFont13H_1_00DC } /* code 00DC */
  ,{   7,   7,  1, acFont13H_1_00DD } /* code 00DD */
  ,{   7,   7,  1, acFont13H_1_00DE } /* code 00DE */
  ,{   7,   7,  1, acFont13H_1_00DF } /* code 00DF */
  ,{   7,   7,  1, acFont13H_1_00E0 } /* code 00E0 */
  ,{   7,   7,  1, acFont13H_1_00E1 } /* code 00E1 */
  ,{   7,   7,  1, acFont13H_1_00E2 } /* code 00E2 */
  ,{   7,   7,  1, acFont13H_1_00E3 } /* code 00E3 */
  ,{   7,   7,  1, acFont13H_1_00E4 } /* code 00E4 */
  ,{   7,   7,  1, acFont13H_1_00E5 } /* code 00E5 */
  ,{  11,  11,  2, acFont13H_1_00E6 } /* code 00E6 */
  ,{   6,   6,  1, acFont13H_1_00E7 } /* code 00E7 */
  ,{   7,   7,  1, acFont13H_1_00E8 } /* code 00E8 */
  ,{   7,   7,  1, acFont13H_1_00E9 } /* code 00E9 */
  ,{   7,   7,  1, acFont13H_1_00EA } /* code 00EA */
  ,{   7,   7,  1, acFont13H_1_00EB } /* code 00EB */
  ,{   3,   3,  1, acFont13H_1_00EC } /* code 00EC */
  ,{   3,   3,  1, acFont13H_1_00ED } /* code 00ED */
  ,{   3,   3,  1, acFont13H_1_00EE } /* code 00EE */
  ,{   3,   3,  1, acFont13H_1_00EF } /* code 00EF */
  ,{   7,   7,  1, acFont13H_1_00F0 } /* code 00F0 */
  ,{   7,   7,  1, acFont13H_1_00F1 } /* code 00F1 */
  ,{   7,   7,  1, acFont13H_1_00F2 } /* code 00F2 */
  ,{   7,   7,  1, acFont13H_1_00F3 } /* code 00F3 */
  ,{   7,   7,  1, acFont13H_1_00F4 } /* code 00F4 */
  ,{   7,   7,  1, acFont13H_1_00F5 } /* code 00F5 */
  ,{   7,   7,  1, acFont13H_1_00F6 } /* code 00F6 */
  ,{   9,   9,  2, acFont13H_1_00F7 } /* code 00F7 */
  ,{   7,   7,  1, acFont13H_1_00F8 } /* code 00F8 */
  ,{   7,   7,  1, acFont13H_1_00F9 } /* code 00F9 */
  ,{   7,   7,  1, acFont13H_1_00FA } /* code 00FA */
  ,{   7,   7,  1, acFont13H_1_00FB } /* code 00FB */
  ,{   7,   7,  1, acFont13H_1_00FC } /* code 00FC */
  ,{   6,   6,  1, acFont13H_1_00FD } /* code 00FD */
  ,{   7,   7,  1, acFont13H_1_00FE } /* code 00FE */
  ,{   6,   6,  1, acFont13H_1_00FF } /* code 00FF */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_Font13H_1_Prop2 = {
   0x00A0                     /* first character */
  ,0x00FF                     /* last character  */
  ,&GUI_Font13H_1_CharInfo[0] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP*)0    /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_Font13H_1_Prop1 = {
   0x0020                         /* first character */
  ,0x007E                         /* last character  */
  ,&GUI_Font13H_ASCII_CharInfo[0] /* address of first character */
  ,&GUI_Font13H_1_Prop2           /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_Font13H_1 = {
   GUI_FONTTYPE_PROP  /* type of font    */
  ,13                 /* height of font  */
  ,13                 /* space of font y */
  ,1                  /* magnification x */
  ,1                  /* magnification y */
  ,{&GUI_Font13H_1_Prop1}
  , 11, 7, 9
};

