/*
*********************************************************************************************************
*                                                uC/GUI
*                        Universal graphic software for embedded applications
*
*                       (c) Copyright 2002, Micrium Inc., Weston, FL
*                       (c) Copyright 2002, SEGGER Microcontroller Systeme GmbH
*
*              C/GUI is protected by international copyright laws. Knowledge of the
*              source code may not be used to write a similar product. This file may
*              only be used in accordance with a license and should not be redistributed
*              in any way. We appreciate your understanding and fairness.
*
----------------------------------------------------------------------
File        : F16_1.C
Purpose     : ISO 8859-1 West European Character Set similar to Swiss
Height      : 16
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI_FontIntern.h"


/* The character codes 0x80 - 0x9f are not part of the
   ISO 8859 extensions. If needed them you can include them
   by using a modifyed copy of this file.
*/

#if 0

GUI_CONST_STORAGE unsigned char acFont16_1_128[16] = { /* code 128 */
  ________,
  ________,
  ________,
  ___XXXX_,
  __X_____,
  _X______,
  XXXXXXX_,
  _X______,
  XXXXXXX_,
  _X______,
  _X______,
  __X_____,
  ___XXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_129[32] = { /* code 129 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _XXXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_130[16] = { /* code 130 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _X______,
  _X______,
  _X______,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_131[16] = { /* code 131 */
  ________,
  ________,
  ________,
  ____XXX_,
  ____X___,
  ____X___,
  __XXXX__,
  ___X____,
  ___X____,
  ___X____,
  ___X____,
  ___X____,
  __X_____,
  __X_____,
  __X_____,
  XXX_____};

GUI_CONST_STORAGE unsigned char acFont16_1_132[16] = { /* code 132 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  X_X_____,
  X_X_____,
  X_X_____,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_133[32] = { /* code 133 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _X___X__,_X______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_134[16] = { /* code 134 */
  ________,
  ________,
  ________,
  ___X____,
  ___X____,
  ___X____,
  XXXXXXX_,
  ___X____,
  ___X____,
  ___X____,
  ___X____,
  ___X____,
  ___X____,
  ___X____,
  ___X____,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_135[16] = { /* code 135 */
  ________,
  ________,
  ________,
  ___X____,
  ___X____,
  XXXXXXX_,
  ___X____,
  ___X____,
  ___X____,
  ___X____,
  ___X____,
  ___X____,
  XXXXXXX_,
  ___X____,
  ___X____,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_136[16] = { /* code 136 */
  ________,
  ________,
  ________,
  __XX____,
  _X______,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_137[32] = { /* code 137 */
  ________,________,
  ________,________,
  ________,________,
  _XX___X_,________,
  X__X_X__,________,
  X__X_X__,________,
  X__X_X__,________,
  _XX_X___,________,
  ____X_XX,___XX___,
  ___X_X__,X_X__X__,
  ___X_X__,X_X__X__,
  ___X_X__,X_X__X__,
  __X___XX,___XX___,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_138[32] = { /* code 138 */
  ___X__X_,________,
  ____XX__,________,
  ________,________,
  __XXXXX_,________,
  _X_____X,________,
  _X_____X,________,
  _X______,________,
  __XXX___,________,
  _____XX_,________,
  _______X,________,
  _X_____X,________,
  _X_____X,________,
  __XXXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_139[16] = { /* code 139 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ___X____,
  __X_____,
  _X______,
  _X______,
  __X_____,
  ___X____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_140[32] = { /* code 140 */
  ________,________,
  ________,________,
  ________,________,
  ___XXX_X,XXXX____,
  __X___XX,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,XXXX____,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  __X___XX,________,
  ___XXX_X,XXXX____,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_141[32] = { /* code 141 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _XXXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_142[16] = { /* code 142 */
  __X__X__,
  ___XX___,
  ________,
  _XXXXXX_,
  _____X__,
  ____X___,
  ____X___,
  ___X____,
  ___X____,
  __X_____,
  __X_____,
  _X______,
  XXXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_143[32] = { /* code 143 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _XXXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_144[32] = { /* code 144 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _XXXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_145[16] = { /* code 145 */
  ________,
  ________,
  ________,
  _X______,
  _X______,
  _X______,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_146[16] = { /* code 146 */
  ________,
  ________,
  ________,
  _X______,
  _X______,
  _X______,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_147[16] = { /* code 147 */
  ________,
  ________,
  ________,
  X_X_____,
  X_X_____,
  X_X_____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_148[16] = { /* code 148 */
  ________,
  ________,
  ________,
  _X_X____,
  _X_X____,
  _X_X____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_149[16] = { /* code 149 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XXX____,
  _XXX____,
  _XXX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_150[16] = { /* code 150 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  XXXXXXX_,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_151[32] = { /* code 151 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XXXXXXXX,XXXXX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_152[16] = { /* code 152 */
  ________,
  ________,
  ________,
  _X_X____,
  X_X_____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_153[32] = { /* code 153 */
  ________,________,
  ________,________,
  ________,________,
  _XXXXX_X,___X____,
  ___X___X,X_XX____,
  ___X___X,X_XX____,
  ___X___X,X_XX____,
  ___X___X,_X_X____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_154[16] = { /* code 154 */
  ________,
  ________,
  ________,
  __X__X__,
  ___XX___,
  ________,
  __XXX___,
  _X___X__,
  _X______,
  __XXX___,
  _____X__,
  _X___X__,
  __XXX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_155[16] = { /* code 155 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  X_______,
  _X______,
  __X_____,
  __X_____,
  _X______,
  X_______,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_156[32] = { /* code 156 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXX_XX,XX______,
  _X___X__,__X_____,
  _X___X__,__X_____,
  _X___XXX,XXX_____,
  _X___X__,________,
  _X___X__,__X_____,
  __XXX_XX,XX______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_157[32] = { /* code 157 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _XXXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_158[16] = { /* code 158 */
  ________,
  ________,
  ________,
  __X__X__,
  ___XX___,
  ________,
  _XXXXX__,
  ____X___,
  ____X___,
  ___X____,
  __X_____,
  __X_____,
  _XXXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_159[32] = { /* code 159 */
  ________,________,
  ___X_X__,________,
  ________,________,
  _X_____X,________,
  __X___X_,________,
  __X___X_,________,
  ___X_X__,________,
  ___X_X__,________,
  ____X___,________,
  ____X___,________,
  ____X___,________,
  ____X___,________,
  ____X___,________,
  ________,________,
  ________,________,
  ________,________};

#endif

GUI_CONST_STORAGE unsigned char acFont16_1_160[16] = { /* code 160 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_161[16] = { /* code 161 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _X______,
  ________,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______};

GUI_CONST_STORAGE unsigned char acFont16_1_162[16] = { /* code 162 */
  ________,
  ________,
  ________,
  ____X___,
  ____X___,
  ____X___,
  __XXX___,
  _X_X_X__,
  X__X____,
  X_X_____,
  X_X__X__,
  XXX_X___,
  _XXX____,
  _X______,
  _X______,
  _X______};

GUI_CONST_STORAGE unsigned char acFont16_1_163[16] = { /* code 163 */
  ________,
  ________,
  ________,
  __XXX___,
  _X___X__,
  _X______,
  _X______,
  XXXXX___,
  __X_____,
  __X_____,
  _X______,
  _XXX____,
  X___XX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_164[16] = { /* code 164 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _X_X_X__,
  __X_X___,
  _X___X__,
  __X_X___,
  _X_X_X__,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_165[16] = { /* code 165 */
  ________,
  ________,
  ________,
  X_____X_,
  _X___X__,
  _X___X__,
  __X_X___,
  __X_X___,
  XXXXXXX_,
  ___X____,
  XXXXXXX_,
  ___X____,
  ___X____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_166[16] = { /* code 166 */
  ________,
  ________,
  ________,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  ________,
  ________,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_167[16] = { /* code 167 */
  ________,
  ________,
  ________,
  ___XX___,
  __X__X__,
  __X_____,
  __XX____,
  _X__XX__,
  _X___XX_,
  _XX___X_,
  __XX_XX_,
  ____X___,
  _____X__,
  _X___X__,
  __XXX___,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_168[16] = { /* code 168 */
  ________,
  ________,
  ________,
  X_X_____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_169[32] = { /* code 169 */
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,________,
  _X______,X_______,
  X__XXXX_,_X______,
  X_X____X,_X______,
  X_X_____,_X______,
  X_X_____,_X______,
  X_X____X,_X______,
  X__XXXX_,_X______,
  _X______,X_______,
  __XXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_170[16] = { /* code 170 */
  ________,
  ________,
  ________,
  _XXX____,
  X__X____,
  _XXX____,
  X__X____,
  XXXX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_171[16] = { /* code 171 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ___X_X__,
  __X_X___,
  _X_X____,
  _X_X____,
  __X_X___,
  ___X_X__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_172[16] = { /* code 172 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  XXXXXXX_,
  ______X_,
  ______X_,
  ______X_,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_173[16] = { /* code 173 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  XXX_____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_174[32] = { /* code 174 */
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,________,
  _X______,X_______,
  X__XXXX_,_X______,
  X__X___X,_X______,
  X__X___X,_X______,
  X__XXXX_,_X______,
  X__X__X_,_X______,
  X__X___X,_X______,
  _X______,X_______,
  __XXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_175[16] = { /* code 175 */
  ________,
  ________,
  XXXXXXX_,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_176[16] = { /* code 176 */
  ________,
  ________,
  ________,
  __XX____,
  _X__X___,
  _X__X___,
  __XX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_177[16] = { /* code 177 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ___X____,
  ___X____,
  ___X____,
  XXXXXXX_,
  ___X____,
  ___X____,
  ___X____,
  XXXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_178[16] = { /* code 178 */
  ________,
  ________,
  ________,
  _XXX____,
  X__X____,
  __X_____,
  _X______,
  XXXX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_179[16] = { /* code 179 */
  ________,
  ________,
  ________,
  _XXX____,
  X__X____,
  __X_____,
  X__X____,
  _XXX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_180[16] = { /* code 180 */
  ________,
  ________,
  ________,
  __X_____,
  _X______,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_181[16] = { /* code 181 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  _XXXXX__,
  _X______,
  _X______,
  _X______};

GUI_CONST_STORAGE unsigned char acFont16_1_182[16] = { /* code 182 */
  ________,
  ________,
  ________,
  _XXXXXX_,
  XXXX_X__,
  XXXX_X__,
  XXXX_X__,
  _XXX_X__,
  ___X_X__,
  ___X_X__,
  ___X_X__,
  ___X_X__,
  ___X_X__,
  ___X_X__,
  ___X_X__,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_183[16] = { /* code 183 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _X______,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_184[16] = { /* code 184 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __X_____,
  ___X____,
  _XXX____};

GUI_CONST_STORAGE unsigned char acFont16_1_185[16] = { /* code 185 */
  ________,
  ________,
  ________,
  __X_____,
  _XX_____,
  __X_____,
  __X_____,
  __X_____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_186[16] = { /* code 186 */
  ________,
  ________,
  ________,
  _XXX____,
  X___X___,
  X___X___,
  X___X___,
  _XXX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_187[16] = { /* code 187 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _X_X____,
  __X_X___,
  ___X_X__,
  ___X_X__,
  __X_X___,
  _X_X____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_188[32] = { /* code 188 */
  ________,________,
  ________,________,
  ________,________,
  __X_____,X_______,
  _XX_____,X_______,
  __X____X,________,
  __X___X_,________,
  __X___X_,________,
  _____X__,_X______,
  ____X___,XX______,
  ___X___X,_X______,
  ___X___X,XXX_____,
  __X_____,_X______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_189[32] = { /* code 189 */
  ________,________,
  ________,________,
  ________,________,
  __X_____,X_______,
  _XX____X,________,
  __X____X,________,
  __X___X_,________,
  __X__X__,________,
  _____X__,XX______,
  ____X__X,__X_____,
  ___X____,_X______,
  ___X____,X_______,
  __X____X,XXX_____,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_190[32] = { /* code 190 */
  ________,________,
  ________,________,
  ________,________,
  _XXX____,X_______,
  X__X____,X_______,
  __X____X,________,
  X__X__X_,________,
  _XXX__X_,________,
  _____X__,_X______,
  ____X___,XX______,
  ___X___X,_X______,
  ___X___X,XXX_____,
  __X_____,_X______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_191[16] = { /* code 191 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ___X____,
  ________,
  ___X____,
  ___X____,
  ___X____,
  __X_____,
  _X______,
  _X____X_,
  _X____X_,
  __XXXX__};

GUI_CONST_STORAGE unsigned char acFont16_1_192[32] = { /* code 192 */
  ___X____,________,
  ____X___,________,
  ________,________,
  ____X___,________,
  ___X_X__,________,
  ___X_X__,________,
  ___X_X__,________,
  __X___X_,________,
  __X___X_,________,
  _XXXXXXX,________,
  _X_____X,________,
  X_______,X_______,
  X_______,X_______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_193[32] = { /* code 193 */
  _____X__,________,
  ____X___,________,
  ________,________,
  ____X___,________,
  ___X_X__,________,
  ___X_X__,________,
  ___X_X__,________,
  __X___X_,________,
  __X___X_,________,
  _XXXXXXX,________,
  _X_____X,________,
  X_______,X_______,
  X_______,X_______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_194[32] = { /* code 194 */
  ___XX___,________,
  __X__X__,________,
  ________,________,
  ____X___,________,
  ___X_X__,________,
  ___X_X__,________,
  ___X_X__,________,
  __X___X_,________,
  __X___X_,________,
  _XXXXXXX,________,
  _X_____X,________,
  X_______,X_______,
  X_______,X_______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_195[32] = { /* code 195 */
  ____X_X_,________,
  ___X_X__,________,
  ________,________,
  ____X___,________,
  ___X_X__,________,
  ___X_X__,________,
  ___X_X__,________,
  __X___X_,________,
  __X___X_,________,
  _XXXXXXX,________,
  _X_____X,________,
  X_______,X_______,
  X_______,X_______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_196[32] = { /* code 196 */
  ________,________,
  ___X_X__,________,
  ________,________,
  ____X___,________,
  ___X_X__,________,
  ___X_X__,________,
  ___X_X__,________,
  __X___X_,________,
  __X___X_,________,
  _XXXXXXX,________,
  _X_____X,________,
  X_______,X_______,
  X_______,X_______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_197[32] = { /* code 197 */
  ________,________,
  ___XXX__,________,
  ___X_X__,________,
  ___XXX__,________,
  ___X_X__,________,
  ___X_X__,________,
  ___X_X__,________,
  __X___X_,________,
  __X___X_,________,
  _XXXXXXX,________,
  _X_____X,________,
  X_______,X_______,
  X_______,X_______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_198[32] = { /* code 198 */
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,XXXX____,
  ___X__X_,________,
  ___X__X_,________,
  ___X__X_,________,
  __X___XX,XXXX____,
  __X___X_,________,
  _XXXXXX_,________,
  _X____X_,________,
  X_____X_,________,
  X_____XX,XXXX____,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_199[32] = { /* code 199 */
  ________,________,
  ________,________,
  ________,________,
  ___XXX__,________,
  __X___X_,________,
  _X_____X,________,
  _X______,________,
  _X______,________,
  _X______,________,
  _X______,________,
  _X_____X,________,
  __X___X_,________,
  ___XXX__,________,
  ____X___,________,
  _____X__,________,
  ___XXX__,________};

GUI_CONST_STORAGE unsigned char acFont16_1_200[32] = { /* code 200 */
  ___X____,________,
  ____X___,________,
  ________,________,
  _XXXXXXX,________,
  _X______,________,
  _X______,________,
  _X______,________,
  _XXXXXXX,________,
  _X______,________,
  _X______,________,
  _X______,________,
  _X______,________,
  _XXXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_201[32] = { /* code 201 */
  _____X__,________,
  ____X___,________,
  ________,________,
  _XXXXXXX,________,
  _X______,________,
  _X______,________,
  _X______,________,
  _XXXXXXX,________,
  _X______,________,
  _X______,________,
  _X______,________,
  _X______,________,
  _XXXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_202[32] = { /* code 202 */
  ____XX__,________,
  ___X__X_,________,
  ________,________,
  _XXXXXXX,________,
  _X______,________,
  _X______,________,
  _X______,________,
  _XXXXXXX,________,
  _X______,________,
  _X______,________,
  _X______,________,
  _X______,________,
  _XXXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_203[32] = { /* code 203 */
  ________,________,
  ___X_X__,________,
  ________,________,
  _XXXXXXX,________,
  _X______,________,
  _X______,________,
  _X______,________,
  _XXXXXXX,________,
  _X______,________,
  _X______,________,
  _X______,________,
  _X______,________,
  _XXXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_204[16] = { /* code 204 */
  X_______,
  _X______,
  ________,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_205[16] = { /* code 205 */
  __X_____,
  _X______,
  ________,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_206[16] = { /* code 206 */
  _XX_____,
  X_______,
  ________,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_207[16] = { /* code 207 */
  ________,
  X_X_____,
  ________,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_208[32] = { /* code 208 */
  ________,________,
  ________,________,
  ________,________,
  _XXXXX__,________,
  _X____X_,________,
  _X_____X,________,
  _X_____X,________,
  XXXXX__X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X____X_,________,
  _XXXXX__,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_209[32] = { /* code 209 */
  ____X_X_,________,
  ___X_X__,________,
  ________,________,
  _X_____X,________,
  _XX____X,________,
  _X_X___X,________,
  _X_X___X,________,
  _X__X__X,________,
  _X__X__X,________,
  _X___X_X,________,
  _X___X_X,________,
  _X____XX,________,
  _X_____X,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_210[32] = { /* code 210 */
  ____X___,________,
  _____X__,________,
  ________,________,
  ___XXXX_,________,
  __X____X,________,
  _X______,X_______,
  _X______,X_______,
  _X______,X_______,
  _X______,X_______,
  _X______,X_______,
  _X______,X_______,
  __X____X,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_211[32] = { /* code 211 */
  _____X__,________,
  ____X___,________,
  ________,________,
  ___XXXX_,________,
  __X____X,________,
  _X______,X_______,
  _X______,X_______,
  _X______,X_______,
  _X______,X_______,
  _X______,X_______,
  _X______,X_______,
  __X____X,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_212[32] = { /* code 212 */
  ____XX__,________,
  ___X__X_,________,
  ________,________,
  ___XXXX_,________,
  __X____X,________,
  _X______,X_______,
  _X______,X_______,
  _X______,X_______,
  _X______,X_______,
  _X______,X_______,
  _X______,X_______,
  __X____X,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_213[32] = { /* code 213 */
  ____X_X_,________,
  ___X_X__,________,
  ________,________,
  ___XXXX_,________,
  __X____X,________,
  _X______,X_______,
  _X______,X_______,
  _X______,X_______,
  _X______,X_______,
  _X______,X_______,
  _X______,X_______,
  __X____X,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_214[32] = { /* code 214 */
  ________,________,
  ____X_X_,________,
  ________,________,
  ___XXXX_,________,
  __X____X,________,
  _X______,X_______,
  _X______,X_______,
  _X______,X_______,
  _X______,X_______,
  _X______,X_______,
  _X______,X_______,
  __X____X,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_215[16] = { /* code 215 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _X___X__,
  __XXX___,
  ___X____,
  __XXX___,
  _X___X__,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_216[32] = { /* code 216 */
  ________,________,
  ________,________,
  ________,________,
  ___XXXX_,X_______,
  __X____X,________,
  _X____X_,X_______,
  _X____X_,X_______,
  _X___X__,X_______,
  _X__X___,X_______,
  _X__X___,X_______,
  _X_X____,X_______,
  __X____X,________,
  _X_XXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_217[32] = { /* code 217 */
  ___X____,________,
  ____X___,________,
  ________,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  __X___X_,________,
  ___XXX__,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_218[32] = { /* code 218 */
  _____X__,________,
  ____X___,________,
  ________,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  __X___X_,________,
  ___XXX__,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_219[32] = { /* code 219 */
  ____XX__,________,
  ___X__X_,________,
  ________,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  __X___X_,________,
  ___XXX__,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_220[32] = { /* code 220 */
  ________,________,
  ___X_X__,________,
  ________,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  _X_____X,________,
  __X___X_,________,
  ___XXX__,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_221[32] = { /* code 221 */
  _____X__,________,
  ____X___,________,
  ________,________,
  _X_____X,________,
  __X___X_,________,
  __X___X_,________,
  ___X_X__,________,
  ___X_X__,________,
  ____X___,________,
  ____X___,________,
  ____X___,________,
  ____X___,________,
  ____X___,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_222[32] = { /* code 222 */
  ________,________,
  ________,________,
  ________,________,
  _X______,________,
  _X______,________,
  _XXXXXX_,________,
  _X____XX,________,
  _X_____X,________,
  _X_____X,________,
  _X____XX,________,
  _XXXXXX_,________,
  _X______,________,
  _X______,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_223[32] = { /* code 223 */
  ________,________,
  ________,________,
  ________,________,
  ___XXX__,________,
  __X___X_,________,
  _X____X_,________,
  _X___X__,________,
  _X___X__,________,
  _X___X__,________,
  _X____X_,________,
  _X_____X,________,
  _X_X___X,________,
  _X__XXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_224[16] = { /* code 224 */
  ________,
  ________,
  ________,
  ___X____,
  ____X___,
  ________,
  __XXX___,
  _X___X__,
  _____X__,
  __XXXX__,
  _X___X__,
  _X__XX__,
  __XX_X__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_225[16] = { /* code 225 */
  ________,
  ________,
  ________,
  ____X___,
  ___X____,
  ________,
  __XXX___,
  _X___X__,
  _____X__,
  __XXXX__,
  _X___X__,
  _X__XX__,
  __XX_X__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_226[16] = { /* code 226 */
  ________,
  ________,
  ________,
  ___XX___,
  __X__X__,
  ________,
  __XXX___,
  _X___X__,
  _____X__,
  __XXXX__,
  _X___X__,
  _X__XX__,
  __XX_X__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_227[16] = { /* code 227 */
  ________,
  ________,
  ________,
  ___X_X__,
  __X_X___,
  ________,
  __XXX___,
  _X___X__,
  _____X__,
  __XXXX__,
  _X___X__,
  _X__XX__,
  __XX_X__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_228[16] = { /* code 228 */
  ________,
  ________,
  ________,
  ________,
  __X_X___,
  ________,
  __XXX___,
  _X___X__,
  _____X__,
  __XXXX__,
  _X___X__,
  _X__XX__,
  __XX_X__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_229[16] = { /* code 229 */
  ________,
  ________,
  __XXX___,
  __X_X___,
  __XXX___,
  ________,
  __XXX___,
  _X___X__,
  _____X__,
  __XXXX__,
  _X___X__,
  _X__XX__,
  __XX_X__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_230[32] = { /* code 230 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXX_X,XX______,
  _X___XX_,__X_____,
  ___XXX__,__X_____,
  __X__XXX,XXX_____,
  _X___X__,________,
  _X___XX_,__X_____,
  __XXX__X,XX______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_1_231[16] = { /* code 231 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXX___,
  _X___X__,
  _X______,
  _X______,
  _X______,
  _X___X__,
  __XXX___,
  ___X____,
  ____X___,
  __XXX___};

GUI_CONST_STORAGE unsigned char acFont16_1_232[16] = { /* code 232 */
  ________,
  ________,
  ________,
  __X_____,
  ___X____,
  ________,
  __XXX___,
  _X___X__,
  _X___X__,
  _XXXXX__,
  _X______,
  _X___X__,
  __XXX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_233[16] = { /* code 233 */
  ________,
  ________,
  ________,
  ____X___,
  ___X____,
  ________,
  __XXX___,
  _X___X__,
  _X___X__,
  _XXXXX__,
  _X______,
  _X___X__,
  __XXX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_234[16] = { /* code 234 */
  ________,
  ________,
  ________,
  ___XX___,
  __X__X__,
  ________,
  __XXX___,
  _X___X__,
  _X___X__,
  _XXXXX__,
  _X______,
  _X___X__,
  __XXX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_235[16] = { /* code 235 */
  ________,
  ________,
  ________,
  ________,
  __X_X___,
  ________,
  __XXX___,
  _X___X__,
  _X___X__,
  _XXXXX__,
  _X______,
  _X___X__,
  __XXX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_236[16] = { /* code 236 */
  ________,
  ________,
  ________,
  X_______,
  _X______,
  ________,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_237[16] = { /* code 237 */
  ________,
  ________,
  ________,
  __X_____,
  _X______,
  ________,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_238[16] = { /* code 238 */
  ________,
  ________,
  ________,
  _XX_____,
  X_______,
  ________,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_239[16] = { /* code 239 */
  ________,
  ________,
  ________,
  ________,
  X_X_____,
  ________,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_240[16] = { /* code 240 */
  ________,
  ________,
  ________,
  __X_X___,
  __XX____,
  _X__X___,
  __XXX___,
  _X__XX__,
  X____X__,
  X____X__,
  X____X__,
  _X__X___,
  __XX____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_241[16] = { /* code 241 */
  ________,
  ________,
  ________,
  ___X_X__,
  __X_X___,
  ________,
  _X_XX___,
  _XX__X__,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_242[16] = { /* code 242 */
  ________,
  ________,
  ________,
  __X_____,
  ___X____,
  ________,
  __XXX___,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  __XXX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_243[16] = { /* code 243 */
  ________,
  ________,
  ________,
  ____X___,
  ___X____,
  ________,
  __XXX___,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  __XXX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_244[16] = { /* code 244 */
  ________,
  ________,
  ________,
  ___XX___,
  __X__X__,
  ________,
  __XXX___,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  __XXX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_245[16] = { /* code 245 */
  ________,
  ________,
  ________,
  ___X_X__,
  __X_X___,
  ________,
  __XXX___,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  __XXX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_246[16] = { /* code 246 */
  ________,
  ________,
  ________,
  ________,
  __X_X___,
  ________,
  __XXX___,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  __XXX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_247[16] = { /* code 247 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ___X____,
  ________,
  XXXXXXX_,
  ________,
  ___X____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_248[16] = { /* code 248 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XX_X__,
  _X__X___,
  _X__XX__,
  _X_X_X__,
  _XX__X__,
  __X__X__,
  _X_XX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_249[16] = { /* code 249 */
  ________,
  ________,
  ________,
  __X_____,
  ___X____,
  ________,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_250[16] = { /* code 250 */
  ________,
  ________,
  ________,
  ____X___,
  ___X____,
  ________,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_251[16] = { /* code 251 */
  ________,
  ________,
  ________,
  ___XX___,
  __X__X__,
  ________,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_252[16] = { /* code 252 */
  ________,
  ________,
  ________,
  ________,
  __X_X___,
  ________,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  _X___X__,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16_1_253[16] = { /* code 253 */
  ________,
  ________,
  ________,
  ____X___,
  ___X____,
  ________,
  _X___X__,
  _X___X__,
  __X_X___,
  __X_X___,
  __X_X___,
  ___X____,
  ___X____,
  ___X____,
  ___X____,
  _XX_____};

GUI_CONST_STORAGE unsigned char acFont16_1_254[16] = { /* code 254 */
  ________,
  ________,
  ________,
  _X______,
  _X______,
  _X______,
  _XXX____,
  _X__X___,
  _X___X__,
  _X___X__,
  _X___X__,
  _X__X___,
  _XXX____,
  _X______,
  _X______,
  _X______};

GUI_CONST_STORAGE unsigned char acFont16_1_255[16] = { /* code 255 */
  ________,
  ________,
  ________,
  ________,
  __X_X___,
  ________,
  _X___X__,
  _X___X__,
  __X_X___,
  __X_X___,
  __X_X___,
  ___X____,
  ___X____,
  ___X____,
  ___X____,
  _XX_____};


GUI_CONST_STORAGE GUI_CHARINFO GUI_CharInfo_Font16_1[96] = {
   {   4,   4,  1, acFont16_1_160 } /* code 160 */
  ,{   3,   3,  1, acFont16_1_161 } /* code 161 */
  ,{   7,   7,  1, acFont16_1_162 } /* code 162 */
  ,{   7,   7,  1, acFont16_1_163 } /* code 163 */
  ,{   7,   7,  1, acFont16_1_164 } /* code 164 */
  ,{   7,   7,  1, acFont16_1_165 } /* code 165 */
  ,{   3,   3,  1, acFont16_1_166 } /* code 166 */
  ,{   7,   7,  1, acFont16_1_167 } /* code 167 */
  ,{   4,   4,  1, acFont16_1_168 } /* code 168 */
  ,{  10,  10,  2, acFont16_1_169 } /* code 169 */
  ,{   4,   4,  1, acFont16_1_170 } /* code 170 */
  ,{   7,   7,  1, acFont16_1_171 } /* code 171 */
  ,{   8,   8,  1, acFont16_1_172 } /* code 172 */
  ,{   4,   4,  1, acFont16_1_173 } /* code 173 */
  ,{  10,  10,  2, acFont16_1_174 } /* code 174 */
  ,{   7,   7,  1, acFont16_1_175 } /* code 175 */
  ,{   5,   5,  1, acFont16_1_176 } /* code 176 */
  ,{   7,   7,  1, acFont16_1_177 } /* code 177 */
  ,{   4,   4,  1, acFont16_1_178 } /* code 178 */
  ,{   4,   4,  1, acFont16_1_179 } /* code 179 */
  ,{   4,   4,  1, acFont16_1_180 } /* code 180 */
  ,{   7,   7,  1, acFont16_1_181 } /* code 181 */
  ,{   7,   7,  1, acFont16_1_182 } /* code 182 */
  ,{   4,   4,  1, acFont16_1_183 } /* code 183 */
  ,{   4,   4,  1, acFont16_1_184 } /* code 184 */
  ,{   4,   4,  1, acFont16_1_185 } /* code 185 */
  ,{   5,   5,  1, acFont16_1_186 } /* code 186 */
  ,{   7,   7,  1, acFont16_1_187 } /* code 187 */
  ,{  11,  11,  2, acFont16_1_188 } /* code 188 */
  ,{  11,  11,  2, acFont16_1_189 } /* code 189 */
  ,{  11,  11,  2, acFont16_1_190 } /* code 190 */
  ,{   8,   8,  1, acFont16_1_191 } /* code 191 */
  ,{   9,   9,  2, acFont16_1_192 } /* code 192 */
  ,{   9,   9,  2, acFont16_1_193 } /* code 193 */
  ,{   9,   9,  2, acFont16_1_194 } /* code 194 */
  ,{   9,   9,  2, acFont16_1_195 } /* code 195 */
  ,{   9,   9,  2, acFont16_1_196 } /* code 196 */
  ,{   9,   9,  2, acFont16_1_197 } /* code 197 */
  ,{  13,  13,  2, acFont16_1_198 } /* code 198 */
  ,{   9,   9,  2, acFont16_1_199 } /* code 199 */
  ,{   9,   9,  2, acFont16_1_200 } /* code 200 */
  ,{   9,   9,  2, acFont16_1_201 } /* code 201 */
  ,{   9,   9,  2, acFont16_1_202 } /* code 202 */
  ,{   9,   9,  2, acFont16_1_203 } /* code 203 */
  ,{   3,   3,  1, acFont16_1_204 } /* code 204 */
  ,{   3,   3,  1, acFont16_1_205 } /* code 205 */
  ,{   3,   3,  1, acFont16_1_206 } /* code 206 */
  ,{   3,   3,  1, acFont16_1_207 } /* code 207 */
  ,{   9,   9,  2, acFont16_1_208 } /* code 208 */
  ,{   9,   9,  2, acFont16_1_209 } /* code 209 */
  ,{  10,  10,  2, acFont16_1_210 } /* code 210 */
  ,{  10,  10,  2, acFont16_1_211 } /* code 211 */
  ,{  10,  10,  2, acFont16_1_212 } /* code 212 */
  ,{  10,  10,  2, acFont16_1_213 } /* code 213 */
  ,{  10,  10,  2, acFont16_1_214 } /* code 214 */
  ,{   8,   8,  1, acFont16_1_215 } /* code 215 */
  ,{  10,  10,  2, acFont16_1_216 } /* code 216 */
  ,{   9,   9,  2, acFont16_1_217 } /* code 217 */
  ,{   9,   9,  2, acFont16_1_218 } /* code 218 */
  ,{   9,   9,  2, acFont16_1_219 } /* code 219 */
  ,{   9,   9,  2, acFont16_1_220 } /* code 220 */
  ,{   9,   9,  2, acFont16_1_221 } /* code 221 */
  ,{   9,   9,  2, acFont16_1_222 } /* code 222 */
  ,{   9,   9,  2, acFont16_1_223 } /* code 223 */
  ,{   7,   7,  1, acFont16_1_224 } /* code 224 */
  ,{   7,   7,  1, acFont16_1_225 } /* code 225 */
  ,{   7,   7,  1, acFont16_1_226 } /* code 226 */
  ,{   7,   7,  1, acFont16_1_227 } /* code 227 */
  ,{   7,   7,  1, acFont16_1_228 } /* code 228 */
  ,{   7,   7,  1, acFont16_1_229 } /* code 229 */
  ,{  12,  12,  2, acFont16_1_230 } /* code 230 */
  ,{   7,   7,  1, acFont16_1_231 } /* code 231 */
  ,{   7,   7,  1, acFont16_1_232 } /* code 232 */
  ,{   7,   7,  1, acFont16_1_233 } /* code 233 */
  ,{   7,   7,  1, acFont16_1_234 } /* code 234 */
  ,{   7,   7,  1, acFont16_1_235 } /* code 235 */
  ,{   3,   3,  1, acFont16_1_236 } /* code 236 */
  ,{   3,   3,  1, acFont16_1_237 } /* code 237 */
  ,{   3,   3,  1, acFont16_1_238 } /* code 238 */
  ,{   3,   3,  1, acFont16_1_239 } /* code 239 */
  ,{   7,   7,  1, acFont16_1_240 } /* code 240 */
  ,{   7,   7,  1, acFont16_1_241 } /* code 241 */
  ,{   7,   7,  1, acFont16_1_242 } /* code 242 */
  ,{   7,   7,  1, acFont16_1_243 } /* code 243 */
  ,{   7,   7,  1, acFont16_1_244 } /* code 244 */
  ,{   7,   7,  1, acFont16_1_245 } /* code 245 */
  ,{   7,   7,  1, acFont16_1_246 } /* code 246 */
  ,{   7,   7,  1, acFont16_1_247 } /* code 247 */
  ,{   7,   7,  1, acFont16_1_248 } /* code 248 */
  ,{   7,   7,  1, acFont16_1_249 } /* code 249 */
  ,{   7,   7,  1, acFont16_1_250 } /* code 250 */
  ,{   7,   7,  1, acFont16_1_251 } /* code 251 */
  ,{   7,   7,  1, acFont16_1_252 } /* code 252 */
  ,{   7,   7,  1, acFont16_1_253 } /* code 253 */
  ,{   7,   7,  1, acFont16_1_254 } /* code 254 */
  ,{   7,   7,  1, acFont16_1_255 } /* code 255 */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_Font16_1_FontProp1 = {
   160                        /* first character               */
  ,255                        /* last character                */
  ,&GUI_CharInfo_Font16_1[0]  /* address of first character    */
  ,&GUI_Font16ASCIIProp1      /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_Font16_1 = {
   GUI_FONTTYPE_PROP            /* type of font    */
  ,16                           /* height of font  */
  ,16                           /* space of font y */
  ,1                            /* magnification x */
  ,1                            /* magnification y */
  ,{&GUI_Font16_1_FontProp1}
  , 13, 7, 10
};

