/*
*********************************************************************************************************
*                                                uC/GUI
*                        Universal graphic software for embedded applications
*
*                       (c) Copyright 2002, Micrium Inc., Weston, FL
*                       (c) Copyright 2002, SEGGER Microcontroller Systeme GmbH
*
*              C/GUI is protected by international copyright laws. Knowledge of the
*              source code may not be used to write a similar product. This file may
*              only be used in accordance with a license and should not be redistributed
*              in any way. We appreciate your understanding and fairness.
*
----------------------------------------------------------------------
File        : F24B_ASCII.C
Purpose     : ASCII character set, bold, high
Height      : 13
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI_FontIntern.h"

/* Start of unicode area <Basic Latin> */
GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0020[ 24] = { /* code 0020 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0021[ 24] = { /* code 0021 */
  ________,
  ________,
  ________,
  ________,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  ___X____,
  ___X____,
  ________,
  __XXX___,
  __XXX___,
  __XXX___,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0022[ 48] = { /* code 0022 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX__XX,X_______,
  _XXX__XX,X_______,
  _XXX__XX,X_______,
  _XXX__XX,X_______,
  _XXX__XX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0023[ 48] = { /* code 0023 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XX__,_XX_____,
  ____XX__,_XX_____,
  ____XX__,_XX_____,
  ___XX___,XX______,
  XXXXXXXX,XXXX____,
  XXXXXXXX,XXXX____,
  ___XX___,XX______,
  __XXX__X,XX______,
  __XX___X,X_______,
  XXXXXXXX,XXXX____,
  XXXXXXXX,XXXX____,
  __XX___X,X_______,
  _XXX__XX,X_______,
  _XX___XX,________,
  _XX___XX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0024[ 48] = { /* code 0024 */
  ________,________,
  ________,________,
  ________,________,
  _____XX_,________,
  ___XXXXX,X_______,
  __XXXXXX,XX______,
  _XXX_XX_,XXX_____,
  _XXX_XX_,XXX_____,
  _XXX_XX_,________,
  _XXXXXX_,________,
  __XXXXXX,________,
  ___XXXXX,XX______,
  _____XXX,XXX_____,
  _____XX_,XXX_____,
  _____XX_,XXX_____,
  _XXX_XX_,XXX_____,
  _XXX_XX_,XXX_____,
  __XXXXXX,XX______,
  ___XXXXX,X_______,
  _____XX_,________,
  _____XX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0025[ 72] = { /* code 0025 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXX__,___XX___,________,
  _XXXXXX_,__XXX___,________,
  _XX__XX_,__XX____,________,
  _XX__XX_,__XX____,________,
  _XX__XX_,_XX_____,________,
  _XX__XX_,_XX_____,________,
  _XXXXXX_,XX______,________,
  __XXXX__,XX______,________,
  _______X,X__XXXX_,________,
  _______X,X_XXXXXX,________,
  ______XX,X_XX__XX,________,
  ______XX,__XX__XX,________,
  ______XX,__XX__XX,________,
  _____XX_,__XX__XX,________,
  _____XX_,__XXXXXX,________,
  ____XX__,___XXXX_,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0026[ 48] = { /* code 0026 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,X_______,
  ____XXXX,XX______,
  ___XXX__,XXX_____,
  ___XXX__,XXX_____,
  ___XXXX_,XXX_____,
  ____XXXX,XX______,
  ____XXXX,X_______,
  ___XXXXX,X_______,
  __XXXXXX,X__XXX__,
  _XXX___X,XXXXXX__,
  _XXX___X,XXXXX___,
  _XXX____,XXXX____,
  _XXXX__X,XXXXXX__,
  __XXXXXX,XXXXXXX_,
  ___XXXXX,X___XX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0027[ 24] = { /* code 0027 */
  ________,
  ________,
  ________,
  ________,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0028[ 24] = { /* code 0028 */
  ________,
  ________,
  ________,
  ________,
  ____XX__,
  ___XX___,
  ___XX___,
  __XXX___,
  __XXX___,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  __XX____,
  __XXX___,
  __XXX___,
  ___XX___,
  ___XX___,
  ____XX__,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0029[ 24] = { /* code 0029 */
  ________,
  ________,
  ________,
  ________,
  _XX_____,
  __XX____,
  __XX____,
  __XXX___,
  __XXX___,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ___XX___,
  __XXX___,
  __XXX___,
  __XX____,
  __XX____,
  _XX_____,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_002A[ 24] = { /* code 002A */
  ________,
  ________,
  ________,
  ________,
  ___XX___,
  ___XX___,
  XX_XX_XX,
  XXXXXXXX,
  ___XXX__,
  __XXXX__,
  _XX__XX_,
  __X__X__,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_002B[ 48] = { /* code 002B */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXXX____,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_002C[ 24] = { /* code 002C */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XXX____,
  _XXX____,
  _XXX____,
  ___X____,
  __XX____,
  _XX_____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_002D[ 24] = { /* code 002D */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XXXXXX_,
  _XXXXXX_,
  _XXXXXX_,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_002E[ 24] = { /* code 002E */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XXX____,
  _XXX____,
  _XXX____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_002F[ 24] = { /* code 002F */
  ________,
  ________,
  ________,
  ________,
  ____XX__,
  ____XX__,
  ___XX___,
  ___XX___,
  ___XX___,
  __XXX___,
  __XX____,
  __XX____,
  __XX____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  XX______,
  XX______,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0030[ 48] = { /* code 0030 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,________,
  __XXXXXX,XX______,
  __XXX__X,XX______,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  __XXX__X,XX______,
  __XXXXXX,XX______,
  ____XXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0031[ 48] = { /* code 0031 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ______XX,X_______,
  ______XX,X_______,
  _____XXX,X_______,
  ___XXXXX,X_______,
  __XXXXXX,X_______,
  __XXX_XX,X_______,
  __X___XX,X_______,
  ______XX,X_______,
  ______XX,X_______,
  ______XX,X_______,
  ______XX,X_______,
  ______XX,X_______,
  ______XX,X_______,
  ______XX,X_______,
  ______XX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0032[ 48] = { /* code 0032 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXXX,X_______,
  __XXXXXX,XX______,
  _XXXX__X,XXX_____,
  _XXX____,XXX_____,
  ________,XXX_____,
  ________,XXX_____,
  _______X,XX______,
  ______XX,XX______,
  _____XXX,X_______,
  ____XXXX,________,
  ___XXXX_,________,
  ___XXX__,________,
  __XXX___,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0033[ 48] = { /* code 0033 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXXX,________,
  __XXXXXX,X_______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _______X,XX______,
  ______XX,XX______,
  ____XXXX,X_______,
  ____XXXX,X_______,
  _______X,XX______,
  ________,XXX_____,
  ________,XXX_____,
  _XXX____,XXX_____,
  _XXXX__X,XX______,
  __XXXXXX,XX______,
  ___XXXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0034[ 48] = { /* code 0034 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ______XX,X_______,
  _____XXX,X_______,
  _____XXX,X_______,
  ____XXXX,X_______,
  ____XXXX,X_______,
  ___XX_XX,X_______,
  __XX__XX,X_______,
  __XX__XX,X_______,
  _XX___XX,X_______,
  XX____XX,X_______,
  XXXXXXXX,XXX_____,
  XXXXXXXX,XXX_____,
  ______XX,X_______,
  ______XX,X_______,
  ______XX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0035[ 48] = { /* code 0035 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXXX,XX______,
  ___XXXXX,XX______,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  __XXXXXX,X_______,
  _XXXXXXX,XX______,
  _XXX___X,XXX_____,
  ________,XXX_____,
  ________,XXX_____,
  ________,XXX_____,
  _XXX____,XXX_____,
  _XXXX__X,XX______,
  __XXXXXX,XX______,
  ___XXXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0036[ 48] = { /* code 0036 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,X_______,
  __XXXXXX,XX______,
  __XXX__X,XXX_____,
  _XXX____,X_______,
  _XXX____,________,
  _XXX_XXX,X_______,
  _XXXXXXX,XX______,
  _XXXX__X,XX______,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  __XXX__X,XX______,
  __XXXXXX,XX______,
  ____XXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0037[ 48] = { /* code 0037 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  ________,XXX_____,
  _______X,XX______,
  ______XX,X_______,
  ______XX,X_______,
  _____XXX,________,
  _____XXX,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0038[ 48] = { /* code 0038 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXXX,X_______,
  __XXXXXX,XX______,
  _XXXX__X,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  __XXX__X,XX______,
  ___XXXXX,X_______,
  ___XXXXX,X_______,
  __XXX__X,XX______,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXXX__X,XXX_____,
  __XXXXXX,XX______,
  ___XXXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0039[ 48] = { /* code 0039 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,________,
  __XXXXXX,XX______,
  __XXX__X,XX______,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  __XXX__X,XXX_____,
  __XXXXXX,XXX_____,
  ___XXXX_,XXX_____,
  ________,XXX_____,
  __XX____,XXX_____,
  _XXXX__X,XX______,
  __XXXXXX,XX______,
  ___XXXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_003A[ 24] = { /* code 003A */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXX___,
  __XXX___,
  __XXX___,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXX___,
  __XXX___,
  __XXX___,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_003B[ 24] = { /* code 003B */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXX___,
  __XXX___,
  __XXX___,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXX___,
  __XXX___,
  __XXX___,
  ____X___,
  ___XX___,
  __XX____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_003C[ 48] = { /* code 003C */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,__X_____,
  ________,XXX_____,
  _____XXX,XXX_____,
  ___XXXXX,X_______,
  _XXXXX__,________,
  _XXX____,________,
  _XXXXXX_,________,
  ___XXXXX,XX______,
  _____XXX,XXX_____,
  ________,XXX_____,
  ________,__X_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_003D[ 48] = { /* code 003D */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  ________,________,
  ________,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_003E[ 48] = { /* code 003E */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _X______,________,
  _XXX____,________,
  _XXXXXX_,________,
  ___XXXXX,X_______,
  ______XX,XXX_____,
  ________,XXX_____,
  _____XXX,XXX_____,
  __XXXXXX,X_______,
  _XXXXXX_,________,
  _XXX____,________,
  _X______,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_003F[ 48] = { /* code 003F */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,X_______,
  __XXXXXX,XXX_____,
  _XXXX___,XXXX____,
  _XXX____,_XXX____,
  ________,_XXX____,
  ________,XXXX____,
  _______X,XXX_____,
  ______XX,XX______,
  _____XXX,X_______,
  _____XXX,________,
  _____XXX,________,
  ________,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0040[ 72] = { /* code 0040 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,XXXXXX__,________,
  _____XXX,XXXXXXXX,________,
  ____XXXX,______XX,X_______,
  ___XXX__,_______X,XX______,
  ___XX__X,XX_XXXX_,XX______,
  __XX__XX,XXXXXX__,_XX_____,
  __XX__XX,XXXXXX__,_XX_____,
  _XX___XX,X_XXXX__,_XX_____,
  _XX__XXX,__XXXX__,_XX_____,
  _XX__XXX,__XXXX__,_XX_____,
  _XX__XXX,__XXX___,XX______,
  _XX__XXX,_XXXX___,XX______,
  _XX__XXX,XXXXX__X,X_______,
  _XX___XX,XXXXXXXX,________,
  __XX__XX,X_XXXX__,________,
  __XXX___,________,_XXX____,
  ___XXX__,________,XXX_____,
  ____XXXX,______XX,XX______,
  _____XXX,XXXXXXXX,X_______,
  _______X,XXXXXXX_,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0041[ 48] = { /* code 0041 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XX______,
  _____XXX,XX______,
  _____XXX,XX______,
  ____XXX_,XXX_____,
  ____XXX_,XXX_____,
  ____XXX_,XXX_____,
  ___XXX__,_XXX____,
  ___XXX__,_XXX____,
  __XXX___,__XXX___,
  __XXXXXX,XXXXX___,
  __XXXXXX,XXXXX___,
  _XXXXXXX,XXXXXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  XXX_____,____XXX_,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0042[ 48] = { /* code 0042 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,XXX_____,
  __XXXXXX,XXXX____,
  __XXXXXX,XXXXX___,
  __XXX___,__XXX___,
  __XXX___,__XXX___,
  __XXX___,__XXX___,
  __XXXXXX,XXXX____,
  __XXXXXX,XXXX____,
  __XXXXXX,XXXXX___,
  __XXX___,___XXX__,
  __XXX___,___XXX__,
  __XXX___,___XXX__,
  __XXXXXX,XXXXXX__,
  __XXXXXX,XXXXX___,
  __XXXXXX,XXXX____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0043[ 48] = { /* code 0043 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XXXX____,
  __XXXXXX,XXXXX___,
  __XXXX__,__XXXX__,
  _XXXX___,___XX___,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXXX___,___XX___,
  __XXXX__,__XXXX__,
  __XXXXXX,XXXXX___,
  ___XXXXX,XXXX____,
  _____XXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0044[ 48] = { /* code 0044 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,XXX_____,
  __XXXXXX,XXXX____,
  __XXXXXX,XXXXX___,
  __XXX___,__XXX___,
  __XXX___,__XXXX__,
  __XXX___,___XXX__,
  __XXX___,___XXX__,
  __XXX___,___XXX__,
  __XXX___,___XXX__,
  __XXX___,___XXX__,
  __XXX___,___XXX__,
  __XXX___,__XXX___,
  __XXXXXX,XXXXX___,
  __XXXXXX,XXXX____,
  __XXXXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0045[ 48] = { /* code 0045 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,XXXXX___,
  __XXXXXX,XXXXX___,
  __XXXXXX,XXXXX___,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  __XXXXXX,XXXX____,
  __XXXXXX,XXXX____,
  __XXXXXX,XXXX____,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  __XXXXXX,XXXXX___,
  __XXXXXX,XXXXX___,
  __XXXXXX,XXXXX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0046[ 48] = { /* code 0046 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,XXXX____,
  __XXXXXX,XXXX____,
  __XXXXXX,XXXX____,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0047[ 48] = { /* code 0047 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ______XX,XXX_____,
  ____XXXX,XXXXX___,
  ___XXXXX,XXXXXX__,
  __XXXX__,___XXXX_,
  _XXXX___,____XX__,
  _XXX____,________,
  _XXX____,________,
  _XXX____,XXXXXXX_,
  _XXX____,XXXXXXX_,
  _XXX____,XXXXXXX_,
  __XXX___,____XXX_,
  __XXXX__,___XXXX_,
  ___XXXXX,XXXXXXX_,
  ____XXXX,XXXXXX__,
  ______XX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0048[ 48] = { /* code 0048 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXXXXXX,XXXXX___,
  _XXXXXXX,XXXXX___,
  _XXXXXXX,XXXXX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0049[ 24] = { /* code 0049 */
  ________,
  ________,
  ________,
  ________,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_004A[ 48] = { /* code 004A */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _______X,XX______,
  _______X,XX______,
  _______X,XX______,
  _______X,XX______,
  _______X,XX______,
  _______X,XX______,
  _______X,XX______,
  _______X,XX______,
  _______X,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXXX___X,XX______,
  _XXXXXXX,XX______,
  _XXXXXXX,X_______,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_004B[ 48] = { /* code 004B */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXX___,__XXXX__,
  __XXX___,_XXXX___,
  __XXX___,XXXX____,
  __XXX___,XXX_____,
  __XXX__X,XX______,
  __XXX_XX,X_______,
  __XXXXXX,XX______,
  __XXXXXX,XX______,
  __XXXXX_,XXX_____,
  __XXXX__,XXX_____,
  __XXX___,_XXX____,
  __XXX___,__XXX___,
  __XXX___,__XXX___,
  __XXX___,___XXX__,
  __XXX___,___XXX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_004C[ 48] = { /* code 004C */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  __XXXXXX,XXXX____,
  __XXXXXX,XXXX____,
  __XXXXXX,XXXX____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_004D[ 72] = { /* code 004D */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _XXXXX__,___XXXXX,________,
  _XXXXXX_,__XXXXXX,________,
  _XXXXXX_,__XXXXXX,________,
  _XXX_XX_,__XX_XXX,________,
  _XXX_XX_,__XX_XXX,________,
  _XXX_XX_,__XX_XXX,________,
  _XXX_XXX,_XXX_XXX,________,
  _XXX_XXX,_XXX_XXX,________,
  _XXX__XX,_XX__XXX,________,
  _XXX__XX,_XX__XXX,________,
  _XXX__XX,XXX__XXX,________,
  _XXX__XX,XXX__XXX,________,
  _XXX__XX,XXX__XXX,________,
  _XXX___X,XX___XXX,________,
  _XXX___X,XX___XXX,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_004E[ 48] = { /* code 004E */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX____,__XXX___,
  _XXXX___,__XXX___,
  _XXXX___,__XXX___,
  _XXXXX__,__XXX___,
  _XXXXXX_,__XXX___,
  _XXX_XX_,__XXX___,
  _XXX_XXX,__XXX___,
  _XXX__XX,__XXX___,
  _XXX__XX,X_XXX___,
  _XXX___X,X_XXX___,
  _XXX___X,XXXXX___,
  _XXX____,XXXXX___,
  _XXX____,XXXXX___,
  _XXX____,_XXXX___,
  _XXX____,__XXX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_004F[ 48] = { /* code 004F */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XXX_____,
  ___XXXXX,XXXXX___,
  __XXXXXX,XXXXXX__,
  __XXXX__,__XXXX__,
  _XXXX___,___XXXX_,
  _XXX____,____XXX_,
  _XXX____,____XXX_,
  _XXX____,____XXX_,
  _XXX____,____XXX_,
  _XXX____,____XXX_,
  _XXXX___,___XXXX_,
  __XXXX__,__XXXX__,
  __XXXXXX,XXXXXX__,
  ___XXXXX,XXXXX___,
  _____XXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0050[ 48] = { /* code 0050 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,XXX_____,
  __XXXXXX,XXXX____,
  __XXXXXX,XXXXX___,
  __XXX___,_XXXX___,
  __XXX___,__XXX___,
  __XXX___,_XXXX___,
  __XXXXXX,XXXXX___,
  __XXXXXX,XXXX____,
  __XXXXXX,XXX_____,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  __XXX___,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0051[ 48] = { /* code 0051 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XXX_____,
  ___XXXXX,XXXXX___,
  __XXXXXX,XXXXXX__,
  __XXXX__,__XXXX__,
  _XXXX___,___XXXX_,
  _XXX____,____XXX_,
  _XXX____,____XXX_,
  _XXX____,____XXX_,
  _XXX____,____XXX_,
  _XXX____,X___XXX_,
  _XXXX__X,XX_XXXX_,
  __XXXX__,XXXXXX__,
  __XXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXX_,
  _____XXX,XXX_XXXX,
  ________,_____XX_,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0052[ 48] = { /* code 0052 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,XXX_____,
  __XXXXXX,XXXX____,
  __XXXXXX,XXXXX___,
  __XXX___,__XXX___,
  __XXX___,__XXX___,
  __XXX___,__XXX___,
  __XXXXXX,XXXXX___,
  __XXXXXX,XXXX____,
  __XXXXXX,XX______,
  __XXX___,XXX_____,
  __XXX___,XXXX____,
  __XXX___,_XXX____,
  __XXX___,__XXX___,
  __XXX___,__XXX___,
  __XXX___,___XXX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0053[ 48] = { /* code 0053 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XXXX____,
  __XXXXXX,XXXX____,
  __XXX___,_XXXX___,
  __XXX___,__XXX___,
  __XXXX__,________,
  ___XXXXX,X_______,
  ____XXXX,XXXX____,
  ______XX,XXXX____,
  ________,_XXXX___,
  _XXX____,__XXX___,
  _XXXX___,_XXXX___,
  __XXXXXX,XXXXX___,
  __XXXXXX,XXXX____,
  ____XXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0054[ 48] = { /* code 0054 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXXX____,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0055[ 48] = { /* code 0055 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXXX___,_XXXX___,
  __XXXXXX,XXXX____,
  __XXXXXX,XXXX____,
  ____XXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0056[ 48] = { /* code 0056 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XXX_____,__XXX___,
  XXX_____,_XXXX___,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  ___XXX_X,XX______,
  ___XXX_X,XX______,
  ___XXX_X,XX______,
  ____XXXX,X_______,
  ____XXXX,X_______,
  ____XXXX,X_______,
  _____XXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0057[ 72] = { /* code 0057 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  XXX_____,_XXX____,__XXX___,
  XXX_____,XXXXX___,__XXX___,
  _XXX____,XXXXX___,_XXX____,
  _XXX____,XXXXX___,_XXX____,
  _XXX___X,XX_XXX__,_XXX____,
  _XXX___X,XX_XXX__,_XXX____,
  __XXX__X,XX_XXX__,XXX_____,
  __XXX_XX,X___XXX_,XXX_____,
  __XXX_XX,X___XXX_,XXX_____,
  __XXX_XX,X___XXX_,XXX_____,
  ___XXXXX,_____XXX,XXX_____,
  ___XXXXX,_____XXX,XX______,
  ___XXXXX,_____XXX,XX______,
  ___XXXX_,______XX,XX______,
  ___XXXX_,______XX,XX______,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0058[ 48] = { /* code 0058 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  __XXX___,_XXX____,
  ___XXX__,XXX_____,
  ___XXX__,XXX_____,
  ____XXXX,XX______,
  _____XXX,X_______,
  _____XXX,X_______,
  _____XXX,X_______,
  ____XXXX,XX______,
  ___XXX__,XXX_____,
  ___XXX__,XXX_____,
  __XXX___,_XXX____,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0059[ 48] = { /* code 0059 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XXX_____,__XXX___,
  XXX_____,__XXX___,
  _XXX____,_XXX____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  ___XXX_X,XX______,
  ____XXXX,X_______,
  ____XXXX,X_______,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_005A[ 48] = { /* code 005A */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXXX____,
  ________,XXXX____,
  _______X,XXX_____,
  ______XX,XX______,
  _____XXX,X_______,
  ____XXXX,________,
  ___XXXX_,________,
  __XXXX__,________,
  _XXXX___,________,
  XXXX____,________,
  XXXXXXXX,XXXX____,
  XXXXXXXX,XXXX____,
  XXXXXXXX,XXXX____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_005B[ 24] = { /* code 005B */
  ________,
  ________,
  ________,
  ________,
  __XXXXX_,
  __XXXXX_,
  __XXXXX_,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXXXX_,
  __XXXXX_,
  __XXXXX_,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_005C[ 24] = { /* code 005C */
  ________,
  ________,
  ________,
  ________,
  XX______,
  XX______,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  __XX____,
  __XX____,
  __XX____,
  __XXX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ____XX__,
  ____XX__,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_005D[ 24] = { /* code 005D */
  ________,
  ________,
  ________,
  ________,
  XXXXX___,
  XXXXX___,
  XXXXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  XXXXX___,
  XXXXX___,
  XXXXX___,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_005E[ 48] = { /* code 005E */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XX_,________,
  ____XXXX,________,
  ____XXXX,________,
  ___XXXXX,X_______,
  ___XX__X,X_______,
  __XXX__X,XX______,
  __XXX__X,XX______,
  _XXX____,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_005F[ 48] = { /* code 005F */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XXXXXXXX,XXXX____,
  XXXXXXXX,XXXX____,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0060[ 24] = { /* code 0060 */
  ________,
  ________,
  ________,
  ________,
  XXX_____,
  _XX_____,
  __XX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0061[ 48] = { /* code 0061 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXXX,X_______,
  __XXXXXX,XX______,
  _XX_____,XXX_____,
  ______XX,XXX_____,
  ___XXXXX,XXX_____,
  __XXXX__,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX___X,XXX_____,
  __XXXXXX,XXX_____,
  ___XXXX_,_XXX____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0062[ 48] = { /* code 0062 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX_XXX,X_______,
  _XXXXXXX,XXX_____,
  _XXXX___,XXX_____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXXX___,XXX_____,
  _XXXXXXX,XXX_____,
  _XXX_XXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0063[ 48] = { /* code 0063 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,________,
  __XXXXXX,XX______,
  __XXX__X,XX______,
  _XXX____,XXX_____,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,XXX_____,
  __XXX__X,XX______,
  __XXXXXX,XX______,
  ____XXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0064[ 48] = { /* code 0064 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,_XXX____,
  ________,_XXX____,
  ________,_XXX____,
  ________,_XXX____,
  ____XXXX,_XXX____,
  __XXXXXX,XXXX____,
  __XXX___,XXXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  __XXX___,XXXX____,
  __XXXXXX,XXXX____,
  ____XXXX,_XXX____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0065[ 48] = { /* code 0065 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,________,
  __XXXXXX,XX______,
  __XXX__X,XX______,
  _XXX____,XXX_____,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  _XXX____,________,
  _XXX____,XXX_____,
  __XXX__X,XX______,
  __XXXXXX,XX______,
  ____XXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0066[ 24] = { /* code 0066 */
  ________,
  ________,
  ________,
  ________,
  ___XXXX_,
  __XXXXX_,
  __XXX___,
  __XXX___,
  XXXXXXX_,
  XXXXXXX_,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0067[ 48] = { /* code 0067 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,_XXX____,
  __XXXXXX,XXXX____,
  __XXX___,XXXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  __XXX___,XXXX____,
  __XXXXXX,XXXX____,
  ___XXXXX,_XXX____,
  ________,_XXX____,
  _XXX____,XXXX____,
  _XXXXXXX,XXX_____,
  ___XXXXX,XX______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0068[ 48] = { /* code 0068 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX__XX,XX______,
  _XXXXXXX,XXX_____,
  _XXXX___,XXXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0069[ 24] = { /* code 0069 */
  ________,
  ________,
  ________,
  ________,
  _XXX____,
  _XXX____,
  ________,
  ________,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_006A[ 24] = { /* code 006A */
  ________,
  ________,
  ________,
  ________,
  _XXX____,
  _XXX____,
  ________,
  ________,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  XXXX____,
  XXX_____,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_006B[ 48] = { /* code 006B */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,XXX_____,
  _XXX___X,XX______,
  _XXX__XX,X_______,
  _XXXXXXX,________,
  _XXXXXXX,________,
  _XXXXXXX,________,
  _XXXX_XX,X_______,
  _XXX___X,X_______,
  _XXX___X,XX______,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_006C[ 24] = { /* code 006C */
  ________,
  ________,
  ________,
  ________,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_006D[ 72] = { /* code 006D */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _XXX_XXX,XX__XXXX,________,
  _XXXXXXX,XXXXXXXX,X_______,
  _XXXX___,XXXX___X,XX______,
  _XXX____,XXX____X,XX______,
  _XXX____,XXX____X,XX______,
  _XXX____,XXX____X,XX______,
  _XXX____,XXX____X,XX______,
  _XXX____,XXX____X,XX______,
  _XXX____,XXX____X,XX______,
  _XXX____,XXX____X,XX______,
  _XXX____,XXX____X,XX______,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_006E[ 48] = { /* code 006E */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX__XX,XX______,
  _XXXXXXX,XXX_____,
  _XXXX___,XXXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_006F[ 48] = { /* code 006F */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,X_______,
  __XXXXXX,XXX_____,
  __XXX___,XXX_____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  __XXX___,XXX_____,
  __XXXXXX,XXX_____,
  ____XXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0070[ 48] = { /* code 0070 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX_XXX,X_______,
  _XXXXXXX,XXX_____,
  _XXXX___,XXX_____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXXX___,XXX_____,
  _XXXXXXX,XXX_____,
  _XXX_XXX,X_______,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0071[ 48] = { /* code 0071 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,_XXX____,
  __XXXXXX,XXXX____,
  __XXX___,XXXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  __XXX___,XXXX____,
  __XXXXXX,XXXX____,
  ____XXXX,_XXX____,
  ________,_XXX____,
  ________,_XXX____,
  ________,_XXX____,
  ________,_XXX____,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0072[ 24] = { /* code 0072 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XXX_XXX,
  _XXXXXXX,
  _XXXX___,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0073[ 48] = { /* code 0073 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXXX,X_______,
  __XXXXXX,XX______,
  _XXX____,XXX_____,
  _XXX____,________,
  _XXXXXX_,________,
  __XXXXXX,XX______,
  _____XXX,XXX_____,
  ________,XXX_____,
  _XXX____,XXX_____,
  __XXXXXX,XX______,
  ___XXXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0074[ 24] = { /* code 0074 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ___X____,
  __XX____,
  _XXX____,
  XXXXXX__,
  XXXXXX__,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXXXX__,
  __XXXX__,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0075[ 48] = { /* code 0075 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXXX___,XXXX____,
  __XXXXXX,XXXX____,
  ___XXXXX,_XXX____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0076[ 48] = { /* code 0076 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  ___XXX_X,XX______,
  ___XXX_X,XX______,
  ____XXXX,X_______,
  ____XXXX,X_______,
  _____XXX,________,
  _____XXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0077[ 48] = { /* code 0077 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XXX___XX,X___XXX_,
  XXX___XX,X___XXX_,
  _XX___XX,X___XX__,
  _XXX_XXX,XX_XXX__,
  _XXX_XX_,XX_XXX__,
  __XX_XX_,XX_XX___,
  __XX_XX_,XX_XX___,
  __XXXXX_,XXXXX___,
  __XXXX__,_XXXX___,
  ___XXX__,_XXX____,
  ___XXX__,_XXX____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0078[ 48] = { /* code 0078 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX____,XXX_____,
  __XXX__X,XX______,
  __XXX__X,XX______,
  ___XXXXX,X_______,
  ____XXXX,________,
  ____XXXX,________,
  ____XXXX,________,
  ___XXXXX,X_______,
  __XXX__X,XX______,
  __XXX__X,XX______,
  _XXX____,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_0079[ 48] = { /* code 0079 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XXX_____,XXX_____,
  XXX_____,XXX_____,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,X_______,
  __XXX_XX,X_______,
  __XXX_XX,X_______,
  ___XX_XX,________,
  ___XXXXX,________,
  ___XXXXX,________,
  ____XXX_,________,
  ____XXX_,________,
  ___XXX__,________,
  _XXXXX__,________,
  _XXXX___,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_007A[ 48] = { /* code 007A */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XX______,
  _XXXXXXX,XX______,
  _______X,XX______,
  ______XX,X_______,
  _____XXX,________,
  ____XXX_,________,
  ___XXX__,________,
  __XXX___,________,
  _XXX____,________,
  _XXXXXXX,XX______,
  _XXXXXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_007B[ 24] = { /* code 007B */
  ________,
  ________,
  ________,
  ________,
  _____XXX,
  ____XXXX,
  ___XXXXX,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  __XXXX__,
  _XXXX___,
  _XXXX___,
  __XXXX__,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ___XXXXX,
  ___XXXXX,
  ____XXXX,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_007C[ 24] = { /* code 007C */
  ________,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_007D[ 24] = { /* code 007D */
  ________,
  ________,
  ________,
  ________,
  XXX_____,
  XXXX____,
  XXXXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXXX__,
  ___XXXX_,
  ___XXXX_,
  __XXXX__,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  XXXXX___,
  XXXXX___,
  XXXX____,
  ________};

GUI_CONST_STORAGE unsigned char acFont24B_ASCII_007E[ 48] = { /* code 007E */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXX__,__X_____,
  XXXXXXXX,XXX_____,
  XXXXXXXX,XXX_____,
  X____XXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE GUI_CHARINFO GUI_Font24B_ASCII_CharInfo[95] = {
   {   6,   6,  1, acFont24B_ASCII_0020 } /* code 0020 */
  ,{   7,   7,  1, acFont24B_ASCII_0021 } /* code 0021 */
  ,{  10,  10,  2, acFont24B_ASCII_0022 } /* code 0022 */
  ,{  12,  12,  2, acFont24B_ASCII_0023 } /* code 0023 */
  ,{  12,  12,  2, acFont24B_ASCII_0024 } /* code 0024 */
  ,{  17,  17,  3, acFont24B_ASCII_0025 } /* code 0025 */
  ,{  15,  15,  2, acFont24B_ASCII_0026 } /* code 0026 */
  ,{   5,   5,  1, acFont24B_ASCII_0027 } /* code 0027 */
  ,{   7,   7,  1, acFont24B_ASCII_0028 } /* code 0028 */
  ,{   7,   7,  1, acFont24B_ASCII_0029 } /* code 0029 */
  ,{   8,   8,  1, acFont24B_ASCII_002A } /* code 002A */
  ,{  12,  12,  2, acFont24B_ASCII_002B } /* code 002B */
  ,{   6,   6,  1, acFont24B_ASCII_002C } /* code 002C */
  ,{   7,   7,  1, acFont24B_ASCII_002D } /* code 002D */
  ,{   6,   6,  1, acFont24B_ASCII_002E } /* code 002E */
  ,{   6,   6,  1, acFont24B_ASCII_002F } /* code 002F */
  ,{  12,  12,  2, acFont24B_ASCII_0030 } /* code 0030 */
  ,{  12,  12,  2, acFont24B_ASCII_0031 } /* code 0031 */
  ,{  12,  12,  2, acFont24B_ASCII_0032 } /* code 0032 */
  ,{  12,  12,  2, acFont24B_ASCII_0033 } /* code 0033 */
  ,{  12,  12,  2, acFont24B_ASCII_0034 } /* code 0034 */
  ,{  12,  12,  2, acFont24B_ASCII_0035 } /* code 0035 */
  ,{  12,  12,  2, acFont24B_ASCII_0036 } /* code 0036 */
  ,{  12,  12,  2, acFont24B_ASCII_0037 } /* code 0037 */
  ,{  12,  12,  2, acFont24B_ASCII_0038 } /* code 0038 */
  ,{  12,  12,  2, acFont24B_ASCII_0039 } /* code 0039 */
  ,{   7,   7,  1, acFont24B_ASCII_003A } /* code 003A */
  ,{   7,   7,  1, acFont24B_ASCII_003B } /* code 003B */
  ,{  12,  12,  2, acFont24B_ASCII_003C } /* code 003C */
  ,{  12,  12,  2, acFont24B_ASCII_003D } /* code 003D */
  ,{  12,  12,  2, acFont24B_ASCII_003E } /* code 003E */
  ,{  13,  13,  2, acFont24B_ASCII_003F } /* code 003F */
  ,{  20,  20,  3, acFont24B_ASCII_0040 } /* code 0040 */
  ,{  15,  15,  2, acFont24B_ASCII_0041 } /* code 0041 */
  ,{  15,  15,  2, acFont24B_ASCII_0042 } /* code 0042 */
  ,{  15,  15,  2, acFont24B_ASCII_0043 } /* code 0043 */
  ,{  15,  15,  2, acFont24B_ASCII_0044 } /* code 0044 */
  ,{  14,  14,  2, acFont24B_ASCII_0045 } /* code 0045 */
  ,{  13,  13,  2, acFont24B_ASCII_0046 } /* code 0046 */
  ,{  16,  16,  2, acFont24B_ASCII_0047 } /* code 0047 */
  ,{  14,  14,  2, acFont24B_ASCII_0048 } /* code 0048 */
  ,{   5,   5,  1, acFont24B_ASCII_0049 } /* code 0049 */
  ,{  12,  12,  2, acFont24B_ASCII_004A } /* code 004A */
  ,{  15,  15,  2, acFont24B_ASCII_004B } /* code 004B */
  ,{  13,  13,  2, acFont24B_ASCII_004C } /* code 004C */
  ,{  17,  17,  3, acFont24B_ASCII_004D } /* code 004D */
  ,{  14,  14,  2, acFont24B_ASCII_004E } /* code 004E */
  ,{  16,  16,  2, acFont24B_ASCII_004F } /* code 004F */
  ,{  14,  14,  2, acFont24B_ASCII_0050 } /* code 0050 */
  ,{  16,  16,  2, acFont24B_ASCII_0051 } /* code 0051 */
  ,{  15,  15,  2, acFont24B_ASCII_0052 } /* code 0052 */
  ,{  14,  14,  2, acFont24B_ASCII_0053 } /* code 0053 */
  ,{  13,  13,  2, acFont24B_ASCII_0054 } /* code 0054 */
  ,{  14,  14,  2, acFont24B_ASCII_0055 } /* code 0055 */
  ,{  13,  13,  2, acFont24B_ASCII_0056 } /* code 0056 */
  ,{  21,  21,  3, acFont24B_ASCII_0057 } /* code 0057 */
  ,{  14,  14,  2, acFont24B_ASCII_0058 } /* code 0058 */
  ,{  13,  13,  2, acFont24B_ASCII_0059 } /* code 0059 */
  ,{  12,  12,  2, acFont24B_ASCII_005A } /* code 005A */
  ,{   7,   7,  1, acFont24B_ASCII_005B } /* code 005B */
  ,{   6,   6,  1, acFont24B_ASCII_005C } /* code 005C */
  ,{   7,   7,  1, acFont24B_ASCII_005D } /* code 005D */
  ,{  12,  12,  2, acFont24B_ASCII_005E } /* code 005E */
  ,{  12,  12,  2, acFont24B_ASCII_005F } /* code 005F */
  ,{   7,   7,  1, acFont24B_ASCII_0060 } /* code 0060 */
  ,{  12,  12,  2, acFont24B_ASCII_0061 } /* code 0061 */
  ,{  13,  13,  2, acFont24B_ASCII_0062 } /* code 0062 */
  ,{  12,  12,  2, acFont24B_ASCII_0063 } /* code 0063 */
  ,{  13,  13,  2, acFont24B_ASCII_0064 } /* code 0064 */
  ,{  12,  12,  2, acFont24B_ASCII_0065 } /* code 0065 */
  ,{   7,   7,  1, acFont24B_ASCII_0066 } /* code 0066 */
  ,{  13,  13,  2, acFont24B_ASCII_0067 } /* code 0067 */
  ,{  13,  13,  2, acFont24B_ASCII_0068 } /* code 0068 */
  ,{   5,   5,  1, acFont24B_ASCII_0069 } /* code 0069 */
  ,{   5,   5,  1, acFont24B_ASCII_006A } /* code 006A */
  ,{  12,  12,  2, acFont24B_ASCII_006B } /* code 006B */
  ,{   5,   5,  1, acFont24B_ASCII_006C } /* code 006C */
  ,{  19,  19,  3, acFont24B_ASCII_006D } /* code 006D */
  ,{  13,  13,  2, acFont24B_ASCII_006E } /* code 006E */
  ,{  13,  13,  2, acFont24B_ASCII_006F } /* code 006F */
  ,{  13,  13,  2, acFont24B_ASCII_0070 } /* code 0070 */
  ,{  13,  13,  2, acFont24B_ASCII_0071 } /* code 0071 */
  ,{   8,   8,  1, acFont24B_ASCII_0072 } /* code 0072 */
  ,{  12,  12,  2, acFont24B_ASCII_0073 } /* code 0073 */
  ,{   7,   7,  1, acFont24B_ASCII_0074 } /* code 0074 */
  ,{  13,  13,  2, acFont24B_ASCII_0075 } /* code 0075 */
  ,{  13,  13,  2, acFont24B_ASCII_0076 } /* code 0076 */
  ,{  15,  15,  2, acFont24B_ASCII_0077 } /* code 0077 */
  ,{  12,  12,  2, acFont24B_ASCII_0078 } /* code 0078 */
  ,{  11,  11,  2, acFont24B_ASCII_0079 } /* code 0079 */
  ,{  11,  11,  2, acFont24B_ASCII_007A } /* code 007A */
  ,{   8,   8,  1, acFont24B_ASCII_007B } /* code 007B */
  ,{   6,   6,  1, acFont24B_ASCII_007C } /* code 007C */
  ,{   8,   8,  1, acFont24B_ASCII_007D } /* code 007D */
  ,{  12,  12,  2, acFont24B_ASCII_007E } /* code 007E */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_Font24B_ASCII_Prop1 = {
   0x0020                         /* first character */
  ,0x007E                         /* last character  */
  ,&GUI_Font24B_ASCII_CharInfo[0] /* address of first character */
  ,(const GUI_FONT_PROP*)0        /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_Font24B_ASCII = {
   GUI_FONTTYPE_PROP        /* type of font    */
  ,24                       /* height of font  */
  ,24                       /* space of font y */
  ,1                        /* magnification x */
  ,1                        /* magnification y */
  ,{&GUI_Font24B_ASCII_Prop1}
  ,19, 11, 15
};

