/*
*********************************************************************************************************
*                                                uC/GUI
*                        Universal graphic software for embedded applications
*
*                       (c) Copyright 2002, Micrium Inc., Weston, FL
*                       (c) Copyright 2002, SEGGER Microcontroller Systeme GmbH
*
*              C/GUI is protected by international copyright laws. Knowledge of the
*              source code may not be used to write a similar product. This file may
*              only be used in accordance with a license and should not be redistributed
*              in any way. We appreciate your understanding and fairness.
*
----------------------------------------------------------------------
File        : F8x13.C
Purpose     : Monospaced Font similar to courier
Height      : 13
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI_FontIntern.h"

GUI_CONST_STORAGE unsigned char acF8x13_1_160[13] = { /* code 160 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_161[13] = { /* code 161 */
  ________,
  ________,
  ____X___,
  ________,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_162[13] = { /* code 162 */
  ________,
  ________,
  ________,
  ________,
  ____X___,
  ___XXX__,
  __X___X_,
  __X_____,
  __X___X_,
  ___XXX__,
  ____X___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_163[13] = { /* code 163 */
  ________,
  ________,
  ________,
  ___XX___,
  __X__X__,
  __X_____,
  ___X____,
  __XXXX__,
  ___X____,
  ___X____,
  __XXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_164[13] = { /* code 164 */
  ________,
  ________,
  _X_____X,
  __XXXXX_,
  __X___X_,
  __X___X_,
  __X___X_,
  __XXXXX_,
  _X_____X,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_165[13] = { /* code 165 */
  ________,
  ________,
  ________,
  _XXX_XXX,
  __X___X_,
  _XXXXXXX,
  ___X_X__,
  _XXXXXXX,
  ____X___,
  ____X___,
  ___XXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_166[13] = { /* code 166 */
  ________,
  ________,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  ________,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  ____X___};

GUI_CONST_STORAGE unsigned char acF8x13_1_167[13] = { /* code 167 */
  ________,
  ________,
  ___XXXX_,
  __X___X_,
  _X_X____,
  _X__X___,
  __X__X__,
  ___X__X_,
  ____X_X_,
  _X___X__,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_168[13] = { /* code 168 */
  ________,
  ________,
  __X___X_,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_169[13] = { /* code 169 */
  ________,
  ________,
  ___XXX__,
  __X___X_,
  _X__XX_X,
  _X_X___X,
  _X_X___X,
  _X__XX_X,
  __X___X_,
  ___XXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_170[13] = { /* code 170 */
  ________,
  ________,
  ___XX___,
  _____X__,
  ___XXX__,
  __X__X__,
  ___XXX__,
  ________,
  __XXXX__,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_171[13] = { /* code 171 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ___X___X,
  __X___X_,
  _X___X__,
  __X___X_,
  ___X___X,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_172[13] = { /* code 172 */
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXXXX_,
  ______X_,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_173[13] = { /* code 173 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XXXXXXX,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_174[13] = { /* code 174 */
  ________,
  ________,
  ___XXX__,
  __X___X_,
  _X_XX__X,
  _X_X_X_X,
  _X_XX__X,
  _X_X_X_X,
  __X___X_,
  ___XXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_175[13] = { /* code 175 */
  ________,
  XXXXXXXX,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_176[13] = { /* code 176 */
  ________,
  ________,
  ____X___,
  ___X_X__,
  ____X___,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_177[13] = { /* code 177 */
  ________,
  ________,
  ____X___,
  ____X___,
  ____X___,
  _XXXXXXX,
  ____X___,
  ____X___,
  ____X___,
  ________,
  _XXXXXXX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_178[13] = { /* code 178 */
  ________,
  ________,
  ____X___,
  ___X_X__,
  _____X__,
  ____X___,
  ___XXX__,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_179[13] = { /* code 179 */
  ________,
  ________,
  ___XX___,
  _____X__,
  ____X___,
  _____X__,
  ___XX___,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_180[13] = { /* code 180 */
  ________,
  ________,
  _____X__,
  ____X___,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_181[13] = { /* code 181 */
  ________,
  ________,
  ________,
  ________,
  ________,
  __X___X_,
  __X___X_,
  __X___X_,
  __X___X_,
  __X___X_,
  __XXXX__,
  __X_____,
  _X______};

GUI_CONST_STORAGE unsigned char acF8x13_1_182[13] = { /* code 182 */
  ________,
  ________,
  __XXXXXX,
  _XXXX_X_,
  _XXXX_X_,
  _XXXX_X_,
  __XXX_X_,
  ____X_X_,
  ____X_X_,
  ____X_X_,
  ___XX_XX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_183[13] = { /* code 183 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ____X___,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_184[13] = { /* code 184 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ____X___,
  _____X__,
  ___XX___};

GUI_CONST_STORAGE unsigned char acF8x13_1_185[13] = { /* code 185 */
  ________,
  ________,
  ___XX___,
  ____X___,
  ____X___,
  ____X___,
  ___XXX__,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_186[13] = { /* code 186 */
  ________,
  ________,
  ___XX___,
  __X__X__,
  __X__X__,
  __X__X__,
  ___XX___,
  ________,
  __XXXX__,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_187[13] = { /* code 187 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _X___X__,
  __X___X_,
  ___X___X,
  __X___X_,
  _X___X__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_188[13] = { /* code 188 */
  ________,
  ________,
  _XX_____,
  __X____X,
  __X___X_,
  __X__X__,
  _XXXX__X,
  ___X__XX,
  __X__X_X,
  _X__XXXX,
  _______X,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_189[13] = { /* code 189 */
  ________,
  ________,
  _XX_____,
  __X____X,
  __X___X_,
  __X__X__,
  _XXXX_X_,
  ___X_X_X,
  __X____X,
  _X____X_,
  _____XXX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_190[13] = { /* code 190 */
  ________,
  ________,
  _XX_____,
  ___X___X,
  __X___X_,
  ___X_X__,
  _XX_X__X,
  ___X__XX,
  __X__X_X,
  _X__XXXX,
  _______X,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_191[13] = { /* code 191 */
  ________,
  ________,
  ____X___,
  ________,
  ____X___,
  ____X___,
  ___X____,
  __X_____,
  __X_____,
  __X___X_,
  ___XXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_192[13] = { /* code 192 */
  ___X____,
  ____X___,
  ___XX___,
  ____X___,
  ____X___,
  ___X_X__,
  ___X_X__,
  __X___X_,
  __XXXXX_,
  __X___X_,
  _XXX_XXX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_193[13] = { /* code 193 */
  _____X__,
  ____X___,
  ___XX___,
  ____X___,
  ____X___,
  ___X_X__,
  ___X_X__,
  __X___X_,
  __XXXXX_,
  __X___X_,
  _XXX_XXX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_194[13] = { /* code 194 */
  ____X___,
  ___X_X__,
  ___XX___,
  ____X___,
  ____X___,
  ___X_X__,
  ___X_X__,
  __X___X_,
  __XXXXX_,
  __X___X_,
  _XXX_XXX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_195[13] = { /* code 195 */
  __XXX__X,
  _X__XXX_,
  ___XX___,
  ____X___,
  ____X___,
  ___X_X__,
  ___X_X__,
  __X___X_,
  __XXXXX_,
  __X___X_,
  _XXX_XXX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_196[13] = { /* code 196 */
  __X___X_,
  ________,
  ___XX___,
  ____X___,
  ____X___,
  ___X_X__,
  ___X_X__,
  __X___X_,
  __XXXXX_,
  __X___X_,
  _XXX_XXX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_197[13] = { /* code 197 */
  ____X___,
  ___X_X__,
  ____X___,
  ____X___,
  ____X___,
  ___X_X__,
  ___X_X__,
  __X___X_,
  __XXXXX_,
  __X___X_,
  _XXX_XXX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_198[13] = { /* code 198 */
  ________,
  ________,
  __XXXXXX,
  ___XX__X,
  ___XX___,
  __X_X_X_,
  __X_XXX_,
  __X_X_X_,
  _XXXX___,
  _X__X__X,
  _X__XXXX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_199[13] = { /* code 199 */
  ________,
  ________,
  ________,
  ___XXXX_,
  __X____X,
  _X______,
  _X______,
  _X______,
  _X______,
  __X____X,
  ___XXXX_,
  _____X__,
  ____XX__};

GUI_CONST_STORAGE unsigned char acF8x13_1_200[13] = { /* code 200 */
  ___X____,
  ____X___,
  _XXXXXXX,
  __X____X,
  __X_____,
  __X__X__,
  __XXXX__,
  __X__X__,
  __X_____,
  __X____X,
  _XXXXXXX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_201[13] = { /* code 201 */
  _____X__,
  ____X___,
  _XXXXXXX,
  __X____X,
  __X_____,
  __X__X__,
  __XXXX__,
  __X__X__,
  __X_____,
  __X____X,
  _XXXXXXX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_202[13] = { /* code 202 */
  ____X___,
  ___X_X__,
  _XXXXXXX,
  __X____X,
  __X_____,
  __X__X__,
  __XXXX__,
  __X__X__,
  __X_____,
  __X____X,
  _XXXXXXX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_203[13] = { /* code 203 */
  __X___X_,
  ________,
  _XXXXXXX,
  __X____X,
  __X_____,
  __X__X__,
  __XXXX__,
  __X__X__,
  __X_____,
  __X____X,
  _XXXXXXX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_204[13] = { /* code 204 */
  ___X____,
  ____X___,
  __XXXXX_,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  __XXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_205[13] = { /* code 205 */
  _____X__,
  ____X___,
  __XXXXX_,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  __XXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_206[13] = { /* code 206 */
  ____X___,
  ___X_X__,
  __XXXXX_,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  __XXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_207[13] = { /* code 207 */
  __X___X_,
  ________,
  __XXXXX_,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  __XXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_208[13] = { /* code 208 */
  ________,
  ________,
  _XXXXX__,
  __X___X_,
  __X____X,
  __X____X,
  _XXXX__X,
  __X____X,
  __X____X,
  __X___X_,
  _XXXXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_209[13] = { /* code 209 */
  __XXX__X,
  _X__XXX_,
  _XX__XXX,
  __X___X_,
  __XX__X_,
  __XX__X_,
  __X_X_X_,
  __X__XX_,
  __X__XX_,
  __X___X_,
  _XXX__X_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_210[13] = { /* code 210 */
  ___X____,
  ____X___,
  ___XXX__,
  __X___X_,
  _X_____X,
  _X_____X,
  _X_____X,
  _X_____X,
  _X_____X,
  __X___X_,
  ___XXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_211[13] = { /* code 211 */
  _____X__,
  ____X___,
  ___XXX__,
  __X___X_,
  _X_____X,
  _X_____X,
  _X_____X,
  _X_____X,
  _X_____X,
  __X___X_,
  ___XXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_212[13] = { /* code 212 */
  ____X___,
  ___X_X__,
  ___XXX__,
  __X___X_,
  _X_____X,
  _X_____X,
  _X_____X,
  _X_____X,
  _X_____X,
  __X___X_,
  ___XXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_213[13] = { /* code 213 */
  __XXX__X,
  _X__XXX_,
  ___XXX__,
  __X___X_,
  _X_____X,
  _X_____X,
  _X_____X,
  _X_____X,
  _X_____X,
  __X___X_,
  ___XXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_214[13] = { /* code 214 */
  __X___X_,
  ________,
  ___XXX__,
  __X___X_,
  _X_____X,
  _X_____X,
  _X_____X,
  _X_____X,
  _X_____X,
  __X___X_,
  ___XXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_215[13] = { /* code 215 */
  ________,
  ________,
  ________,
  ________,
  _X_____X,
  __X___X_,
  ___X_X__,
  ____X___,
  ___X_X__,
  __X___X_,
  _X_____X,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_216[13] = { /* code 216 */
  ________,
  ________,
  ___XXX_X,
  __X___X_,
  _X___X_X,
  _X___X_X,
  _X__X__X,
  _X_X___X,
  _X_X___X,
  __X___X_,
  _X_XXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_217[13] = { /* code 217 */
  ___X____,
  ____X___,
  _XXX_XXX,
  __X___X_,
  __X___X_,
  __X___X_,
  __X___X_,
  __X___X_,
  __X___X_,
  __X___X_,
  ___XXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_218[13] = { /* code 218 */
  _____X__,
  ____X___,
  _XXX_XXX,
  __X___X_,
  __X___X_,
  __X___X_,
  __X___X_,
  __X___X_,
  __X___X_,
  __X___X_,
  ___XXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_219[13] = { /* code 219 */
  ____X___,
  ___X_X__,
  _XXX_XXX,
  __X___X_,
  __X___X_,
  __X___X_,
  __X___X_,
  __X___X_,
  __X___X_,
  __X___X_,
  ___XXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_220[13] = { /* code 220 */
  __X___X_,
  ________,
  _XXX_XXX,
  __X___X_,
  __X___X_,
  __X___X_,
  __X___X_,
  __X___X_,
  __X___X_,
  __X___X_,
  ___XXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_221[13] = { /* code 221 */
  _____X__,
  ____X___,
  _XXX_XXX,
  __X___X_,
  __X___X_,
  ___X_X__,
  ___X_X__,
  ____X___,
  ____X___,
  ____X___,
  ___XXX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_222[13] = { /* code 222 */
  ________,
  ________,
  _XX_____,
  __X_____,
  __XXXXX_,
  __X____X,
  __X____X,
  __X____X,
  __XXXXX_,
  __X_____,
  _XXX____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_223[13] = { /* code 223 */
  ________,
  ________,
  ___XXX__,
  __X___X_,
  __X___X_,
  __X___X_,
  __X_XXX_,
  __X____X,
  __X____X,
  __X____X,
  _XX_XXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_224[13] = { /* code 224 */
  ________,
  ________,
  ___X____,
  ____X___,
  ________,
  __XXXX__,
  ______X_,
  __XXXXX_,
  _X____X_,
  _X____X_,
  __XXXX_X,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_225[13] = { /* code 225 */
  ________,
  ________,
  _____X__,
  ____X___,
  ________,
  __XXXX__,
  ______X_,
  __XXXXX_,
  _X____X_,
  _X____X_,
  __XXXX_X,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_226[13] = { /* code 226 */
  ________,
  ________,
  ____X___,
  ___X_X__,
  ________,
  __XXXX__,
  ______X_,
  __XXXXX_,
  _X____X_,
  _X____X_,
  __XXXX_X,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_227[13] = { /* code 227 */
  ________,
  ________,
  __XXX__X,
  _X__XXX_,
  ________,
  __XXXX__,
  ______X_,
  __XXXXX_,
  _X____X_,
  _X____X_,
  __XXXX_X,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_228[13] = { /* code 228 */
  ________,
  ________,
  __X___X_,
  ________,
  ________,
  __XXXX__,
  ______X_,
  __XXXXX_,
  _X____X_,
  _X____X_,
  __XXXX_X,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_229[13] = { /* code 229 */
  ________,
  ____X___,
  ___X_X__,
  ____X___,
  ________,
  __XXXX__,
  ______X_,
  __XXXXX_,
  _X____X_,
  _X____X_,
  __XXXX_X,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_230[13] = { /* code 230 */
  ________,
  ________,
  ________,
  ________,
  ________,
  __XX_XX_,
  ____X__X,
  __XXXXXX,
  _X__X___,
  _X__X__X,
  __XX_XX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_231[13] = { /* code 231 */
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXXXX_,
  _X_____X,
  _X______,
  _X______,
  _X_____X,
  __XXXXX_,
  _____X__,
  ____XX__};

GUI_CONST_STORAGE unsigned char acF8x13_1_232[13] = { /* code 232 */
  ________,
  ________,
  ___X____,
  ____X___,
  ________,
  __XXXXX_,
  _X_____X,
  _XXXXXXX,
  _X______,
  _X_____X,
  __XXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_233[13] = { /* code 233 */
  ________,
  ________,
  _____X__,
  ____X___,
  ________,
  __XXXXX_,
  _X_____X,
  _XXXXXXX,
  _X______,
  _X_____X,
  __XXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_234[13] = { /* code 234 */
  ________,
  ________,
  ____X___,
  ___X_X__,
  ________,
  __XXXXX_,
  _X_____X,
  _XXXXXXX,
  _X______,
  _X_____X,
  __XXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_235[13] = { /* code 235 */
  ________,
  ________,
  __X___X_,
  ________,
  ________,
  __XXXXX_,
  _X_____X,
  _XXXXXXX,
  _X______,
  _X_____X,
  __XXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_236[13] = { /* code 236 */
  ________,
  ________,
  ___X____,
  ____X___,
  ________,
  __XXX___,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  __XXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_237[13] = { /* code 237 */
  ________,
  ________,
  ____X___,
  ___X____,
  ________,
  __XXX___,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  __XXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_238[13] = { /* code 238 */
  ________,
  ________,
  ____X___,
  ___X_X__,
  ________,
  __XXX___,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  __XXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_239[13] = { /* code 239 */
  ________,
  ________,
  __X__X__,
  ________,
  ________,
  __XXX___,
  ____X___,
  ____X___,
  ____X___,
  ____X___,
  __XXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_240[13] = { /* code 240 */
  ________,
  ________,
  __XX_XX_,
  ____X___,
  __XX_X__,
  ______X_,
  __XXXXX_,
  _X_____X,
  _X_____X,
  _X_____X,
  __XXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_241[13] = { /* code 241 */
  ________,
  ________,
  __XXX__X,
  _X__XXX_,
  ________,
  _XX_XX__,
  __XX__X_,
  __X___X_,
  __X___X_,
  __X___X_,
  _XXX_XXX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_242[13] = { /* code 242 */
  ________,
  ________,
  ___X____,
  ____X___,
  ________,
  __XXXXX_,
  _X_____X,
  _X_____X,
  _X_____X,
  _X_____X,
  __XXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_243[13] = { /* code 243 */
  ________,
  ________,
  _____X__,
  ____X___,
  ________,
  __XXXXX_,
  _X_____X,
  _X_____X,
  _X_____X,
  _X_____X,
  __XXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_244[13] = { /* code 244 */
  ________,
  ________,
  ____X___,
  ___X_X__,
  ________,
  __XXXXX_,
  _X_____X,
  _X_____X,
  _X_____X,
  _X_____X,
  __XXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_245[13] = { /* code 245 */
  ________,
  ________,
  __XXX__X,
  _X__XXX_,
  ________,
  __XXXXX_,
  _X_____X,
  _X_____X,
  _X_____X,
  _X_____X,
  __XXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_246[13] = { /* code 246 */
  ________,
  ________,
  __X___X_,
  ________,
  ________,
  __XXXXX_,
  _X_____X,
  _X_____X,
  _X_____X,
  _X_____X,
  __XXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_247[13] = { /* code 247 */
  ________,
  ________,
  ________,
  ________,
  ____X___,
  ________,
  ________,
  _XXXXXXX,
  ________,
  ________,
  ____X___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_248[13] = { /* code 248 */
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXXXXX,
  _X____XX,
  _X__XX_X,
  _X_XX__X,
  _XX____X,
  _XXXXXX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_249[13] = { /* code 249 */
  ________,
  ________,
  ___X____,
  ____X___,
  ________,
  _XX__XX_,
  __X___X_,
  __X___X_,
  __X___X_,
  __X__XX_,
  ___XX_XX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_250[13] = { /* code 250 */
  ________,
  ________,
  _____X__,
  ____X___,
  ________,
  _XX__XX_,
  __X___X_,
  __X___X_,
  __X___X_,
  __X__XX_,
  ___XX_XX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_251[13] = { /* code 251 */
  ________,
  ________,
  ____X___,
  ___X_X__,
  ________,
  _XX__XX_,
  __X___X_,
  __X___X_,
  __X___X_,
  __X__XX_,
  ___XX_XX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_252[13] = { /* code 252 */
  ________,
  ________,
  __X___X_,
  ________,
  ________,
  _XX__XX_,
  __X___X_,
  __X___X_,
  __X___X_,
  __X__XX_,
  ___XX_XX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x13_1_253[13] = { /* code 253 */
  ________,
  ________,
  _____X__,
  ____X___,
  ________,
  _XXX_XXX,
  __X___X_,
  __X___X_,
  ___X_X__,
  ___X_X__,
  ____X___,
  ____X___,
  __XX____};

GUI_CONST_STORAGE unsigned char acF8x13_1_254[13] = { /* code 254 */
  ________,
  ________,
  _XX_____,
  __X_____,
  __X_____,
  __XXXXX_,
  __X____X,
  __X____X,
  __X____X,
  __X____X,
  __XXXXX_,
  __X_____,
  _XXX____};

GUI_CONST_STORAGE unsigned char acF8x13_1_255[13] = { /* code 255 */
  ________,
  ________,
  __X___X_,
  ________,
  ________,
  _XXX_XXX,
  __X___X_,
  __X___X_,
  ___X_X__,
  ___X_X__,
  ____X___,
  ____X___,
  __XX____};



GUI_CONST_STORAGE GUI_CHARINFO GUI_CharInfoF8x13_1[96] = {
   {   8,   8,  1, acF8x13_1_160 } /* code 160 */
  ,{   8,   8,  1, acF8x13_1_161 } /* code 161 */
  ,{   8,   8,  1, acF8x13_1_162 } /* code 162 */
  ,{   8,   8,  1, acF8x13_1_163 } /* code 163 */
  ,{   8,   8,  1, acF8x13_1_164 } /* code 164 */
  ,{   8,   8,  1, acF8x13_1_165 } /* code 165 */
  ,{   8,   8,  1, acF8x13_1_166 } /* code 166 */
  ,{   8,   8,  1, acF8x13_1_167 } /* code 167 */
  ,{   8,   8,  1, acF8x13_1_168 } /* code 168 */
  ,{   8,   8,  1, acF8x13_1_169 } /* code 169 */
  ,{   8,   8,  1, acF8x13_1_170 } /* code 170 */
  ,{   8,   8,  1, acF8x13_1_171 } /* code 171 */
  ,{   8,   8,  1, acF8x13_1_172 } /* code 172 */
  ,{   8,   8,  1, acF8x13_1_173 } /* code 173 */
  ,{   8,   8,  1, acF8x13_1_174 } /* code 174 */
  ,{   8,   8,  1, acF8x13_1_175 } /* code 175 */
  ,{   8,   8,  1, acF8x13_1_176 } /* code 176 */
  ,{   8,   8,  1, acF8x13_1_177 } /* code 177 */
  ,{   8,   8,  1, acF8x13_1_178 } /* code 178 */
  ,{   8,   8,  1, acF8x13_1_179 } /* code 179 */
  ,{   8,   8,  1, acF8x13_1_180 } /* code 180 */
  ,{   8,   8,  1, acF8x13_1_181 } /* code 181 */
  ,{   8,   8,  1, acF8x13_1_182 } /* code 182 */
  ,{   8,   8,  1, acF8x13_1_183 } /* code 183 */
  ,{   8,   8,  1, acF8x13_1_184 } /* code 184 */
  ,{   8,   8,  1, acF8x13_1_185 } /* code 185 */
  ,{   8,   8,  1, acF8x13_1_186 } /* code 186 */
  ,{   8,   8,  1, acF8x13_1_187 } /* code 187 */
  ,{   8,   8,  1, acF8x13_1_188 } /* code 188 */
  ,{   8,   8,  1, acF8x13_1_189 } /* code 189 */
  ,{   8,   8,  1, acF8x13_1_190 } /* code 190 */
  ,{   8,   8,  1, acF8x13_1_191 } /* code 191 */
  ,{   8,   8,  1, acF8x13_1_192 } /* code 192 */
  ,{   8,   8,  1, acF8x13_1_193 } /* code 193 */
  ,{   8,   8,  1, acF8x13_1_194 } /* code 194 */
  ,{   8,   8,  1, acF8x13_1_195 } /* code 195 */
  ,{   8,   8,  1, acF8x13_1_196 } /* code 196 */
  ,{   8,   8,  1, acF8x13_1_197 } /* code 197 */
  ,{   8,   8,  1, acF8x13_1_198 } /* code 198 */
  ,{   8,   8,  1, acF8x13_1_199 } /* code 199 */
  ,{   8,   8,  1, acF8x13_1_200 } /* code 200 */
  ,{   8,   8,  1, acF8x13_1_201 } /* code 201 */
  ,{   8,   8,  1, acF8x13_1_202 } /* code 202 */
  ,{   8,   8,  1, acF8x13_1_203 } /* code 203 */
  ,{   8,   8,  1, acF8x13_1_204 } /* code 204 */
  ,{   8,   8,  1, acF8x13_1_205 } /* code 205 */
  ,{   8,   8,  1, acF8x13_1_206 } /* code 206 */
  ,{   8,   8,  1, acF8x13_1_207 } /* code 207 */
  ,{   8,   8,  1, acF8x13_1_208 } /* code 208 */
  ,{   8,   8,  1, acF8x13_1_209 } /* code 209 */
  ,{   8,   8,  1, acF8x13_1_210 } /* code 210 */
  ,{   8,   8,  1, acF8x13_1_211 } /* code 211 */
  ,{   8,   8,  1, acF8x13_1_212 } /* code 212 */
  ,{   8,   8,  1, acF8x13_1_213 } /* code 213 */
  ,{   8,   8,  1, acF8x13_1_214 } /* code 214 */
  ,{   8,   8,  1, acF8x13_1_215 } /* code 215 */
  ,{   8,   8,  1, acF8x13_1_216 } /* code 216 */
  ,{   8,   8,  1, acF8x13_1_217 } /* code 217 */
  ,{   8,   8,  1, acF8x13_1_218 } /* code 218 */
  ,{   8,   8,  1, acF8x13_1_219 } /* code 219 */
  ,{   8,   8,  1, acF8x13_1_220 } /* code 220 */
  ,{   8,   8,  1, acF8x13_1_221 } /* code 221 */
  ,{   8,   8,  1, acF8x13_1_222 } /* code 222 */
  ,{   8,   8,  1, acF8x13_1_223 } /* code 223 */
  ,{   8,   8,  1, acF8x13_1_224 } /* code 224 */
  ,{   8,   8,  1, acF8x13_1_225 } /* code 225 */
  ,{   8,   8,  1, acF8x13_1_226 } /* code 226 */
  ,{   8,   8,  1, acF8x13_1_227 } /* code 227 */
  ,{   8,   8,  1, acF8x13_1_228 } /* code 228 */
  ,{   8,   8,  1, acF8x13_1_229 } /* code 229 */
  ,{   8,   8,  1, acF8x13_1_230 } /* code 230 */
  ,{   8,   8,  1, acF8x13_1_231 } /* code 231 */
  ,{   8,   8,  1, acF8x13_1_232 } /* code 232 */
  ,{   8,   8,  1, acF8x13_1_233 } /* code 233 */
  ,{   8,   8,  1, acF8x13_1_234 } /* code 234 */
  ,{   8,   8,  1, acF8x13_1_235 } /* code 235 */
  ,{   8,   8,  1, acF8x13_1_236 } /* code 236 */
  ,{   8,   8,  1, acF8x13_1_237 } /* code 237 */
  ,{   8,   8,  1, acF8x13_1_238 } /* code 238 */
  ,{   8,   8,  1, acF8x13_1_239 } /* code 239 */
  ,{   8,   8,  1, acF8x13_1_240 } /* code 240 */
  ,{   8,   8,  1, acF8x13_1_241 } /* code 241 */
  ,{   8,   8,  1, acF8x13_1_242 } /* code 242 */
  ,{   8,   8,  1, acF8x13_1_243 } /* code 243 */
  ,{   8,   8,  1, acF8x13_1_244 } /* code 244 */
  ,{   8,   8,  1, acF8x13_1_245 } /* code 245 */
  ,{   8,   8,  1, acF8x13_1_246 } /* code 246 */
  ,{   8,   8,  1, acF8x13_1_247 } /* code 247 */
  ,{   8,   8,  1, acF8x13_1_248 } /* code 248 */
  ,{   8,   8,  1, acF8x13_1_249 } /* code 249 */
  ,{   8,   8,  1, acF8x13_1_250 } /* code 250 */
  ,{   8,   8,  1, acF8x13_1_251 } /* code 251 */
  ,{   8,   8,  1, acF8x13_1_252 } /* code 252 */
  ,{   8,   8,  1, acF8x13_1_253 } /* code 253 */
  ,{   8,   8,  1, acF8x13_1_254 } /* code 254 */
  ,{   8,   8,  1, acF8x13_1_255 } /* code 255 */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontPropF8x13_1_2 = {
   160                      /* first character               */
  ,255                      /* last character                */
  ,&GUI_CharInfoF8x13_1[0]  /* address of first character    */
  ,(const GUI_FONT_PROP *)0 /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontPropF8x13_1_1 = {
   32                           /* first character               */
  ,127                          /* last character                */
  ,&GUI_CharInfoF8x13_ASCII[0]  /* address of first character    */
  ,&GUI_FontPropF8x13_1_2       /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_Font8x13_1 = {
   GUI_FONTTYPE_PROP  /* type of font    */
  ,13                 /* height of font  */
  ,13                 /* space of font y */
  ,1                  /* magnification x */
  ,1                  /* magnification y */
  ,{&GUI_FontPropF8x13_1_1}
  , 11, 6, 9
};

