/*
*********************************************************************************************************
*                                                uC/GUI
*                        Universal graphic software for embedded applications
*
*                       (c) Copyright 2002, Micrium Inc., Weston, FL
*                       (c) Copyright 2002, SEGGER Microcontroller Systeme GmbH
*
*              C/GUI is protected by international copyright laws. Knowledge of the
*              source code may not be used to write a similar product. This file may
*              only be used in accordance with a license and should not be redistributed
*              in any way. We appreciate your understanding and fairness.
*
----------------------------------------------------------------------
File        : F8x15B.C
Purpose     : Monospaced Bold Font similar to the fixed system font
Height      : 15
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI_FontIntern.h"

GUI_CONST_STORAGE unsigned char acF8x15B_1_160[15] = { /* code 160 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_161[15] = { /* code 161 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ___XX___,
  ___XX___,
  ________,
  ___XX___,
  ___XX___,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  ___XX___};

GUI_CONST_STORAGE unsigned char acF8x15B_1_162[15] = { /* code 162 */
  ________,
  ________,
  ________,
  ___XX___,
  ___XX___,
  __XXXX__,
  _XX__XX_,
  _XX_____,
  _XX_____,
  _XX__XX_,
  __XXXX__,
  ___XX___,
  ___XX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_163[15] = { /* code 163 */
  ________,
  ________,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX_____,
  _XX_____,
  XXXXXX__,
  _XX_____,
  _XX_____,
  XX______,
  XXXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_164[15] = { /* code 164 */
  ________,
  ________,
  ________,
  ________,
  _XX__XX_,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  _XX__XX_,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_165[15] = { /* code 165 */
  ________,
  ________,
  ________,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  _XXXXXX_,
  ___XX___,
  _XXXXXX_,
  ___XX___,
  ___XX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_166[15] = { /* code 166 */
  ________,
  ________,
  ________,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ________,
  ________,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___};

GUI_CONST_STORAGE unsigned char acF8x15B_1_167[15] = { /* code 167 */
  ________,
  ________,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX_____,
  __XXX___,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ___XXX__,
  _____XX_,
  _XX__XX_,
  __XXXX__};

GUI_CONST_STORAGE unsigned char acF8x15B_1_168[15] = { /* code 168 */
  ________,
  ________,
  _XX__XX_,
  _XX__XX_,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_169[15] = { /* code 169 */
  ________,
  ________,
  ________,
  _XXXXXX_,
  XX____XX,
  X__XX__X,
  X_X__X_X,
  X_X____X,
  X_X__X_X,
  X__XX__X,
  XX____XX,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_170[15] = { /* code 170 */
  ________,
  ________,
  ________,
  __XXXX__,
  _____XX_,
  __XXXXX_,
  _XX__XX_,
  __XXXXX_,
  ________,
  _XXXXXX_,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_171[15] = { /* code 171 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XX__XX,
  _XX__XX_,
  XX__XX__,
  _XX__XX_,
  __XX__XX,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_172[15] = { /* code 172 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XXXXXX_,
  _____XX_,
  _____XX_,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_173[15] = { /* code 173 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XXXXXX_,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_174[15] = { /* code 174 */
  ________,
  ________,
  ________,
  _XXXXXX_,
  XX____XX,
  X_XXX__X,
  X_X__X_X,
  X_X__X_X,
  X_XXX__X,
  X_X__X_X,
  XX____XX,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_175[15] = { /* code 175 */
  XXXXXXXX,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_176[15] = { /* code 176 */
  ________,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_177[15] = { /* code 177 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ___XX___,
  ___XX___,
  _XXXXXX_,
  ___XX___,
  ___XX___,
  ________,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_178[15] = { /* code 178 */
  ________,
  ________,
  ________,
  __XXX___,
  ____XX__,
  ___XX___,
  __XX____,
  __XXXX__,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_179[15] = { /* code 179 */
  ________,
  ________,
  ________,
  __XXX___,
  ____XX__,
  ___XX___,
  ____XX__,
  __XXX___,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_180[15] = { /* code 180 */
  ________,
  ___XXX__,
  ___XX___,
  __XX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_181[15] = { /* code 181 */
  ________,
  ________,
  ________,
  ________,
  ________,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XXXX_XX,
  _XX_____,
  _XX_____,
  XX______};

GUI_CONST_STORAGE unsigned char acF8x15B_1_182[15] = { /* code 182 */
  ________,
  ________,
  ________,
  ___XXXXX,
  __XXXXX_,
  _XXXXXX_,
  _XXXXXX_,
  _XXXXXX_,
  __XXXXX_,
  ___XXXX_,
  _____XX_,
  _____XX_,
  _____XX_,
  _____XX_,
  _____XX_};

GUI_CONST_STORAGE unsigned char acF8x15B_1_183[15] = { /* code 183 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ___XXX__,
  ___XXX__,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_184[15] = { /* code 184 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ___XX___,
  ____XX__,
  __XXX___};

GUI_CONST_STORAGE unsigned char acF8x15B_1_185[15] = { /* code 185 */
  ________,
  ________,
  ________,
  ___XX___,
  __XXX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_186[15] = { /* code 186 */
  ________,
  ________,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  _XXXXXX_,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_187[15] = { /* code 187 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  XX__XX__,
  _XX__XX_,
  __XX__XX,
  _XX__XX_,
  XX__XX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_188[15] = { /* code 188 */
  ________,
  ________,
  _XX_____,
  XXX_____,
  _XX___XX,
  _XX__XX_,
  _XX_XX__,
  ___XX___,
  __XX_XXX,
  _XX_XXXX,
  XX_XX_XX,
  ___XXXXX,
  ______XX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_189[15] = { /* code 189 */
  ________,
  ________,
  _XX_____,
  XXX_____,
  _XX___XX,
  _XX__XX_,
  _XX_XX__,
  ___XX___,
  __XXXXX_,
  _XX___XX,
  XX___XX_,
  ____XX__,
  ____XXXX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_190[15] = { /* code 190 */
  ________,
  ________,
  XXX_____,
  __XX____,
  _XX___XX,
  __XX_XX_,
  XXX_XX__,
  ___XX___,
  __XX_XXX,
  _XX_XXXX,
  XX_XX_XX,
  ___XXXXX,
  ______XX,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_191[15] = { /* code 191 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ___XX___,
  ___XX___,
  ________,
  ___XX___,
  ___XX___,
  __XX____,
  _XX__XX_,
  _XX__XX_,
  __XXXX__};

GUI_CONST_STORAGE unsigned char acF8x15B_1_192[15] = { /* code 192 */
  __XX____,
  ___XX___,
  ________,
  ___XX___,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XXXXXX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_193[15] = { /* code 193 */
  ____XX__,
  ___XX___,
  ________,
  ___XX___,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XXXXXX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_194[15] = { /* code 194 */
  __XXXX__,
  _XX__XX_,
  ________,
  ___XX___,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XXXXXX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_195[15] = { /* code 195 */
  __XXX_XX,
  _XX_XXX_,
  ________,
  ___XX___,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XXXXXX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_196[15] = { /* code 196 */
  _XX__XX_,
  _XX__XX_,
  ________,
  ___XX___,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XXXXXX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_197[15] = { /* code 197 */
  __XXXX__,
  _XX__XX_,
  __XXXX__,
  ___XX___,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XXXXXX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_198[15] = { /* code 198 */
  ________,
  ________,
  ________,
  ____XXXX,
  ___XXX__,
  __XXXX__,
  _XX_XX__,
  _XX_XXXX,
  _XXXXX__,
  _XX_XX__,
  _XX_XX__,
  _XX_XXXX,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_199[15] = { /* code 199 */
  ________,
  ________,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ___XX___,
  ____XX__,
  __XXX___};

GUI_CONST_STORAGE unsigned char acF8x15B_1_200[15] = { /* code 200 */
  __XX____,
  ___XX___,
  ________,
  _XXXXXX_,
  _XX_____,
  _XX_____,
  _XX_____,
  _XXXXX__,
  _XX_____,
  _XX_____,
  _XX_____,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_201[15] = { /* code 201 */
  ____XX__,
  ___XX___,
  ________,
  _XXXXXX_,
  _XX_____,
  _XX_____,
  _XX_____,
  _XXXXX__,
  _XX_____,
  _XX_____,
  _XX_____,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_202[15] = { /* code 202 */
  __XXXX__,
  _XX__XX_,
  ________,
  _XXXXXX_,
  _XX_____,
  _XX_____,
  _XX_____,
  _XXXXX__,
  _XX_____,
  _XX_____,
  _XX_____,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_203[15] = { /* code 203 */
  _XX__XX_,
  _XX__XX_,
  ________,
  _XXXXXX_,
  _XX_____,
  _XX_____,
  _XX_____,
  _XXXXX__,
  _XX_____,
  _XX_____,
  _XX_____,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_204[15] = { /* code 204 */
  __XX____,
  ___XX___,
  ________,
  __XXXX__,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_205[15] = { /* code 205 */
  ____XX__,
  ___XX___,
  ________,
  __XXXX__,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_206[15] = { /* code 206 */
  __XXXX__,
  _XX__XX_,
  ________,
  __XXXX__,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_207[15] = { /* code 207 */
  _XX__XX_,
  _XX__XX_,
  ________,
  __XXXX__,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_208[15] = { /* code 208 */
  ________,
  ________,
  ________,
  _XXXX___,
  _XX_XX__,
  _XX__XX_,
  _XX__XX_,
  XXXX_XX_,
  _XX__XX_,
  _XX__XX_,
  _XX_XX__,
  _XXXX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_209[15] = { /* code 209 */
  __XXX_XX,
  _XX_XXX_,
  ________,
  _XX___XX,
  _XX___XX,
  _XXX__XX,
  _XXXX_XX,
  _XX_XXXX,
  _XX__XXX,
  _XX___XX,
  _XX___XX,
  _XX___XX,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_210[15] = { /* code 210 */
  __XX____,
  ___XX___,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_211[15] = { /* code 211 */
  ____XX__,
  ___XX___,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_212[15] = { /* code 212 */
  __XXXX__,
  _XX__XX_,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_213[15] = { /* code 213 */
  __XXX_XX,
  _XX_XXX_,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_214[15] = { /* code 214 */
  _XX__XX_,
  _XX__XX_,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_215[15] = { /* code 215 */
  ________,
  ________,
  ________,
  ________,
  _X____X_,
  _XX__XX_,
  __XXXX__,
  ___XX___,
  __XXXX__,
  _XX__XX_,
  _X____X_,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_216[15] = { /* code 216 */
  ________,
  ________,
  ________,
  __XXXXX_,
  _XX__XX_,
  _XX_XXX_,
  _XX_XXX_,
  _XXXXXX_,
  _XXX_XX_,
  _XXX_XX_,
  _XX__XX_,
  _XXXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_217[15] = { /* code 217 */
  __XX____,
  ___XX___,
  ________,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_218[15] = { /* code 218 */
  ____XX__,
  ___XX___,
  ________,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_219[15] = { /* code 219 */
  __XXXX__,
  _XX__XX_,
  ________,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_220[15] = { /* code 220 */
  _XX__XX_,
  _XX__XX_,
  ________,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_221[15] = { /* code 221 */
  ____XX__,
  ___XX___,
  ________,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_222[15] = { /* code 222 */
  ________,
  ________,
  ________,
  _XX_____,
  _XX_____,
  _XXXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XXXXX__,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_223[15] = { /* code 223 */
  ________,
  ________,
  ________,
  __XXX___,
  _XX_XX__,
  _XX_XX__,
  _XX_XX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX_XX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_224[15] = { /* code 224 */
  ________,
  _XXX____,
  __XX____,
  ___XX___,
  ________,
  __XXXX__,
  _____XX_,
  _____XX_,
  __XXXXX_,
  _XX__XX_,
  _XX__XX_,
  __XXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_225[15] = { /* code 225 */
  ________,
  ____XXX_,
  ____XX__,
  ___XX___,
  ________,
  __XXXX__,
  _____XX_,
  _____XX_,
  __XXXXX_,
  _XX__XX_,
  _XX__XX_,
  __XXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_226[15] = { /* code 226 */
  ________,
  ___XX___,
  __XXXX__,
  _XX__XX_,
  ________,
  __XXXX__,
  _____XX_,
  _____XX_,
  __XXXXX_,
  _XX__XX_,
  _XX__XX_,
  __XXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_227[15] = { /* code 227 */
  ________,
  _XXX___X,
  XX_XX_XX,
  X___XXX_,
  ________,
  __XXXX__,
  _____XX_,
  _____XX_,
  __XXXXX_,
  _XX__XX_,
  _XX__XX_,
  __XXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_228[15] = { /* code 228 */
  ________,
  ________,
  _XX__XX_,
  _XX__XX_,
  ________,
  __XXXX__,
  _____XX_,
  _____XX_,
  __XXXXX_,
  _XX__XX_,
  _XX__XX_,
  __XXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_229[15] = { /* code 229 */
  ________,
  __XXXX__,
  _XX__XX_,
  __XXXX__,
  ________,
  __XXXX__,
  _____XX_,
  _____XX_,
  __XXXXX_,
  _XX__XX_,
  _XX__XX_,
  __XXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_230[15] = { /* code 230 */
  ________,
  ________,
  ________,
  ________,
  ________,
  _XX_XXX_,
  ___XX_XX,
  ___XX_XX,
  _XXXXXXX,
  XX_XX___,
  XX_XX___,
  _XXX_XXX,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_231[15] = { /* code 231 */
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX__XX_,
  __XXXX__,
  ___XX___,
  ____XX__,
  __XXX___};

GUI_CONST_STORAGE unsigned char acF8x15B_1_232[15] = { /* code 232 */
  ________,
  _XXX____,
  __XX____,
  ___XX___,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XXXXXX_,
  _XX_____,
  _XX_____,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_233[15] = { /* code 233 */
  ________,
  ____XXX_,
  ____XX__,
  ___XX___,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XXXXXX_,
  _XX_____,
  _XX_____,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_234[15] = { /* code 234 */
  ________,
  ___XX___,
  __XXXX__,
  _XX__XX_,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XXXXXX_,
  _XX_____,
  _XX_____,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_235[15] = { /* code 235 */
  ________,
  ________,
  _XX__XX_,
  _XX__XX_,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XXXXXX_,
  _XX_____,
  _XX_____,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_236[15] = { /* code 236 */
  ________,
  _XXX____,
  __XX____,
  ___XX___,
  ________,
  _XXXX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_237[15] = { /* code 237 */
  ________,
  ____XXX_,
  ____XX__,
  ___XX___,
  ________,
  _XXXX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_238[15] = { /* code 238 */
  ________,
  ___XX___,
  __XXXX__,
  _XX__XX_,
  ________,
  _XXXX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_239[15] = { /* code 239 */
  ________,
  ________,
  _XX__XX_,
  _XX__XX_,
  ________,
  _XXXX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_240[15] = { /* code 240 */
  ________,
  ________,
  ________,
  __XX_XX_,
  ___XX___,
  _XX_XX__,
  ___XXXX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_241[15] = { /* code 241 */
  ________,
  _XXX___X,
  XX_XX_XX,
  X___XXX_,
  ________,
  _XXXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_242[15] = { /* code 242 */
  ________,
  _XXX____,
  __XX____,
  ___XX___,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_243[15] = { /* code 243 */
  ________,
  ____XXX_,
  ____XX__,
  ___XX___,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_244[15] = { /* code 244 */
  ________,
  ___XX___,
  __XXXX__,
  _XX__XX_,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_245[15] = { /* code 245 */
  ________,
  _XXX___X,
  XX_XX_XX,
  X___XXX_,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_246[15] = { /* code 246 */
  ________,
  ________,
  _XX__XX_,
  _XX__XX_,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_247[15] = { /* code 247 */
  ________,
  ________,
  ________,
  ________,
  ___XX___,
  ___XX___,
  ________,
  _XXXXXX_,
  ________,
  ___XX___,
  ___XX___,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_248[15] = { /* code 248 */
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXXXX_,
  _XX__XX_,
  _XX_XXX_,
  _XXXXXX_,
  _XXX_XX_,
  _XX__XX_,
  _XXXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_249[15] = { /* code 249 */
  ________,
  _XXX____,
  __XX____,
  ___XX___,
  ________,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_250[15] = { /* code 250 */
  ________,
  ____XXX_,
  ____XX__,
  ___XX___,
  ________,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_251[15] = { /* code 251 */
  ________,
  ___XX___,
  __XXXX__,
  _XX__XX_,
  ________,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_252[15] = { /* code 252 */
  ________,
  ________,
  _XX__XX_,
  _XX__XX_,
  ________,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acF8x15B_1_253[15] = { /* code 253 */
  ________,
  ____XXX_,
  ____XX__,
  ___XX___,
  ________,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ____XX__,
  ___XX___,
  XXXX____};

GUI_CONST_STORAGE unsigned char acF8x15B_1_254[15] = { /* code 254 */
  ________,
  ________,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XXXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XXXXX__,
  _XX_____,
  _XX_____,
  _XX_____};

GUI_CONST_STORAGE unsigned char acF8x15B_1_255[15] = { /* code 255 */
  ________,
  ________,
  _XX__XX_,
  _XX__XX_,
  ________,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ____XX__,
  ___XX___,
  XXXX____};

GUI_CONST_STORAGE GUI_CHARINFO GUI_CharInfoF8x15B_1[96] = {
   {   8,   8,  1, acF8x15B_1_160 } /* code 160 */
  ,{   8,   8,  1, acF8x15B_1_161 } /* code 161 */
  ,{   8,   8,  1, acF8x15B_1_162 } /* code 162 */
  ,{   8,   8,  1, acF8x15B_1_163 } /* code 163 */
  ,{   8,   8,  1, acF8x15B_1_164 } /* code 164 */
  ,{   8,   8,  1, acF8x15B_1_165 } /* code 165 */
  ,{   8,   8,  1, acF8x15B_1_166 } /* code 166 */
  ,{   8,   8,  1, acF8x15B_1_167 } /* code 167 */
  ,{   8,   8,  1, acF8x15B_1_168 } /* code 168 */
  ,{   8,   8,  1, acF8x15B_1_169 } /* code 169 */
  ,{   8,   8,  1, acF8x15B_1_170 } /* code 170 */
  ,{   8,   8,  1, acF8x15B_1_171 } /* code 171 */
  ,{   8,   8,  1, acF8x15B_1_172 } /* code 172 */
  ,{   8,   8,  1, acF8x15B_1_173 } /* code 173 */
  ,{   8,   8,  1, acF8x15B_1_174 } /* code 174 */
  ,{   8,   8,  1, acF8x15B_1_175 } /* code 175 */
  ,{   8,   8,  1, acF8x15B_1_176 } /* code 176 */
  ,{   8,   8,  1, acF8x15B_1_177 } /* code 177 */
  ,{   8,   8,  1, acF8x15B_1_178 } /* code 178 */
  ,{   8,   8,  1, acF8x15B_1_179 } /* code 179 */
  ,{   8,   8,  1, acF8x15B_1_180 } /* code 180 */
  ,{   8,   8,  1, acF8x15B_1_181 } /* code 181 */
  ,{   8,   8,  1, acF8x15B_1_182 } /* code 182 */
  ,{   8,   8,  1, acF8x15B_1_183 } /* code 183 */
  ,{   8,   8,  1, acF8x15B_1_184 } /* code 184 */
  ,{   8,   8,  1, acF8x15B_1_185 } /* code 185 */
  ,{   8,   8,  1, acF8x15B_1_186 } /* code 186 */
  ,{   8,   8,  1, acF8x15B_1_187 } /* code 187 */
  ,{   8,   8,  1, acF8x15B_1_188 } /* code 188 */
  ,{   8,   8,  1, acF8x15B_1_189 } /* code 189 */
  ,{   8,   8,  1, acF8x15B_1_190 } /* code 190 */
  ,{   8,   8,  1, acF8x15B_1_191 } /* code 191 */
  ,{   8,   8,  1, acF8x15B_1_192 } /* code 192 */
  ,{   8,   8,  1, acF8x15B_1_193 } /* code 193 */
  ,{   8,   8,  1, acF8x15B_1_194 } /* code 194 */
  ,{   8,   8,  1, acF8x15B_1_195 } /* code 195 */
  ,{   8,   8,  1, acF8x15B_1_196 } /* code 196 */
  ,{   8,   8,  1, acF8x15B_1_197 } /* code 197 */
  ,{   8,   8,  1, acF8x15B_1_198 } /* code 198 */
  ,{   8,   8,  1, acF8x15B_1_199 } /* code 199 */
  ,{   8,   8,  1, acF8x15B_1_200 } /* code 200 */
  ,{   8,   8,  1, acF8x15B_1_201 } /* code 201 */
  ,{   8,   8,  1, acF8x15B_1_202 } /* code 202 */
  ,{   8,   8,  1, acF8x15B_1_203 } /* code 203 */
  ,{   8,   8,  1, acF8x15B_1_204 } /* code 204 */
  ,{   8,   8,  1, acF8x15B_1_205 } /* code 205 */
  ,{   8,   8,  1, acF8x15B_1_206 } /* code 206 */
  ,{   8,   8,  1, acF8x15B_1_207 } /* code 207 */
  ,{   8,   8,  1, acF8x15B_1_208 } /* code 208 */
  ,{   8,   8,  1, acF8x15B_1_209 } /* code 209 */
  ,{   8,   8,  1, acF8x15B_1_210 } /* code 210 */
  ,{   8,   8,  1, acF8x15B_1_211 } /* code 211 */
  ,{   8,   8,  1, acF8x15B_1_212 } /* code 212 */
  ,{   8,   8,  1, acF8x15B_1_213 } /* code 213 */
  ,{   8,   8,  1, acF8x15B_1_214 } /* code 214 */
  ,{   8,   8,  1, acF8x15B_1_215 } /* code 215 */
  ,{   8,   8,  1, acF8x15B_1_216 } /* code 216 */
  ,{   8,   8,  1, acF8x15B_1_217 } /* code 217 */
  ,{   8,   8,  1, acF8x15B_1_218 } /* code 218 */
  ,{   8,   8,  1, acF8x15B_1_219 } /* code 219 */
  ,{   8,   8,  1, acF8x15B_1_220 } /* code 220 */
  ,{   8,   8,  1, acF8x15B_1_221 } /* code 221 */
  ,{   8,   8,  1, acF8x15B_1_222 } /* code 222 */
  ,{   8,   8,  1, acF8x15B_1_223 } /* code 223 */
  ,{   8,   8,  1, acF8x15B_1_224 } /* code 224 */
  ,{   8,   8,  1, acF8x15B_1_225 } /* code 225 */
  ,{   8,   8,  1, acF8x15B_1_226 } /* code 226 */
  ,{   8,   8,  1, acF8x15B_1_227 } /* code 227 */
  ,{   8,   8,  1, acF8x15B_1_228 } /* code 228 */
  ,{   8,   8,  1, acF8x15B_1_229 } /* code 229 */
  ,{   8,   8,  1, acF8x15B_1_230 } /* code 230 */
  ,{   8,   8,  1, acF8x15B_1_231 } /* code 231 */
  ,{   8,   8,  1, acF8x15B_1_232 } /* code 232 */
  ,{   8,   8,  1, acF8x15B_1_233 } /* code 233 */
  ,{   8,   8,  1, acF8x15B_1_234 } /* code 234 */
  ,{   8,   8,  1, acF8x15B_1_235 } /* code 235 */
  ,{   8,   8,  1, acF8x15B_1_236 } /* code 236 */
  ,{   8,   8,  1, acF8x15B_1_237 } /* code 237 */
  ,{   8,   8,  1, acF8x15B_1_238 } /* code 238 */
  ,{   8,   8,  1, acF8x15B_1_239 } /* code 239 */
  ,{   8,   8,  1, acF8x15B_1_240 } /* code 240 */
  ,{   8,   8,  1, acF8x15B_1_241 } /* code 241 */
  ,{   8,   8,  1, acF8x15B_1_242 } /* code 242 */
  ,{   8,   8,  1, acF8x15B_1_243 } /* code 243 */
  ,{   8,   8,  1, acF8x15B_1_244 } /* code 244 */
  ,{   8,   8,  1, acF8x15B_1_245 } /* code 245 */
  ,{   8,   8,  1, acF8x15B_1_246 } /* code 246 */
  ,{   8,   8,  1, acF8x15B_1_247 } /* code 247 */
  ,{   8,   8,  1, acF8x15B_1_248 } /* code 248 */
  ,{   8,   8,  1, acF8x15B_1_249 } /* code 249 */
  ,{   8,   8,  1, acF8x15B_1_250 } /* code 250 */
  ,{   8,   8,  1, acF8x15B_1_251 } /* code 251 */
  ,{   8,   8,  1, acF8x15B_1_252 } /* code 252 */
  ,{   8,   8,  1, acF8x15B_1_253 } /* code 253 */
  ,{   8,   8,  1, acF8x15B_1_254 } /* code 254 */
  ,{   8,   8,  1, acF8x15B_1_255 } /* code 255 */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontPropF8x15B_1_2 = {
   160                      /* first character               */
  ,255                      /* last character                */
  ,GUI_CharInfoF8x15B_1     /* address of first character    */
  ,(const GUI_FONT_PROP*)0  /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontPropF8x15B_1_1 = {
   32                       /* first character               */
  ,127                      /* last character                */
  ,GUI_CharInfoF8x15B_ASCII /* address of first character    */
  ,&GUI_FontPropF8x15B_1_2  /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_Font8x15B_1 = {
   GUI_FONTTYPE_PROP  /* type of font    */
  ,15                 /* height of font  */
  ,15                 /* space of font y */
  ,1                  /* magnification x */
  ,1                  /* magnification y */
  ,{&GUI_FontPropF8x15B_1_1}
  , 12, 7, 9
};

