/*
*********************************************************************************************************
*                                                uC/GUI
*                        Universal graphic software for embedded applications
*
*                       (c) Copyright 2002, Micrium Inc., Weston, FL
*                       (c) Copyright 2002, SEGGER Microcontroller Systeme GmbH
*
*              C/GUI is protected by international copyright laws. Knowledge of the
*              source code may not be used to write a similar product. This file may
*              only be used in accordance with a license and should not be redistributed
*              in any way. We appreciate your understanding and fairness.
*
----------------------------------------------------------------------
File        : FComic18B_ASCII.C
Purpose     : Font, similar to Comic, ASCII only
Height      : 18
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI_FontIntern.h"

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_32[18] = { /* code 32 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_33[18] = { /* code 33 */
  ________,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  _XX_____,
  _XX_____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_34[18] = { /* code 34 */
  ________,
  ________,
  ________,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_35[36] = { /* code 35 */
  ________,________,
  ________,________,
  ________,________,
  ____XX__,_XX_____,
  ____XX__,_XX_____,
  _XXXXXXX,XXXXX___,
  _XXXXXXX,XXXXX___,
  ___XX___,XX______,
  ___XX__X,XX______,
  __XX___X,X_______,
  XXXXXXXX,XXXX____,
  XXXXXXXX,XXXX____,
  __XX__XX,X_______,
  _XX___XX,________,
  _XX___XX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_36[36] = { /* code 36 */
  ________,________,
  ____XX__,________,
  ____XX__,________,
  ___XXXXX,________,
  _XXXXXXX,X_______,
  XXX_XX__,________,
  XX__XX__,________,
  XX__XX__,________,
  XXXXXXXX,________,
  __XXXXXX,X_______,
  ____XX_X,XX______,
  ____XX__,XX______,
  XX__XX_X,XX______,
  XXXXXXXX,X_______,
  _XXXXXXX,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_37[36] = { /* code 37 */
  ________,________,
  ________,________,
  ________,X_______,
  _XXX___X,X_______,
  XXXXX__X,________,
  XX_XX_XX,________,
  XXXXX_X_,________,
  _XXX_XX_,________,
  _____X__,________,
  ____XX__,________,
  ____X___,XXX_____,
  ___XX__X,XXXX____,
  ___X___X,X_XX____,
  __XX___X,XXXX____,
  __X_____,XXX_____,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_38[36] = { /* code 38 */
  ________,________,
  ________,________,
  ________,________,
  ____XXX_,________,
  ___XXXXX,________,
  ___XX_XX,________,
  ___XXXX_,________,
  ___XXX__,________,
  __XXXX__,_X______,
  _XX__XX_,_X______,
  XX____XX,XX______,
  XX_____X,XX______,
  XXX____X,X_______,
  _XXXXXXX,XX______,
  __XXXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_39[18] = { /* code 39 */
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_40[18] = { /* code 40 */
  ________,
  ________,
  ____XX__,
  ___XXX__,
  ___XX___,
  __XX____,
  __XX____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  __XX____,
  __XX____,
  ___XX___,
  ____XX__};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_41[18] = { /* code 41 */
  ________,
  ________,
  XX______,
  XXX_____,
  _XX_____,
  __XX____,
  __XX____,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  __XX____,
  __XX____,
  _XX_____,
  XX______};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_42[36] = { /* code 42 */
  ________,________,
  ________,________,
  ________,________,
  ____X___,________,
  _XXXXXXX,________,
  __XXXXXX,________,
  ___XXX__,________,
  __XX_XX_,________,
  __X__XX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_43[18] = { /* code 43 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ___XX___,
  ___XX___,
  ___XX___,
  XXXXXXXX,
  XXXXXXXX,
  ___XX___,
  ___XX___,
  ___XX___,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_44[18] = { /* code 44 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __X_____,
  _XX_____,
  _X______,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_45[18] = { /* code 45 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XXXXX__,
  _XXXXX__,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_46[18] = { /* code 46 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_47[36] = { /* code 47 */
  ________,________,
  ________,________,
  ________,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  _____XX_,________,
  _____XX_,________,
  ____XX__,________,
  ____XX__,________,
  ___XX___,________,
  ___XX___,________,
  __XX____,________,
  __XX____,________,
  _XX_____,________,
  _XX_____,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_48[36] = { /* code 48 */
  ________,________,
  ________,________,
  ________,________,
  ___XXXX_,________,
  _XXXXXXX,________,
  _XX___XX,________,
  XX_____X,X_______,
  XX_____X,X_______,
  XX_____X,X_______,
  XX_____X,X_______,
  XX_____X,X_______,
  XX_____X,X_______,
  _XX___XX,________,
  _XXXXXXX,________,
  __XXXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_49[18] = { /* code 49 */
  ________,
  ________,
  ________,
  ___XX___,
  __XXX___,
  _XXXX___,
  _X_XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  _XXXXXX_,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_50[36] = { /* code 50 */
  ________,________,
  ________,________,
  ________,________,
  ___XXXX_,________,
  __XXXXXX,X_______,
  _XXX___X,X_______,
  _XX____X,X_______,
  _______X,X_______,
  _____XXX,________,
  ____XXX_,________,
  __XXX___,________,
  _XXX____,________,
  _XX_____,________,
  _XXXXXXX,X_______,
  _XXXXXXX,X_______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_51[36] = { /* code 51 */
  ________,________,
  ________,________,
  ________,________,
  __XXXXX_,________,
  _XXXXXXX,________,
  _XX___XX,________,
  ______XX,________,
  _____XXX,________,
  __XXXX__,________,
  ___XXXXX,________,
  ______XX,________,
  ______XX,________,
  _X____XX,________,
  _XXXXXX_,________,
  __XXXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_52[36] = { /* code 52 */
  ________,________,
  ________,________,
  ________,________,
  ______XX,________,
  _____XXX,________,
  ____XXXX,________,
  ____X_XX,________,
  ___X__XX,________,
  __XX__XX,________,
  _XX___XX,________,
  XXXXXXXX,XX______,
  XXXXXXXX,XX______,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_53[36] = { /* code 53 */
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,X_______,
  _XXXXXXX,X_______,
  _XX_____,________,
  _XXXXXX_,________,
  _XXXXXXX,________,
  _XX___XX,X_______,
  _XX____X,X_______,
  _______X,X_______,
  _______X,X_______,
  _XX___XX,X_______,
  _XXXXXXX,________,
  __XXXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_54[36] = { /* code 54 */
  ________,________,
  ________,________,
  ________,________,
  _____XX_,________,
  ____XXX_,________,
  ___XXX__,________,
  __XXX___,________,
  __XX____,________,
  _XXXXXXX,________,
  _XXXXXXX,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XXX__XX,X_______,
  __XXXXXX,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_55[36] = { /* code 55 */
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XX______,
  _XXXXXXX,XX______,
  _______X,X_______,
  ______XX,________,
  ______X_,________,
  _____XX_,________,
  _____XX_,________,
  ____XX__,________,
  ____XX__,________,
  ___XX___,________,
  ___XX___,________,
  ___X____,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_56[36] = { /* code 56 */
  ________,________,
  ________,________,
  ________,________,
  ___XXXX_,________,
  _XXXXXXX,________,
  _XX____X,X_______,
  _XX____X,X_______,
  _XXXXXXX,________,
  __XXXXXX,________,
  _XXX__XX,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XXXXXXX,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_57[36] = { /* code 57 */
  ________,________,
  ________,________,
  ________,________,
  ___XXXX_,________,
  __XXXXXX,________,
  _XXX__XX,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XXX__XX,X_______,
  __XXXXXX,X_______,
  ___XXXXX,X_______,
  ______XX,________,
  _____XXX,________,
  ____XXX_,________,
  __XXXX__,________,
  __XX____,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_58[18] = { /* code 58 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_59[18] = { /* code 59 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  ________,
  ________,
  ________,
  ________,
  __XX____,
  _XX_____,
  _XX_____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_60[18] = { /* code 60 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ____XX__,
  ___XXX__,
  __XXX___,
  _XX_____,
  __XX____,
  ___XX___,
  ____XX__,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_61[18] = { /* code 61 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XXXXXX_,
  _XXXXXX_,
  ________,
  ________,
  ________,
  _XXXXXX_,
  _XXXXXX_,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_62[18] = { /* code 62 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XX_____,
  __XX____,
  ___XX___,
  ____XX__,
  __XXX___,
  _XXX____,
  _X______,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_63[36] = { /* code 63 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXX__,________,
  _XXXXXX_,________,
  _XX__XXX,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  _____XX_,________,
  ___XXX__,________,
  ___X____,________,
  ________,________,
  __XX____,________,
  __XX____,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_64[36] = { /* code 64 */
  ________,________,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XXXX____,
  ___XX___,__XXX___,
  __XX____,___XX___,
  __XX__XX,____XX__,
  _XX__XX_,____XX__,
  _XX_XX__,X___XX__,
  _XX_XX_X,X___XX__,
  _XX_XXXX,XXXXX___,
  _XX__XX_,_XXX____,
  _XXX____,________,
  __XX____,________,
  ___XX___,_XX_____,
  ___XXXXX,XXX_____,
  _____XXX,XX______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_65[36] = { /* code 65 */
  ________,________,
  ________,________,
  ________,________,
  _______X,X_______,
  _______X,X_______,
  ______XX,X_______,
  _____XX_,XX______,
  _____XX_,XX______,
  ____XX__,XX______,
  ___XXXXX,XX______,
  ___XXXXX,XX______,
  __XX____,XXX_____,
  __XX____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_66[36] = { /* code 66 */
  ________,________,
  ________,________,
  ________,________,
  _XXXXX__,________,
  _XXXXXX_,________,
  _XX__XXX,________,
  _XX___XX,________,
  _XX__XXX,________,
  _XXXXXX_,________,
  _XXXXXXX,________,
  _XX___XX,X_______,
  _XX____X,X_______,
  _XX___XX,X_______,
  _XXXXXXX,________,
  _XXXXX__,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_67[36] = { /* code 67 */
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,________,
  ___XXXXX,________,
  __XX__XX,________,
  _XX_____,________,
  _XX_____,________,
  XX______,________,
  XX______,________,
  XX______,________,
  XX_____X,________,
  XXX__XXX,________,
  _XXXXXX_,________,
  __XXXX__,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_68[36] = { /* code 68 */
  ________,________,
  ________,________,
  ________,________,
  _XX_____,________,
  _XXXXX__,________,
  _XXXXXXX,________,
  _XX___XX,X_______,
  _XX_____,XX______,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX____X,XX______,
  _XXXXXXX,X_______,
  __XXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_69[36] = { /* code 69 */
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,________,
  _XXXXXXX,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XXXXXXX,________,
  _XXXXXXX,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XXXXXXX,________,
  __XXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_70[36] = { /* code 70 */
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,X_______,
  _XXXXXXX,XX______,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XXXXXXX,X_______,
  _XXXXXXX,X_______,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_71[36] = { /* code 71 */
  ________,________,
  ________,________,
  ________,________,
  ____XXX_,________,
  ___XXXXX,X_______,
  __XXX__X,X_______,
  _XXX____,________,
  _XX_____,________,
  XX_XXXXX,XX______,
  XX_XXXXX,XX______,
  XX______,XX______,
  XX_____X,X_______,
  XX____XX,X_______,
  _XXXXXXX,________,
  __XXXX__,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_72[36] = { /* code 72 */
  ________,________,
  ________,________,
  ________,________,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX__XXX,XXX_____,
  _XXXXXXX,XXX_____,
  _XXXX___,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_73[36] = { /* code 73 */
  ________,________,
  ________,________,
  ________,________,
  XXXXXXXX,________,
  XXXXXXXX,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  XXXXXXXX,________,
  XXXXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_74[36] = { /* code 74 */
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,XX______,
  __XXXXXX,XX______,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  XX___XX_,________,
  XX___XX_,________,
  XXX__XX_,________,
  _XXXXXX_,________,
  ___XXX__,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_75[36] = { /* code 75 */
  ________,________,
  ________,________,
  ________,________,
  _XX_____,X_______,
  _XX____X,X_______,
  _XX___XX,________,
  _XX__XX_,________,
  _XX_XX__,________,
  _XXX____,________,
  _XXX____,________,
  _XXXX___,________,
  _XX_XX__,________,
  _XX__XX_,________,
  _XX___XX,X_______,
  _XX____X,X_______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_76[36] = { /* code 76 */
  ________,________,
  ________,________,
  ________,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XXXXXXX,________,
  _XXXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_77[36] = { /* code 77 */
  ________,________,
  ________,________,
  ________,________,
  ____XX__,__X_____,
  ___XXX__,_XXX____,
  ___XXX__,_XXX____,
  ___XXX__,_XXX____,
  ___X_X__,_X_X____,
  __XX_XX_,XX_XX___,
  __XX_XX_,XX_XX___,
  __XX_XX_,XX_XX___,
  __X__XX_,XX_XX___,
  _XX__XXX,X__XX___,
  _XX___XX,X___XX__,
  _XX___XX,X___XX__,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_78[36] = { /* code 78 */
  ________,________,
  ________,________,
  ________,________,
  _XX_____,__X_____,
  _XX_____,__XX____,
  _XXX____,__XX____,
  _XXXX___,__XX____,
  _XX_XX__,__XX____,
  _XX__XX_,__XX____,
  _XX___X_,__XX____,
  _XX___XX,__XX____,
  _XX____X,X_XX____,
  _XX_____,XXXX____,
  _XX_____,_XXX____,
  _XX_____,__XX____,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_79[36] = { /* code 79 */
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XXX_____,
  __XXX___,_XXX____,
  __XX____,__XX____,
  _XXX____,__XX____,
  _XX_____,__XX____,
  _XX_____,__XX____,
  _XX_____,_XXX____,
  _XX_____,_XX_____,
  __XX____,XXX_____,
  __XXXXXX,XX______,
  ____XXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_80[18] = { /* code 80 */
  ________,
  ________,
  ________,
  _XXXXX__,
  _XXXXXX_,
  _XX__XXX,
  _XX___XX,
  _XX__XXX,
  _XXXXXX_,
  _XXXXX__,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_81[36] = { /* code 81 */
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,XX______,
  __XXXXXX,XXX_____,
  _XXXX___,_XXX____,
  _XX_____,__XX____,
  XX______,___XX___,
  XX______,___XX___,
  XX______,___XX___,
  XX____X_,___XX___,
  _XX___XX,___XX___,
  _XXX___X,X_XX____,
  __XXXXXX,XXXX____,
  ____XXXX,_XX_____,
  ________,__XX____,
  ________,___XX___,
  ________,____X___};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_82[36] = { /* code 82 */
  ________,________,
  ________,________,
  ________,________,
  _XXXX___,________,
  _XXXXXX_,________,
  _XX__XXX,________,
  _XX___XX,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX___XX,________,
  _XXXXXX_,________,
  _XXXXXX_,________,
  _XX__XXX,________,
  _XX____X,XX______,
  _XX_____,XX______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_83[36] = { /* code 83 */
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,________,
  ___XXXXX,X_______,
  __XXX___,________,
  __XX____,________,
  __XXXXXX,________,
  ___XXXXX,X_______,
  _______X,XX______,
  ________,XX______,
  _XX_____,XX______,
  _XX____X,XX______,
  __XXXXXX,X_______,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_84[36] = { /* code 84 */
  ________,________,
  ________,________,
  ________,________,
  XXXXXXXX,XX______,
  XXXXXXXX,XX______,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_85[36] = { /* code 85 */
  ________,________,
  ________,________,
  ________,________,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XXX____,XX______,
  __XX___X,XX______,
  __XXXXXX,X_______,
  ____XXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_86[36] = { /* code 86 */
  ________,________,
  ________,________,
  ________,________,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX____X,X_______,
  __XX___X,X_______,
  __XX___X,X_______,
  __XX___X,X_______,
  __XX__XX,________,
  ___XX_XX,________,
  ___XX_XX,________,
  ___XX_XX,________,
  ____XXX_,________,
  ____XXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_87[54] = { /* code 87 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _XX_____,XX____XX,________,
  _XX____X,XX____XX,________,
  _XX____X,XX____XX,________,
  _XX____X,_X____XX,________,
  __XX__XX,_XX__XX_,________,
  __XX__XX,_XX__XX_,________,
  __XX__XX,_XX__XX_,________,
  __XX_XX_,_XX_XX__,________,
  ___X_XX_,_XX_XX__,________,
  ___XXX__,_XX_XX__,________,
  ___XXX__,_XXXX___,________,
  ___XXX__,__XXX___,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_88[36] = { /* code 88 */
  ________,________,
  ________,________,
  ________,________,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  __XX____,XX______,
  ___XX__X,X_______,
  ____XXXX,________,
  _____XX_,________,
  _____XXX,________,
  ____XXXX,X_______,
  ___XX__X,X_______,
  __XX____,XX______,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_89[36] = { /* code 89 */
  ________,________,
  ________,________,
  ________,________,
  _XX_____,XX______,
  _XX_____,XX______,
  __XX___X,XX______,
  __XX___X,X_______,
  ___XX_XX,X_______,
  ___XX_XX,________,
  ____XXXX,________,
  ____XXXX,________,
  _____XX_,________,
  ____XXX_,________,
  ____XX__,________,
  ___XX___,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_90[36] = { /* code 90 */
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  _______X,XX______,
  ______XX,X_______,
  _____XXX,________,
  ____XXX_,________,
  ____XX__,________,
  ___XX___,________,
  __XX____,________,
  _XX_____,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_91[18] = { /* code 91 */
  ________,
  ________,
  __XXXX__,
  __XXXX__,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XXXX__,
  __XXXX__};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_92[18] = { /* code 92 */
  ________,
  ________,
  ________,
  _XX_____,
  _XX_____,
  __XX____,
  __XX____,
  ___X____,
  ___XX___,
  ___XX___,
  ____X___,
  ____XX__,
  ____XX__,
  ____XX__,
  _____XX_,
  _____XX_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_93[18] = { /* code 93 */
  ________,
  ________,
  XXXXX___,
  XXXXX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  XXXXX___,
  XXXXX___};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_94[18] = { /* code 94 */
  ________,
  ________,
  ___XX___,
  __XXXX__,
  __XX_XX_,
  _XX___X_,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_95[36] = { /* code 95 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XXXXXXXX,XX______};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_96[36] = { /* code 96 */
  ________,________,
  ________,________,
  _X______,________,
  _XX_____,________,
  __XX____,________,
  ___X____,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_97[18] = { /* code 97 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXXXX_,
  _XXXXXX_,
  XXX__XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XXXXXXX_,
  _XXXX_XX,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_98[36] = { /* code 98 */
  ________,________,
  ________,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_XXX_,________,
  _XXXXXXX,________,
  _XXX__XX,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX___XX,X_______,
  _XXXXXXX,________,
  _XXXXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_99[18] = { /* code 99 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXXX__,
  _XXXXXX_,
  _XX___X_,
  XX______,
  XX______,
  XX____X_,
  _XXXXXX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_100[36] = { /* code 100 */
  ________,________,
  ________,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  __XXXXXX,________,
  _XXXXXXX,________,
  XXX___XX,________,
  XX____XX,________,
  XX____XX,________,
  XXX___XX,________,
  _XXXXXXX,________,
  __XXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_101[18] = { /* code 101 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXXX__,
  _XXXXXX_,
  XXX__XX_,
  XX__XX__,
  XX_XX___,
  XXX___X_,
  XXXXXXX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_102[18] = { /* code 102 */
  ________,
  ________,
  _____XXX,
  ____XXXX,
  ___XXX__,
  ___XX___,
  ___XX___,
  _XXXXXX_,
  _XXXXXX_,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_103[18] = { /* code 103 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXXX__,
  _XXXXXX_,
  XXX__XX_,
  XX___XX_,
  XX___XX_,
  XX__XXX_,
  XXXXXXX_,
  _XXX_XX_,
  _____XX_,
  ____XX__,
  XXXXXX__,
  _XXXX___};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_104[18] = { /* code 104 */
  ________,
  ________,
  XX______,
  XX______,
  XX______,
  XX______,
  XX______,
  XX_XXX__,
  XXXXXXX_,
  XXX__XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_105[18] = { /* code 105 */
  ________,
  ________,
  ________,
  _XX_____,
  _XX_____,
  ________,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_106[18] = { /* code 106 */
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  ________,
  ________,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_107[36] = { /* code 107 */
  ________,________,
  ________,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX___X_,________,
  _XX__XX_,________,
  _XX_XX__,________,
  _XXXXX__,________,
  _XXXXX__,________,
  _XX__XX_,________,
  _XX___XX,________,
  _XX___XX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_108[18] = { /* code 108 */
  ________,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_109[36] = { /* code 109 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XX_XXX_X,X_______,
  XXXXXXXX,XX______,
  XXX_XXX_,XX______,
  XX__XX__,XX______,
  XX__XX__,XX______,
  XX__XX__,XX______,
  XX__XX__,XX______,
  XX__XX__,XX______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_110[18] = { /* code 110 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  XX_XXX__,
  XXXXXXX_,
  XXX__XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_111[18] = { /* code 111 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXX___,
  _XXXXX__,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  _XXXXX__,
  __XXX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_112[36] = { /* code 112 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XX_____,________,
  _XX_XXX_,________,
  _XXXXXXX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XXXXXX_,________,
  _XXXXX__,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_113[18] = { /* code 113 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXXXX_,
  _XXXXXX_,
  XXX__XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  _XXXXXX_,
  __XXXXX_,
  _____XX_,
  _____XX_,
  _____XX_};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_114[18] = { /* code 114 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XX_XXX_,
  _XXX_XX_,
  _XX__XX_,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_115[18] = { /* code 115 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ___XXX__,
  _XXXXX__,
  XXX_____,
  XXXXX___,
  _XXXXX__,
  ____XX__,
  XXXXXX__,
  _XXXX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_116[18] = { /* code 116 */
  ________,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  __XX____,
  XXXXXX__,
  XXXXXX__,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_117[18] = { /* code 117 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XXXXXXX_,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_118[18] = { /* code 118 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  XX___XX_,
  XX___XX_,
  _XX_XX__,
  _XX_XX__,
  _XX_XX__,
  __XXX___,
  __XXX___,
  ___X____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_119[36] = { /* code 119 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XX__XX__,XX______,
  XX__XX__,XX______,
  XX__XX__,XX______,
  XX_XXXX_,XX______,
  XX_XX_X_,XX______,
  XX_XX_X_,XX______,
  _XXX__XX,X_______,
  _XXX__XX,X_______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_120[36] = { /* code 120 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XX____XX,________,
  XXX__XXX,________,
  _XXXXXX_,________,
  __XXXX__,________,
  __XXXX__,________,
  _XXXXXX_,________,
  XXX__XXX,________,
  XX____XX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_121[36] = { /* code 121 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XX____XX,________,
  XXX___XX,________,
  _XX___XX,________,
  _XXX_XX_,________,
  __XX_XX_,________,
  __XXXX__,________,
  ___XXX__,________,
  ___XX___,________,
  ___XX___,________,
  __XX____,________,
  __XX____,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_122[36] = { /* code 122 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,________,
  _XXXXXXX,________,
  _____XX_,________,
  ____XX__,________,
  ___XX___,________,
  __XX____,________,
  _XXXXXXX,________,
  _XXXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_123[18] = { /* code 123 */
  ________,
  ________,
  ___XXX__,
  __XXXX__,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  _XXX____,
  _XX_____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  ___XXX__,
  ___XXX__};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_124[18] = { /* code 124 */
  ________,
  ________,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_125[18] = { /* code 125 */
  ________,
  ________,
  XXX_____,
  XXXX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XXX___,
  ___XXX__,
  __XXX___,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  XXX_____,
  XXX_____};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_126[36] = { /* code 126 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XX___,________,
  __XXXX__,X_______,
  _XX_XX__,X_______,
  _XX__XXX,X_______,
  _X___XXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_127[18] = { /* code 127 */
  ________,
  ________,
  _XXXXXX_,
  _XXXXXX_,
  _X____X_,
  _X____X_,
  _X____X_,
  _X____X_,
  _X____X_,
  _X____X_,
  _X____X_,
  _X____X_,
  _X____X_,
  _XXXXXX_,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_ASCII_128[36] = { /* code 128 */
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XX______,
  __XXX___,________,
  XXXXXXXX,________,
  XXXXXXXX,________,
  _XX_____,________,
  XXXXXXX_,________,
  XXXXXXX_,________,
  _XX_____,________,
  _XXX___X,X_______,
  __XXXXXX,X_______,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE GUI_CHARINFO CharInfo18B_ASCII[97] = {
   {   5,   5,  1, acFontComic18B_ASCII_32 } /* code  32 */
  ,{   4,   4,  1, acFontComic18B_ASCII_33 } /* code  33 */
  ,{   8,   8,  1, acFontComic18B_ASCII_34 } /* code  34 */
  ,{  13,  13,  2, acFontComic18B_ASCII_35 } /* code  35 */
  ,{  11,  11,  2, acFontComic18B_ASCII_36 } /* code  36 */
  ,{  13,  13,  2, acFontComic18B_ASCII_37 } /* code  37 */
  ,{  10,  10,  2, acFontComic18B_ASCII_38 } /* code  38 */
  ,{   6,   6,  1, acFontComic18B_ASCII_39 } /* code  39 */
  ,{   6,   6,  1, acFontComic18B_ASCII_40 } /* code  40 */
  ,{   6,   6,  1, acFontComic18B_ASCII_41 } /* code  41 */
  ,{   9,   9,  2, acFontComic18B_ASCII_42 } /* code  42 */
  ,{   8,   8,  1, acFontComic18B_ASCII_43 } /* code  43 */
  ,{   4,   4,  1, acFontComic18B_ASCII_44 } /* code  44 */
  ,{   7,   7,  1, acFontComic18B_ASCII_45 } /* code  45 */
  ,{   4,   4,  1, acFontComic18B_ASCII_46 } /* code  46 */
  ,{   9,   9,  2, acFontComic18B_ASCII_47 } /* code  47 */
  ,{  10,  10,  2, acFontComic18B_ASCII_48 } /* code  48 */
  ,{   7,   7,  1, acFontComic18B_ASCII_49 } /* code  49 */
  ,{  10,  10,  2, acFontComic18B_ASCII_50 } /* code  50 */
  ,{  10,  10,  2, acFontComic18B_ASCII_51 } /* code  51 */
  ,{  10,  10,  2, acFontComic18B_ASCII_52 } /* code  52 */
  ,{  10,  10,  2, acFontComic18B_ASCII_53 } /* code  53 */
  ,{  10,  10,  2, acFontComic18B_ASCII_54 } /* code  54 */
  ,{  10,  10,  2, acFontComic18B_ASCII_55 } /* code  55 */
  ,{  10,  10,  2, acFontComic18B_ASCII_56 } /* code  56 */
  ,{  10,  10,  2, acFontComic18B_ASCII_57 } /* code  57 */
  ,{   5,   5,  1, acFontComic18B_ASCII_58 } /* code  58 */
  ,{   5,   5,  1, acFontComic18B_ASCII_59 } /* code  59 */
  ,{   6,   6,  1, acFontComic18B_ASCII_60 } /* code  60 */
  ,{   8,   8,  1, acFontComic18B_ASCII_61 } /* code  61 */
  ,{   7,   7,  1, acFontComic18B_ASCII_62 } /* code  62 */
  ,{   9,   9,  2, acFontComic18B_ASCII_63 } /* code  63 */
  ,{  15,  15,  2, acFontComic18B_ASCII_64 } /* code  64 */
  ,{  12,  12,  2, acFontComic18B_ASCII_65 } /* code  65 */
  ,{  10,  10,  2, acFontComic18B_ASCII_66 } /* code  66 */
  ,{  10,  10,  2, acFontComic18B_ASCII_67 } /* code  67 */
  ,{  12,  12,  2, acFontComic18B_ASCII_68 } /* code  68 */
  ,{  10,  10,  2, acFontComic18B_ASCII_69 } /* code  69 */
  ,{  10,  10,  2, acFontComic18B_ASCII_70 } /* code  70 */
  ,{  11,  11,  2, acFontComic18B_ASCII_71 } /* code  71 */
  ,{  12,  12,  2, acFontComic18B_ASCII_72 } /* code  72 */
  ,{   9,   9,  2, acFontComic18B_ASCII_73 } /* code  73 */
  ,{  11,  11,  2, acFontComic18B_ASCII_74 } /* code  74 */
  ,{  10,  10,  2, acFontComic18B_ASCII_75 } /* code  75 */
  ,{   9,   9,  2, acFontComic18B_ASCII_76 } /* code  76 */
  ,{  15,  15,  2, acFontComic18B_ASCII_77 } /* code  77 */
  ,{  13,  13,  2, acFontComic18B_ASCII_78 } /* code  78 */
  ,{  13,  13,  2, acFontComic18B_ASCII_79 } /* code  79 */
  ,{   8,   8,  1, acFontComic18B_ASCII_80 } /* code  80 */
  ,{  14,  14,  2, acFontComic18B_ASCII_81 } /* code  81 */
  ,{  11,  11,  2, acFontComic18B_ASCII_82 } /* code  82 */
  ,{  11,  11,  2, acFontComic18B_ASCII_83 } /* code  83 */
  ,{  11,  11,  2, acFontComic18B_ASCII_84 } /* code  84 */
  ,{  12,  12,  2, acFontComic18B_ASCII_85 } /* code  85 */
  ,{  10,  10,  2, acFontComic18B_ASCII_86 } /* code  86 */
  ,{  17,  17,  3, acFontComic18B_ASCII_87 } /* code  87 */
  ,{  12,  12,  2, acFontComic18B_ASCII_88 } /* code  88 */
  ,{  11,  11,  2, acFontComic18B_ASCII_89 } /* code  89 */
  ,{  12,  12,  2, acFontComic18B_ASCII_90 } /* code  90 */
  ,{   6,   6,  1, acFontComic18B_ASCII_91 } /* code  91 */
  ,{   8,   8,  1, acFontComic18B_ASCII_92 } /* code  92 */
  ,{   6,   6,  1, acFontComic18B_ASCII_93 } /* code  93 */
  ,{   8,   8,  1, acFontComic18B_ASCII_94 } /* code  94 */
  ,{  10,  10,  2, acFontComic18B_ASCII_95 } /* code  95 */
  ,{   9,   9,  2, acFontComic18B_ASCII_96 } /* code  96 */
  ,{   8,   8,  1, acFontComic18B_ASCII_97 } /* code  97 */
  ,{  10,  10,  2, acFontComic18B_ASCII_98 } /* code  98 */
  ,{   8,   8,  1, acFontComic18B_ASCII_99 } /* code  99 */
  ,{   9,   9,  2, acFontComic18B_ASCII_100 } /* code 100 */
  ,{   8,   8,  1, acFontComic18B_ASCII_101 } /* code 101 */
  ,{   8,   8,  1, acFontComic18B_ASCII_102 } /* code 102 */
  ,{   8,   8,  1, acFontComic18B_ASCII_103 } /* code 103 */
  ,{   8,   8,  1, acFontComic18B_ASCII_104 } /* code 104 */
  ,{   5,   5,  1, acFontComic18B_ASCII_105 } /* code 105 */
  ,{   6,   6,  1, acFontComic18B_ASCII_106 } /* code 106 */
  ,{   9,   9,  2, acFontComic18B_ASCII_107 } /* code 107 */
  ,{   5,   5,  1, acFontComic18B_ASCII_108 } /* code 108 */
  ,{  11,  11,  2, acFontComic18B_ASCII_109 } /* code 109 */
  ,{   8,   8,  1, acFontComic18B_ASCII_110 } /* code 110 */
  ,{   8,   8,  1, acFontComic18B_ASCII_111 } /* code 111 */
  ,{   9,   9,  2, acFontComic18B_ASCII_112 } /* code 112 */
  ,{   8,   8,  1, acFontComic18B_ASCII_113 } /* code 113 */
  ,{   8,   8,  1, acFontComic18B_ASCII_114 } /* code 114 */
  ,{   7,   7,  1, acFontComic18B_ASCII_115 } /* code 115 */
  ,{   7,   7,  1, acFontComic18B_ASCII_116 } /* code 116 */
  ,{   8,   8,  1, acFontComic18B_ASCII_117 } /* code 117 */
  ,{   8,   8,  1, acFontComic18B_ASCII_118 } /* code 118 */
  ,{  11,  11,  2, acFontComic18B_ASCII_119 } /* code 119 */
  ,{   9,   9,  2, acFontComic18B_ASCII_120 } /* code 120 */
  ,{   9,   9,  2, acFontComic18B_ASCII_121 } /* code 121 */
  ,{   9,   9,  2, acFontComic18B_ASCII_122 } /* code 122 */
  ,{   6,   6,  1, acFontComic18B_ASCII_123 } /* code 123 */
  ,{   7,   7,  1, acFontComic18B_ASCII_124 } /* code 124 */
  ,{   6,   6,  1, acFontComic18B_ASCII_125 } /* code 125 */
  ,{  10,  10,  2, acFontComic18B_ASCII_126 } /* code 126 */
  ,{   8,   8,  1, acFontComic18B_ASCII_127 } /* code 127 */
  ,{  11,  11,  2, acFontComic18B_ASCII_128 } /* code 128 */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontComic18BProp_ASCII_1 = {
   32                       /* first character               */
  ,128                      /* last character                */
  ,CharInfo18B_ASCII        /* address of first character    */
  ,(const GUI_FONT_PROP *)0 /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_FontComic18B_ASCII = {
   GUI_FONTTYPE_PROP  /* type of font    */
  ,18                 /* height of font  */
  ,18                 /* space of font y */
  ,1                  /* magnification x */
  ,1                  /* magnification y */
  ,{&GUI_FontComic18BProp_ASCII_1}
  ,15, 8, 12
};

