/*
*********************************************************************************************************
*                                                uC/GUI
*                        Universal graphic software for embedded applications
*
*                       (c) Copyright 2002, Micrium Inc., Weston, FL
*                       (c) Copyright 2002, SEGGER Microcontroller Systeme GmbH
*
*              C/GUI is protected by international copyright laws. Knowledge of the
*              source code may not be used to write a similar product. This file may
*              only be used in accordance with a license and should not be redistributed
*              in any way. We appreciate your understanding and fairness.
*
----------------------------------------------------------------------
File        : FComic24B_ASCII.C
Purpose     : Similar to Comic
Height      : 24
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI_FontIntern.h"


GUI_CONST_STORAGE unsigned char acFontComic24B_32[48] = { /* code 32 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_33[24] = { /* code 33 */
  ________,
  ________,
  ________,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  ________,
  _XX_____,
  _XXX____,
  __XX____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic24B_34[48] = { /* code 34 */
  ________,________,
  ________,________,
  ________,________,
  _XX__XX_,________,
  _XX__XX_,________,
  _XX__XX_,________,
  _XX__XX_,________,
  _XX__XX_,________,
  _XX__XX_,________,
  _XX__XX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_35[72] = { /* code 35 */
  ________,________,________,
  ________,________,________,
  ______XX,X___XXX_,________,
  ______XX,X___XXX_,________,
  ______XX,X__XXXX_,________,
  _XXXXXXX,XXXXXXXX,X_______,
  _XXXXXXX,XXXXXXXX,X_______,
  _XXXXXXX,XXXXXXXX,X_______,
  ____XXXX,__XXXX__,________,
  ____XXX_,__XXX___,________,
  ____XXX_,__XXX___,________,
  ___XXX__,__XXX___,________,
  XXXXXXXX,XXXXXXXX,________,
  XXXXXXXX,XXXXXXXX,________,
  XXXXXXXX,XXXXXXXX,________,
  __XXX___,_XXX____,________,
  _XXXX___,XXX_____,________,
  _XXX____,XXX_____,________,
  _XXX____,XXX_____,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_36[48] = { /* code 36 */
  ______XX,X_______,
  ______XX,X_______,
  ______XX,X_______,
  _____XXX,XXX_____,
  ___XXXXX,XXXXX___,
  __XXXXXX,XXXXX___,
  __XXX_XX,X_______,
  _XXX__XX,X_______,
  _XXX__XX,X_______,
  _XXXXXXX,XXX_____,
  __XXXXXX,XXXXX___,
  ____XXXX,XXXXX___,
  ______XX,X_XXXX__,
  ______XX,X__XXX__,
  ______XX,X__XXX__,
  ______XX,X__XXX__,
  _XXX__XX,X_XXXX__,
  _XXXXXXX,XXXXX___,
  _XXXXXXX,XXXX____,
  __XXXXXX,XX______,
  ______XX,X_______,
  ______XX,X_______,
  ______XX,X_______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_37[72] = { /* code 37 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXX__,___XX___,________,
  _XXXXXX_,__XXX___,________,
  XXXXXXXX,_XXX____,________,
  XXX__XXX,_XXX____,________,
  XXX__XXX,XXX_____,________,
  XXXXXXXX,XXX_____,________,
  _XXXXXXX,XX______,________,
  __XXXX_X,XX______,________,
  ______XX,X__XXXX_,________,
  ______XX,X_XXXXXX,________,
  _____XXX,_XXXXXXX,X_______,
  _____XXX,_XXX__XX,X_______,
  ____XXX_,_XXX__XX,X_______,
  ____XX__,_XXXXXXX,X_______,
  ___XXX__,__XXXXXX,________,
  ___XX___,___XXXX_,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_38[48] = { /* code 38 */
  ________,________,
  ________,________,
  ________,________,
  ______XX,XX______,
  _____XXX,XXX_____,
  ____XXXX,XXX_____,
  ____XXX_,XXX_____,
  ____XXX_,XXX_____,
  ____XXXX,XX______,
  _____XXX,X_______,
  ___XXXXX,X_XXX___,
  __XXXXXX,X_XXX___,
  _XXXX_XX,XXXXX___,
  XXXX___X,XXXXX___,
  XXX_____,XXXXX___,
  XXX_____,XXXX____,
  XXXX___X,XXXXX___,
  _XXXXXXX,XXXXX___,
  _XXXXXXX,XXXXXX__,
  ___XXXXX,___XXX__,
  ________,___XXX__,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_39[48] = { /* code 39 */
  ________,________,
  ________,________,
  ________,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_40[24] = { /* code 40 */
  ________,
  ________,
  ________,
  _____XXX,
  ____XXXX,
  ___XXXX_,
  ___XXX__,
  __XXX___,
  __XXX___,
  __XXX___,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  __XXX___,
  __XXX___,
  __XXXX__,
  ___XXXX_,
  ____XXXX,
  _____XXX,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic24B_41[24] = { /* code 41 */
  ________,
  ________,
  ________,
  XXX_____,
  XXXX____,
  _XXXX___,
  __XXX___,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  ___XXX__,
  ___XXX__,
  __XXXX__,
  _XXXX___,
  XXXX____,
  XXX_____,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic24B_42[48] = { /* code 42 */
  ________,________,
  ________,________,
  ________,________,
  ____XXX_,________,
  ____XXX_,________,
  XXX_XXXX,XXX_____,
  XXXXXXXX,XXX_____,
  __XXXXXX,X_______,
  __XXXXXX,X_______,
  _XXXX_XX,XX______,
  _XXX___X,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_43[48] = { /* code 43 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_44[48] = { /* code 44 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XX__,________,
  ___XXX__,________,
  ___XX___,________,
  __XXX___,________,
  __XX____,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_45[48] = { /* code 45 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,XX______,
  __XXXXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_46[48] = { /* code 46 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_47[48] = { /* code 47 */
  ________,________,
  ________,________,
  ________,________,
  ________,XX______,
  _______X,XX______,
  _______X,XX______,
  ______XX,X_______,
  ______XX,X_______,
  _____XXX,________,
  _____XXX,________,
  ____XXX_,________,
  ____XXX_,________,
  ___XXX__,________,
  ___XXX__,________,
  __XXX___,________,
  _XXX____,________,
  _XXX____,________,
  XXX_____,________,
  XXX_____,________,
  XX______,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_48[48] = { /* code 48 */
  ________,________,
  ________,________,
  ________,________,
  _____XXX,X_______,
  ___XXXXX,XX______,
  __XXXXXX,XXX_____,
  __XXX___,XXX_____,
  __XXX___,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXXXXX,XXX_____,
  ___XXXXX,XX______,
  ____XXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_49[48] = { /* code 49 */
  ________,________,
  ________,________,
  ________,________,
  _____XXX,________,
  ____XXXX,________,
  ___XXXXX,________,
  __XXXXXX,________,
  __XXXXXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_50[48] = { /* code 50 */
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XX______,
  ____XXXX,XXX_____,
  ___XXXXX,XXXX____,
  __XXXX__,_XXX____,
  __XX____,_XXX____,
  ________,_XXX____,
  ________,XXX_____,
  ______XX,XXX_____,
  _____XXX,XX______,
  ____XXXX,________,
  ___XXXX_,________,
  __XXXX__,________,
  __XXX___,________,
  __XXXXXX,XXX_____,
  __XXXXXX,XXXX____,
  __XXXXXX,XXXX____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_51[48] = { /* code 51 */
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,X_______,
  ___XXXXX,XXX_____,
  __XXXXXX,XXXX____,
  __XXX___,_XXX____,
  ________,_XXX____,
  ________,XXXX____,
  ____XXXX,XXX_____,
  ____XXXX,XX______,
  ____XXXX,XXX_____,
  _______X,XXXX____,
  ________,_XXX____,
  ________,_XXX____,
  __XX____,_XXX____,
  __XXX___,XXXX____,
  __XXXXXX,XXX_____,
  ___XXXXX,XX______,
  ____XXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_52[48] = { /* code 52 */
  ________,________,
  ________,________,
  ________,________,
  _______X,XX______,
  _______X,XX______,
  ______XX,XX______,
  _____XXX,XX______,
  ____XXXX,XX______,
  ____XX_X,XX______,
  ___XX__X,XX______,
  __XX___X,XX______,
  _XX____X,XX______,
  XXXXXXXX,XXX_____,
  XXXXXXXX,XXXX____,
  XXXXXXXX,XXX_____,
  _______X,XX______,
  _______X,XX______,
  _______X,XX______,
  _______X,XX______,
  ________,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_53[48] = { /* code 53 */
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  __XXXXXX,XX______,
  __XX____,________,
  __XXXXXX,X_______,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  _XXXX___,XXXX____,
  _XXX____,_XXX____,
  ________,_XXX____,
  ________,_XXX____,
  ________,_XXX____,
  _XX_____,XXXX____,
  _XXX___X,XXX_____,
  _XXXXXXX,XXX_____,
  __XXXXXX,XX______,
  ___XXXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_54[48] = { /* code 54 */
  ________,________,
  ________,________,
  ________,________,
  ______XX,________,
  _____XXX,X_______,
  ____XXXX,________,
  ___XXXX_,________,
  __XXXX__,________,
  __XXX___,________,
  __XXXXXX,X_______,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  _XXXX___,XXXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXXX___,XXXX____,
  __XXXXXX,XXX_____,
  ___XXXXX,XX______,
  ____XXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_55[48] = { /* code 55 */
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXXXX___,
  _XXXXXXX,XXXXX___,
  _XXXXXXX,XXXX____,
  ________,XXXX____,
  _______X,XXX_____,
  ______XX,XX______,
  ______XX,XX______,
  ______XX,X_______,
  _____XXX,X_______,
  _____XXX,________,
  ____XXXX,________,
  ____XXX_,________,
  ____XXX_,________,
  ___XXXX_,________,
  ___XXX__,________,
  ___XXX__,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_56[48] = { /* code 56 */
  ________,________,
  ________,________,
  ________,________,
  _____XXX,X_______,
  ___XXXXX,XX______,
  __XXXXXX,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXXXXX,XX______,
  ___XXXXX,X_______,
  __XXXXXX,XXX_____,
  __XXX___,XXX_____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXXX___,XXXX____,
  _XXXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  ____XXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_57[48] = { /* code 57 */
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,X_______,
  ___XXXXX,XX______,
  __XXXXXX,XXX_____,
  _XXXX___,XXXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXXX___,XXXX____,
  __XXXXXX,XXXX____,
  __XXXXXX,XXX_____,
  ____XXXX,XXX_____,
  _______X,XX______,
  _____XXX,XX______,
  __XXXXXX,X_______,
  __XXXXX_,________,
  __XXX___,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_58[48] = { /* code 58 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_59[48] = { /* code 59 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XX__,________,
  ___XXX__,________,
  __XXX___,________,
  __XXX___,________,
  __XX____,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_60[48] = { /* code 60 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _______X,X_______,
  ______XX,X_______,
  ____XXXX,________,
  ___XXXX_,________,
  __XXXX__,________,
  __XXXXX_,________,
  ____XXXX,________,
  _____XXX,X_______,
  ______XX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_61[48] = { /* code 61 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  ________,________,
  ________,________,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_62[48] = { /* code 62 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXX__,________,
  ___XXXX_,________,
  ____XXXX,________,
  _____XXX,X_______,
  ______XX,XXX_____,
  _______X,XXX_____,
  ______XX,XX______,
  ____XXXX,X_______,
  ___XXXX_,________,
  ___XXX__,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_63[48] = { /* code 63 */
  ________,________,
  ________,________,
  ________,________,
  ___XXXXX,________,
  __XXXXXX,X_______,
  _XXXXXXX,XX______,
  _XXX___X,XXX_____,
  ________,XXX_____,
  ________,XXX_____,
  ________,XXX_____,
  ______XX,XX______,
  _____XXX,X_______,
  ____XXXX,________,
  ___XXXX_,________,
  ___XXX__,________,
  ________,________,
  ___XX___,________,
  __XXX___,________,
  __XXX___,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_64[72] = { /* code 64 */
  ________,________,________,
  ________,________,________,
  _______X,XXXXX___,________,
  _____XXX,XXXXXXXX,________,
  ____XXXX,XXXXXXXX,X_______,
  ___XXXX_,_____XXX,XX______,
  __XXXX__,XXXX___X,XX______,
  __XXX__X,XXX_____,XXX_____,
  _XXX__XX,X_______,XXX_____,
  _XXX_XXX,___XX___,XXX_____,
  _XXX_XXX,__XXX___,XXX_____,
  _XXX_XXX,XXXXXXXX,XXX_____,
  _XXX__XX,XXXXXXXX,XX______,
  _XXX___X,XX__XXXX,X_______,
  __XXX___,________,________,
  __XXXX__,________,________,
  ___XXXX_,_____XX_,________,
  ____XXXX,XXXXXXXX,________,
  _____XXX,XXXXXXX_,________,
  _______X,XXXXX___,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_65[48] = { /* code 65 */
  ________,________,
  ________,________,
  ________,________,
  ________,_XX_____,
  ________,XXX_____,
  ________,XXX_____,
  _______X,XXX_____,
  ______XX,XXXX____,
  ______XX,XXXX____,
  _____XXX,_XXX____,
  _____XXX,_XXX____,
  ____XXX_,_XXX____,
  ____XXXX,XXXX____,
  ___XXXXX,XXXXX___,
  __XXXXXX,XXXXX___,
  __XXX___,__XXX___,
  __XXX___,__XXX___,
  _XXXX___,___XXX__,
  _XXX____,___XXX__,
  _XXX____,____XX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_66[48] = { /* code 66 */
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,________,
  _XXXXXXX,X_______,
  _XXXXXXX,XX______,
  _XXX___X,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX___X,XXX_____,
  _XXXXXXX,XX______,
  _XXXXXXX,XX______,
  _XXXXXXX,XXX_____,
  _XXX____,XXXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX___X,XXXX____,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XX______,
  __XXXXX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_67[48] = { /* code 67 */
  ________,________,
  ________,________,
  ________,________,
  _______X,XXXXX___,
  ______XX,XXXXX___,
  _____XXX,XXXXX___,
  ____XXXX,__XXX___,
  ___XXXX_,___XX___,
  ___XXX__,________,
  __XXX___,________,
  __XXX___,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,__XX____,
  _XXXX___,XXXX____,
  __XXXXXX,XXXX____,
  ___XXXXX,XX______,
  ____XXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_68[48] = { /* code 68 */
  ________,________,
  ________,________,
  ________,________,
  __XX____,________,
  _XXXXX__,________,
  _XXXXXXX,X_______,
  _XXX_XXX,XX______,
  _XXX___X,XXX_____,
  _XXX____,_XXX____,
  _XXX____,__XXX___,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,__XXX___,
  _XXX____,_XXXX___,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXX_____,
  ___XXXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_69[48] = { /* code 69 */
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXX_____,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXX_____,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXXXXXX,XXX_____,
  __XXXXXX,XXXX____,
  ___XXXXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_70[48] = { /* code 70 */
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XX______,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXX_____,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXXXXXX,XX______,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XX______,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  __X_____,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_71[48] = { /* code 71 */
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XX______,
  ____XXXX,XXX_____,
  ___XXXXX,XXXX____,
  __XXXX__,_XXX____,
  __XXXX__,________,
  _XXXX___,________,
  _XXX____,________,
  _XXX__XX,XXXXXX__,
  XXX_XXXX,XXXXXX__,
  XXX_XXXX,XXXXX___,
  XXX_____,__XXX___,
  XXX_____,_XXX____,
  XXX_____,_XXX____,
  XXXX___X,XXXX____,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XX______,
  ___XXXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_72[48] = { /* code 72 */
  ________,________,
  ________,________,
  ________,________,
  ___X____,_____X__,
  __XXX___,____XXX_,
  __XXX___,____XXX_,
  __XXX___,____XXX_,
  __XXX___,____XXX_,
  __XXX___,____XXX_,
  __XXX___,____XXX_,
  __XXX___,XXXXXXX_,
  __XXXXXX,XXXXXXX_,
  __XXXXXX,XXXXXXX_,
  __XXXXXX,____XXX_,
  __XXX___,____XXX_,
  __XXX___,____XXX_,
  __XXX___,____XXX_,
  __XXX___,____XXX_,
  __XXX___,____XXX_,
  ___X____,_____X__,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_73[48] = { /* code 73 */
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XX______,
  XXXXXXXX,XXX_____,
  _XXXXXXX,XX______,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  _XXXXXXX,XX______,
  XXXXXXXX,XXX_____,
  _XXXXXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_74[48] = { /* code 74 */
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,XXXX____,
  ___XXXXX,XXXXX___,
  ____XXXX,XXXX____,
  _______X,XX______,
  _______X,XX______,
  _______X,XX______,
  _______X,XX______,
  _______X,XX______,
  _______X,XX______,
  _______X,XX______,
  _X____XX,XX______,
  XXX___XX,XX______,
  XXX___XX,X_______,
  XXXX__XX,X_______,
  _XXXXXXX,X_______,
  __XXXXXX,X_______,
  ____XXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_75[48] = { /* code 75 */
  ________,________,
  ________,________,
  ________,________,
  __X_____,_XX_____,
  _XXX____,XXX_____,
  _XXX___X,XX______,
  _XXX__XX,XX______,
  _XXX__XX,X_______,
  _XXX_XXX,________,
  _XXXXXX_,________,
  _XXXXX__,________,
  _XXXX___,________,
  _XXXXX__,________,
  _XXXXXX_,________,
  _XXXXXXX,________,
  _XXX_XXX,X_______,
  _XXX__XX,XXX_____,
  _XXX____,XXXX____,
  _XXX____,_XXX____,
  __X_____,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_76[48] = { /* code 76 */
  ________,________,
  ________,________,
  ________,________,
  __X_____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,XXX_____,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXX_____,
  __XXXXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_77[72] = { /* code 77 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ____XX__,____X___,________,
  ___XXX__,___XXX__,________,
  ___XXXX_,___XXX__,________,
  ___XXXX_,___XXX__,________,
  __XXXXX_,__XXXXX_,________,
  __XXXXX_,__XXXXX_,________,
  __XXXXX_,__XXXXX_,________,
  __XXXXXX,__XXXXX_,________,
  __XX_XXX,_XXXXXX_,________,
  _XXX_XXX,_XXX_XX_,________,
  _XXX_XXX,XXXX_XXX,________,
  _XXX__XX,XXX__XXX,________,
  XXXX__XX,XXX__XXX,________,
  XXX___XX,XXX___XX,________,
  XXX____X,XXX___XX,X_______,
  XXX____X,XX____XX,X_______,
  XXX____X,XX_____X,X_______,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_78[72] = { /* code 78 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _XXX____,_____XX_,________,
  _XXX____,_____XXX,________,
  _XXXX___,_____XXX,________,
  _XXXXX__,_____XXX,________,
  _XXXXX__,_____XXX,________,
  _XXXXXX_,_____XXX,________,
  _XXX_XXX,_____XXX,________,
  _XXX_XXX,X____XXX,________,
  _XXX__XX,X____XXX,________,
  _XXX___X,XX___XXX,________,
  _XXX____,XXX__XXX,________,
  _XXX____,_XXX_XXX,________,
  _XXX____,__XXXXXX,________,
  _XXX____,__XXXXXX,________,
  _XXX____,___XXXXX,________,
  _XXX____,____XXXX,________,
  __X_____,______X_,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_79[72] = { /* code 79 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ______XX,XXXX____,________,
  _____XXX,XXXXXX__,________,
  ____XXXX,XXXXXXX_,________,
  ___XXXX_,____XXX_,________,
  __XXXX__,_____XXX,________,
  __XXX___,_____XXX,________,
  __XXX___,_____XXX,________,
  _XXX____,_____XXX,________,
  _XXX____,_____XXX,________,
  _XXX____,_____XXX,________,
  _XXX____,____XXX_,________,
  _XXX____,____XXX_,________,
  _XXXX___,___XXXX_,________,
  __XXXX__,__XXXX__,________,
  ___XXXXX,XXXXX___,________,
  ____XXXX,XXXX____,________,
  _____XXX,XXX_____,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_80[48] = { /* code 80 */
  ________,________,
  ________,________,
  ________,________,
  _XXXXXX_,________,
  XXXXXXXX,________,
  XXXXXXXX,X_______,
  XXX___XX,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXX___XX,XX______,
  XXXXXXXX,X_______,
  XXXXXXXX,________,
  XXXXXXX_,________,
  XXX_____,________,
  XXX_____,________,
  XXX_____,________,
  XXX_____,________,
  XXX_____,________,
  XXX_____,________,
  _X______,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_81[72] = { /* code 81 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ______XX,XXXX____,________,
  ____XXXX,XXXXXX__,________,
  ___XXXXX,XXXXXXX_,________,
  __XXXXX_,___XXXXX,________,
  _XXXX___,_____XXX,________,
  _XXX____,_____XXX,X_______,
  XXX_____,______XX,X_______,
  XXX_____,______XX,X_______,
  XXX_____,______XX,X_______,
  XXX_____,______XX,X_______,
  XXX____X,XX____XX,X_______,
  XXXX___X,XX___XXX,X_______,
  _XXXX__X,XXX_XXXX,________,
  __XXXX__,XXXXXXX_,________,
  __XXXXXX,XXXXXX__,________,
  ____XXXX,XXXXXXX_,________,
  _____XXX,XXX_XXXX,________,
  ________,_____XXX,X_______,
  ________,______XX,XX______,
  ________,_______X,XX______,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_82[48] = { /* code 82 */
  ________,________,
  ________,________,
  ________,________,
  __XXXXX_,________,
  _XXXXXXX,X_______,
  _XXXXXXX,XX______,
  _XXX__XX,XXX_____,
  _XXX____,XXXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXX___X,XXXX____,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XX______,
  _XXXXXXX,X_______,
  _XXX_XXX,XXX_____,
  _XXX____,XXXX____,
  _XXX____,_XXXX___,
  _XXX____,__XXX___,
  __X_____,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_83[48] = { /* code 83 */
  ________,________,
  ________,________,
  ________,________,
  ______XX,XXX_____,
  ____XXXX,XXXXX___,
  ___XXXXX,XXXXX___,
  ___XXX__,________,
  __XXX___,________,
  __XXX___,________,
  __XXXXXX,XXX_____,
  ___XXXXX,XXXXX___,
  ____XXXX,XXXXX___,
  ________,__XXXX__,
  ________,___XXX__,
  ________,___XXX__,
  _XXX____,__XXXX__,
  _XXXX___,_XXXXX__,
  _XXXXXXX,XXXXX___,
  __XXXXXX,XXXX____,
  ___XXXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_84[48] = { /* code 84 */
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXXXXX__,
  XXXXXXXX,XXXXXXX_,
  _XXXXXXX,XXXXXX__,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  ______X_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_85[48] = { /* code 85 */
  ________,________,
  ________,________,
  ________,________,
  __X_____,____X___,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXXX___,__XXX___,
  __XXX___,_XXX____,
  __XXXXXX,XXX_____,
  ___XXXXX,XXX_____,
  ____XXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_86[48] = { /* code 86 */
  ________,________,
  ________,________,
  ________,________,
  _XXX____,__XXX___,
  _XXX____,_XXXX___,
  _XXX____,_XXXX___,
  _XXX____,_XXX____,
  __XXX___,XXXX____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX__X,XX______,
  ___XX__X,XX______,
  ___XXX_X,XX______,
  ___XXXXX,X_______,
  ____XXXX,X_______,
  ____XXXX,X_______,
  ____XXXX,________,
  ____XXXX,________,
  _____XX_,________,
  _____XX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_87[72] = { /* code 87 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _XXX____,__XX____,__XXX___,
  _XXX____,_XXX____,__XXX___,
  _XXXX___,_XXX____,_XXXX___,
  __XXX___,_XXX____,_XXX____,
  __XXX___,XXXXX___,_XXX____,
  __XXX___,XXXXX___,XXXX____,
  ___XXX__,XXXXX___,XXX_____,
  ___XXX_X,XXXXX___,XXX_____,
  ___XXX_X,XX_XX__X,XX______,
  ____XX_X,XX_XX__X,XX______,
  ____XX_X,X__XXX_X,X_______,
  ____XXXX,X__XXXXX,X_______,
  ____XXXX,X__XXXXX,X_______,
  _____XXX,___XXXXX,________,
  _____XXX,____XXXX,________,
  _____XXX,____XXX_,________,
  _____XXX,____XXX_,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_88[48] = { /* code 88 */
  ________,________,
  ________,________,
  ________,________,
  _XXX____,___XXX__,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  __XXXX__,_XXXX___,
  ___XXXX_,XXXX____,
  ____XXX_,XXX_____,
  ____XXXX,XXX_____,
  _____XXX,XX______,
  ______XX,X_______,
  _____XXX,XX______,
  ____XXXX,XXX_____,
  ___XXXX_,XXX_____,
  __XXXX__,XXXX____,
  _XXXX___,_XXXX___,
  XXXXX___,__XXXX__,
  XXXX____,__XXXX__,
  XXX_____,___XXX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_89[48] = { /* code 89 */
  ________,________,
  ________,________,
  ________,________,
  XXX_____,__XXX___,
  XXX_____,__XXX___,
  XXXX____,_XXXX___,
  _XXX____,_XXX____,
  _XXXX___,XXXX____,
  __XXX___,XXX_____,
  ___XXX_X,XXX_____,
  ___XXX_X,XX______,
  ____XXXX,XX______,
  ____XXXX,X_______,
  _____XXX,X_______,
  _____XXX,________,
  ____XXXX,________,
  ____XXX_,________,
  ___XXXX_,________,
  ___XXX__,________,
  ___XXX__,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_90[48] = { /* code 90 */
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXXXX___,
  XXXXXXXX,XXXXXX__,
  _XXXXXXX,XXXXX___,
  _______X,XXXX____,
  ______XX,XXX_____,
  ______XX,XX______,
  _____XXX,X_______,
  _____XXX,________,
  ____XXXX,________,
  ___XXXX_,________,
  ___XXX__,________,
  __XXXX__,________,
  __XXX___,________,
  _XXX____,________,
  _XXXXXXX,XXXXX___,
  XXXXXXXX,XXXXXX__,
  _XXXXXXX,XXXXX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_91[24] = { /* code 91 */
  ________,
  ________,
  ________,
  _XXXXXX_,
  _XXXXXX_,
  _XXXXXX_,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXXXXX_,
  _XXXXXX_,
  _XXXXXX_,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic24B_92[48] = { /* code 92 */
  ________,________,
  ________,________,
  ________,________,
  __XX____,________,
  __XXX___,________,
  __XXXX__,________,
  ___XXX__,________,
  ____XX__,________,
  ____XXX_,________,
  ____XXX_,________,
  _____XXX,________,
  _____XXX,________,
  ______XX,________,
  ______XX,X_______,
  ______XX,X_______,
  _______X,XX______,
  _______X,XX______,
  ________,XXX_____,
  ________,XXX_____,
  ________,_XX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_93[24] = { /* code 93 */
  ________,
  ________,
  ________,
  _XXXXXX_,
  _XXXXXX_,
  _XXXXXX_,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  _XXXXXX_,
  _XXXXXX_,
  _XXXXXX_,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic24B_94[48] = { /* code 94 */
  ________,________,
  ________,________,
  _____XX_,________,
  ____XXXX,________,
  __XXXXXX,X_______,
  _XXXX__X,XX______,
  _XXX____,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_95[48] = { /* code 95 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XXXXXXXX,XXXXX___,
  XXXXXXXX,XXXXX___,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_96[48] = { /* code 96 */
  ________,________,
  ________,________,
  _XX_____,________,
  _XXX____,________,
  __XXX___,________,
  ___XXX__,________,
  ____XX__,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_97[48] = { /* code 97 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,________,
  ___XXXXX,XX______,
  __XXXXXX,XX______,
  __XXX__X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  ___XXXX_,_XX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_98[48] = { /* code 98 */
  ________,________,
  ________,________,
  ________,________,
  __XX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX_XXX,________,
  _XXXXXXX,XX______,
  _XXXXXXX,XX______,
  _XXXX__X,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX___X,XXX_____,
  _XXXXXXX,XX______,
  _XXXXXXX,X_______,
  _XXXXXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_99[48] = { /* code 99 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,________,
  __XXXXXX,XX______,
  __XXXXXX,XX______,
  _XXXX___,XX______,
  XXXX____,________,
  XXX_____,________,
  XXX_____,________,
  XXX_____,________,
  XXXX___X,XX______,
  _XXXXXXX,XX______,
  _XXXXXXX,X_______,
  ___XXXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_100[48] = { /* code 100 */
  ________,________,
  ________,________,
  ________,________,
  ________,_X______,
  ________,XXX_____,
  ________,XXX_____,
  ________,XXX_____,
  ________,XXX_____,
  ____XXXX,XXX_____,
  ___XXXXX,XXX_____,
  __XXXXXX,XXX_____,
  _XXXX___,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXXX__X,XXX_____,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  ____XXXX,_XX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_101[48] = { /* code 101 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,X_______,
  __XXXXXX,XX______,
  _XXXXXXX,XXX_____,
  _XXX____,XXX_____,
  XXXX__XX,XXX_____,
  XXX_XXXX,XX______,
  XXXXXXXX,________,
  XXXXXX__,________,
  XXXX____,XXX_____,
  _XXXXXXX,XXX_____,
  __XXXXXX,XX______,
  ___XXXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_102[48] = { /* code 102 */
  ________,________,
  ________,________,
  ________,________,
  _____XXX,X_______,
  ____XXXX,XX______,
  ____XXXX,X_______,
  ___XXXX_,________,
  ___XXX__,________,
  _XXXXXXX,X_______,
  XXXXXXXX,XX______,
  _XXXXXXX,X_______,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ____X___,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_103[48] = { /* code 103 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,________,
  __XXXXXX,XX______,
  _XXXXXXX,XX______,
  _XXX___X,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXX____X,X_______,
  XXX___XX,X_______,
  XXX___XX,X_______,
  XXXXXXXX,X_______,
  _XXXXXXX,X_______,
  __XXX_XX,X_______,
  ______XX,X_______,
  _____XXX,X_______,
  XXXXXXXX,________,
  _XXXXXX_,________, 
  ___XXX__,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_104[48] = { /* code 104 */
  ________,________,
  ________,________,
  ________,________,
  __X_____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX_XXX,XX______,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  _XXXXX__,XXX_____,
  _XXXX___,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  __X_____,_X______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_105[24] = { /* code 105 */
  ________,
  ________,
  ________,
  _XXX____,
  _XXX____,
  _XXX____,
  ________,
  ________,
  __X_____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  __X_____,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic24B_106[24] = { /* code 106 */
  ________,
  ________,
  ________,
  ________,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ________,
  ____X___,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  X___XXX_,
  XX__XXX_,
  XXX_XXX_,
  XXXXXXX_,
  __XXXX__};

GUI_CONST_STORAGE unsigned char acFontComic24B_107[48] = { /* code 107 */
  ________,________,
  ________,________,
  ________,________,
  _X______,________,
  XXX_____,________,
  XXX_____,________,
  XXX_____,________,
  XXX_____,________,
  XXX____X,XX______,
  XXX___XX,XX______,
  XXX__XXX,X_______,
  XXX_XXXX,________,
  XXXXXXX_,________,
  XXXXXXX_,________,
  XXXXXXXX,________,
  XXX__XXX,X_______,
  XXX___XX,X_______,
  XXX___XX,XX______,
  XXX____X,XX______,
  _X______,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_108[24] = { /* code 108 */
  ________,
  ________,
  ________,
  __X_____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  __X_____,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic24B_109[48] = { /* code 109 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XX__XXX,__XXXX__,
  XXXXXXXX,XXXXXXX_,
  XXXXXXXX,XXXXXXX_,
  XXXXX_XX,XX__XXX_,
  XXXX__XX,X___XXX_,
  XXX___XX,X___XXX_,
  XXX___XX,X___XXX_,
  XXX___XX,X___XXX_,
  XXX___XX,X___XXX_,
  XXX___XX,X___XXX_,
  XXX___XX,X___XXX_,
  _X_____X,_____X__,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_110[48] = { /* code 110 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX_XXX,X_______,
  _XXXXXXX,X_______,
  _XXXXXXX,XX______,
  _XXXXX_X,XX______,
  _XXXX__X,XX______,
  _XXXX__X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  __X_____,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_111[48] = { /* code 111 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXXX,________,
  __XXXXXX,X_______,
  _XXXXXXX,X_______,
  _XXX__XX,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXXX__XX,XX______,
  _XXXXXXX,X_______,
  _XXXXXXX,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_112[48] = { /* code 112 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XX_XXXX,________,
  XXXXXXXX,X_______,
  XXXXXXXX,X_______,
  XXXX___X,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXX___XX,XX______,
  XXXXXXXX,X_______,
  XXXXXXXX,X_______,
  XXXXXXX_,________,
  XXX_____,________,
  XXX_____,________,
  XXX_____,________,
  XXX_____,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_113[48] = { /* code 113 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,XX______,
  __XXXXXX,XX______,
  _XXXXXXX,XX______,
  _XXXX__X,XX______,
  XXXX___X,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXXX___X,XX______,
  _XXXXXXX,XX______,
  _XXXXXXX,XX______,
  ___XXXXX,XX______,
  _______X,XX______,
  _______X,XX______,
  _______X,XX______,
  _______X,XX______};

GUI_CONST_STORAGE unsigned char acFontComic24B_114[48] = { /* code 114 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX_XXX,X_______,
  _XXXXXXX,XX______,
  _XXXXXXX,XX______,
  _XXXXX_X,XX______,
  _XXX___X,XX______,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  __X_____,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_115[48] = { /* code 115 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,X_______,
  _XXXXXXX,X_______,
  XXXXXXXX,X_______,
  XXX____X,X_______,
  XXXX____,________,
  _XXXXX__,________,
  ___XXXXX,________,
  _____XXX,X_______,
  XXX___XX,X_______,
  XXXXXXXX,X_______,
  XXXXXXXX,________,
  __XXXXX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_116[48] = { /* code 116 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____X___,________,
  ___XXX__,________,
  ___XXX__,________,
  _XXXXXXX,________,
  XXXXXXXX,X_______,
  _XXXXXXX,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ____X___,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_117[48] = { /* code 117 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __X_____,X_______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXXXXXX,XX______,
  __XXXXXX,XX______,
  ___XXXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_118[48] = { /* code 118 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XXX_____,XX______,
  XXX_____,XX______,
  XXXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  __XXX_XX,X_______,
  __XXX_XX,X_______,
  ___XXXXX,________,
  ___XXXXX,________,
  ___XXXXX,________,
  ____XXX_,________,
  ____XXX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_119[48] = { /* code 119 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX__XX,X__XXX__,
  _XXX__XX,X__XXX__,
  _XXX__XX,X__XXX__,
  _XXX_XXX,X__XXX__,
  _XXX_XXX,X_XXX___,
  __XX_XXX,XXXXX___,
  __XXXXXX,XXXXX___,
  __XXXXX_,XXXXX___,
  __XXXX__,XXXX____,
  __XXXX__,XXXX____,
  ___XX___,XXXX____,
  ___XX___,_XX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_120[48] = { /* code 120 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXX__,_XXX____,
  __XXXX__,_XXX____,
  __XXXX__,XXXX____,
  ___XXXXX,XXX_____,
  ____XXXX,XX______,
  _____XXX,X_______,
  ____XXXX,X_______,
  ___XXXXX,XX______,
  __XXXX_X,XXX_____,
  _XXXXX__,XXX_____,
  _XXXX___,XXXX____,
  _XXX____,_XXX____,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_121[48] = { /* code 121 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXXX___,XXXX____,
  __XXX___,XXX_____,
  __XXXX_X,XXX_____,
  ___XXX_X,XX______,
  ___XXXXX,XX______,
  ____XXXX,X_______,
  ____XXXX,X_______,
  _____XXX,X_______,
  _____XXX,________,
  ____XXXX,________,
  ____XXX_,________,
  ____XXX_,________,
  ___XXXX_,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_122[48] = { /* code 122 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XX______,
  XXXXXXXX,XX______,
  _XXXXXXX,XX______,
  ______XX,X_______,
  _____XXX,________,
  ____XXX_,________,
  ___XXXX_,________,
  ___XXX__,________,
  __XXX___,________,
  _XXXXXXX,X_______,
  XXXXXXXX,XX______,
  XXXXXXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_123[24] = { /* code 123 */
  ________,
  ________,
  ________,
  ___XXX__,
  __XXXXX_,
  _XXXXXX_,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  XXX_____,
  XX______,
  XXX_____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  __XXXXX_,
  __XXXXX_,
  ___XXXX_,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic24B_124[48] = { /* code 124 */
  ________,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_125[24] = { /* code 125 */
  ________,
  ________,
  ________,
  _XXX____,
  XXXXX___,
  XXXXXX__,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ____XXXX,
  _____XXX,
  ____XXX_,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  XXXXX___,
  XXXXX___,
  XXXX____,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic24B_126[48] = { /* code 126 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXX__,__XX____,
  _XXXXXX_,_XXX____,
  _XXX_XXX,_XXX____,
  XXX___XX,XXX_____,
  XX_____X,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_127[48] = { /* code 127 */
  ________,________,
  ________,________,
  _XXXXXXX,X_______,
  _XXXXXXX,X_______,
  _XX_____,X_______,
  _XX_____,X_______,
  _XX_____,X_______,
  _XX_____,X_______,
  _XX_____,X_______,
  _XX_____,X_______,
  _XX_____,X_______,
  _XX_____,X_______,
  _XX_____,X_______,
  _XX_____,X_______,
  _XX_____,X_______,
  _XX_____,X_______,
  _XX_____,X_______,
  _XX_____,X_______,
  _XXXXXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};




GUI_CONST_STORAGE GUI_CHARINFO CharInfo24B_ASCII[96] = {
   {   9,   9,  2, acFontComic24B_32 } /* code  32 */
  ,{   5,   5,  1, acFontComic24B_33 } /* code  33 */
  ,{   9,   9,  2, acFontComic24B_34 } /* code  34 */
  ,{  18,  18,  3, acFontComic24B_35 } /* code  35 */
  ,{  15,  15,  2, acFontComic24B_36 } /* code  36 */
  ,{  17,  17,  3, acFontComic24B_37 } /* code  37 */
  ,{  14,  14,  2, acFontComic24B_38 } /* code  38 */
  ,{   9,   9,  2, acFontComic24B_39 } /* code  39 */
  ,{   8,   8,  1, acFontComic24B_40 } /* code  40 */
  ,{   8,   8,  1, acFontComic24B_41 } /* code  41 */
  ,{  11,  11,  2, acFontComic24B_42 } /* code  42 */
  ,{  13,  13,  2, acFontComic24B_43 } /* code  43 */
  ,{   9,   9,  2, acFontComic24B_44 } /* code  44 */
  ,{  13,  13,  2, acFontComic24B_45 } /* code  45 */
  ,{   9,   9,  2, acFontComic24B_46 } /* code  46 */
  ,{  11,  11,  2, acFontComic24B_47 } /* code  47 */
  ,{  13,  13,  2, acFontComic24B_48 } /* code  48 */
  ,{  13,  13,  2, acFontComic24B_49 } /* code  49 */
  ,{  13,  13,  2, acFontComic24B_50 } /* code  50 */
  ,{  13,  13,  2, acFontComic24B_51 } /* code  51 */
  ,{  13,  13,  2, acFontComic24B_52 } /* code  52 */
  ,{  13,  13,  2, acFontComic24B_53 } /* code  53 */
  ,{  13,  13,  2, acFontComic24B_54 } /* code  54 */
  ,{  13,  13,  2, acFontComic24B_55 } /* code  55 */
  ,{  13,  13,  2, acFontComic24B_56 } /* code  56 */
  ,{  13,  13,  2, acFontComic24B_57 } /* code  57 */
  ,{   9,   9,  2, acFontComic24B_58 } /* code  58 */
  ,{   9,   9,  2, acFontComic24B_59 } /* code  59 */
  ,{  13,  13,  2, acFontComic24B_60 } /* code  60 */
  ,{  13,  13,  2, acFontComic24B_61 } /* code  61 */
  ,{  13,  13,  2, acFontComic24B_62 } /* code  62 */
  ,{  12,  12,  2, acFontComic24B_63 } /* code  63 */
  ,{  20,  20,  3, acFontComic24B_64 } /* code  64 */
  ,{  15,  15,  2, acFontComic24B_65 } /* code  65 */
  ,{  13,  13,  2, acFontComic24B_66 } /* code  66 */
  ,{  14,  14,  2, acFontComic24B_67 } /* code  67 */
  ,{  15,  15,  2, acFontComic24B_68 } /* code  68 */
  ,{  13,  13,  2, acFontComic24B_69 } /* code  69 */
  ,{  13,  13,  2, acFontComic24B_70 } /* code  70 */
  ,{  14,  14,  2, acFontComic24B_71 } /* code  71 */
  ,{  16,  16,  2, acFontComic24B_72 } /* code  72 */
  ,{  11,  11,  2, acFontComic24B_73 } /* code  73 */
  ,{  14,  14,  2, acFontComic24B_74 } /* code  74 */
  ,{  13,  13,  2, acFontComic24B_75 } /* code  75 */
  ,{  12,  12,  2, acFontComic24B_76 } /* code  76 */
  ,{  19,  19,  3, acFontComic24B_77 } /* code  77 */
  ,{  17,  17,  3, acFontComic24B_78 } /* code  78 */
  ,{  17,  17,  3, acFontComic24B_79 } /* code  79 */
  ,{  11,  11,  2, acFontComic24B_80 } /* code  80 */
  ,{  18,  18,  3, acFontComic24B_81 } /* code  81 */
  ,{  13,  13,  2, acFontComic24B_82 } /* code  82 */
  ,{  15,  15,  2, acFontComic24B_83 } /* code  83 */
  ,{  15,  15,  2, acFontComic24B_84 } /* code  84 */
  ,{  15,  15,  2, acFontComic24B_85 } /* code  85 */
  ,{  14,  14,  2, acFontComic24B_86 } /* code  86 */
  ,{  22,  22,  3, acFontComic24B_87 } /* code  87 */
  ,{  15,  15,  2, acFontComic24B_88 } /* code  88 */
  ,{  13,  13,  2, acFontComic24B_89 } /* code  89 */
  ,{  15,  15,  2, acFontComic24B_90 } /* code  90 */
  ,{   8,   8,  1, acFontComic24B_91 } /* code  91 */
  ,{  12,  12,  2, acFontComic24B_92 } /* code  92 */
  ,{   8,   8,  1, acFontComic24B_93 } /* code  93 */
  ,{  13,  13,  2, acFontComic24B_94 } /* code  94 */
  ,{  13,  13,  2, acFontComic24B_95 } /* code  95 */
  ,{  12,  12,  2, acFontComic24B_96 } /* code  96 */
  ,{  12,  12,  2, acFontComic24B_97 } /* code  97 */
  ,{  12,  12,  2, acFontComic24B_98 } /* code  98 */
  ,{  11,  11,  2, acFontComic24B_99 } /* code  99 */
  ,{  12,  12,  2, acFontComic24B_100 } /* code 100 */
  ,{  12,  12,  2, acFontComic24B_101 } /* code 101 */
  ,{  11,  11,  2, acFontComic24B_102 } /* code 102 */
  ,{  11,  11,  2, acFontComic24B_103 } /* code 103 */
  ,{  12,  12,  2, acFontComic24B_104 } /* code 104 */
  ,{   6,   6,  1, acFontComic24B_105 } /* code 105 */
  ,{   8,   8,  1, acFontComic24B_106 } /* code 106 */
  ,{  11,  11,  2, acFontComic24B_107 } /* code 107 */
  ,{   6,   6,  1, acFontComic24B_108 } /* code 108 */
  ,{  16,  16,  2, acFontComic24B_109 } /* code 109 */
  ,{  11,  11,  2, acFontComic24B_110 } /* code 110 */
  ,{  11,  11,  2, acFontComic24B_111 } /* code 111 */
  ,{  11,  11,  2, acFontComic24B_112 } /* code 112 */
  ,{  11,  11,  2, acFontComic24B_113 } /* code 113 */
  ,{  10,  10,  2, acFontComic24B_114 } /* code 114 */
  ,{  10,  10,  2, acFontComic24B_115 } /* code 115 */
  ,{  10,  10,  2, acFontComic24B_116 } /* code 116 */
  ,{  11,  11,  2, acFontComic24B_117 } /* code 117 */
  ,{  10,  10,  2, acFontComic24B_118 } /* code 118 */
  ,{  14,  14,  2, acFontComic24B_119 } /* code 119 */
  ,{  12,  12,  2, acFontComic24B_120 } /* code 120 */
  ,{  12,  12,  2, acFontComic24B_121 } /* code 121 */
  ,{  11,  11,  2, acFontComic24B_122 } /* code 122 */
  ,{   8,   8,  1, acFontComic24B_123 } /* code 123 */
  ,{   9,   9,  2, acFontComic24B_124 } /* code 124 */
  ,{   8,   8,  1, acFontComic24B_125 } /* code 125 */
  ,{  13,  13,  2, acFontComic24B_126 } /* code 126 */
  ,{  11,  11,  2, acFontComic24B_127 } /* code 127 */
};

GUI_CONST_STORAGE GUI_FONT_PROP FontComic24BProp_ASCII = {
   32                       /* first character               */
  ,127                      /* last character                */
  ,CharInfo24B_ASCII        /* address of first character    */
  ,(const GUI_FONT_PROP*)0  /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_FontComic24B_ASCII = {
   GUI_FONTTYPE_PROP  /* type of font    */
  ,24                 /* height of font  */
  ,24                 /* space of font y */
  ,1                  /* magnification x */
  ,1                  /* magnification y */
  ,{&FontComic24BProp_ASCII}
  ,20, 12, 17
};

