#include "includes.h"
#include "sys.h"
#include "usart.h"		
#include "delay.h"	
#include "led.h" 
#include "key.h"
#include "lcd.h"
#include "ds18b20.h"		 
//ucos ʵ

//ջС
#define LED_STK_SIZE     64
#define LED1_STK_SIZE    64
#define DS18B20_STK_SIZE 256
#define START_STK_SIZE   128

//ȼ
#define LED_TASK_Prio       7
#define LED1_TASK_Prio      6
#define DS18B20_TASK_Prio   8
#define START_TASK_Prio     4

//ջ
OS_STK  TASK_LED1_STK[LED_STK_SIZE];
OS_STK  TASK_LED_STK[LED_STK_SIZE];
OS_STK  TASK_DS18B20_STK[DS18B20_STK_SIZE];
OS_STK  TASK_START_STK[START_STK_SIZE];
//
void TaskStart(void *pdata);
void TaskLed(void *pdata);
void TaskLed1(void *pdata);
void TaskDS18B20(void *pdata);

//ϵͳʱú
void SysTick_Configuration(void);

			 
int main(void)
{			 	   
	Stm32_Clock_Init(9); //ϵͳʱ
	delay_init(72);	     //ʱʼ 
	uart_init(72,9600);	 //ڳʼΪ9600
	LED_Init();		  	 //ʼLEDӵӲӿ  
	LCD_Init();
	DS18B20_Init();
	SysTick_Configuration();
	OSInit();
	OSTaskCreate( TaskStart,	//task pointer
					(void *)0,	//parameter
					(OS_STK *) & TASK_START_STK[START_STK_SIZE-1],	//task stack top pointer
					START_TASK_Prio 
				);	//task priority
	
	OSStart();
	return 0;	   
}

//ʼ
void TaskStart(void * pdata)
{
	pdata = pdata; 
	OS_ENTER_CRITICAL();   
	OSTaskCreate(   TaskLed,
	                (void * )0,
	                (OS_STK *)&TASK_LED_STK[LED_STK_SIZE-1],
				    LED_TASK_Prio
				);

	OSTaskCreate(   TaskLed1, 
	                (void * )0,
				    (OS_STK *)&TASK_LED1_STK[LED1_STK_SIZE-1],
					 LED1_TASK_Prio
			    );

	OSTaskCreate(	TaskDS18B20,
	                (void * )0,
					(OS_STK *)&TASK_DS18B20_STK[DS18B20_STK_SIZE-1],
					DS18B20_TASK_Prio
	            );


	OSTaskSuspend(START_TASK_Prio);	//suspend but not delete
	OS_EXIT_CRITICAL();
}
//1_DS0.
void TaskLed(void *pdata)
{
	while(1)
	{
		LED0=!LED0;
	//	OSTimeDlyHMSM(0,0,0,500);
	   	OSTimeDly(100);
	}
}
//2_DS1.
void TaskLed1(void *pdata)
{
	while(1)
	{
		LED1=!LED1;
	//	OSTimeDlyHMSM(0,0,0,1000);
		OSTimeDly(500);	
	}
}	  
 
//4_DS18B20
void TaskDS18B20(void *pdata)
	{ 
	   	short temp;
		POINT_COLOR=RED;//Ϊɫ	   
		LCD_ShowString(60,70,"DS18B20 TEST");	
		LCD_ShowString(60,90,"TEMPTURE");
		LCD_ShowString(60,110,"2012/10/14");
		while(DS18B20_Init())//ʼDS18B20,18B20
			{
				LCD_ShowString(60,130,"DS18B20 Check Failed!");
				OSTimeDly(500);		  
				LCD_ShowString(60,130,"Please Check!        ");
		    	OSTimeDly(500);
			}
   		LCD_ShowString(60,130,"DS18B20 Ready!     ");	 
 		POINT_COLOR=BLUE;//Ϊɫ	   
		LCD_ShowString(60,150, "Temperate:   . C");	 
		while(1)
			{	  
				temp=DS18B20_Get_Temp();
				if(temp<0)
					{
						temp=-temp;
						LCD_ShowChar(140,150,'-',16,0);//ʾ	
					}						 
				LCD_ShowNum(148,150,temp/10,2,16);//ʾ¶ֵ	  
				LCD_ShowNum(172,150,temp%10,1,16);//ʾ¶ֵ
				//printf("t1:%d\n",temp);
				OSTimeDly(500);
			}			   
	}




//ϵͳʱжϷ
void SysTick_Handler(void)
{
	OS_ENTER_CRITICAL(); /* Tell uC/OS-II that we are starting an ISR  */
    OSIntNesting++;
    OS_EXIT_CRITICAL();

    OSTimeTick();        /* Call uC/OS-II's OSTimeTick()               */

    OSIntExit();         /* Tell uC/OS-II that we are leaving the ISR  */
}
//ϵͳʱã1msһж
void SysTick_Configuration(void)
{
 	SysTick->CTRL&=~(1<<2);//SYSTICKʹⲿʱԴ
	SysTick->CTRL|=1<<1;   //SYSTICKж
	SysTick->LOAD=9000;    //1msж
	//bit2,ѡⲿʱ  HCLK/8
	MY_NVIC_Init(2,2,SystemHandler_SysTick,2);//2ȼ 
	SysTick->CTRL|=1<<0;   //SYSTICK
}




















