/*
*********************************************************************************************************
uC/OS-IIʵʱں
Ҫİļ
ں˹ļ

 : OS_CORE.C ں˽ṹļ
 : Jean J. Labrosse
*********************************************************************************************************
*/

#ifndef  OS_MASTER_FILE	 //ûжOS_MASTER_FILEļ
#define  OS_GLOBALS		 //ȫ̱ OS_GLOBALS
#include "includes.h"
#endif

//*******************************************************************************************************
//                             MAPPING TABLE TO MAP BIT POSITION TO BIT MASK
//ע: ַǶӦOSRbyTbl[i]λֵ(0~7)ֵOSMapTbl[]()

//OSMapTbl[]ӦOSRdy GrpOSRbyTbl[i]λֵ(0~7)
INT8U  const  OSMapTbl[]   = {0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80};

//*******************************************************************************************************
//ȼұ(PRIORITY RESOLUTION TABLE)
//ע: ַλģʽҳ̬ȼ񣬸ֵӦϸȼλλֵ(0~7)

//OSUnMapTbl[]ȼұӦOSRdy GrpOSRbyTbl[i]λֵ(0~7)
INT8U  const  OSUnMapTbl[] = {
    0, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,       /* 0x00 to 0x0F                             */
    4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,       /* 0x10 to 0x1F                             */
    5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,       /* 0x20 to 0x2F                             */
    4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,       /* 0x30 to 0x3F                             */
    6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,       /* 0x40 to 0x4F                             */
    4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,       /* 0x50 to 0x5F                             */
    5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,       /* 0x60 to 0x6F                             */
    4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,       /* 0x70 to 0x7F                             */
    7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,       /* 0x80 to 0x8F                             */
    4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,       /* 0x90 to 0x9F                             */
    5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,       /* 0xA0 to 0xAF                             */
    4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,       /* 0xB0 to 0xBF                             */
    6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,       /* 0xC0 to 0xCF                             */
    4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,       /* 0xD0 to 0xDF                             */
    5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,       /* 0xE0 to 0xEF                             */
    4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0        /* 0xF0 to 0xFF                             */
};

/*
*********************************************************************************************************
*                                       FUNCTION PROTOTYPES
*********************************************************************************************************
*/
static  void  OS_InitEventList(void);
static  void  OS_InitMisc(void);
static  void  OS_InitRdyList(void);
static  void  OS_InitTaskIdle(void);
static  void  OS_InitTaskStat(void);
static  void  OS_InitTCBList(void);

//ʼ:(INITIALIZATION)
//: ʼuC/OS-IIĵñڵOSStart()֮ǰ
//OSStart()ʼж
void  OSInit (void)
{
#if OS_VERSION >= 204
    OSInitHookBegin();                                           /* Call port specific initialization code   */
#endif

    OS_InitMisc();                                               /* Initialize miscellaneous variables       */

    OS_InitRdyList();                                            /* Initialize the Ready List                */
    OS_InitTCBList();                                            /* Initialize the free list of OS_TCBs      */
    OS_InitEventList();                                          /* Initialize the free list of OS_EVENTs    */

#if (OS_VERSION >= 251) && (OS_FLAG_EN > 0) && (OS_MAX_FLAGS > 0)
    OS_FlagInit();                                               /* Initialize the event flag structures     */
#endif

#if (OS_MEM_EN > 0) && (OS_MAX_MEM_PART > 0)
    OS_MemInit();                                                /* Initialize the memory manager            */
#endif

#if (OS_Q_EN > 0) && (OS_MAX_QS > 0)
    OS_QInit();                                                  /* Initialize the message queue structures  */
#endif

    OS_InitTaskIdle();                                           /* Create the Idle Task                     */
#if OS_TASK_STAT_EN > 0
    OS_InitTaskStat();                                           /* Create the Statistic Task                */
#endif

#if OS_VERSION >= 204
    OSInitHookEnd();                                             /* Call port specific init. code            */
#endif
}
//жϺִ ENTER ISR
//: ֪ͨuC/OS-IIһжϴڽУuC/OS-IIжǶ
//OSIntEnter ()OSIntExit (ʹ)ߣֻжϳС
//: 	   
//: 	  
//ע: 1) 񼶲ܵøú
//      2) ϵͳʹõĴִܹԶĶִжȡ޸ģдĲôͿֱӵ
//         жǶײ(OSIntNesting)ԱúĶ⿪жϷӳ
//         OSIntNesting1ǲģΪOSIntNesting1ʱжǹرյ
//      3) жǶȿɴ255
void  OSIntEnter (void)
{
#if OS_CRITICAL_METHOD == 3                                //жϺ趨Ϊģʽ3
    OS_CPU_SR  cpu_sr;
#endif
	//OS_ENTER_CRITICAL(); //رж
    if (OSRunning == TRUE) {
        if (OSIntNesting < 255) {
            OSIntNesting++;                      //жǶ׼1
        }
    }
	//OS_EXIT_CRITICAL(); //ж
}

//жϺѾ EXIT ISR
//: ֪ͨuC/OS-IIһжϷѾִɣuC/OS-IIжǶ׵ͨ
//OSIntExit()OSIntEnter()ʹáһǶ׵жִʱиȼ
//׼uC/OS-IIȺ£жϷصȼ񣬶
//Ǳж˵񡣵ߣֻжϳС
//: 	   
//: 	  
//ע: 1) 񼶲ܵøúҼʹûеOSIntEnter()ʹֱӵOSIntNestingķ
//         ҲOSIntExit()
//      2) ڽֹ (鿴 OSSchedLock())	  
void  OSIntExit (void)
{
#if OS_CRITICAL_METHOD == 3                                //жϺ趨Ϊģʽ3
    OS_CPU_SR  cpu_sr;
#endif
    
    
    if (OSRunning == TRUE) {							   //رж
        OS_ENTER_CRITICAL();
        if (OSIntNesting > 0) {                            //жǶ״0
            OSIntNesting--;								   //жǶ׼1
        }
//1)жǶײǶ׼(OSLockNesting)߶
//2)OSRdyTbl[]ļֵYǱȫ̱OSIntExitY
//3)ȼľȼǷеȼ
//4)ƿȼ浽ָ߼ȼƿָ
//5)лĴ(ͳ)
//6)жл	
        if ((OSIntNesting == 0) && (OSLockNesting == 0)) { //1
            OSIntExitY    = OSUnMapTbl[OSRdyGrp];          //2
            OSPrioHighRdy = (INT8U)((OSIntExitY << 3) + OSUnMapTbl[OSRdyTbl[OSIntExitY]]);
            if (OSPrioHighRdy != OSPrioCur) {              //3
                OSTCBHighRdy  = OSTCBPrioTbl[OSPrioHighRdy];//4
                OSCtxSwCtr++;                              //5
                OSIntCtxSw();                              //6
            }
        }
        OS_EXIT_CRITICAL();	//ж
    }
}

// PREVENT SCHEDULING
//: ڽֹȣֱɺøOSSchedUnlock()Ϊֹ
//	  	OSSchedlock()񱣳ֶCPUĿȨиȼߵ˾̬Ȼ,ʱ
//		жǿԱʶ,жϷҲܵõ(жǿŵ)OSSchedlock()OSSchedUnlock()
//		ɶʹ.OSLockNestingOSSchedLock()õĴ,Ƕ׵ĺ
//		δ,δ񲻵øԤ.uC/OS-IIǶȴ255.OSLockNestingʱ
//		µõ.OSSchedLock()OSSchedUnlock()ʹҪǳ,ΪӰuC/OS-II
//		
//˵OSLockNestingʱOSSchedUnlock()OSSchedOSSchedUnlock()Ǳĳõģ
//		ڵڼ䣬ʲô¼˲ʹһȼ̬
//: 
//: 
//棺õðѵǰĳ
//ע: 1) OSSchedLock()ԺûӦó򲻵ʹκܽϵͳáҲ˵
//		û򲻵õOSMboxPend()OSQPend()OSSemPend()OSTaskSuspend(OS_PR1O_SELF)
//		OSTimeDly()OSTimeDlyHMSM(),ֱOSLockNestingΪֹΪûס
//		ϵͳκ񶼲С
//		2) ȼҪϢ䡢ϢСźʱûϣȼ
//		䡢кźûеõϢ֮ǰȡCPUĿȨʱûʹýֹ
//		
#if OS_SCHED_LOCK_EN > 0   //OSSchedLock()
void  OSSchedLock (void)
{
#if OS_CRITICAL_METHOD == 3                      //жϺ趨Ϊģʽ3
    OS_CPU_SR  cpu_sr;
#endif    
    
    
    if (OSRunning == TRUE) {                      //ж
        OS_ENTER_CRITICAL();
        if (OSLockNesting < 255) {               //ǶǷ255
            OSLockNesting++;                     //Ƕ׼1
        }
        OS_EXIT_CRITICAL();					     //ж
    }
}
#endif    

// ENABLE SCHEDULING
//: ڽ
//: 
//: 
//ע: 1) OSSchedlock()OSSchedUnlock()ɶʹãʹOSSchedUnlock()֮ǰʹ
//		   OSSchedLock()
#if OS_SCHED_LOCK_EN > 0
void  OSSchedUnlock (void)
{
#if OS_CRITICAL_METHOD == 3                                /* Allocate storage for CPU status register */
    OS_CPU_SR  cpu_sr;
#endif    
    
    
    if (OSRunning == TRUE) {                                   /* Make sure multitasking is running    */
        OS_ENTER_CRITICAL();
        if (OSLockNesting > 0) {                               /* Do not decrement if already 0        */
            OSLockNesting--;                                   /* Decrement lock nesting level         */
            if ((OSLockNesting == 0) && (OSIntNesting == 0)) { /* See if sched. enabled and not an ISR */
                OS_EXIT_CRITICAL();
                OS_Sched();                                    /* See if a HPT is ready                */
            } else {
                OS_EXIT_CRITICAL();
            }
        } else {
            OS_EXIT_CRITICAL();
        }
    }
}
#endif  
  
// START MULTITASKING
//: OSStart()ʱOSStart()ҳǸûȼ
//		顣ȻOSStart()øȼOSStartHighRdy()(ļ
//		OS_CPU_A.ASM)ļѡ΢йءʵϣOSStartHighRdy()ǽջ
//		ֵصCPUĴУȻִһжϷָжϷָǿִи롣
//		ȼOSStartHighRdy()
//: 
//: 
//ע: OSStartHighRdy() :
//		a) OSRunningΪ棬ָѾʼ
//		b) uC/OS-II֮ǰٱ뽨һӦ
//	    c) OSStartHighRdy()ԶصOSStart()
void  OSStart (void)
{
    INT8U y;
    INT8U x;
    if (OSRunning == FALSE) {//OSRunningΪ""ָѾʼ
        y             = OSUnMapTbl[OSRdyGrp];        //ȼ
        x             = OSUnMapTbl[OSRdyTbl[y]];
        OSPrioHighRdy = (INT8U)((y << 3) + x);		 //ҳ̬߼ƿ
        OSPrioCur     = OSPrioHighRdy;				 //OSPrioCurOSPrioHighRdyŵûӦȼ
        OSTCBHighRdy  = OSTCBPrioTbl[OSPrioHighRdy]; /* Point to highest priority task ready to run    */
        OSTCBCur      = OSTCBHighRdy;
        OSStartHighRdy();                            //øȼ
    }
}

//ͳʼ STATISTICS INITIALIZATION
//: ͳƳʼOSStatInit()ûӦʱм(OSIdleCtr)ļ
//		ж졣ÿִһΣȷӦóе˶CPUʱ䡣û
//		ӦóԺпCPUʱˣOSIdleCtrͲԭʲô񶼲
//		ʱôҪ֪OSIdleCtrֵOSStatInit()ڳʼʱڼ
//		ֵOSIdleCtrMaxеġCPUʣ
//		                                        мֵOSIdleCtr
//      CPU ʹUsage (%) = 100 * (1 - --------------------------------)
//                                        趨мֵOSIdleCtrMax
//: 
//: 											   
#if OS_TASK_STAT_EN > 0
void  OSStatInit (void)
{
#if OS_CRITICAL_METHOD == 3                      /* Allocate storage for CPU status register           */
    OS_CPU_SR  cpu_sr;
#endif    
    
    
    OSTimeDly(2);                                //ӳٺOSTimeDly()ʱ2ʱӽֹͣ
												 //ΪʹOSStatInit()ʱӽͬ
    OS_ENTER_CRITICAL();
    OSIdleCtr    = 0L;                           //ִOSStartInit()ʱмOSIdleCtr                                */
    OS_EXIT_CRITICAL();
    OSTimeDly(OS_TICKS_PER_SEC);                 //ʱһ
	                                             //(Ϊû̬OSTaskIdle()ֻCPUĿȨ)
    OS_ENTER_CRITICAL();
    OSIdleCtrMax = OSIdleCtr;                    //м1ڼֵмֵ
    OSStatRdy    = TRUE;						 //ͳ־OSStatRdyΪ""Դʱӽ
    OS_EXIT_CRITICAL();
}
#endif
//ʱӽĺ PROCESS SYSTEM TICK
//: uC/OSҪûṩźԴʵʱʱȷϳʱӦÿ10ε100
//		֮䣬˵10100HzʱӽԽߣϵͳĶ⸺ɾԽ.ʱӽĵʵƵȡ
//		ûӦóľȡʱӽԴרŵӲʱҲ50/60HzԴ
//		ź														   
//: 
//: 
void  OSTimeTick (void)
{
#if OS_CRITICAL_METHOD == 3                                /* Allocate storage for CPU status register */
    OS_CPU_SR  cpu_sr;
#endif    
    OS_TCB    *ptcb; //ƿȼ


    OSTimeTickHook();                                      //ûԶ庯(Ӻ)
#if OS_TIME_GET_SET_EN > 0   
    OS_ENTER_CRITICAL();                                   //ۼӴӿʱ䣬õһ޷32λ
    OSTime++;
    OS_EXIT_CRITICAL();
#endif
    if (OSRunning == TRUE) {    
        ptcb = OSTCBList;                                  //ƿб׵ַ
														   //OSTCBListʼOS_TCBһֱ
        while (ptcb->OSTCBPrio != OS_IDLE_PRIO) {          /* Go through all TCBs in TCB list          */
            OS_ENTER_CRITICAL();
            if (ptcb->OSTCBDly != 0) {                     //ȴʱΪ0
										   				//ȷбĺOSTaskSuspend()򲻻̬
														//ִʱֱӦóн˶ٸ
             if (--ptcb->OSTCBDly == 0) {               //ȴʱΪ0
														//ĳƿеʱʱOSTCBDly㣬ͽ˾̬
                    if ((ptcb->OSTCBStat & OS_STAT_SUSPEND) == OS_STAT_RDY) { /* Is task suspended?    */
                        OSRdyGrp               |= ptcb->OSTCBBitY; /* No,  Make task R-to-R (timed out)*/
                        OSRdyTbl[ptcb->OSTCBY] |= ptcb->OSTCBBitX;
                    } else {                               /* Yes, Leave 1 tick to prevent ...         */
                        ptcb->OSTCBDly = 1;                /* ... loosing the task when the ...        */
                    }                                      /* ... suspension is removed.               */
                }
            }
            ptcb = ptcb->OSTCBNext;                        //ָ˫ӱĺ
            OS_EXIT_CRITICAL();
        }
    }
}		 
//ð汾GET VERSION
//: ǷһuC/OS-IIİ汾ֵ. ֵ100uC/OS-IIİ汾. 														   
//: 
//: uC/OS-IIİ汾ų100.
INT16U  OSVersion (void)
{
    return (OS_VERSION);
}

//⺯ DUMMY FUNCTION
//: . OSTaskDel().														   
//: 
//: uC/OS-IIİ汾ų100.
#if OS_TASK_DEL_EN > 0
void  OS_Dummy (void)
{
}
#endif

//ʹһ̬ MAKE TASK READY TO RUN BASED ON EVENT OCCURING
//: ĳ¼¼ȴбеȼ(HPT)Ҫھ̬ʱ¼Ӧ		  
//		OSSemPost()OSMboxPost()OSQPost()OSQPostFront()OSEventTaskRdy()ʵ
//		ò仰˵úӵȴɾHPT񣬲Ѹھ̬
//: pevent    is a pointer to the event control block corresponding to the event.
//      msg       is a pointer to a message.  This pointer is used by message oriented services
//                such as MAILBOXEs and QUEUEs.  The pointer is not used when called by other
//                service functions.
//      msk       is a mask that is used to clear the status byte of the TCB.  For example,
//                OSSemPost() will pass OS_STAT_SEM, OSMboxPost() will pass OS_STAT_MBOX etc.//: 
//ע: uC/OS-IIڲ㲻Ӧó,ô˺ҲӦرж
#if OS_EVENT_EN > 0
INT8U  OS_EventTaskRdy (OS_EVENT *pevent, void *msg, INT8U msk)
{
    OS_TCB *ptcb;
    INT8U   x;
    INT8U   y;
    INT8U   bitx;
    INT8U   bity;
    INT8U   prio;

//1)ȼHPT.OSEventTbl[]еֽһ0OS_LOWEST_PRIO/8+1֮
//2)øõȼ.OSEventGrpеλ
//3)жHPT.OSEventTbl[]Ӧλλ
//4)һ0OS_LOWEST_PRIO/8+1֮ԼӦλ
//5)ϽOSEventTaskRdy()HPTȼ
//6)ȻͿԴӵȴбɾ
    y    = OSUnMapTbl[pevent->OSEventGrp];            /* Find highest prio. task waiting for message   */
    bity = OSMapTbl[y];
    x    = OSUnMapTbl[pevent->OSEventTbl[y]];
    bitx = OSMapTbl[x];
    prio = (INT8U)((y << 3) + x);                     /* Find priority of task getting the msg         */
    if ((pevent->OSEventTbl[y] &= ~bitx) == 0x00) {   /* Remove this task from the waiting list        */
        pevent->OSEventGrp &= ~bity;                  /* Clr group bit if this was only task pending   */
    }
//7)TCBаҪıϢ֪HPTȼͿɵõָTCBָ
//8)ΪȼѾõ㣬ֹͣOSTimeTick().OSTCBDlyĵݼ
// OSEventTaskRdy()ֱӽ峺0
//9)Ϊٵȴ¼ķԱƿָ¼ƿָָNULL
//10)OSEventTaskRdy()OSMboxPost()OSQPost()õģúҪӦϢݸ
// HPTƿ
    ptcb                 =  OSTCBPrioTbl[prio];       /* Point to this task's OS_TCB                   */
    ptcb->OSTCBDly       =  0;                        /* Prevent OSTimeTick() from readying task       */
    ptcb->OSTCBEventPtr  = (OS_EVENT *)0;             /* Unlink ECB from this task                     */
#if ((OS_Q_EN > 0) && (OS_MAX_QS > 0)) || (OS_MBOX_EN > 0)
    ptcb->OSTCBMsg       = msg;                       /* Send message directly to waiting task         */
#else
    msg                  = msg;                       /* Prevent compiler warning if not used          */
#endif
//11)OSEventTaskRdy()ʱλmskΪݸòڶƿе
// λλ룬¼Ӧ
//12).OSTCBStatжϸǷѴھ״̬
//13), HPT뵽uC/OS-IIľбСע⣬HPTõ¼һ
// ״̬ҲѾԭ
    ptcb->OSTCBStat     &= ~msk;                      /* Clear bit associated with event type          */
    if (ptcb->OSTCBStat == OS_STAT_RDY) {             /* See if task is ready (could be susp'd)        */
        OSRdyGrp        |=  bity;                     /* Put task in the ready to run list             */
        OSRdyTbl[y]     |=  bitx;
    }
    return (prio);
}
#endif
//ʹһȴĳ¼״̬ MAKE TASK WAIT FOR EVENT TO OCCUR		  
//: ĳȴһ¼ķʱźźԼϢлͨӦ
//		PENDñʹǰӾ̬ŵӦ¼ƿECBĵ
// 			 
//: pevent ¼ƿָ룬Ϊȴĳ¼		 
//: 	   
//ע: uC/OS-IIڲ㲻ӦóеOS_EventTO()ҲӦرж
#if OS_EVENT_EN > 0
void  OS_EventTaskWait (OS_EVENT *pevent)
{	//ָ¼ƿECBָŵƿTCBУ¼ƿECB֮
    OSTCBCur->OSTCBEventPtr = pevent;             //Ӿɾ
    if ((OSRdyTbl[OSTCBCur->OSTCBY] &= ~OSTCBCur->OSTCBBitX) == 0x00) {   /* Task no longer ready      */
        OSRdyGrp &= ~OSTCBCur->OSTCBBitY;        /* Clear event grp bit if this was only task pending  */
    }
    //Ѹŵ¼ƿECBĵȴ¼б
	pevent->OSEventTbl[OSTCBCur->OSTCBY] |= OSTCBCur->OSTCBBitX;          /* Put task in waiting list  */
    pevent->OSEventGrp                   |= OSTCBCur->OSTCBBitY;
}
#endif

//ڳʱΪ̬ MAKE TASK READY TO RUN BASED ON EVENT TIMEOUT	    
//: Ԥָĵȴʱȴ¼ûзôΪȴʱ
//		״̬Ϊ̬£źźԼϢлͨPEND
//		ñ	    
//: pevent ¼ƿָ룬Ϊʱ̬   
//: 	    
//ע: uC/OS-IIڲ㲻ӦóеOS_EventTO()ҲӦرж
#if OS_EVENT_EN > 0
void  OS_EventTO (OS_EVENT *pevent)
{
    if ((pevent->OSEventTbl[OSTCBCur->OSTCBY] &= ~OSTCBCur->OSTCBBitX) == 0x00) {
        pevent->OSEventGrp &= ~OSTCBCur->OSTCBBitY;
    }
    OSTCBCur->OSTCBStat     = OS_STAT_RDY;       /* Set status to ready                                */
    OSTCBCur->OSTCBEventPtr = (OS_EVENT *)0;     /* No longer waiting for event                        */
}
#endif
//¼ƿбʼ INITIALIZE EVENT CONTROL BLOCK'S WAIT LIST
//: һźϢʱӦĽOSSemInit()OSMboxCreate()
//		OSQCreate()ͨOSEventWaitListInit()¼ƿеĵȴбгʼú
//		ʼһյĵȴбûκ񡣸úĵòֻһָҪ
// 		ʼ¼ƿָpevent
//: pevent һָ¼ƿ飬ָǴźźϢ
// 		ʱ¼ƿָ
//: 
//ע: uC/OS-IIڲ㲻Ե
#if ((OS_Q_EN > 0) && (OS_MAX_QS > 0)) || (OS_MBOX_EN > 0) || (OS_SEM_EN > 0) || (OS_MUTEX_EN > 0)
void  OS_EventWaitListInit (OS_EVENT *pevent)
{
    INT8U  *ptbl;


    pevent->OSEventGrp = 0x00;                   /* No task waiting on event                           */
    ptbl               = &pevent->OSEventTbl[0];

#if OS_EVENT_TBL_SIZE > 0
    *ptbl++            = 0x00;
#endif

#if OS_EVENT_TBL_SIZE > 1
    *ptbl++            = 0x00;
#endif

#if OS_EVENT_TBL_SIZE > 2
    *ptbl++            = 0x00;
#endif

#if OS_EVENT_TBL_SIZE > 3
    *ptbl++            = 0x00;
#endif

#if OS_EVENT_TBL_SIZE > 4
    *ptbl++            = 0x00;
#endif

#if OS_EVENT_TBL_SIZE > 5
    *ptbl++            = 0x00;
#endif

#if OS_EVENT_TBL_SIZE > 6
    *ptbl++            = 0x00;
#endif

#if OS_EVENT_TBL_SIZE > 7
    *ptbl              = 0x00;
#endif
}
#endif
/*$PAGE*/
/*
*********************************************************************************************************
*                                             INITIALIZATION
*                           INITIALIZE THE FREE LIST OF EVENT CONTROL BLOCKS
*
* Description: This function is called by OSInit() to initialize the free list of event control blocks.
*
* Arguments  : none
*
* Returns    : none
*********************************************************************************************************
*/

static  void  OS_InitEventList (void)
{
#if (OS_EVENT_EN > 0) && (OS_MAX_EVENTS > 0)
#if (OS_MAX_EVENTS > 1)
    INT16U     i;
    OS_EVENT  *pevent1;
    OS_EVENT  *pevent2;


    pevent1 = &OSEventTbl[0];
    pevent2 = &OSEventTbl[1];
    for (i = 0; i < (OS_MAX_EVENTS - 1); i++) {                  /* Init. list of free EVENT control blocks  */
        pevent1->OSEventType = OS_EVENT_TYPE_UNUSED;
        pevent1->OSEventPtr  = pevent2;
        pevent1++;
        pevent2++;
    }
    pevent1->OSEventType = OS_EVENT_TYPE_UNUSED;
    pevent1->OSEventPtr  = (OS_EVENT *)0;
    OSEventFreeList      = &OSEventTbl[0];
#else
    OSEventFreeList              = &OSEventTbl[0];               /* Only have ONE event control block        */
    OSEventFreeList->OSEventType = OS_EVENT_TYPE_UNUSED;
    OSEventFreeList->OSEventPtr  = (OS_EVENT *)0;
#endif
#endif
}
/*$PAGE*/
/*
*********************************************************************************************************
*                                             INITIALIZATION
*                                    INITIALIZE MISCELLANEOUS VARIABLES
*
* Description: This function is called by OSInit() to initialize miscellaneous variables.
*
* Arguments  : none
*
* Returns    : none
*********************************************************************************************************
*/

static  void  OS_InitMisc (void)
{
#if OS_TIME_GET_SET_EN > 0   
    OSTime        = 0L;                                          /* Clear the 32-bit system clock            */
#endif

    OSIntNesting  = 0;                                           /* Clear the interrupt nesting counter      */
    OSLockNesting = 0;                                           /* Clear the scheduling lock counter        */

    OSTaskCtr     = 0;                                           /* Clear the number of tasks                */

    OSRunning     = FALSE;                                       /* Indicate that multitasking not started   */
    
    OSCtxSwCtr    = 0;                                           /* Clear the context switch counter         */
    OSIdleCtr     = 0L;                                          /* Clear the 32-bit idle counter            */

#if (OS_TASK_STAT_EN > 0) && (OS_TASK_CREATE_EXT_EN > 0)
    OSIdleCtrRun  = 0L;
    OSIdleCtrMax  = 0L;
    OSStatRdy     = FALSE;                                       /* Statistic task is not ready              */
#endif
}
/*$PAGE*/
/*
*********************************************************************************************************
*                                             INITIALIZATION
*                                       INITIALIZE THE READY LIST
*
* Description: This function is called by OSInit() to initialize the Ready List.
*
* Arguments  : none
*
* Returns    : none
*********************************************************************************************************
*/

static  void  OS_InitRdyList (void)
{
    INT16U   i;
    INT8U   *prdytbl;


    OSRdyGrp      = 0x00;                                        /* Clear the ready list                     */
    prdytbl       = &OSRdyTbl[0];
    for (i = 0; i < OS_RDY_TBL_SIZE; i++) {
        *prdytbl++ = 0x00;
    }

    OSPrioCur     = 0;
    OSPrioHighRdy = 0;

    OSTCBHighRdy  = (OS_TCB *)0;                                 
    OSTCBCur      = (OS_TCB *)0;
}

/*$PAGE*/
/*
*********************************************************************************************************
*                                             INITIALIZATION
*                                         CREATING THE IDLE TASK
*
* Description: This function creates the Idle Task.
*
* Arguments  : none
*
* Returns    : none
*********************************************************************************************************
*/

static  void  OS_InitTaskIdle (void)
{
#if OS_TASK_CREATE_EXT_EN > 0
    #if OS_STK_GROWTH == 1
    (void)OSTaskCreateExt(OS_TaskIdle,
                          (void *)0,                                 /* No arguments passed to OS_TaskIdle() */
                          &OSTaskIdleStk[OS_TASK_IDLE_STK_SIZE - 1], /* Set Top-Of-Stack                     */
                          OS_IDLE_PRIO,                              /* Lowest priority level                */
                          OS_TASK_IDLE_ID,
                          &OSTaskIdleStk[0],                         /* Set Bottom-Of-Stack                  */
                          OS_TASK_IDLE_STK_SIZE,
                          (void *)0,                                 /* No TCB extension                     */
                          OS_TASK_OPT_STK_CHK | OS_TASK_OPT_STK_CLR);/* Enable stack checking + clear stack  */
    #else
    (void)OSTaskCreateExt(OS_TaskIdle,
                          (void *)0,                                 /* No arguments passed to OS_TaskIdle() */
                          &OSTaskIdleStk[0],                         /* Set Top-Of-Stack                     */
                          OS_IDLE_PRIO,                              /* Lowest priority level                */
                          OS_TASK_IDLE_ID,
                          &OSTaskIdleStk[OS_TASK_IDLE_STK_SIZE - 1], /* Set Bottom-Of-Stack                  */
                          OS_TASK_IDLE_STK_SIZE,
                          (void *)0,                                 /* No TCB extension                     */
                          OS_TASK_OPT_STK_CHK | OS_TASK_OPT_STK_CLR);/* Enable stack checking + clear stack  */
    #endif
#else
    #if OS_STK_GROWTH == 1
    (void)OSTaskCreate(OS_TaskIdle,
                       (void *)0,
                       &OSTaskIdleStk[OS_TASK_IDLE_STK_SIZE - 1],
                       OS_IDLE_PRIO);
    #else
    (void)OSTaskCreate(OS_TaskIdle,
                       (void *)0,
                       &OSTaskIdleStk[0],
                       OS_IDLE_PRIO);
    #endif
#endif
}
/*$PAGE*/
/*
*********************************************************************************************************
*                                             INITIALIZATION
*                                      CREATING THE STATISTIC TASK
*
* Description: This function creates the Statistic Task.
*
* Arguments  : none
*
* Returns    : none
*********************************************************************************************************
*/

#if OS_TASK_STAT_EN > 0
static  void  OS_InitTaskStat (void)
{
#if OS_TASK_CREATE_EXT_EN > 0
    #if OS_STK_GROWTH == 1
    (void)OSTaskCreateExt(OS_TaskStat,
                          (void *)0,                                   /* No args passed to OS_TaskStat()*/
                          &OSTaskStatStk[OS_TASK_STAT_STK_SIZE - 1],   /* Set Top-Of-Stack               */
                          OS_STAT_PRIO,                                /* One higher than the idle task  */
                          OS_TASK_STAT_ID,
                          &OSTaskStatStk[0],                           /* Set Bottom-Of-Stack            */
                          OS_TASK_STAT_STK_SIZE,
                          (void *)0,                                   /* No TCB extension               */
                          OS_TASK_OPT_STK_CHK | OS_TASK_OPT_STK_CLR);  /* Enable stack checking + clear  */
    #else
    (void)OSTaskCreateExt(OS_TaskStat,
                          (void *)0,                                   /* No args passed to OS_TaskStat()*/
                          &OSTaskStatStk[0],                           /* Set Top-Of-Stack               */
                          OS_STAT_PRIO,                                /* One higher than the idle task  */
                          OS_TASK_STAT_ID,
                          &OSTaskStatStk[OS_TASK_STAT_STK_SIZE - 1],   /* Set Bottom-Of-Stack            */
                          OS_TASK_STAT_STK_SIZE,
                          (void *)0,                                   /* No TCB extension               */
                          OS_TASK_OPT_STK_CHK | OS_TASK_OPT_STK_CLR);  /* Enable stack checking + clear  */
    #endif
#else
    #if OS_STK_GROWTH == 1
    (void)OSTaskCreate(OS_TaskStat,
                       (void *)0,                                      /* No args passed to OS_TaskStat()*/
                       &OSTaskStatStk[OS_TASK_STAT_STK_SIZE - 1],      /* Set Top-Of-Stack               */
                       OS_STAT_PRIO);                                  /* One higher than the idle task  */
    #else
    (void)OSTaskCreate(OS_TaskStat,
                       (void *)0,                                      /* No args passed to OS_TaskStat()*/
                       &OSTaskStatStk[0],                              /* Set Top-Of-Stack               */
                       OS_STAT_PRIO);                                  /* One higher than the idle task  */
    #endif
#endif
}
#endif
/*$PAGE*/
/*
*********************************************************************************************************
*                                             INITIALIZATION
*                            INITIALIZE THE FREE LIST OF TASK CONTROL BLOCKS
*
* Description: This function is called by OSInit() to initialize the free list of OS_TCBs.
*
* Arguments  : none
*
* Returns    : none
*********************************************************************************************************
*/

static  void  OS_InitTCBList (void)
{
    INT8U    i;
    OS_TCB  *ptcb1;
    OS_TCB  *ptcb2;


    OSTCBList     = (OS_TCB *)0;                                 /* TCB Initialization                       */
    for (i = 0; i < (OS_LOWEST_PRIO + 1); i++) {                 /* Clear the priority table                 */
        OSTCBPrioTbl[i] = (OS_TCB *)0;
    }
    ptcb1 = &OSTCBTbl[0];
    ptcb2 = &OSTCBTbl[1];
    for (i = 0; i < (OS_MAX_TASKS + OS_N_SYS_TASKS - 1); i++) {  /* Init. list of free TCBs                  */
        ptcb1->OSTCBNext = ptcb2;
        ptcb1++;
        ptcb2++;
    }
    ptcb1->OSTCBNext = (OS_TCB *)0;                              /* Last OS_TCB                              */
    OSTCBFreeList    = &OSTCBTbl[0];
}

//
//: uC/OS-IIн̬ȼߵһȷĸȼߣ
// 		˵Ĺɵ(Scheduler)ɵġ񼶵ĵɺOSSched()ɵġ
//		жϼĵһOSIntExt()ɵeduling).
//: none
//: none
//ע: 1) һuC/OS-IIڲ㲻Ӧóʹ
//		2) ڽֹ (鿴 OSSchedLock())
//˵: 1)лܼ򵥣ɣ΢ĴջȻ󽫽ϸ
//		ļĴֵջлָĴСuC/OS-IIУջṹǿ
//	 	շжһ΢ļĴջС仰˵uC/OS-IIо̬
//		ҪһУֻǻָеCPUĴжϷָΪл
//		OS_TASK_SW(),Ϊģһжϡ΢жָָTRAPʵ
//		жϷӳ崦(Trap hardler)Ҳ¹ʴ(exception handler)
//		жԺOSCtxSw()OSCtxSw()ҪOS_TCBHighRdyָ򼴽
//		ҪõǰƿOSTCBCurָ򼴽񣬲μ8£ֲuC/OS-IIй
//		OSCtxSw()ĸ꾡Ľ͡
//		2) OSSched()д붼ٽδ롣Ѱҽ̬ȼߵУΪֹ
//		Ϸӳһ򼸸ľλλжǱصġΪлʱ䣬OSSched()ȫ
//		붼ûдΪӿɶԣֲԺͽԴٻOSSched()
//		Cдġ


void  OS_Sched (void)
{
#if OS_CRITICAL_METHOD == 3                            /* Allocate storage for CPU status register     */
    OS_CPU_SR  cpu_sr;
#endif    
    INT8U      y;


    OS_ENTER_CRITICAL();
	//ΪʵлOSTCBHighRdyָȼߵǸƿOS_TCBͨ
    if ((OSIntNesting == 0) && (OSLockNesting == 0)) { /* Sched. only if all ISRs done & not locked    */
	//жϷӳеõģҵģȺҳ̬
	//ȼ񣬽̬ھOSRdyTbl[ ]Ӧλλ.
        y             = OSUnMapTbl[OSRdyGrp];          /* Get pointer to HPT ready to run              */
        OSPrioHighRdy = (INT8U)((y << 3) + OSUnMapTbl[OSRdyTbl[y]]);
 		//ҵȼ󣬺ȼߵǷǵǰеԱⲻ
		//Ҫȣ໨ʱ
       if (OSPrioHighRdy != OSPrioCur) {              /* No Ctx Sw if current task is highest rdy     */
		//ΪʵлOSTCBHighRdyָȼߵǸƿOS_TCBͨ
		//OSPrioHighRdyΪ±OSTCBPrioTbl[]еǸԪظOSTCBHighRdyʵֵ
            OSTCBHighRdy = OSTCBPrioTbl[OSPrioHighRdy];
            OSCtxSwCtr++;                              //ͳƼOSCtxSwCtr1Ըл
            OS_TASK_SW();                              //OS_TASK_SW()ʵϵл
        }
    }
    OS_EXIT_CRITICAL();
}
// IDLE TASK
//: uC/OS-IIڲuC/OS-IIҪһû
//		̬ʱͶСԶΪȼOS_LOWEST_PRIO.񲻿ܱӦ
//		ɾ
//: 
//: 
//ע: 1) OSTaskIdleHook()ûںдԼĴ룬ԽOSTaskIdleHook()
//		CPUִSTOPָӶ͹ģʽӦϵͳɵعʱַʽرá
//		2) Զھ̬ԲҪOSTaskIdleHook()еÿʹPEND
//		OSTineDly???()OSTaskSuspend()
void  OS_TaskIdle (void *pdata)
{
#if OS_CRITICAL_METHOD == 3                      /* Allocate storage for CPU status register           */
    OS_CPU_SR  cpu_sr;
#endif    
    
    
    pdata = pdata;                               /* Prevent compiler warning for not using 'pdata'     */
    for (;;) {
        OS_ENTER_CRITICAL();
        OSIdleCtr++;
        OS_EXIT_CRITICAL();
        OSTaskIdleHook();                        /* Call user definable HOOK                           */
    }
}
//ͳ STATISTICS TASK
//: uC/OS-IIһṩʱͳƵOSTaskStat(),ûϵͳ峣
//		OS_TASK_STAT_EN(ļOS_CFG.H)Ϊ1ͻὨһõOSTaskStat()
//		ÿһ(ļOS_CORE.C)㵱ǰCPUʡ仰˵OSTaskStat()û
//		Ӧóʹ˶CPUʱ䣬ðٷֱȱʾֵһз8λOSCPUsageУ
//		1ٷֵ㡣
//		ûӦóʹͳûڳʼʱһΨһ
//		OSStatInit()(ļOS_CORE.C)仰˵ڵϵͳOSStart()֮ǰû
//		ʼȽһеϵͳͳƳʼOSStatInit()Ȼٽ
//		Ӧóе
//								 OSIdleCtr
//		OSCPUUsage = 100 * (1 - ------------) (units are in %)
//								OSIdleCtrMax
//: pdata ָһݽṹýṹڽͳʱ񴫵ݲ
//: 
//ע: 1) uC/OS-IIѾȼΪͣOS_LOWEST_PR10ͳȼΪ
//		ͣOS_LOWEST_PR10-1.
//		2) ΪûӦóȽһʼTaskStart()ʹͳǰû
//		ȵõuC/OS-IIеϵͳʼOSInit()
//		3) ڴͳ֮ǰΪ˱ϵͳﵽȶ״̬Ҫӳ5ӣʱ2
//		趨мֵ
#if OS_TASK_STAT_EN > 0
void  OS_TaskStat (void *pdata)
{
#if OS_CRITICAL_METHOD == 3                      /* Allocate storage for CPU status register           */
    OS_CPU_SR  cpu_sr;
#endif    
    INT32U     run;
    INT32U     max;
    INT8S      usage;


    pdata = pdata;                               /* Prevent compiler warning for not using 'pdata'     */
    while (OSStatRdy == FALSE) {
        OSTimeDly(2 * OS_TICKS_PER_SEC);         /* Wait until statistic task is ready                 */
    }
    max = OSIdleCtrMax / 100L;
    for (;;) {
        OS_ENTER_CRITICAL();
        OSIdleCtrRun = OSIdleCtr;                /* Obtain the of the idle counter for the past second */
        run          = OSIdleCtr;
        OSIdleCtr    = 0L;                       /* Reset the idle counter for the next second         */
        OS_EXIT_CRITICAL();
        if (max > 0L) {
            usage = (INT8S)(100L - run / max);
            if (usage >= 0) {                    /* Make sure we don't have a negative percentage      */
                OSCPUUsage = usage;
            } else {
                OSCPUUsage = 0;
            }
        } else {
            OSCPUUsage = 0;
            max        = OSIdleCtrMax / 100L;
        }
        OSTaskStatHook();                        /* Invoke user definable hook                         */
        OSTimeDly(OS_TICKS_PER_SEC);             /* Accumulate OSIdleCtr for the next second           */
    }
}
#endif
//ƿʼ INITIALIZE TCB
//: uC/OS-IIڲڽʱõĳʼƿOS_TCB,7
//		(鿴 OSTaskCreate()  OSTaskCreateExt()).
//: prio ȼ
//		ptos OSTaskInit()ջṹԺ,ptosָջָ,ұOS_TCBOSTCBStkPrt
//		pbos ָջ׵ָ룬OSTCBStkBottomԪ
//		id ־(0..65535).OSTCBId
//		stk_size ջOS_TCBOSTABStkSize
//		pext OS_TCBеչָ룬.OSTCBExtPtrֵ
//		opt OS_TCBѡ.OSTCBOpt
//: OS_NO_ERR óɹ
//		OS_NO_MORE_TCB ûиƿ鱻䣬޷µ
//ע: uC/OS-IIڲ㲻Ե  
INT8U  OS_TCBInit (INT8U prio, OS_STK *ptos, OS_STK *pbos, INT16U id, INT32U stk_size, void *pext, INT16U opt)
{
#if OS_CRITICAL_METHOD == 3                                /* Allocate storage for CPU status register */
    OS_CPU_SR  cpu_sr;
#endif    
    OS_TCB    *ptcb;


    OS_ENTER_CRITICAL();
    ptcb = OSTCBFreeList;                                  /* Get a free TCB from the free TCB list    */
    if (ptcb != (OS_TCB *)0) {
        OSTCBFreeList        = ptcb->OSTCBNext;            /* Update pointer to free TCB list          */
        OS_EXIT_CRITICAL();
        ptcb->OSTCBStkPtr    = ptos;                       /* Load Stack pointer in TCB                */
        ptcb->OSTCBPrio      = (INT8U)prio;                /* Load task priority into TCB              */
        ptcb->OSTCBStat      = OS_STAT_RDY;                /* Task is ready to run                     */
        ptcb->OSTCBDly       = 0;                          /* Task is not delayed                      */

#if OS_TASK_CREATE_EXT_EN > 0
        ptcb->OSTCBExtPtr    = pext;                       /* Store pointer to TCB extension           */
        ptcb->OSTCBStkSize   = stk_size;                   /* Store stack size                         */
        ptcb->OSTCBStkBottom = pbos;                       /* Store pointer to bottom of stack         */
        ptcb->OSTCBOpt       = opt;                        /* Store task options                       */
        ptcb->OSTCBId        = id;                         /* Store task ID                            */
#else
        pext                 = pext;                       /* Prevent compiler warning if not used     */
        stk_size             = stk_size;
        pbos                 = pbos;
        opt                  = opt;
        id                   = id;
#endif

#if OS_TASK_DEL_EN > 0
        ptcb->OSTCBDelReq    = OS_NO_ERR;
#endif

        ptcb->OSTCBY         = prio >> 3;                  /* Pre-compute X, Y, BitX and BitY          */
        ptcb->OSTCBBitY      = OSMapTbl[ptcb->OSTCBY];
        ptcb->OSTCBX         = prio & 0x07;
        ptcb->OSTCBBitX      = OSMapTbl[ptcb->OSTCBX];

#if OS_EVENT_EN > 0
        ptcb->OSTCBEventPtr  = (OS_EVENT *)0;              /* Task is not pending on an event          */
#endif

#if (OS_VERSION >= 251) && (OS_FLAG_EN > 0) && (OS_MAX_FLAGS > 0) && (OS_TASK_DEL_EN > 0)
        ptcb->OSTCBFlagNode  = (OS_FLAG_NODE *)0;          /* Task is not pending on an event flag     */
#endif

#if (OS_MBOX_EN > 0) || ((OS_Q_EN > 0) && (OS_MAX_QS > 0))
        ptcb->OSTCBMsg       = (void *)0;                  /* No message received                      */
#endif

#if OS_VERSION >= 204
        OSTCBInitHook(ptcb);
#endif

        OSTaskCreateHook(ptcb);                            /* Call user defined hook                   */
        
        OS_ENTER_CRITICAL();
        OSTCBPrioTbl[prio] = ptcb;
        ptcb->OSTCBNext    = OSTCBList;                    /* Link into TCB chain                      */
        ptcb->OSTCBPrev    = (OS_TCB *)0;
        if (OSTCBList != (OS_TCB *)0) {
            OSTCBList->OSTCBPrev = ptcb;
        }
        OSTCBList               = ptcb;
        OSRdyGrp               |= ptcb->OSTCBBitY;         /* Make task ready to run                   */
        OSRdyTbl[ptcb->OSTCBY] |= ptcb->OSTCBBitX;
        OS_EXIT_CRITICAL();
        return (OS_NO_ERR);
    }
    OS_EXIT_CRITICAL();
    return (OS_NO_MORE_TCB);
}
