/*
*********************************************************************************************************
* uC/OS-IIʵʱں
* Ҫİļ
*  : uCOS_II.H ucosڲ趨
*  : Jean J. Labrosse
*********************************************************************************************************
*/
#include "includes.h"
#include "os_cpu.h"
#include "os_cfg.h"

//ӵĶ
#define  OS_VERSION              252       //UCOSIIİ汾,2.52汾

#ifdef   OS_GLOBALS						   // OS_GLOBALS ѱ, 뽫ᱻ
#define  OS_EXT							   // OS_EXT
#else
#define  OS_EXT  extern					   //򣬶 OS_EXT Ϊ extern
#endif


//stm32f10x_type.höٵķʽˣԲҪٶ
//#ifndef  FALSE						   //Ƿδ FALSE
//#define  FALSE                     0	   //û FALSE Ϊ 0
//#endif
//
//#ifndef  TRUE							   //Ƿδ TRUE
//#define  TRUE                      1	   //û TRUE Ϊ 1
//#endif

#define  OS_PRIO_SELF           0xFF       // OS_PRIO_SELF Ϊ 0xFF

#if OS_TASK_STAT_EN > 0
#define  OS_N_SYS_TASKS            2       //ϵͳΪ2   
#else
#define  OS_N_SYS_TASKS            1	   //ϵͳΪ1 
#endif

#define  OS_STAT_PRIO       (OS_LOWEST_PRIO - 1)        //ͳȼ
#define  OS_IDLE_PRIO       (OS_LOWEST_PRIO)            //ȼ 

#define  OS_EVENT_TBL_SIZE ((OS_LOWEST_PRIO) / 8 + 1)   //¼бС
#define  OS_RDY_TBL_SIZE   ((OS_LOWEST_PRIO) / 8 + 1)   //бС

#define  OS_TASK_IDLE_ID       65535                    //ϵͳID
#define  OS_TASK_STAT_ID       65534

#define  OS_EVENT_EN       (((OS_Q_EN > 0) && (OS_MAX_QS > 0)) || (OS_MBOX_EN > 0) || (OS_SEM_EN > 0) || (OS_MUTEX_EN > 0))

//*********************************************************************************************************
//״̬ TASK STATUS (OSTCBStatλ)       
#define  OS_STAT_RDY            0x00        // (״̬)ھ״̬
#define  OS_STAT_SEM            0x01        // (״̬)ź״̬                               
#define  OS_STAT_MBOX           0x02        // (״̬)״̬  
#define  OS_STAT_Q              0x04        // (״̬)Q״̬
#define  OS_STAT_SUSPEND        0x08        // ʾ񱻹
#define  OS_STAT_MUTEX          0x10        // (״̬)MUTEX״̬
#define  OS_STAT_FLAG           0x20        // (״̬)FLAG״̬

//*********************************************************************************************************
//¼(OS_EVENT types)
#define  OS_EVENT_TYPE_UNUSED      0        // ¼͵(¼------------0)
#define  OS_EVENT_TYPE_MBOX        1		// ¼͵(Ϊ--------1)
#define  OS_EVENT_TYPE_Q           2		// ¼͵(ϢΪ----2)
#define  OS_EVENT_TYPE_SEM         3	    // ¼͵(źΪ------3)
#define  OS_EVENT_TYPE_MUTEX       4	    // ¼͵(źΪ4)
#define  OS_EVENT_TYPE_FLAG        5		// ¼͵(¼־Ϊ--5)

//*********************************************************************************************************
//¼־(EVENT FLAGS)
#define  OS_FLAG_WAIT_CLR_ALL      0        // ָ¼־λ0 ------ 0
#define  OS_FLAG_WAIT_CLR_AND      0

#define  OS_FLAG_WAIT_CLR_ANY      1        // ָ¼־λ0 ------ 1
#define  OS_FLAG_WAIT_CLR_OR       1

#define  OS_FLAG_WAIT_SET_ALL      2        // ָ¼־λ1 ------ 2
#define  OS_FLAG_WAIT_SET_AND      2

#define  OS_FLAG_WAIT_SET_ANY      3        // ָ¼־λ1 ------ 3
#define  OS_FLAG_WAIT_SET_OR       3

// Ҫڵõ־󣬻ָ¼־˳
#define  OS_FLAG_CONSUME        0x80        // 峣OS_FLAG_CONSUMEΪ0x80

											
#define  OS_FLAG_CLR               0		//  OS_FLAG_CLR Ϊ0
#define  OS_FLAG_SET               1	    //  OS_FLAG_SET Ϊ1

//*********************************************************************************************************
//'opt'У OSSemDel(), OSMboxDel(), OSQDel()  OSMutexDel()
#define  OS_DEL_NO_PEND            0		// ѡֻѾûκڵȴźʱɾź
#define  OS_DEL_ALWAYS             1		// ûڵȴźɾź

//*********************************************************************************************************
//OS???PostOpt() OPTIONS()
//Щ OSMboxPostOpt()  OSQPostOpt().	 
#define  OS_POST_OPT_NONE       0x00       	// һϢ()һȴϢȼߵ
#define  OS_POST_OPT_BROADCAST  0x01        // ϢеȴϢ 
#define  OS_POST_OPT_FRONT      0x02        // ԺȳʽϢ(OSQPostFront())

//*********************************************************************************************************
// TASK OPTIONS (鿴OSTaskCreateExt())   
#define  OS_TASK_OPT_STK_CHK  0x0001        // Ƿջ
#define  OS_TASK_OPT_STK_CLR  0x0002        // Ƿնջ
#define  OS_TASK_OPT_SAVE_FP  0x0004        // Ƿ񱣴渡ĴֵиʱЧӲصĴ

//*********************************************************************************************************
// ERROR CODES
#define OS_NO_ERR                 0			// سɹ;

#define OS_ERR_EVENT_TYPE         1			// ָ¼()͵ָ;
#define OS_ERR_PEND_ISR           2			// жϷӳе OSźAccept().
#define OS_ERR_POST_NULL_PTR      3			// ûָ롣ݹﲻָֿ֧;
#define OS_ERR_PEVENT_NULL        4			// 'pevent'ָָ;
#define OS_ERR_POST_ISR           5			// ͼжϷӳеOSMutexPost()[ͷһmutex];
#define OS_ERR_QUERY_ISR          6			// ͼжӳеOSMutexQuery()[õmutexǰ״̬Ϣ]
#define OS_ERR_INVALID_OPT        7			// optЧ;
#define OS_ERR_TASK_WAITING       8			// һһϵڵȴϢеϢ;

#define OS_TIMEOUT               10			// Ϣûָ͵;
#define OS_TASK_NOT_EXIST        11			// ָ񲻴;

#define OS_MBOX_FULL             20			// ϢѾϢ;

#define OS_Q_FULL                30			// ϢѾ;

#define OS_PRIO_EXIST            40			// ȼΪPIPѾ;
#define OS_PRIO_ERR              41			// еԭȼ;
#define OS_PRIO_INVALID          42			// ָȼOS_LOWEST_PRIO;

#define OS_SEM_OVF               50			// źֵ;

#define OS_TASK_DEL_ERR          60			// ָҪɾ񲻴
#define OS_TASK_DEL_IDLE         61			// ͼɾ(Idle task);
#define OS_TASK_DEL_REQ          62			// ǰյɾ;
#define OS_TASK_DEL_ISR          63			// ͼжϴɾ;

#define OS_NO_MORE_TCB           70			// ϵͳûOS_TCBԷ;

#define OS_TIME_NOT_DLY          80			// Ҫѵʱ״̬;
#define OS_TIME_INVALID_MINUTES  81			// 󣬷59;
#define OS_TIME_INVALID_SECONDS  82			// 59
#define OS_TIME_INVALID_MILLI    83			// 򷵻ز󣬺999;
#define OS_TIME_ZERO_DLY         84		    // ĸȫΪ0

#define OS_TASK_SUSPEND_PRIO     90			// Ҫ񲻴
#define OS_TASK_SUSPEND_IDLE     91			// ͼuC/OS-IIеĿ(Idle task)

#define OS_TASK_RESUME_PRIO     100		    // Ҫѵ񲻴;
#define OS_TASK_NOT_SUSPENDED   101			// Ҫѵڹ״̬

#define OS_MEM_INVALID_PART     110			// ûпеڴ;
#define OS_MEM_INVALID_BLKS     111			// ûΪÿһڴ2ڴ;
#define OS_MEM_INVALID_SIZE     112			// ڴСһָ;
#define OS_MEM_NO_FREE_BLKS     113			// ڴѾûпռڴ;
#define OS_MEM_FULL             114			// ڴѾٽܸͷŵڴ顣˵û
#define OS_MEM_INVALID_PBLK     115
#define OS_MEM_INVALID_PMEM     116		    // 'pmem'ǿָ;
#define OS_MEM_INVALID_PDATA    117			// pdataǿָ;
#define OS_MEM_INVALID_ADDR     118			// ǷַַΪָ;

#define OS_ERR_NOT_MUTEX_OWNER  120			// mutexʵϲռmutex;

#define OS_TASK_OPT_ERR         130			// OSTaskCreateExt()ʱûָ

#define OS_ERR_DEL_ISR          140			// ͼжϷӳɾ(Ϣ䡢źϢСź)
#define OS_ERR_CREATE_ISR       141			// ͼжϷӳн(¼־顢ź);

#define OS_FLAG_INVALID_PGRP    150			// pgrpһָ;
#define OS_FLAG_ERR_WAIT_TYPE   151			// 'wait_type'ָĲ֮һ;
#define OS_FLAG_ERR_NOT_RDY     152			// ָ¼־ûз;
#define OS_FLAG_INVALID_OPT     153		    // optָĲ֮һ;
#define OS_FLAG_GRP_DEPLETED    154			// ϵͳûʣĿ¼־飬ҪOS_CFG.Hе¼־Ŀ

//*********************************************************************************************************
//¼ƿ(EVENT CONTROL BLOCK)
#if (OS_EVENT_EN > 0) && (OS_MAX_EVENTS > 0)
typedef struct {						   // һ¼ƿṹ(OS_EVENT)
    INT8U   OSEventType;                   // ¼
    INT8U   OSEventGrp;                    // ȴڵ
    INT16U  OSEventCnt;                    // (¼źʱ)
    void   *OSEventPtr;                    // ָϢϢеָ
    INT8U   OSEventTbl[OS_EVENT_TBL_SIZE]; // ȴб
} OS_EVENT;
#endif

//*********************************************************************************************************
//¼־ƿ (EVENT FLAGS CONTROL BLOCK)
#if (OS_VERSION >= 251) && (OS_FLAG_EN > 0) && (OS_MAX_FLAGS > 0)//汾Ϊ2.51  ¼־ ¼־0ʱ
typedef struct {                             // һOS_FLAG_GRPṹ                                   
    INT8U         OSFlagType;                // ָǷָ¼־ָ
    void         *OSFlagWaitList;            // һȴ¼б
    OS_FLAGS      OSFlagFlags;               // һϵбǰ¼־״̬λ               
} OS_FLAG_GRP;    							 // ¼־
											      
typedef struct {                            // һ¼־ȴбڵ(OS_FLAG_NODE)ṹ
    void         *OSFlagNodeNext;           // ˫OS_FLAG_NODEݽṹĺһ
    void         *OSFlagNodePrev;           // ˫OS_FLAG_NODEݽṹǰһ
    void         *OSFlagNodeTCB;            // ָĳȴ¼־е¼־Ŀƿ
    void         *OSFlagNodeFlagGrp;        // һָ¼־ָ 
    OS_FLAGS      OSFlagNodeFlags;          // ָȴ¼־еЩ¼־
    INT8U         OSFlagNodeWaitType;       // ָȴ¼־е¼־ķ(롢)
                                            /*      OS_FLAG_WAIT_AND                                   */
                                            /*      OS_FLAG_WAIT_ALL                                   */
                                            /*      OS_FLAG_WAIT_OR                                    */
                                            /*      OS_FLAG_WAIT_ANY                                   */
} OS_FLAG_NODE;
#endif


//*********************************************************************************************************
// 趨һϢеݽṹ (MESSAGE MAILBOX DATA)
#if OS_MBOX_EN > 0
typedef struct {						   // һOS_MBOX_DATAṹ
    void   *OSMsg;                         // ϢϢָ.OSQOutָĶеԪ
										   // ݡǿյģ.OSMsgһNULLָ
    INT8U   OSEventTbl[OS_EVENT_TBL_SIZE]; // Ϣеĵȴб
    INT8U   OSEventGrp;                    // OSEventTbl[]ʹ
} OS_MBOX_DATA;
#endif

//*********************************************************************************************************
//趨һڴݽṹ (MEMORY PARTITION DATA STRUCTURES)
#if (OS_MEM_EN > 0) && (OS_MAX_MEM_PART > 0)
typedef struct {                       // ʹڴƿ飨memory control blocksݽṹÿһ
									   // ڴϵͳеÿڴԼڴƿ顣
    void   *OSMemAddr;                 // ָڴʼַָ
    void   *OSMemFreeList;             // ָһڴƿһеڴָ
    INT32U  OSMemBlkSize;              // ڴڴĴСûڴʱָ
    INT32U  OSMemNBlks;                // ڴܵڴҲûڴʱָ
    INT32U  OSMemNFree;                // ڴеǰԵÿڴ
} OS_MEM;


typedef struct {
    void   *OSAddr;                    // ָڴʼַָ
    void   *OSFreeList;                /// ָڴбʼַָ
    INT32U  OSBlkSize;                 // ÿڴĴС
    INT32U  OSNBlks;                   // ڴڴ
    INT32U  OSNFree;                   // еڴĿ
    INT32U  OSNUsed;                   // ʹõڴĿ
} OS_MEM_DATA;
#endif

//*********************************************************************************************************
//ź(MUTUAL EXCLUSION SEMAPHORE DATA)
#if OS_MUTEX_EN > 0	// (1)߲źش
typedef struct {	// ָΪ(OS_MUTEX_DATA)ݽṹָ
    INT8U   OSEventTbl[OS_EVENT_TBL_SIZE];  /* List of tasks waiting for event to occur                */
    INT8U   OSEventGrp;                     // Ƶȴmutexб
    INT8U   OSValue;                        // ǰmutexֵ.1ʾʹã0ʾʹ
    INT8U   OSOwnerPrio;                    // ռmutexȼ
    INT8U   OSMutexPIP;                     // mutexȼ̳ȼPIP
} OS_MUTEX_DATA;
#endif

//*********************************************************************************************************
// Ϣ (MESSAGE QUEUE DATA)
/*
пƿһάϢϢݽṹµһЩȻڸǰ
һ[.]ʾݽṹеһ
1).OSQPtr: ڿжпƿеĶпƿ顣һϢУͲˡ
2).OSQStart: ָϢеָʼַָ롣ûӦóʹϢ֮ǰȶ

3).OSQEnd: ָϢнԪһַָ롣ָʹϢйһѭĻ
4).OSQIn: ָϢвһϢλõָ롣.OSQIn.OSQEndʱ.OSQInָ
ϢеʼԪ
5).OSQOut: ָϢһȡϢλõָ롣.OSQOut.OSQEndʱ.OSQOutָ
ϢеʼԪ
6).OSQSize: ϢܵĵԪֵڽϢʱûӦóġuC/OS-II,ֵ
65,535
7).OSQEntries: ϢеǰϢϢǿյʱֵΪ0ϢԺ󣬸ֵ
.OSQSizeֵһ ϢиոսʱֵΪ0
*/

#if OS_Q_EN > 0
typedef struct os_q {                   // һOS_Qпƿ                                    */
    struct os_q   *OSQPtr;              /* Link to next queue control block in list of free blocks     */
    void         **OSQStart;            /* Pointer to start of queue data                              */
    void         **OSQEnd;              /* Pointer to end   of queue data                              */
    void         **OSQIn;               /* Pointer to where next message will be inserted  in   the Q  */
    void         **OSQOut;              /* Pointer to where next message will be extracted from the Q  */
    INT16U         OSQSize;             /* Size of queue (maximum number of entries)                   */
    INT16U         OSQEntries;          /* Current number of entries in the queue                      */
} OS_Q;								 

typedef struct {						// һϢ(OS_Q_DATA)ṹ
    void          *OSMsg;               // ϢϢָ
    INT16U         OSNMsgs;             // ϢеϢ
    INT16U         OSQSize;             // Ϣеܵ                                      */
    INT8U          OSEventTbl[OS_EVENT_TBL_SIZE];  /* List of tasks waiting for event to occur         */
    INT8U          OSEventGrp;          //OSEventTbl[]һϣϢеĵȴб
} OS_Q_DATA;
#endif

//*********************************************************************************************************
//źݽṹ (SEMAPHORE DATA)
#if OS_SEM_EN > 0
typedef struct {						    // һźݽṹ(OS_SEM_DATA)
    INT16U  OSCnt;                          // źֵ                                      
    INT8U   OSEventTbl[OS_EVENT_TBL_SIZE];  // ȴб
    INT8U   OSEventGrp;                     // ȴ¼
} OS_SEM_DATA;
#endif

//*********************************************************************************************************
//ջ (TASK STACK DATA)
#if OS_TASK_CREATE_EXT_EN > 0
typedef struct {					   // һջݽṹ(OS_STK_DATA)
    INT32U  OSFree;                    // ջδʹõֽ
    INT32U  OSUsed;                    // ջʹõֽ                
} OS_STK_DATA;
#endif

//*********************************************************************************************************
//ƿ (TASK CONTROL BLOCK)
typedef struct os_tcb {
    OS_STK        *OSTCBStkPtr;        //ǰTCBջָ

#if OS_TASK_CREATE_EXT_EN > 0		   //OSTaskCreateExt()
    void          *OSTCBExtPtr;        //ָûƿ(չָ)
    OS_STK        *OSTCBStkBottom;     //ָָջ׵ָ
    INT32U         OSTCBStkSize;       //趨ջ
    INT16U         OSTCBOpt;           //OS_TCBѡ
    INT16U         OSTCBId;            //ID  (0..65535)             
#endif

    struct os_tcb *OSTCBNext;          //ָTCB˫ӵĺ
    struct os_tcb *OSTCBPrev;          //ָTCB˫ӵǰ

#if ((OS_Q_EN > 0) && (OS_MAX_QS > 0)) || (OS_MBOX_EN > 0) || (OS_SEM_EN > 0) || (OS_MUTEX_EN > 0)
//ϸ¼ʱ
    OS_EVENT      *OSTCBEventPtr;      //ָ¼ƿָ
#endif

#if ((OS_Q_EN > 0) && (OS_MAX_QS > 0)) || (OS_MBOX_EN > 0)
//,崫ݸϢָ
    void          *OSTCBMsg;           /* Message received from OSMboxPost() or OSQPost()              */
#endif

#if (OS_VERSION >= 251) && (OS_FLAG_EN > 0) && (OS_MAX_FLAGS > 0)
#if OS_TASK_DEL_EN > 0
    OS_FLAG_NODE  *OSTCBFlagNode;      ///¼־ڵָ
#endif    
    OS_FLAGS       OSTCBFlagsRdy;      //׼ϵƿе?
#endif

    INT16U         OSTCBDly;           //ȴʱ
    INT8U          OSTCBStat;          //״̬        
    INT8U          OSTCBPrio;          //ȼ(0 == highest, 63 == lowest)                 

    INT8U          OSTCBX;             //ָȼĵ3λ=priority&0x07
    INT8U          OSTCBY;             //ָȼĸ3λ=priority>>3
    INT8U          OSTCBBitX;          //3λӦֵ07OSMapTbl[priority&0x07]
    INT8U          OSTCBBitY;          //3λӦֵ07OSMapTbl[priority>>3]

#if OS_TASK_DEL_EN > 0				   // OSTaskDel() 뺯
    BOOLEAN        OSTCBDelReq;        //ڱʾǷɾ
#endif
} OS_TCB;

//*********************************************************************************************************
//ȫֱ (GLOBAL VARIABLES)
OS_EXT  INT32U            OSCtxSwCtr;               //лĴ(ͳ)

#if (OS_EVENT_EN > 0) && (OS_MAX_EVENTS > 0)	    //Ϣ¼Ϣ¼>0
OS_EXT  OS_EVENT         *OSEventFreeList;          //¼бָ
OS_EXT  OS_EVENT          OSEventTbl[OS_MAX_EVENTS];//¼ƿ
#endif
//汾2.51¼־¼־
#if (OS_VERSION >= 251) && (OS_FLAG_EN > 0) && (OS_MAX_FLAGS > 0)
OS_EXT  OS_FLAG_GRP       OSFlagTbl[OS_MAX_FLAGS];  //һ¼־б
OS_EXT  OS_FLAG_GRP      *OSFlagFreeList;           //һе¼־
#endif

#if OS_TASK_STAT_EN > 0							    //OS_TaskStat()
OS_EXT  INT8S             OSCPUUsage;               //CPU ʹ                        
OS_EXT  INT32U            OSIdleCtrMax;             //мֵ
OS_EXT  INT32U            OSIdleCtrRun;             //嵱ǰĿмֵ
OS_EXT  BOOLEAN           OSStatRdy;                //ͳ־
OS_EXT  OS_STK            OSTaskStatStk[OS_TASK_STAT_STK_SIZE];/* Statistics task stack          */
#endif

OS_EXT  INT8U             OSIntNesting;             //жǶײ
OS_EXT  INT8U             OSIntExitY;				//ںOSInieExt( )

OS_EXT  INT8U             OSLockNesting;            //Ƕ׼

OS_EXT  INT8U             OSPrioCur;                //еȼ
OS_EXT  INT8U             OSPrioHighRdy;            //ȼľȼ

OS_EXT  INT8U             OSRdyGrp;                        /* Ready list group                         */
OS_EXT  INT8U             OSRdyTbl[OS_RDY_TBL_SIZE];       //Ҫеб

OS_EXT  BOOLEAN           OSRunning;                       //Ѿʼ=1,ڲ״̬=0

OS_EXT  INT8U             OSTaskCtr;                       //

OS_EXT  volatile  INT32U  OSIdleCtr;                        //32λļ

OS_EXT  OS_STK            OSTaskIdleStk[OS_TASK_IDLE_STK_SIZE];//ջջָ


OS_EXT  OS_TCB           *OSTCBCur;                        //ָƿָ
OS_EXT  OS_TCB           *OSTCBFreeList;                   //ƿָ  
OS_EXT  OS_TCB           *OSTCBHighRdy;                    //ָ߼ȼƿָ
OS_EXT  OS_TCB           *OSTCBList;                       //ƿб׵ַ
OS_EXT  OS_TCB           *OSTCBPrioTbl[OS_LOWEST_PRIO + 1];//ƿȼ
OS_EXT  OS_TCB            OSTCBTbl[OS_MAX_TASKS + OS_N_SYS_TASKS];//嵱ǰƿб

//룺ʱ´
//OS_MEM_EN (1) ֹ߽ (0) ڴش
//OS_MAX_MEM_PART ڴĿ
#if (OS_MEM_EN > 0) && (OS_MAX_MEM_PART > 0)
OS_EXT  OS_MEM           *OSMemFreeList;            //ڴƿ()ָ
OS_EXT  OS_MEM            OSMemTbl[OS_MAX_MEM_PART];/* Storage for memory partition manager            */
#endif

#if (OS_Q_EN > 0) && (OS_MAX_QS > 0)				//룺OS_Q_EN  (1)Ϣش
//룺ӦпƿĿ > 0			
OS_EXT  OS_Q             *OSQFreeList;              /* Pointer to list of free QUEUE control blocks    */
OS_EXT  OS_Q              OSQTbl[OS_MAX_QS];        /* Table of QUEUE control blocks                   */
#endif

#if OS_TIME_GET_SET_EN > 0   					    //OSTimeGet() 	 
OS_EXT  volatile  INT32U  OSTime;                   //ǰϵͳʱֵ(in ticks)        
#endif

extern  INT8U  const      OSMapTbl[];               /* Priority->Bit Mask lookup table                 */
extern  INT8U  const      OSUnMapTbl[];             /* Priority->Index    lookup table                 */

//*********************************************************************************************************
//ԭ (FUNCTION PROTOTYPES)
//Լĺ (Target Independent Functions)
//¼־ (EVENT FLAGS MANAGEMENT)
//OSFlagAccept() ¼־麯(־ָ롢¼־λȴ¼־λķʽָ)
//OSFlagCreate() һ¼־(ֵ)
//OSFlagDel() ɾһ¼־(ָ롢ֵֵ)
//OSFlagPend() ȴ¼־¼־λ(¼ָ롢Ҫı־λȴ¼־λķʽ
//ȴʱӽġʱӽ)
//OSFlagPost() λ0¼־еı־λ(ָ롢־λֵ)
//OSFlagQuery() ѯ¼־ĵǰ¼־״̬(¼־ָ롢ָ)

#if (OS_VERSION >= 251) && (OS_FLAG_EN > 0) && (OS_MAX_FLAGS > 0)

#if OS_FLAG_ACCEPT_EN > 0
OS_FLAGS      OSFlagAccept(OS_FLAG_GRP *pgrp, OS_FLAGS flags, INT8U wait_type, INT8U *err);
#endif

OS_FLAG_GRP  *OSFlagCreate(OS_FLAGS flags, INT8U *err);

#if OS_FLAG_DEL_EN > 0
OS_FLAG_GRP  *OSFlagDel(OS_FLAG_GRP *pgrp, INT8U opt, INT8U *err);
#endif

OS_FLAGS      OSFlagPend(OS_FLAG_GRP *pgrp, OS_FLAGS flags, INT8U wait_type, INT16U timeout, INT8U *err);
OS_FLAGS      OSFlagPost(OS_FLAG_GRP *pgrp, OS_FLAGS flags, INT8U operation, INT8U *err);

#if OS_FLAG_QUERY_EN > 0
OS_FLAGS      OSFlagQuery(OS_FLAG_GRP *pgrp, INT8U *err);
#endif
#endif

//*********************************************************************************************************
//Ϣ (MESSAGE MAILBOX MANAGEMENT)
//OSMboxAccept () 鿴Ϣ(Ϣָ)
//OSMboxCreate () ʼһϢ(msg Ϊպ)
//OSMboxDel () ɾϢ(Ϣָ롢ɾָ)
//OSMboxPend () ȴһϢ亯(Ϣָ롢ȴʱӽġָ)
//OSMboxPost () Ϣ(Ϣָ롢ʵʷ͸Ϣ)
//OSMboxPostOpt () ䷢һϢ(ָ롢Ϣ)
//OSMboxQuery () ѯһĵǰ״̬(źָ롢״̬ݽṹָ)


#if OS_MBOX_EN > 0

#if OS_MBOX_ACCEPT_EN > 0
void         *OSMboxAccept(OS_EVENT *pevent);
#endif

OS_EVENT     *OSMboxCreate(void *msg);

#if OS_MBOX_DEL_EN > 0
OS_EVENT     *OSMboxDel(OS_EVENT *pevent, INT8U opt, INT8U *err);
#endif

void         *OSMboxPend(OS_EVENT *pevent, INT16U timeout, INT8U *err);

#if OS_MBOX_POST_EN > 0
INT8U         OSMboxPost(OS_EVENT *pevent, void *msg);
#endif

#if OS_MBOX_POST_OPT_EN > 0
INT8U         OSMboxPostOpt(OS_EVENT *pevent, void *msg, INT8U opt);
#endif

#if OS_MBOX_QUERY_EN > 0
INT8U         OSMboxQuery(OS_EVENT *pevent, OS_MBOX_DATA *pdata);
#endif
#endif

//*********************************************************************************************************
//ڴ (MEMORY MANAGEMENT)	  
//OSMemCreate () ʼһڴ(ʼַҪڴĿڴСشָ)
//OSMemGet () ڴһڴ
//OSMemPut () ͷһڴ飬ڴͷŻԭڴ
//OSMemQuery () õڴϢ


#if (OS_MEM_EN > 0) && (OS_MAX_MEM_PART > 0)

OS_MEM       *OSMemCreate(void *addr, INT32U nblks, INT32U blksize, INT8U *err);
void         *OSMemGet(OS_MEM *pmem, INT8U *err);
INT8U         OSMemPut(OS_MEM *pmem, void *pblk);

#if OS_MEM_QUERY_EN > 0
INT8U         OSMemQuery(OS_MEM *pmem, OS_MEM_DATA *pdata);
#endif

#endif

//*********************************************************************************************************
//ź (MUTUAL EXCLUSION SEMAPHORE MANAGEMENT) 
//OSMutexAccept () ޵ȴػȡź[񲻹](źָ롢)
//OSMutexCreate () ʼһź(ȼ̳ȼ(PIP)ָ)
//OSMutexDel () ɾź(źָ롢ɾָ)
//OSMutexPend () ȴһź(ָ롢ȴʱʱޡָ)
//OSMutexPost () ͷһź(źָ)
//OSMutexQuery () ѯһźĵǰ״̬(źָ롢״̬ݽṹָ)


#if OS_MUTEX_EN > 0

#if OS_MUTEX_ACCEPT_EN > 0
INT8U         OSMutexAccept(OS_EVENT *pevent, INT8U *err);
#endif

OS_EVENT     *OSMutexCreate(INT8U prio, INT8U *err);

#if OS_MUTEX_DEL_EN > 0
OS_EVENT     *OSMutexDel(OS_EVENT *pevent, INT8U opt, INT8U *err);
#endif

void          OSMutexPend(OS_EVENT *pevent, INT16U timeout, INT8U *err);
INT8U         OSMutexPost(OS_EVENT *pevent);

#if OS_MUTEX_QUERY_EN > 0
INT8U         OSMutexQuery(OS_EVENT *pevent, OS_MUTEX_DATA *pdata);
#endif

#endif

//*********************************************************************************************************
//Ϣй (MESSAGE QUEUE MANAGEMENT)	  
//OSQAccept () ϢǷѾҪϢ(Ϣеָ)
//OSQCreate () һϢ(ϢڴĻַ(ָ)ϢڴĴС)
//OSQDel () ɾһϢ(Ϣָ롢ɾָ)
//OSQFlush () Ϣ(ָõϢеָ)
//OSQPend () ȴϢеϢ(Ϣָ롢ȴʱӽġָ)
//OSQPost () ϢзһϢFIFO(Ϣָ롢͵Ϣ)
//OSQPostFront () ϢзһϢLIFO(Ϣָ롢͵Ϣ)
//OSQPostOpt () ϢзһϢLIFO(Ϣָ롢͵Ϣ)
//OSQQuery () ѯһϢеĵǰ״̬(źָ롢״̬ݽṹָ)

#if (OS_Q_EN > 0) && (OS_MAX_QS > 0)

#if OS_Q_ACCEPT_EN > 0
void         *OSQAccept(OS_EVENT *pevent);
#endif

OS_EVENT     *OSQCreate(void **start, INT16U size);

#if OS_Q_DEL_EN > 0
OS_EVENT     *OSQDel(OS_EVENT *pevent, INT8U opt, INT8U *err);
#endif

#if OS_Q_FLUSH_EN > 0
INT8U         OSQFlush(OS_EVENT *pevent);
#endif

void         *OSQPend(OS_EVENT *pevent, INT16U timeout, INT8U *err);

#if OS_Q_POST_EN > 0
INT8U         OSQPost(OS_EVENT *pevent, void *msg);
#endif

#if OS_Q_POST_FRONT_EN > 0
INT8U         OSQPostFront(OS_EVENT *pevent, void *msg);
#endif

#if OS_Q_POST_OPT_EN > 0
INT8U         OSQPostOpt(OS_EVENT *pevent, void *msg, INT8U opt);
#endif

#if OS_Q_QUERY_EN > 0
INT8U         OSQQuery(OS_EVENT *pevent, OS_Q_DATA *pdata);
#endif

#endif

//*********************************************************************************************************
//ź (SEMAPHORE MANAGEMENT)	    
//OSSemAccept() صȴһź
//OSSemCreate() ʼһź(һźֵ)
//OSSemDel() ɾһź(źָ롢ɾָ)
//OSSemPend () ȴһź(źָ롢ȴʱӽġָ)
//OSSemPost () һź(źָ)
//OSSemQuery () ѯһźĵǰ״̬(źָ롢״̬ݽṹָ)

#if OS_SEM_EN > 0

#if OS_SEM_ACCEPT_EN > 0
INT16U        OSSemAccept(OS_EVENT *pevent);
#endif

OS_EVENT     *OSSemCreate(INT16U cnt);

#if OS_SEM_DEL_EN > 0
OS_EVENT     *OSSemDel(OS_EVENT *pevent, INT8U opt, INT8U *err);
#endif

void          OSSemPend(OS_EVENT *pevent, INT16U timeout, INT8U *err);
INT8U         OSSemPost(OS_EVENT *pevent);

#if OS_SEM_QUERY_EN > 0
INT8U         OSSemQuery(OS_EVENT *pevent, OS_SEM_DATA *pdata);
#endif

#endif
	   
//*********************************************************************************************************
// (TASK MANAGEMENT)    
//OSTaskChangePrio () ıһȼ(ɵȼµȼ)
//OSTaskCreate () (ָ롢ݲָ롢ջջָ롢ȼ)
//OSTaskCreateExt () չ(ָ/ݲָ/ջջָ/ȼ
//(δ)ȼʶ(ȼͬ)/ջջָ/ָջ()
//ָûӵָ/趨ѡ)
//OSTaskDel () ɾ(ȼ)
//OSTaskDelReq () һɾ?(ȼ)
//OSTaskResume () һOSTaskSuspend()(ȼ)
//OSTaskStkChk () ջ״̬(ȼջݽṹ)
//OSTaskSuspend () һ(ȼ)
//OSTaskQuery () ȡϢ(ָ롢ݽṹָ)

#if OS_TASK_CHANGE_PRIO_EN > 0
INT8U         OSTaskChangePrio(INT8U oldprio, INT8U newprio);
#endif

#if OS_TASK_CREATE_EN > 0
INT8U         OSTaskCreate(void (*task)(void *pd), void *pdata, OS_STK *ptos, INT8U prio);
#endif

#if OS_TASK_CREATE_EXT_EN > 0
INT8U         OSTaskCreateExt(void  (*task)(void *pd),
                              void   *pdata,
                              OS_STK *ptos,
                              INT8U   prio,
                              INT16U  id,
                              OS_STK *pbos,
                              INT32U  stk_size,
                              void   *pext,
                              INT16U  opt);
#endif

#if OS_TASK_DEL_EN > 0
INT8U         OSTaskDel(INT8U prio);
INT8U         OSTaskDelReq(INT8U prio);
#endif

#if OS_TASK_SUSPEND_EN > 0
INT8U         OSTaskResume(INT8U prio);
INT8U         OSTaskSuspend(INT8U prio);
#endif

#if OS_TASK_CREATE_EXT_EN > 0
INT8U         OSTaskStkChk(INT8U prio, OS_STK_DATA *pdata);
#endif

#if OS_TASK_QUERY_EN > 0
INT8U         OSTaskQuery(INT8U prio, OS_TCB *pdata);
#endif

//*********************************************************************************************************
//ʱӹ (TIME MANAGEMENT)  
//OSTimeDly () ʱ(ʱӽ)
//OSTimeDlyHMSM () һʱʱ(趨ʱ֡롢)
//OSTimeDlyResume () һOSTimeDly()OSTimeDlyHMSM()(ȼ)
//OSTimeGet () ȡǰϵͳʱֵ
//OSTimeSet () õǰϵͳʱֵ	 

void          OSTimeDly(INT16U ticks);

#if OS_TIME_DLY_HMSM_EN > 0
INT8U         OSTimeDlyHMSM(INT8U hours, INT8U minutes, INT8U seconds, INT16U milli);
#endif

#if OS_TIME_DLY_RESUME_EN > 0
INT8U         OSTimeDlyResume(INT8U prio);
#endif

#if OS_TIME_GET_SET_EN > 0
INT32U        OSTimeGet(void);
void          OSTimeSet(INT32U ticks);
#endif

void          OSTimeTick(void);

//*********************************************************************************************************
//Ӻ	 
//OSInit() ʼUCOS-II
//OSIntEnter() жϺִ
//OSIntExit() жϺѾ(ж)
//OSSchedLock() 
//OSSchedUnlock() 
//OSStart() 
//OSStatInit() ͳʼ
//OSVersion() ð汾

void          OSInit(void);

void          OSIntEnter(void);
void          OSIntExit(void);

#if OS_SCHED_LOCK_EN > 0
void          OSSchedLock(void);
void          OSSchedUnlock(void);
#endif

void          OSStart(void);

void          OSStatInit(void);

INT16U        OSVersion(void);

//*********************************************************************************************************
//ڲԭ INTERNAL FUNCTION PROTOTYPES
//Ӧóвʹ (Your application MUST NOT call these functions)
 
//OS_Dummy() һ⺯
//OS_EventTaskRdy() ʹһ̬(OS_EVENT *pevent, void *msg, INT8U msk)
//OS_EventTaskWait() ʹһȴĳ¼״̬(ECBָ)
//OS_EventTO() ڳʱΪ̬(ECBָ)
//OS_EventWaitListInit()¼ƿбʼ(¼ƿָ)
//OS_FlagInit() ʼ¼־ṹ
//OS_FlagUnlink() OS_FLAG_NODE¼־ĵȴɾ(OS_FLAG_NODE *pnode)
//OS_MemInit() ʼڴ
//OS_QInit() ʼ¼нṹ
//OS_Sched() Ⱥ
//OS_TaskIdle() (ָһݽṹ)
//OS_TaskStat() ͳ(ָһݽṹ)
//OS_TCBInit() ʼƿTCB(ȼָ롢ջָ롢ջָ롢־
//ջչָ롢ѡ)


#if OS_TASK_DEL_EN > 0
void          OS_Dummy(void);
#endif

#if ((OS_Q_EN > 0) && (OS_MAX_QS > 0)) || (OS_MBOX_EN > 0) || (OS_SEM_EN > 0) || (OS_MUTEX_EN > 0)
INT8U         OS_EventTaskRdy(OS_EVENT *pevent, void *msg, INT8U msk);
void          OS_EventTaskWait(OS_EVENT *pevent);
void          OS_EventTO(OS_EVENT *pevent);
void          OS_EventWaitListInit(OS_EVENT *pevent);
#endif

#if (OS_VERSION >= 251) && (OS_FLAG_EN > 0) && (OS_MAX_FLAGS > 0)
void          OS_FlagInit(void);
void          OS_FlagUnlink(OS_FLAG_NODE *pnode);
#endif

#if (OS_MEM_EN > 0) && (OS_MAX_MEM_PART > 0)
void          OS_MemInit(void);
#endif

#if OS_Q_EN > 0
void          OS_QInit(void);
#endif

void          OS_Sched(void);

void          OS_TaskIdle(void *data);

#if OS_TASK_STAT_EN > 0
void          OS_TaskStat(void *data);
#endif

INT8U         OS_TCBInit(INT8U prio, OS_STK *ptos, OS_STK *pbos, INT16U id, INT32U stk_size, void *pext, INT16U opt);

//*********************************************************************************************************
//๳ӳ (FUNCTION PROTOTYPES)
//رӺԭ (Target Specific Functions)
 

#if OS_VERSION >= 204
void          OSInitHookBegin(void);
void          OSInitHookEnd(void);
#endif

void          OSIntCtxSw(void);

void          OSStartHighRdy(void);

void          OSTaskCreateHook(OS_TCB *ptcb);
void          OSTaskDelHook(OS_TCB *ptcb);

#if OS_VERSION >= 251
void          OSTaskIdleHook(void);
#endif

void          OSTaskStatHook(void);
OS_STK       *OSTaskStkInit(void (*task)(void *pd), void *pdata, OS_STK *ptos, INT16U opt);
void          OSTaskSwHook(void);

#if OS_VERSION >= 204
void          OSTCBInitHook(OS_TCB *ptcb);
#endif

void          OSTimeTickHook(void);

//*********************************************************************************************************
//ԭ FUNCTION PROTOTYPES
//жϺԭ (Compiler Specific ISR prototypes)


#ifndef OS_ISR_PROTO_EXT
void          OSCtxSw(void);
void          OSTickISR(void);
#endif

/*
*********************************************************************************************************
*                                   LOOK FOR MISSING #define CONSTANTS
*
* This section is used to generate ERROR messages at compile time if certain #define constants are 
* MISSING in OS_CFG.H.  This allows you to quickly determine the source of the error.
*
* You SHOULD NOT change this section UNLESS you would like to add more comments as to the source of the
* compile time error.
*********************************************************************************************************
*/

//*********************************************************************************************************
//¼־

#ifndef OS_FLAG_EN
#error  "OS_CFG.H, Missing OS_FLAG_EN: Enable (1) or Disable (0) code generation for Event Flags"
#else
    #ifndef OS_MAX_FLAGS
    #error  "OS_CFG.H, Missing OS_MAX_FLAGS: Max. number of Event Flag Groups in your application"
    #else
        #if     OS_MAX_FLAGS == 0
        #error  "OS_CFG.H, OS_MAX_FLAGS must be > 0"
        #endif
        #if     OS_MAX_FLAGS > 255
        #error  "OS_CFG.H, OS_MAX_FLAGS must be <= 255"
        #endif
    #endif

    #ifndef OS_FLAG_WAIT_CLR_EN
    #error  "OS_CFG.H, Missing OS_FLAG_WAIT_CLR_EN: Include code for Wait on Clear EVENT FLAGS"
    #endif

    #ifndef OS_FLAG_ACCEPT_EN
    #error  "OS_CFG.H, Missing OS_FLAG_ACCEPT_EN: Include code for OSFlagAccept()"
    #endif

    #ifndef OS_FLAG_DEL_EN
    #error  "OS_CFG.H, Missing OS_FLAG_DEL_EN: Include code for OSFlagDel()"
    #endif

    #ifndef OS_FLAG_QUERY_EN
    #error  "OS_CFG.H, Missing OS_FLAG_QUERY_EN: Include code for OSFlagQuery()"
    #endif
#endif

//*********************************************************************************************************
//Ϣ

#ifndef OS_MBOX_EN
#error  "OS_CFG.H, Missing OS_MBOX_EN: Enable (1) or Disable (0) code generation for MAILBOXES"
#else
    #ifndef OS_MBOX_ACCEPT_EN
    #error  "OS_CFG.H, Missing OS_MBOX_ACCEPT_EN: Include code for OSMboxAccept()"
    #endif

    #ifndef OS_MBOX_DEL_EN
    #error  "OS_CFG.H, Missing OS_MBOX_DEL_EN: Include code for OSMboxDel()"
    #endif

    #ifndef OS_MBOX_POST_EN
    #error  "OS_CFG.H, Missing OS_MBOX_POST_EN: Include code for OSMboxPost()"
    #endif

    #ifndef OS_MBOX_POST_OPT_EN
    #error  "OS_CFG.H, Missing OS_MBOX_POST_OPT_EN: Include code for OSMboxPostOpt()"
    #endif

    #ifndef OS_MBOX_QUERY_EN
    #error  "OS_CFG.H, Missing OS_MBOX_QUERY_EN: Include code for OSMboxQuery()"
    #endif
#endif

//*********************************************************************************************************
//ڴ

#ifndef OS_MEM_EN
#error  "OS_CFG.H, Missing OS_MEM_EN: Enable (1) or Disable (0) code generation for MEMORY MANAGER"
#else
    #ifndef OS_MAX_MEM_PART
    #error  "OS_CFG.H, Missing OS_MAX_MEM_PART: Max. number of memory partitions"
    #else
        #if     OS_MAX_MEM_PART == 0
        #error  "OS_CFG.H, OS_MAX_MEM_PART must be > 0"
        #endif
        #if     OS_MAX_MEM_PART > 255
        #error  "OS_CFG.H, OS_MAX_MEM_PART must be <= 255"
        #endif
    #endif

    #ifndef OS_MEM_QUERY_EN
    #error  "OS_CFG.H, Missing OS_MEM_QUERY_EN: Include code for OSMemQuery()"
    #endif
#endif

//*********************************************************************************************************
//ź

#ifndef OS_MUTEX_EN
#error  "OS_CFG.H, Missing OS_MUTEX_EN: Enable (1) or Disable (0) code generation for MUTEX"
#else
    #ifndef OS_MUTEX_ACCEPT_EN
    #error  "OS_CFG.H, Missing OS_MUTEX_ACCEPT_EN: Include code for OSMutexAccept()"
    #endif

    #ifndef OS_MUTEX_DEL_EN
    #error  "OS_CFG.H, Missing OS_MUTEX_DEL_EN: Include code for OSMutexDel()"
    #endif

    #ifndef OS_MUTEX_QUERY_EN
    #error  "OS_CFG.H, Missing OS_MUTEX_QUERY_EN: Include code for OSMutexQuery()"
    #endif
#endif

//*********************************************************************************************************
//Ϣ

#ifndef OS_Q_EN
#error  "OS_CFG.H, Missing OS_Q_EN: Enable (1) or Disable (0) code generation for QUEUES"
#else
    #ifndef OS_MAX_QS
    #error  "OS_CFG.H, Missing OS_MAX_QS: Max. number of queue control blocks"
    #else
        #if     OS_MAX_QS == 0
        #error  "OS_CFG.H, OS_MAX_QS must be > 0"
        #endif
        #if     OS_MAX_QS > 255
        #error  "OS_CFG.H, OS_MAX_QS must be <= 255"
        #endif
    #endif

    #ifndef OS_Q_ACCEPT_EN
    #error  "OS_CFG.H, Missing OS_Q_ACCEPT_EN: Include code for OSQAccept()"
    #endif

    #ifndef OS_Q_DEL_EN
    #error  "OS_CFG.H, Missing OS_Q_DEL_EN: Include code for OSQDel()"
    #endif

    #ifndef OS_Q_FLUSH_EN
    #error  "OS_CFG.H, Missing OS_Q_FLUSH_EN: Include code for OSQFlush()"
    #endif

    #ifndef OS_Q_POST_EN
    #error  "OS_CFG.H, Missing OS_Q_POST_EN: Include code for OSQPost()"
    #endif

    #ifndef OS_Q_POST_FRONT_EN
    #error  "OS_CFG.H, Missing OS_Q_POST_FRONT_EN: Include code for OSQPostFront()"
    #endif

    #ifndef OS_Q_POST_OPT_EN
    #error  "OS_CFG.H, Missing OS_Q_POST_OPT_EN: Include code for OSQPostOpt()"
    #endif

    #ifndef OS_Q_QUERY_EN
    #error  "OS_CFG.H, Missing OS_Q_QUERY_EN: Include code for OSQQuery()"
    #endif
#endif

//*********************************************************************************************************
//ź

#ifndef OS_SEM_EN
#error  "OS_CFG.H, Missing OS_SEM_EN: Enable (1) or Disable (0) code generation for SEMAPHORES"
#else
    #ifndef OS_SEM_ACCEPT_EN
    #error  "OS_CFG.H, Missing OS_SEM_ACCEPT_EN: Include code for OSSemAccept()"
    #endif

    #ifndef OS_SEM_DEL_EN
    #error  "OS_CFG.H, Missing OS_SEM_DEL_EN: Include code for OSSemDel()"
    #endif

    #ifndef OS_SEM_QUERY_EN
    #error  "OS_CFG.H, Missing OS_SEM_QUERY_EN: Include code for OSSemQuery()"
    #endif
#endif

//*********************************************************************************************************
//

#ifndef OS_MAX_TASKS
#error  "OS_CFG.H, Missing OS_MAX_TASKS: Max. number of tasks in your application"
#else
    #if     OS_MAX_TASKS == 0
    #error  "OS_CFG.H,         OS_MAX_TASKS must be >= 2"
    #endif
    #if     OS_MAX_TASKS > 63
    #error  "OS_CFG.H,         OS_MAX_TASKS must be <= 63"
    #endif
#endif

#ifndef OS_TASK_IDLE_STK_SIZE
#error  "OS_CFG.H, Missing OS_TASK_IDLE_STK_SIZE: Idle task stack size"
#endif

#ifndef OS_TASK_STAT_EN
#error  "OS_CFG.H, Missing OS_TASK_STAT_EN: Enable (1) or Disable(0) the statistics task"
#endif

#ifndef OS_TASK_STAT_STK_SIZE
#error  "OS_CFG.H, Missing OS_TASK_STAT_STK_SIZE: Statistics task stack size"
#endif

#ifndef OS_TASK_CHANGE_PRIO_EN
#error  "OS_CFG.H, Missing OS_TASK_CHANGE_PRIO_EN: Include code for OSTaskChangePrio()"
#endif

#ifndef OS_TASK_CREATE_EN
#error  "OS_CFG.H, Missing OS_TASK_CREATE_EN: Include code for OSTaskCreate()"
#endif

#ifndef OS_TASK_CREATE_EXT_EN
#error  "OS_CFG.H, Missing OS_TASK_CREATE_EXT_EN: Include code for OSTaskCreateExt()"
#endif

#ifndef OS_TASK_DEL_EN
#error  "OS_CFG.H, Missing OS_TASK_DEL_EN: Include code for OSTaskDel()"
#endif

#ifndef OS_TASK_SUSPEND_EN
#error  "OS_CFG.H, Missing OS_TASK_SUSPEND_EN: Include code for OSTaskSuspend() and OSTaskResume()"
#endif

#ifndef OS_TASK_QUERY_EN
#error  "OS_CFG.H, Missing OS_TASK_QUERY_EN: Include code for OSTaskQuery()"
#endif

//*********************************************************************************************************
//ʱ

#ifndef OS_TICKS_PER_SEC
#error  "OS_CFG.H, Missing OS_TICKS_PER_SEC: Sets the number of ticks in one second"
#endif

#ifndef OS_TIME_DLY_HMSM_EN
#error  "OS_CFG.H, Missing OS_TIME_DLY_HMSM_EN: Include code for OSTimeDlyHMSM()"
#endif

#ifndef OS_TIME_DLY_RESUME_EN
#error  "OS_CFG.H, Missing OS_TIME_DLY_RESUME_EN: Include code for OSTimeDlyResume()"
#endif

#ifndef OS_TIME_GET_SET_EN
#error  "OS_CFG.H, Missing OS_TIME_GET_SET_EN: Include code for OSTimeGet() and OSTimeSet()"
#endif

//*********************************************************************************************************
//Ϲ

#ifndef OS_MAX_EVENTS
#error  "OS_CFG.H, Missing OS_MAX_EVENTS: Max. number of event control blocks in your application"
#else
    #if     OS_MAX_EVENTS == 0
    #error  "OS_CFG.H, OS_MAX_EVENTS must be > 0"
    #endif
    #if     OS_MAX_EVENTS > 255
    #error  "OS_CFG.H, OS_MAX_EVENTS must be <= 255"
    #endif
#endif

#ifndef OS_LOWEST_PRIO
#error  "OS_CFG.H, Missing OS_LOWEST_PRIO: Defines the lowest priority that can be assigned"
#endif

#ifndef OS_ARG_CHK_EN
#error  "OS_CFG.H, Missing OS_ARG_CHK_EN: Enable (1) or Disable (0) argument checking"
#endif

#ifndef OS_CPU_HOOKS_EN
#error  "OS_CFG.H, Missing OS_CPU_HOOKS_EN: uC/OS-II hooks are found in the processor port files when 1"
#endif

#ifndef OS_SCHED_LOCK_EN
#error  "OS_CFG.H, Missing OS_SCHED_LOCK_EN: Include code for OSSchedLock() and OSSchedUnlock()"
#endif
