/*****************************************/
//ͷļ24L01.h
#ifndef _24l01_H_
#define _24l01_H_

#define uchar unsigned char
#define uint unsigned int
// SPI(nRF24L01) commands
#define READ_REG		0x00  // read command to register
#define WRITE_REG  		0x20  // write command to register
#define RD_RX_PLOAD		0x61  // RX payload register address
#define WR_TX_PLOAD 	0xA0  // TX payload register address
#define FLUSH_TX      	0xE1  // flush TX register command
#define FLUSH_RX    	0xE2  // flush RX register command
#define REUSE_TX_PL 	0xE3  // reuse TX payload register command
#define NOP				0xFF  // No Operation, might be used to read status register


//////register address
#define CONFIG      0x00  // 'Config' register address
#define EN_AA       0x01  // 'Enable Auto Acknowledgment' register address
#define EN_RXADDR   0x02  // 'Enabled RX addresses' register address
#define SETUP_AW    0x03  // 'Setup address width' register address
#define SETUP_RETR  0x04  // 'Setup Auto. Retrans' register address
#define RF_CH       0x05  // 'RF channel' register address
#define RF_SETUP    0x06  // 'RF setup' register address
#define STATUS      0x07  // 'Status' register address
#define OBSERVE_TX  0x08  // 'Observe TX' register address
#define CD          0x09  // 'Carrier Detect' register address
#define RX_ADDR_P0  0x0A  // 'RX address pipe0' register address
#define RX_ADDR_P1  0x0B  // 'RX address pipe1' register address
#define RX_ADDR_P2  0x0C  // 'RX address pipe2' register address
#define RX_ADDR_P3  0x0D  // 'RX address pipe3' register address
#define RX_ADDR_P4  0x0E  // 'RX address pipe4' register address
#define RX_ADDR_P5  0x0F  // 'RX address pipe5' register address
#define TX_ADDR     0x10  // 'TX address' register address
#define RX_PW_P0    0x11  // 'RX payload width, pipe0' register address
#define RX_PW_P1    0x12  // 'RX payload width, pipe1' register address
#define RX_PW_P2    0x13  // 'RX payload width, pipe2' register address
#define RX_PW_P3    0x14  // 'RX payload width, pipe3' register address
#define RX_PW_P4    0x15  // 'RX payload width, pipe4' register address
#define RX_PW_P5    0x16  // 'RX payload width, pipe5' register address
#define FIFO_STATUS 0x17  // 'FIFO Status Register' register address

#define RX_DR 0x40		//ж
#define TX_DS 0x20		//ݷж
#define MAX_RT 0x10		//طж


/***************************************************/
#define TX_ADR_WIDTH   5  // 5ֽڿȵķ/յַ
#define TX_PLOAD_WIDTH 32  // ͨЧݿ
#define RX_ADR_WIDTH   5
#define RX_PLOAD_WIDTH 32
//------------------------------------------------------------------------------
//spi־
#define DDR_SPI DDRB
#define DD_MOSI PB5
#define DD_SCK 	PB7
#define DD_SS 	PB4
//--------------------------------NRF24L01ӿڶ--------------------------------
//------------------------------------------------------------------------------
//#define NRF24L01_MISO          PB6  //0 
#define   Hign_24L01_MISO    PORTB|=(1 << PB6)
#define   Low_24L01_MISO     PORTB &= ~(1 << PB6)
#define   Read_24L01_MISO    PINB & (1 << PB6)

//#define NRF24L01_MOSI         PB5       //1
#define   Hign_24L01_MOSI    PORTB |= (1 << PB5) 
#define   Low_24L01_MOSI     PORTB &= ~(1 << PB5)
#define   Read_24L01_MOSI    PINB & (1 << PB5)

//#define NRF24L01_SCK    PB7      //1
#define   Hign_24L01_SCK    PORTB |= (1 << PB7)  
#define   Low_24L01_SCK     PORTB &= ~(1 << PB7)   
#define   Read_24L01_SCK    PINB & (1 << PB7);

//#define NRF24L01_CSN       PB3       //1
#define   Low_24L01_CSN     PORTB &= ~(1 << PB3)
#define   Hign_24L01_CSN    PORTB |= (1 << PB3)

//#define NRF24L01_CE         PB4       //1
#define   Hign_24L01_CE    PORTB |= (1 << PB4) 
#define   Low_24L01_CE     PORTB &= ~(1 << PB4)  
#define   Read_24L01_CE    PINB & (1 << PB4)

#define	  Read_24L01_IRQ	PINB & (1<<PB2)


void spi_init(void);
unsigned char SPI_RW(unsigned char date);
unsigned char SPI_Read(unsigned char reg);
unsigned char SPI_RW_Reg(unsigned char reg, unsigned char value);
unsigned char SPI_Read_Buf(unsigned char reg, unsigned char *pBuf, unsigned char bites);
unsigned char SPI_Write_Buf(unsigned char reg, unsigned char *pBuf, unsigned char bites);
void SetRX_Mode(void);
unsigned char nRF24L01_RxPacket(unsigned char* rx_buf);
void nRF24L01_TxPacket(void);
void loadTxPacket(uchar * tx_buf);
void init_NRF24L01(void);

#endif   /* _24l01_H_ */
