/*
 *  uart.c : UART driver for ATmega16L.
 *  Copyright (C) 2005-2009 Zhao Huabing
 *  www.ursastudio.com.cn
 *	History:	2005-11-20 Zhao Huabing created
 *				2009-01-12 Zhao Huabing modified 
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
 
#include <stdio.h>
#include <avr/io.h>
#include <util/delay.h>
#include "uart.h"
#include "config.h"
#define BAUDX	16
//㲨
#define BAUD(x) ((F_CPU/BAUDX/(x))-1)

void UartInit(uint16_t ubrr)  //UARTʼ
{
	UBRRL = (uint8_t)BAUD(ubrr) % 256;  //ʵͰλ
	UBRRH = (uint8_t)(BAUD(ubrr) >>8);  //ʸ߰λ
	UCSRA |= (BAUDX == 8) ? _BV(U2X) : 0;  		//Ƿȡٷ
	UCSRB |= _BV(RXEN) | _BV(TXEN);  				//ͺͽ
	UCSRC |= _BV(URSEL) | _BV(UCSZ1) | _BV(UCSZ0);	//ַ8λ
	//txd(pd1)rxd(pd0)룬ʹ
	sbi(PORTD,PD1);sbi(PORTD,PD0);
	sbi(DDRD,PD1);cbi(DDRD,PD0);
}

int UartPutchar(char c)  //ݷͺ
{
	loop_until_bit_is_set(UCSRA, UDRE);  //ȴԷ
	return UDR = c;  //
}

int UartGetchar(void)  //ݽպ
{
	loop_until_bit_is_set(UCSRA, RXC);  //ȴյ
	return UDR;  //
}
