/*
 * adc.c
 *
 * Created: 2011-8-18 13:09:27
 *  Author: Administrator
 */ 
#include <avr/io.h>
#include <avr/interrupt.h>

#include "config.h"
#include "adc.h"


// initialize a2d converteróٲԤúͨ
void a2dInit(void)
{
	sbi(ADCSRA, ADEN);				// enable ADC (turn on ADC power)
	cbi(ADCSRA, ADIF);				// default to single sample convert mode
	
	sbi(SFIOR,ADTS1),sbi(SFIOR,ADTS0);//ʱ/ 0 Ƚƥ
	a2dSetPrescaler(ADC_PRESCALE);	// ÷Ƶ
	a2dSetReference(ADC_REFERENCE);	// òοѹ
	a2dSetChannel(ADC_CH_ADC0);		//Ԥͨ0
	sbi(ADMUX, ADLAR);				// set to left-adjusted  result 룬ֻҪ8λȽADCH

	sbi(ADCSRA, ADIE);				// enable ADC interrupts
	sbi(ADCSRA,ADATE);				//Զʹ
	//a2dCompleteFlag = FALSE;		// clear conversion complete flag
	sei();							// turn on interrupts (if not already on)
}

// turn off a2d converter
void a2dOff(void)
{
	cbi(ADCSRA, ADIE);				// disable ADC interrupts
	cbi(ADCSRA, ADEN);				// disable ADC (turn off ADC power)
}

// configure A2D converter clock division (prescaling)
void a2dSetPrescaler(unsigned char prescale)
{
	outb(ADCSRA, ((inb(ADCSRA) & ~ADC_PRESCALE_MASK) | prescale));
}

// configure A2D converter voltage reference
void a2dSetReference(unsigned char ref)
{
	outb(ADMUX, ((inb(ADMUX) & ~ADC_REFERENCE_MASK) | (ref<<6)));
}

// sets the a2d input channel
void a2dSetChannel(unsigned char ch)
{
	//رڲ,ö˿Ϊ
	cbi(PORTA,ch);
	cbi(DDRA,ch);
	outb(ADMUX, (inb(ADMUX) & ~ADC_MUX_MASK) | (ch & ADC_MUX_MASK));	// set channel
}

uint8_t a2dConvert8bit(void)
{
	sbi(ADCSRA, ADIF);						// clear hardware "conversion complete" flag 
	sbi(ADCSRA, ADSC);						// start conversion
	while(!(ADCSRA&(1<<ADSC)));				//ȴת
	uint8_t i=ADCH;
	return (i);			// ʼʱý룬ֻADCH
}


