/*
 * m16_mic_rx.c
 *
 * Created: 2011-11-5 14:39:35
 *  Author: Administrator
 */ 

#include <avr/io.h>
#include <avr/interrupt.h>
#include "24l01.h"
#include "config.h"
uint8_t volatile play=0,byte_count=0,sta;
uint8_t volatile RX_BUF[RX_PLOAD_WIDTH];
uint8_t present_AD=0;
uint8_t volatile SPEED=128;
void timer0_init(void)
{
	TIFR  =  TIFR;       
	sbi(TCCR0,WGM01);         		// CTC ģʽ
	sbi(TCCR0,CS00);		  		//  ʱ
    OCR0  = SPEED;	
	sei();	
}
void pwm_init(void)
{
	DDRD=DDRD | (1<<DDC4) | (1<<DDC5); //M16OC1A,OC1BΪ
	PORTD=PORTD & (~((1<<PD4) | (1<<PD5))); //M16OC1A,OC1BΪ0ƽ
	TCCR1A=0x00;
	TCCR1B=0x00;
	TCCR1A=TCCR1A | (1<<COM1A1) | (1<<COM1B1) | (1<<WGM10) ;//Ƚƥʱ08λPWM
	TCCR1B=TCCR1B | (1<<WGM12)  | (1<<CS10);
}
void interrupt_init(void)
{	
	//½ش;
	sbi(MCUCR,ISC11);
	sbi(MCUCR,ISC01);
	sbi(GICR,INT0);//ʹⲿж0
	sbi(GICR,INT1);//ʹⲿж1
}
//pwmƵʣ
ISR(INT0_vect)
{
	SPEED++;
	OCR0=SPEED;
	sbi(GIFR,INTF0);
}
ISR(INT1_vect)
{
	SPEED--;
	OCR0=SPEED;
	sbi(GIFR,INTF1);
}
//adcжϳ߲ʣΪ˱뷢ͬƵʣڴ˴;
ISR(ADC_vect)
{
	present_AD= ADCH;
	if (play)
	{
		DDRD|=(1<<PD4);
		OCR1A=RX_BUF[byte_count];
		RX_BUF[byte_count]=0;
		byte_count++;
		if (byte_count==32)
		{
			byte_count=0;
			play=0;
		}
	}
	else
	{
		DDRD&=~(1<<PD4);	//ûʱΪ룬ֹƵ;
	}
	OCR1B=present_AD;
	TIFR  =  TIFR;
	sbi(ADCSRA, ADIF);
}


int main(void)
{
	init_NRF24L01();
	SetRX_Mode();
	interrupt_init();
	pwm_init();
	timer0_init();
	a2dInit();
    while(1)
    {
		sta=SPI_Read(STATUS);      // ȡ״̬Ĵжݽ״; 
		if(sta&RX_DR)                 // жǷյRX_DR==1?
		{	
			
			Low_24L01_CE;    //SPIʹ
			SPI_Read_Buf(RD_RX_PLOAD,RX_BUF,TX_PLOAD_WIDTH);// ȡ;
			SPI_RW_Reg(WRITE_REG + STATUS, sta);    //յݺRX_DR,TX_DS,MAX_PTøΪ1ͨд1жϱ־
			play=1;
		}
		Hign_24L01_CE;//ģʽ
    }
}