#include<avr/io.h>
#include<util/delay.h>
#include "avr/interrupt.h"
#include"24l01.h"
#include "config.h"
#define uchar unsigned char
#define uint unsigned int


uchar TX_ADDRESS[TX_ADR_WIDTH] = {0xf1,0xb6,0xb5,0xb4,0xb3};  // һ̬͵ַ
uchar RX_ADDRESS0[RX_ADR_WIDTH] = {0x78,0xb6,0xb5,0xb4,0xb3};
uchar RX_ADDRESS1[RX_ADR_WIDTH] = {0xf1,0xb6,0xb5,0xb4,0xb3};
uchar RX_ADDRESS2[1] = {0xcd};
uchar RX_ADDRESS3[1] = {0xa3};
uchar RX_ADDRESS4[1] = {0x0f};
uchar RX_ADDRESS5[1] = {0x05};


void spi_init(void)
{
 DDR_SPI |= (1<<DD_MOSI)|(1<<DD_SCK)|(1<<DD_SS)|(1 << PB3);//MOSI,SCK,SS.CE ΪOUTPUT,ΪINPUT
 SPCR=(1<<SPE)|(1<<MSTR)|(1<<SPR0);//ʹSPIӿ,ģʽ,MSBλǰ,ģʽ0,16Ƶ,SPIʱ1MHZ
 sbi(SPSR,SPI2X);
}

uchar SPI_RW(uchar date)
{
 	SPDR=date;
    while(!(SPSR&(1<<SPIF)));
    return SPDR;
}

uchar SPI_Read(uchar reg)
{
 uchar reg_val;
 
 Low_24L01_CSN;                // ʹspi
 SPI_RW(reg);            //ѡĴ
 reg_val = SPI_RW(0);    // 
 Hign_24L01_CSN;                // ˴β
 return(reg_val);        // 
}


uchar SPI_RW_Reg(uchar reg, uchar value)
{
 uchar status;
 Low_24L01_CSN;                   //
 status = SPI_RW(reg);      // 
 SPI_RW(value);             //
 Hign_24L01_CSN;                   //
 return(status);            //
}


uchar SPI_Read_Buf(uchar reg, uchar *pBuf, uchar bites)
{
 uint status1,uchar_ctr;
 Low_24L01_CSN;                      //
 status1 = SPI_RW(reg);         // 
 for(uchar_ctr=0;uchar_ctr<bites;uchar_ctr++)
  pBuf[uchar_ctr] = SPI_RW(0);    //
 Hign_24L01_CSN;                          
 return(status1);                    //
}

uchar SPI_Write_Buf(uchar reg, uchar *pBuf, uchar bites)
{
 uchar status1,uchar_ctr;
 
 Low_24L01_CSN;             //SPIʹ      
 status1 = SPI_RW(reg);  
 for(uchar_ctr=0; uchar_ctr<bites; uchar_ctr++) //
 SPI_RW(*pBuf++);
 Hign_24L01_CSN;           //رSPI
 return(status1);        //
}


void SetRX_Mode(void)
{
cli();
 Low_24L01_CE;
 SPI_Write_Buf(WRITE_REG + RX_ADDR_P0, RX_ADDRESS0, RX_ADR_WIDTH);
 SPI_Write_Buf(WRITE_REG + RX_ADDR_P1, RX_ADDRESS1, RX_ADR_WIDTH);
 SPI_Write_Buf(WRITE_REG + RX_ADDR_P2, RX_ADDRESS2, 1);
 SPI_Write_Buf(WRITE_REG + RX_ADDR_P3, RX_ADDRESS3, 1);
 SPI_Write_Buf(WRITE_REG + RX_ADDR_P4, RX_ADDRESS4, 1);
 SPI_Write_Buf(WRITE_REG + RX_ADDR_P5, RX_ADDRESS5, 1);
 SPI_RW_Reg(WRITE_REG + EN_AA, 0x3f);      //6ͨԶӦ
 SPI_RW_Reg(WRITE_REG + EN_RXADDR, 0x3f);  //6ͨյַ
  //SPI_RW_Reg(WRITE_REG + SETUP_AW, 0x03);  //ַ5
 SPI_RW_Reg(WRITE_REG + RF_CH,0);        //
 SPI_RW_Reg(WRITE_REG + RX_PW_P0, RX_PLOAD_WIDTH);//Чݿ;
 SPI_RW_Reg(WRITE_REG + RX_PW_P1, RX_PLOAD_WIDTH);
 SPI_RW_Reg(WRITE_REG + RX_PW_P2, RX_PLOAD_WIDTH);
 SPI_RW_Reg(WRITE_REG + RX_PW_P3, RX_PLOAD_WIDTH);
 SPI_RW_Reg(WRITE_REG + RX_PW_P4, RX_PLOAD_WIDTH);
 SPI_RW_Reg(WRITE_REG + RX_PW_P5, RX_PLOAD_WIDTH);
 SPI_RW_Reg(WRITE_REG + RF_SETUP, 0x0f);  //0dbm,2M
 SPI_RW_Reg(WRITE_REG + CONFIG, 0x0f); 
 Hign_24L01_CE;
 _delay_us(200);//עⲻ̫С;
 sei();
}


uchar nRF24L01_RxPacket(uchar* rx_buf)
{
 uchar sta,flag=0;
 sta=SPI_Read(STATUS);      // ȡ״̬Ĵжݽ״ ; 
 if(sta&0x40)                 // жǷյRX_DR==1?
 {
    Low_24L01_CE;    //SPIʹ
	SPI_Read_Buf(RD_RX_PLOAD,rx_buf,TX_PLOAD_WIDTH);// ռĴ
	flag =1;   //ȡɱ־
	//SPI_RW_Reg(WRITE_REG + CONFIG, 0x0f);//
	SPI_RW_Reg(WRITE_REG + STATUS, sta);    //յݺRX_DR,TX_DS,MAX_PTøΪ1ͨд1жϱ־
 }
 Hign_24L01_CE;//Ϊģʽ
 return (flag);
 
}
///////////////////////////////////////////////////////
void nRF24L01_TxPacket(void)
{
	cli();
 Low_24L01_CE;   //StandBy Iģʽ 
 TX_ADDRESS[0]= RX_ADDRESS0[0];
 SPI_Write_Buf(WRITE_REG + TX_ADDR, TX_ADDRESS, TX_ADR_WIDTH);
 SPI_Write_Buf(WRITE_REG + RX_ADDR_P0, TX_ADDRESS, TX_ADR_WIDTH); // װؽն˵ַ
 //SPI_Write_Buf(WR_TX_PLOAD, tx_buf, TX_PLOAD_WIDTH);     // װ 
 SPI_RW_Reg(WRITE_REG + EN_AA, 0x3f);      //
 SPI_RW_Reg(WRITE_REG + EN_RXADDR, 0x3f);  //
 SPI_RW_Reg(WRITE_REG + SETUP_RETR, 0x03); //250Usطһ
 SPI_RW_Reg(WRITE_REG + RF_CH, 0);        //
 SPI_RW_Reg(WRITE_REG + RF_SETUP, 0x0f);   //2M 0dbm,
 SPI_RW_Reg(WRITE_REG + CONFIG, 0x0e);      // IRQշжӦ16λCRC
 //Hign_24L01_CE;   //øCEݷ
 _delay_us(150);
 sei();
}
///////////////////////////////////////////////////////////
void loadTxPacket(uchar * tx_buf)
{
	cli();
	 Low_24L01_CE;
	 Low_24L01_CSN;
	 SPI_RW(FLUSH_TX);
	 Hign_24L01_CSN;
	 SPI_Write_Buf(WR_TX_PLOAD, tx_buf, TX_PLOAD_WIDTH);     // װ;
	 Hign_24L01_CE;   //øCEݷ 
	 sei();
}	 

void init_NRF24L01(void)
{
	spi_init();
	cbi(DDRB,PB2);//irqΪ;
	sbi(DDRB,PB0);
	Low_24L01_CE;    
	Hign_24L01_CSN; 
	Low_24L01_SCK;  
}


