#include "ds3231.h"

xdata uchar year,month,day,week,hour,min,sec,Dtemp;
//˵                      ʱ      ʱ
xdata uchar al1_min,al1_hour,al1_day,al2_min,    al2_hour,al2_day;
//           1  1ʱ  1 2     2ʱ   2  
bit ack;//Уλ

uchar BCD2HEX(uchar val)   //BCDתΪByte
{
uchar i;
    i= val&0x0f;
    val >>= 4;
    val &= 0x0f;
    val *= 10;
    i += val;
    
    return i;
}

uchar B_BCD(uchar val)//BתΪBCD
{
uchar i,j,k;

  i=val/10;
  j=val%10;
  k=j+(i<<4);
  return k;
}

void delayus(uchar i)
{
   while(--i) ;
}
/************************START***************************/
void Start()
{
    SDA=1;                  //ʼź
    delayus(1);
    SCL=1;
    delayus(5);             //ʼʱ4.7us,ʱ
   
    SDA=0;                  //ʼź
    delayus(5);             // ʼʱ4s
       
    SCL=0;                  //ǯסI2Cߣ׼ͻ
    delayus(2);
} 
/********************************************************/
/************************STOP****************************/
void Stop()
{
    SDA=0;                  //ͽź
    delayus(1);             //ͽʱź
    SCL=1;                  //ʱ4us
    delayus(5);
   
    SDA=1;                  //I2C߽ź
    delayus(4);
}
/********************************************************/






/*******************************************************************
                  ֽݷͺ               
ԭ:     void   SendByte(uchar Dat);
:      cͳȥ,ǵַ,Ҳ,ȴӦ,
           ״̬λв.(ӦӦʹack=0)
           ack=1         
           ack=0        Ӧ𻵡
********************************************************************/
void SendByte(uchar Dat)
{
uchar BitCnt;
   
    for(BitCnt=0;BitCnt<8;BitCnt++)         //Ҫ͵ݳΪ8λ
    {
        if((Dat<<BitCnt)&0x80)
            SDA=1;                          //жϷλ
        else 
            SDA=0;               
          delayus(1);
          SCL=1;                            //ʱΪߣ֪ͨʼλ
          delayus(5);                       //֤ʱӸߵƽڴ4s   
          SCL=0;
    }
   
    delayus(2);
    SDA=1;                                  //8λͷߣ׼Ӧλ
    delayus(2);  
    SCL=1;
    delayus(3);
    if(SDA==1)
        ack=0;    
    else
        ack=1;                              //жǷյӦź
    SCL=0;
    delayus(2);
}
/********************************************************/
/*******************************************************************
                  ֽݽպ               
ԭ:     uchar   RcvByte();
:      մ,жߴ(Ӧź)
           ӦӦӻ  
********************************************************************/ 
uchar RcvByte()
{
uchar retc;
uchar BitCnt;
 
   retc=0;
   SDA=1;                           //Ϊ뷽ʽ
   for(BitCnt=0;BitCnt<8;BitCnt++)
   {
        delayus(1);  
        SCL=0;                      //ʱΪͣ׼λ
       
        delayus(5);                 //ʱӵ͵ƽڴ4.7s
      
        SCL=1;                      //ʱΪʹЧ
        delayus(3);
        retc=retc<<1;
        if(SDA==1)
            retc=retc+1;            //λ,յλretc
        delayus(2);
   }
   SCL=0;
   delayus(2);
   return(retc);
}
/********************************************************************
                      ӦӺ
ԭ:   void I2CACK(bit a);
:       Ӧź(ӦӦźţλa)
********************************************************************/
void I2CACK(bit a)
{
 
    if(a==0)
        SDA=0;              //ڴ˷ӦӦź
    else
        SDA=1;
    delayus(3);     
    SCL=1;
   
    delayus(5);             //ʱӵ͵ƽڴ4s
   
    SCL=0;                  //ʱߣǯסI2CԱ
    delayus(2);   
}
/****************************************************/
/***********һֽдDS3231ָĵַ***********/
uchar I2CWrite(uchar addr,uchar bytedata)
{
	Start();
    SendByte(ADDRTC);
    if (ack == 0)
        return 0;
   
    SendByte(addr);   
    if (ack == 0)
        return 0;
   
    SendByte(bytedata);
    if (ack == 0)
        return 0;
   
    Stop();
    delayus(10);      
    return 1;
}
/****************************************************/
/************DS3231ǰַһֽ************/
uchar I2CRead()
{
uchar read_data;

    Start();
    SendByte(ADDRTC+1);
    if(ack==0)
    {
		//DisplayChar(11,1,'t');
		return(0);
   	}	
    read_data = RcvByte();
    I2CACK(1);
    Stop();
    return read_data;
}

/****************************************************/
/************DS3231ַָһֽ************/
uchar I2CReadAdd(uchar addr)
{
    Start();
    SendByte(ADDRTC);
    if(ack==0)
    {
		//DisplayChar(12,1,'x');
		return(0);
   	}	
    SendByte(addr);
    if(ack==0)
    {
		//DisplayChar(13,1,'y');
		return(0);
   	}	
    return(I2CRead());
}
/***************************************************/
/*********************ȡʱ**********************/
void Readtime()
{
uchar temp;
  
  temp=I2CReadAdd(DS3231_SEC);//   
  sec=BCD2HEX(temp);   // DS3231ڶBCDתΪBYTE Ƭʹ
	
  temp=I2CReadAdd(DS3231_MIN);//
  min=BCD2HEX(temp);   // DS3231ڶBCDתΪBYTE Ƭʹ
	
  temp=I2CReadAdd(DS3231_HOUR);//ʱ
  //temp&=0x3F;
  hour=BCD2HEX(temp);
	
  week=I2CReadAdd(DS3231_DAY);//
	
  temp=I2CReadAdd(DS3231_DATE);  //
  day=BCD2HEX(temp);
	
  temp=I2CReadAdd(DS3231_MONTH); // 
  month=BCD2HEX(temp);
	
  temp=I2CReadAdd(DS3231_YEAR);  //
  year=BCD2HEX(temp);
	
  Dtemp=I2CReadAdd(DS3231_TEMP_H);//¶
}
/***************************************************/
/*******************ȡʱ********************/
void ReadAlarm()
{
uchar temp;
  
  temp=I2CReadAdd(DS3231_AL1MIN);//1
  al1_min=BCD2HEX(temp);
  temp=I2CReadAdd(DS3231_AL1HOUR);  //1ʱ
  al1_hour=BCD2HEX(temp);
  temp=I2CReadAdd(DS3231_AL1DAY);  //1
  al1_day=BCD2HEX(temp);
  temp=I2CReadAdd(DS3231_AL2MIN);//2
  al2_min=BCD2HEX(temp);
  temp=I2CReadAdd(DS3231_AL2HOUR);  //2ʱ
  al2_hour=BCD2HEX(temp);
  temp=I2CReadAdd(DS3231_AL2DAY);  //2
  al2_day=BCD2HEX(temp);
}
/***************************************************/
/****************޸ʱ***************************/
//               ʱ           
void SetTime(uchar yea,uchar mon,uchar da,uchar week,uchar hou,uchar min,uchar sec)
{
uchar temp=0;
  
  temp=B_BCD(sec);//BYTEתΪBCD     ƬBYTE   DS3231ΪBCD
  I2CWrite(0x00,temp);//޸
  temp=B_BCD(min);
  I2CWrite(0x01,temp);//޸ķ
  temp=B_BCD(hou);
  I2CWrite(0x02,temp);//޸ʱ
	temp=B_BCD(week);
	I2CWrite(0x03,temp);//޸
  temp=B_BCD(da);
  I2CWrite(0x04,temp);//޸
  temp=B_BCD(mon);
  I2CWrite(0x05,temp);//޸
  temp=B_BCD(yea);
  I2CWrite(0x06,temp);//޸

	
}

bit runnian()//ж
{
	if((year%4==0&&year%100!=0)||(year%100==0&&year%400==0))
	{
		return 1;
	}
	else
	{
		return 0;
	}


}
/********************************************???????????????****************************************/
void autoweek() 
{
//		unsigned char year1,month1,day1;
    Readtime(); 
//		year1=year+2000;
//		month1=month;
//		day1=day;
//	
//    if( month1 == 1 || month1 == 2 )  
//    {
//        month1 += 12;
//        if( year1> 0 )
//            year1--;
//        else
//            year = 4;
//    }
    week = day%7;
    //I2CWrite(DS3231_DAY,week);
}

void InitDS3231()
{
	SCL=1;
	delayus(5);
	SDA=1;
	delayus(5);
	I2CWrite(DS3231_AL1DAY,0x81);	//A1M4λʱƥʱӦ
	I2CWrite(DS3231_AL2DAY,0x81);	//A2M4λʱƥʱӦ
	I2CWrite(DS3231_CONTROL,0x04);	//ж12ر
	I2CWrite(DS3231_STATUS,0x00);	//32KHZֹӱ־λ
//	SetTime(15,12,10,5,17,0,50);//             ʱ           
}

/* -------- read temperature -------- */
void    read_temp()
{
int     itemp;
float   ftemp;

        do
        {
                itemp=I2CReadAdd(0x0e);
        }       while(itemp & 0x20);            // wait until CNVT bit goes inactive

        Start();
        SendByte(ADDRTC);
        SendByte(0x11);                 //address of temperature MSB
        Start();
        SendByte(ADDRTC + 1);           //send the device address for read
        itemp = ( (int) RcvByte() << 5 );
		I2CACK(0);
        itemp += ( RcvByte() >> 3);
		I2CACK(1);
        Stop();
        if(itemp & 0x1000) {itemp += 0xe000;}        //if sign bit set, make 16 bit 2's comp

        ftemp = 0.03125 * (float) itemp;        // convert to degrees C
        // ftemp = ftemp * 9 / 5 + 32;  // skip this if you don't want degrees F
		Dtemp  = (uchar) ftemp;
}