#ifndef __DS3231_2_H__
#define __DS3231_2_H__
#include<reg52.h>
#define uchar unsigned char
#define uint  unsigned int

sbit    SCL = P3^7;             /* I2C pin definitions */
sbit    SDA = P3^6;
sbit    int0 = P3^2;
/**************************** defines *******************************/
#define ADDRTC  0xd0    /* DS3231 slave address (write) */
//#define DS3231_WriteAddress 0xD0    //дַ 
//#define DS3231_ReadAddress  0xD1    //ַ

#define DS3231_SEC	0x00    //
#define DS3231_MIN	0x01    //
#define DS3231_HOUR	0x02    //ʱ
#define DS3231_DAY	0x03    //
#define DS3231_DATE	0x04    //
#define DS3231_MONTH 0x05    //
#define DS3231_YEAR	0x06    //
//1            
#define DS3231_Al1SEC	0x07    //
#define DS3231_AL1MIN	0x08    //
#define DS3231_AL1HOUR	0x09    //ʱ
#define DS3231_AL1DAY	0x0A    ///
//2
#define DS3231_AL2MIN	0x0b    //
#define DS3231_AL2HOUR	0x0c    //ʱ
#define DS3231_AL2DAY	0x0d    ///
#define DS3231_CONTROL	0x0e    //ƼĴ
#define DS3231_STATUS	0x0f    //״̬Ĵ


#define BSY             2       //æ
#define OSF             7       //ֹͣ־
#define DS3231_XTAL     0x10    //ϻĴ
#define DS3231_TEMP_H	0x11    //¶ȼĴֽ(8λ)
#define DS3231_TEMP_L	0x12    //¶ȼĴֽ(2λ)  

extern xdata uchar   sec, min, hour, week, day, month, year,Dtemp;
extern xdata uchar al1_min,al1_hour,al1_day,al2_min,al2_hour,al2_day;

/*********************** Function Prototypes **************************/
uchar	BCD2HEX(uchar val);
uchar	B_BCD(uchar val);
void	delayus(uchar i);
void    Start();
void    Stop();
void	I2CACK(bit a);
void	SendByte(uchar Dat);
uchar	ReceiveByte(uchar b);
uchar	I2CWrite(uchar addr,uchar bytedata);
uchar	I2CRead();
uchar	I2CReadAdd(uchar addr);
void    read_temp();
void    init_alrm();
void	Readtime();
void	ReadAlarm();
void	InitDS3231();
bit		runnian();
void	autoweek(); 
void SetTime(uchar yea,uchar mon,uchar da,uchar week,uchar hou,uchar min,uchar sec);

#endif