#include <reg52.h>
#include "ds3231.h"
#include "time.h"
#include "lcd1602.h"
#include "key.h"

unsigned char flag200ms=1;
unsigned char setIndex = 0;  //ʱ

unsigned char str[16];

void RefreshTimeShow();
void delay();
void main()
{
	unsigned char psec=0xAA;
	 
	count=200;
//		init_alrm();
		InitDS3231();
    ConfigTime0();  //T0ʱ1ms   //ʱ
    InitLcd1602();    //ʼҺ
		LcdShowStr(0, 0,"maohaolong");
    while (1)
    {
			 KeyDriver();  //ð
			//LcdShowStr(0, 0,"maohaolong");
			if(flag200ms && (setIndex==0))//û¶ҵ200ms
			{
				flag200ms = 0;
				Readtime();        //ʱtime  //   ʱ    
				read_temp();
				if(psec != sec)
				{
					RefreshTimeShow();
					psec = sec;	
				}

			}
		}
}
/* ˢʱʾ */
void RefreshTimeShow()
{
				
					str[0] = '2';
					str[1] = '0';
					str[2] = year/10+'0';  //
					str[3] = year%10+'0';
					str[4] = '-';
					
					str[5]= month/10+'0';  //
					str[6]= month%10+'0';
				
					str[7] = '-';
					str[8] = (day / 10) + '0';//
					str[9] = (day % 10) + '0';
					str[10] = '\0';
				
					LcdShowStr(0, 0, str);  //9  
				
					str[0] = (week %  10 ) + '0';
					str[1] = '\0';
					LcdShowStr(11, 0, "week");
					LcdShowStr(15, 0, str);

					str[0] = (hour / 10) + '0';
					str[1] = (hour % 10) + '0';
					str[2] = ':';
					str[3] = (min / 10) + '0';
					str[4] = (min % 10) + '0';
					str[5] = ':';
					str[6] = (sec / 10) + '0';
					str[7] = (sec % 10) + '0';
					str[8] = ' ';
					
					str[9]=' ';
					str[10]=(Dtemp / 10) + '0';
					str[11]=(Dtemp % 10) + '0';
					str[12]=' ';
					str[13]='C';
					str[14] = '\0';
					
					LcdShowStr(0, 1, str);
}

/* ˢµǰλĹָʾ */
void RefreshSetShow()
{

    switch (setIndex)
    {
        case 1:  LcdSetCursor(3,0); break;//
        case 2:  LcdSetCursor(6,  0); break;//
        case 3:  LcdSetCursor(9,  0); break;//
			  case 4:  LcdSetCursor(1,  1); break;//ʱ
	  		case 5:  LcdSetCursor(4,  1); break;//
			  case 6:  LcdSetCursor(7,  1); break;//
        default:  break;
    }
}

/* ʱ䵱ǰλֵ */
void IncSetTime()
{
    switch (setIndex)
    {
        case 1:  if(year<99)         //
											year=year+1;
								 else
											year = 0;  
								 break;
        case 2:  if(month<12)            //
											month=month+1;
								 else
											month=0; 
								 break;
        case 3:  if(day<31)         //  
											day=day+1;
								 else
											day=0; 
								 break;
		    case 4:  if(hour<24)         //ʱ 
											hour=hour+1;
								 else
											hour=0; 
								 break;
        case 5:  if(min<60)         // 
											min=min+1;
								 else
											min=0; 
								 break;
        case 6:  if(sec<60)         //  
											sec=sec+1;
								 else
											sec=0; 
								 break;
       default:  break;
    }
    RefreshTimeShow();
    RefreshSetShow();
}
/* ݼʱ䵱ǰλֵ */
void DecSetTime()
{
	//year,month,date,day,hour,min,sec
    switch (setIndex)
    {
        case 1:  if(year==0)         //
											year=99;
								 else
											year--;  
								 break;
        case 2:  if(month==0)            //
											month=12;
								 else
											month--; 
								 break;
        case 3:  if(day==0)         //  
											day=31;
								 else
											day--; 
								 break;
		    case 4:  if(hour==0)         //ʱ 
											hour=24;
								 else
											hour--; 
								 break;
        case 5:  if(min==0)         // 
											min=60;
								 else
											min--; 
								 break;
        case 6:  if(sec==0)         //  
											sec=60;
								 else
											sec--; 
								 break;
       default:  break;
    }
    RefreshTimeShow();
    RefreshSetShow();
}
/* ʱλ */
void RightShiftTimeSet()
{
    if (setIndex != 0)
    {
        if (setIndex < 6)
            setIndex++;
        else
            setIndex = 1;
        RefreshSetShow();
    }
}
/* ʱλ */
void LeftShiftTimeSet()
{
    if (setIndex != 0)
    {
        if (setIndex > 1)
            setIndex--;
        else
            setIndex = 6;
        RefreshSetShow();
    }
}
/* ʱ״̬ */
void EnterTimeSet()
{
    setIndex = 6;         //Ϊ2ɽ״̬
    LeftShiftTimeSet(); //ֳɵƲƵλ1ʾˢ
    LcdOpenCursor();     //򿪹˸Ч
}
/* ˳ʱ״̬save-Ƿ񱣴浱ǰõʱֵ */
void ExitTimeSet(bit save)
{
    setIndex = 0;     //Ϊ0˳״̬
    if (save)         //豣ʱѵǰʱдDS1302
    {
			 
			 //autoweek();
				//delay();
//			delay();
//			delay();
//			delay();
			SetTime(year,month,day,week,hour,min,sec);
      
    }
    LcdCloseCursor(); //رչʾ
}
/* ݼִӦĲkeycode- */
void KeyAction(unsigned char keycode)
{
    if  ((keycode>='0') && (keycode<='9'))  //вӦַ
    {
    }
    else if (keycode == 0x26)  //ϼǰλֵ
    {
        IncSetTime();
    }
    else if (keycode == 0x28)  //¼ݼǰλֵ
    {
        DecSetTime();
    }
    else if (keycode == 0x25)  //лλ
    {
        LeftShiftTimeSet();
    }
    else if (keycode == 0x27)  //Ҽлλ
    {
        RightShiftTimeSet();
    }
    else if (keycode == 0x0D)  //سģʽ/õǰֵ
    {
        if (setIndex == 0)  //״̬ʱ״̬
        {
            EnterTimeSet();
        }
        else                //Ѵ״̬ʱʱ䲢˳״̬
        {
            ExitTimeSet(1);
        }
    }
    else if (keycode == 0x1B)  //Escȡǰ
    {
        ExitTimeSet(0);
    }
}
void timer0_out(void) interrupt 1//
{
	TL0=TIME;
	TH0=TIME>>8;
	KeyScan();   //ɨ
	if(count--==0)
	{
		count=200;
		flag200ms=1;
	}
}

void delay()
{
	uint i,j;
	for(j=2550;j>0;j--)
		for(i=255;i>0;i--);
}


