#include <msp430x14x.h>
typedef unsigned char uchar;
typedef unsigned int  uint;

#define SCL_H P1OUT |= BIT1
#define SCL_L P1OUT &= ~BIT1
#define SDA_H P1OUT |= BIT0
#define SDA_L P1OUT &= ~BIT0

#define SCL_out P1DIR |= BIT1    //SCLΪģʽ
#define SDA_in  P1DIR &= ~BIT0   //SDAĳģʽ
#define SDA_out P1DIR |= BIT0    //SDAģʽ
#define SDA_val P1IN&BIT0        //SDAλֵ
 
#define TRUE    1
#define FALSE   0

/*******************************************
ƣSet_IO
    ܣIICӦIOΪߵƽ
    
ֵ  
********************************************/
void Set_IO(void)
{
    SCL_out;
    SDA_out;
    SCL_H;
    SDA_H;
}
/*******************************************
ƣdelay
    ܣʱԼ100usʱ
    
ֵ  
********************************************/
void delay(void)
{
    uchar i;
    
    for(i = 0;i < 15;i++)
        _NOP();
}	
/*******************************************
ƣstart
    ܣIICʼ
    
ֵ  
********************************************/
void start(void)
{
    SCL_H;
    SDA_H;
    delay();
    SDA_L;
    delay();
    SCL_L;
    delay();
}
/*******************************************
ƣstop
    ܣIICֹ
    
ֵ  
********************************************/
void stop(void)
{
    SCL_H;
    SDA_L;	
    delay();
    SDA_H;
    delay();	   
}
/*******************************************
ƣcheck
    ܣӻӦ
    
ֵ  ӻǷӦ1--У0--
********************************************/
uchar check(void)
{
    uchar slaveack;

    SDA_in;
    SCL_H;
    delay();
    slaveack = SDA_val;   //SDAֵ
    SCL_L;
    delay();
    SDA_out;
    if(slaveack)    return FALSE;
    else            return TRUE;
}
/*******************************************
ƣwrite1
    ܣIIC߷һ1
    
ֵ  
********************************************/
void write1(void)
{
    SDA_H;
    delay();
    SCL_H;
    delay();
    SCL_L;				
    delay();
}
/*******************************************
ƣwrite0
    ܣIIC߷һ0
    
ֵ  
********************************************/
void write0(void)
{
    SDA_L;
    delay();
    SCL_H;
    delay();			 
    SCL_L;				
    delay();
}
/*******************************************
ƣwrite1byte
    ܣIIC߷һֽڵ
    wdata--͵
ֵ  
********************************************/
void write1byte(uchar wdata)
{
    uchar i;

    for(i = 8;i > 0;i--)
    {
        if(wdata & 0x80)	write1();
        else 			write0();
        wdata <<= 1;
    }                    
}
