#include <msp430x14x.h>
#include "cry1602.h"
typedef unsigned char uchar;
typedef unsigned int  uint;

/**************궨***************/
#define DataDir     P4DIR
#define DataPort    P4OUT				
#define Busy	    0x80
#define CtrlDir     P3DIR
#define CLR_RS P3OUT&=~BIT0;    //RS = P3.0	
#define SET_RS P3OUT|=BIT0;	
#define CLR_RW P3OUT&=~BIT1;	//RW = P3.1
#define SET_RW P3OUT|=BIT1;	
#define CLR_EN P3OUT&=~BIT2;	//EN = P3.2	
#define SET_EN P3OUT|=BIT2;	
/*******************************************
ƣDispNchar
    ܣҺĳλʾNַ
    x--λõ
          y--λõ
          n--ַ
          ptr--ַָλõָ
ֵ  
********************************************/
void DispNChar(uchar x,uchar y, uchar n,uchar *ptr) 
{
    uchar i;
    
	for (i=0;i<n;i++)
	{
		Disp1Char(x++,y,ptr[i]);
		if (x == 0x0f)
		{
		   x = 0; 
           y ^= 1;
		}
	}
}
/*******************************************
ƣLocateXY
    ܣҺʾַλõϢ
    x--λõ
          y--λõ
ֵ  
********************************************/
void LocateXY(uchar x,uchar y) 
{
    uchar temp;

	temp = x&0x0f;
	y &= 0x01;
	if(y)   temp |= 0x40;  //ڵ2
	temp |= 0x80;
    
	LcdWriteCommand(temp,1);
}
/*******************************************
ƣDisp1Char
    ܣĳλʾһַ
    x--λõ
          y--λõ
          data--ʾַ
ֵ  
********************************************/
void Disp1Char(uchar x,uchar y,uchar data) 
{
	LocateXY( x, y );			
	LcdWriteData( data );		
}
/*******************************************
ƣLcdReset
    ܣ1602Һģиλ
    
ֵ  
********************************************/
void LcdReset(void) 
{
    CtrlDir |= 0x07;                 //߶˿Ϊ״̬ 
    DataDir = 0xFF;                  //ݶ˿Ϊ״̬
  
   	LcdWriteCommand(0x38, 0);	     //涨ĸλ
	Delay5ms();
	LcdWriteCommand(0x38, 0);		
	Delay5ms();
	LcdWriteCommand(0x38, 0);
	Delay5ms();

	LcdWriteCommand(0x38, 1);		//ʾģʽ
    LcdWriteCommand(0x08, 1);		//ʾر
   	LcdWriteCommand(0x01, 1);	    //ʾ
	LcdWriteCommand(0x06, 1);		//дַʱ岻ƶ
	LcdWriteCommand(0x0c, 1);		//ʾα꣬˸
}
/*******************************************
ƣLcdWriteCommand
    ܣҺģд
    cmd--
          chk--Ƿæı־1æ0
ֵ  
********************************************/
void LcdWriteCommand(uchar cmd,uchar chk) 
{

	if (chk) WaitForEnable();   // æź?
	
	CLR_RS;	
	CLR_RW; 
	_NOP();

	DataPort = cmd;             //дݶ˿ 
	_NOP();					
	
	SET_EN;                     //ʹź
	_NOP();
	_NOP();
	CLR_EN;			
}
	
/*******************************************
ƣLcdWriteData
    ܣҺʾĵǰַдʾ
    data--ʾַ
ֵ  
********************************************/
void LcdWriteData( uchar data ) 
{
	WaitForEnable();        //ȴҺæ

	SET_RS;
	CLR_RW; 
	_NOP();

    DataPort = data;        //ʾдݶ˿
    _NOP();

	SET_EN;                 //ʹź
	_NOP(); 
	_NOP(); 
	CLR_EN;		
}
/*******************************************
ƣWaitForEnable
    ܣȴ1602Һڲ
    
ֵ  
********************************************/
void WaitForEnable(void) 
{
    P4DIR &= 0x00;  //P4лΪ״̬

	CLR_RS;
	SET_RW;
	_NOP();
	SET_EN; 
	_NOP();
	_NOP();
	
	while((P4IN & Busy)!=0);  //æ־

	CLR_EN;
    
	P4DIR |= 0xFF;  //P4лΪ״̬
}	
                       
/*******************************************
ƣDelay5ms
    ܣʱԼ5ms
    
ֵ  
********************************************/
void Delay5ms(void)
{ 
    uint i=40000;
    while (i != 0)
    {
        i--;
    }
}
/*******************************************
ƣDelay400ms
    ܣʱԼ400ms
    
ֵ  
********************************************/
void Delay400ms(void)
{
    uchar i=50;
	uint j;
    
	while(i--)
	{
		j=7269;
		while(j--);
	}
}
