/****************************************************
ܣADCDACģѹݣ
          ģѹֵ1602Һʾ
----------------------------------------------------
ãJ12ź3ţ̽
-----------------------------------------------------
˵S3ԼСDACѹ
          S4DACѹ
          ۲Һʾ仯
******************************************************/
#include <msp430x14x.h>
#include "BoardConfig.h"
#include "IIC.h"
#include "cry1602.h"

uint    ADC_tmp[16];      //ADCֵĻ
uchar   cnt = 0;          //
uint    ADC_Val = 0;      //һADCתƽֵ
uchar   DAC_Val;          //DAC

uchar shuzi[] = {"0123456789."};
uchar tishi1[] = {"DAC volt: "};
uchar tishi2[] = {"ADC volt: "};
void Init_ADC(void);
uchar Write_DAC(uchar wdata);
void Trans_val(uint Hex_Val,uchar n);

/********************************/
void main(void)
{
    
    WDTCTL = WDTPW + WDTHOLD;   //ֹͣŹ
    BoardConfig(0xb8);
    P1DIR |= 0x03 + BIT7;       //DACĿIOΪ״̬
    P1OUT  = 0x03;
    P1IE  |= BIT2 + BIT3;       //P1.2P1.3ж
    
    LcdReset();
    DispNChar(0,0,10,tishi1);   //ʾʾ
    Disp1Char(15,0,0x56);       //0x56ַVASCIIֵ       
    DispNChar(0,1,10,tishi2);
    Disp1Char(15,1,0x56);
    
    DAC_Val = 0;
    Write_DAC(DAC_Val);
    Trans_val(DAC_Val,8);
    
    Init_ADC();
    _EINT();
    while(1)
    {       
        ADC12CTL0 |= ADC12SC;           //ʼһת
        LPM0;
        Trans_val(ADC_Val,12);          //Һʾ
    }
}
/*******************************************
ƣADC12_ISR
    ܣADCжϷ
    
ֵ  
********************************************/
#pragma vector=ADC_VECTOR
__interrupt void ADC12_ISR(void)
{   
    ADC_tmp[cnt++] = ADC12MEM0;
    
    if(cnt == 16)
    {
        unsigned long ADC_sum = 0;
        uchar i;
        
        for(i = 0;i < 16;i++)           //16βľֵ
            ADC_sum += ADC_tmp[i];
        
        ADC_Val = ADC_sum >> 4;        
        cnt = 0;
        LPM0_EXIT;
    }
    else
    {
        ADC12CTL0 |= ADC12SC;           //ʼһת
    }
}
/*******************************************
ƣPort1_ISR
    ܣ˿P1жϷ
    
ֵ  
********************************************/
#pragma vector=PORT1_VECTOR
__interrupt void Port1_ISR(void)
{
    
    _DINT();
    
    if(P1IFG & BIT2)
    {
        P1IFG = 0x00;           //жϱ־ 
        DAC_Val -= 10;          //DAC10ƫ
        Write_DAC(DAC_Val);     //дDAC
        Trans_val(DAC_Val,8);   //Һʾ
    }
    else if(P1IFG & BIT3)
    {
        P1IFG = 0x00;           //жϱ־
        DAC_Val += 10;          //DAC10ƫ
        Write_DAC(DAC_Val);     //дDAC
        Trans_val(DAC_Val,8);   //Һʾ
    }
    else
        _NOP();
    
    P1IFG = 0x00;           //жϱ־
    _EINT();
}

/*******************************************
ƣInit_ADC
    ܣʼADCĴ
    
ֵ  
********************************************/
void Init_ADC(void)    
{
    P6SEL |= BIT1;                  //P6.1ѡADC˿
    ADC12CTL0 = SHT0_2 + ADC12ON;   //òʱ䣬ADC
    ADC12CTL1 = SHP;                //ʹòʱѡSMCLK
    ADC12IE = BIT0;                 //ʹܲж
    ADC12MCTL0 = INCH_1;            //ѡͨ1
    ADC12CTL0 |= ENC;               //תʹ
}
/*******************************************
ƣWrite_DAC
    ܣDACдѹ
    
ֵ  д1--ɹ0--ʧ
********************************************/
uchar Write_DAC(uchar wdata)
{
    start();
	write1byte(0x98);   //DAC豸ַ
	if(check())   write1byte(wdata >> 4);   //дģʽ͵ѹݵĸλ
	else          return 0;
	if(check())   write1byte(wdata << 4);  //дѹݵĵλ
	else          return 0;
	if(check())	  stop();
	else          return 0;
	return 1;    
}
/*******************************************
ƣTrans_val
    ܣ16ݱ任λ10ݣ
          Һʾ
    Hex_Val--16
          n--任ʱķĸ2nη       
ֵ  д1--ɹ0--ʧ
********************************************/
void Trans_val(uint Hex_Val,uchar n)
{
    unsigned long caltmp;
    uint Curr_Volt;
    uchar t1,i;
    uchar ptr[4];
    
    caltmp = Hex_Val;
    caltmp = (caltmp << 5) + Hex_Val;           //caltmp = Hex_Val * 33
    caltmp = (caltmp << 3) + (caltmp << 1);     //caltmp = caltmp * 10
    Curr_Volt = caltmp >> n;                    //Curr_Volt = caltmp / 2^n
    ptr[0] = Curr_Volt / 100;                   //Hex->Dec任
    t1 = Curr_Volt - (ptr[0] * 100);
    ptr[2] = t1 / 10;
    ptr[3] = t1 - (ptr[2] * 10);
    if(n == 8)          //DAC
        t1 = 0;
    else                //ADC
        t1 = 1;
    
    ptr[1] = 10;            //shuziе10λӦ"."
    _DINT();
    //Һʾ任Ľ
    for(i = 0;i < 4;i++)
      Disp1Char((10 + i),t1,shuzi[ptr[i]]);
    _EINT();
}
