#include <msp430.h>
typedef unsigned char uchar;
/*******************************************
ƣInitUART
    ܣʼUART˿
    
ֵ  
********************************************/
void InitUART(void)
{
    P3SEL |= 0x30;                            // P3.4,5 = USART0 TXD/RXD
    ME1 |= URXE0 + UTXE0;                             // Enable USART0 T/RXD
    UCTL0 |= CHAR;                            // 8-bit character
    UTCTL0 |= SSEL0;                          // UCLK = ACLK
    UBR00 = 0x03;                             // 32k/9600 - 3.41
    UBR10 = 0x00;                             //
    UMCTL0 = 0x4A;                            // Modulation
    UCTL0 &= ~SWRST;                          // Initialize USART state machine
}
/*******************************************
ƣSend1Char
    ܣPCһַ
    sendchar--Ҫ͵ַ
ֵ  
********************************************/
void Send1Char(uchar sendchar)
{
      while (!(IFG1 & UTXIFG0));    //ȴͼĴΪ         
      TXBUF0 = sendchar; 
   
}
/*******************************************
ƣPutSting
    ܣPCַָ
    ptr--ַָָ
ֵ  
********************************************/
void PutString(uchar *ptr)
{
      while(*ptr != '\0')
      {
            Send1Char(*ptr++);                     // 
      }
      while (!(IFG1 & UTXIFG0));
      TXBUF0 = '\n';                              //ͻָ
}
/*******************************************
ƣPutSting0
    ܣPCַ޻
    ptr--ַָָ
ֵ  
********************************************/
void PutString0(uchar *ptr)
{
      while(*ptr != '\0')
      {
            Send1Char(*ptr++);                     // 
      }
}
