#include <msp430x14x.h> 
//
#define uchar unsigned char
#define uint  unsigned int
#define CPU_F ((double)8000000) 
#define delayus(x) __delay_cycles((long)(CPU_F*(double)x/1000000.0))  //궨ʱ
#define delayms(x) __delay_cycles((long)(CPU_F*(double)x/1000.0)) 
      #define SCL1 P1OUT |=BIT0 
      #define SCL0 P1OUT &=~BIT0 
      #define SCLOUT P1DIR |= BIT0;  
      #define SDA1 P1OUT |=BIT1   //IIC 
      #define SDA0 P1OUT &=~BIT1 
      #define SDAIN P1DIR &=~BIT1 
      #define SDAOUT P1DIR |=BIT1  
      #define SDADATA (P1IN & BIT1)
#define SMPLRT_DIV  0x19 //ǲʪֵ0x07(125Hz)
#define CONFIG   0x1A //ͨ˲Ƶʪֵ0x06(5Hz) 
#define GYRO_CONFIG  0x1B //Լ켰Χֵ0x18(Լ쪢2000deg/s) 
#define ACCEL_CONFIG 0x1C //ټԼ졢Χͨ˲Ƶʪֵ0x01(Լ쪢2G5Hz)
#define ACCEL_XOUT_H 0x3B 
#define ACCEL_XOUT_L 0x3C
#define ACCEL_YOUT_H 0x3D
#define ACCEL_YOUT_L 0x3E
#define ACCEL_ZOUT_H 0x3F 
#define ACCEL_ZOUT_L 0x40
#define TEMP_OUT_H  0x41 
#define TEMP_OUT_L  0x42
#define GYRO_XOUT_H  0x43 
#define GYRO_XOUT_L  0x44  
#define GYRO_YOUT_H  0x45 
#define GYRO_YOUT_L  0x46 
#define GYRO_ZOUT_H  0x47 
#define GYRO_ZOUT_L  0x48 
#define PWR_MGMT_1  0x6B //Դֵ0x00() 
#define WHO_AM_I   0x75 //IICַĴ(Ĭֵ0x68ֻ)
#define SlaveAddress 0xD0 //IICдʱĵַֽݪ+1Ϊȡ       //ʾ(-511512)ַ
void I2C_Start();
void I2C_Stop(); 
void I2C_SendACK(uchar ack); 
uchar I2C_RecvACK(); 
void I2C_SendByte(uchar dat);
uchar I2C_RecvByte(); 
    void Single_WriteI2C(uchar REG_Address,uchar REG_data); 
    uchar Single_ReadI2C(uchar REG_Address);
    void InitMPU6050(); 
void lcd_printf(uchar *s,int temp_data); 
void DisplayListChar(uchar X,uchar Y,uchar *DData,uchar L); 
int GetData(uchar REG_Address);
void Display10BitData(int value,uchar x,uchar y);

//*****************************1602************************************** 
#define CLR_RS P6OUT&=~BIT3;    //RS = P3.0	
#define SET_RS P6OUT|=BIT3;	
#define CLR_RW P6OUT&=~BIT4;	//RW = P3.1
#define SET_RW P6OUT|=BIT4;	
#define CLR_EN P6OUT&=~BIT5;	//EN = P3.2	
#define SET_EN P6OUT|=BIT5;
//void  delay2(unsigned int k);										//ʱ						
void  lcd_printf(uchar *s,int temp_data);
uchar dis[6];							//ʾ(-511512)ַ
int	dis_data;						//
void sent_byte(uchar data);    ///ͺ

void lcd_printf(uchar *s,int temp_data)
{
	if(temp_data<0)
	{
		temp_data=-temp_data;
		*s='-';
	}
	else *s=' ';

	*++s =temp_data/10000+0x30;
	temp_data=temp_data%10000;     //ȡ

	*++s =temp_data/1000+0x30;
	temp_data=temp_data%1000;     //ȡ

	*++s =temp_data/100+0x30;
	temp_data=temp_data%100;     //ȡ
	*++s =temp_data/10+0x30;
	temp_data=temp_data%10;      //ȡ
	*++s =temp_data+0x30; 	
}


void Display10BitData(int value,uchar x,uchar y)
{       
        uchar i;
	lcd_printf(dis, value);			//תʾ
        for(i=0;i<6;i++)
	{
            sent_byte(dis[i]);
        }
}


//int dis_data;
 //************************************** //I2Cʼź //************************************** 
void I2C_Start()
{    
   SDAOUT;    
   SDA1;                    //  
   SCLOUT;   
   SCL1;                    //ʱ
   delayus(5);                 //ʱ    
   SDA0;                    //½ 
   delayus(5);                  //ʱ  
   SCL0;                    //ʱ
} 
//************************************** //I2Cֹͣź //**************************************
void I2C_Stop()
{     
   SDAOUT;
   SDA0;                    //  
   SCLOUT;   
   SCL1;                    //ʱ
   delayus(5);                   //ʱ  
   SDA1;                    // 
   delayus(5);                  //ʱ
}
 //************************************** //I2CӦź //ڲ:ack (0:ACK 1:NAK)
void I2C_SendACK(uchar ack) 
{   
   SDAOUT;   
   SCLOUT; 
   if(ack)
   SDA1;
   else SDA0; //    SDA = ack;                  //дӦź    
   SCL1;                    //ʱ 
   delayus(5);                  //ʱ    
   SCL0;                    //ʱ 
   delayus(5);                  //ʱ 
} //************************************** //I2CӦź //**************************************
uchar I2C_RecvACK() 
{ 
   uchar cy; 
   SCLOUT;  
   SCL1;                    //ʱ   
   SDAIN;
   delayus(5);                 //ʱ
   if(SDADATA)    
   { 
      cy=1;   
   } 
   else  
   { 
      cy=0;   
   } //    cy = SDA;                   //Ӧź  
   SCL0;                    //ʱ 
   delayus(5);                //ʱ    
   SDAOUT; 
   return cy; 
 } 
//I2C߷һֽ
void I2C_SendByte(uchar dat) 
{ 
   uchar i;  
   SDAOUT;   
   for (i=0; i<8; i++)         //8λ 
   { 
      if((dat<<i)&0x80)     
      {           
         SDA1;       
      }
      else       
     {          
         SDA0;    
     }        // SDA = cy;               //ݿ  
     SCLOUT;       
     SCL1;                //ʱ 
     delayus(5);              //ʱ   
     SCL0;                //ʱ
     delayus(5);              //ʱ 
  }   
  I2C_RecvACK();
} 
//I2C߽һֽ
uchar I2C_RecvByte() 
{ 
    uchar i;
    uchar dat = 0,cy;    
    SDAOUT;   
    SCLOUT; 
    SDA1;                    //ʹڲ,׼ȡ,  
    SDAIN;    
    for (i=0; i<8; i++)         //8λ   
    { 
      dat<<= 1;      
      SCL1;                //ʱ 
      delayus(5);             //ʱ
      if(SDADATA)        
      { 
         cy=1;      
      }
      else        
      { 
         cy=0;      
      }
      dat |= cy;             // 
  
  
      SCL0;                //ʱ
      delayus(5);             //ʱ  
    }   
    SDAOUT;
    return dat;
}
 //I2C豸дһֽ
void Single_WriteI2C(uchar REG_Address,uchar REG_data)
{   
   I2C_Start();                  //ʼź  
   I2C_SendByte(SlaveAddress);   //豸ַ+дź  
   I2C_SendByte(REG_Address);    //ڲĴַ   
   I2C_SendByte(REG_data);       //ڲĴݪ    
   I2C_Stop();                   //ֹͣź
}
//I2C豸ȡһֽ 
//************************************** 
uchar Single_ReadI2C(uchar REG_Address) 
{ 
   uchar REG_data;  
   I2C_Start();                   //ʼź 
   I2C_SendByte(SlaveAddress);    //豸ַ+дź 
   I2C_SendByte(REG_Address);     //ʹ洢Ԫַ0ʼ  
   I2C_Start();                   //ʼź  
   I2C_SendByte(SlaveAddress+1);  //豸ַ+ź  
   REG_data=I2C_RecvByte();       //Ĵ 
   I2C_SendACK(1);                //Ӧź 
   I2C_Stop();                    //ֹͣź 
   return REG_data;
 }
//ʼMPU6050 
void InitMPU6050()
{ 
    Single_WriteI2C(PWR_MGMT_1, 0x00); //״̬ 
    Single_WriteI2C(SMPLRT_DIV, 0x07);  
    Single_WriteI2C(CONFIG, 0x06);
    Single_WriteI2C(GYRO_CONFIG, 0x18); 
    Single_WriteI2C(ACCEL_CONFIG, 0x01);
}
//ϳ
int GetData(uchar REG_Address)
{ 
   char H,L; 
   H=Single_ReadI2C(REG_Address);
    L=Single_ReadI2C(REG_Address+1); 
   return (H<<8)+L;  //ϳ
} 

void delay(unsigned int cnt) //򵥵ʱ
{
 while(--cnt);
}
void Sys_Ini(void)//  Sys_Ini();
{
  unsigned int i;
  WDTCTL = WDTPW + WDTHOLD;                 // Stop WDT
  BCSCTL1 &= ~XT2OFF;                       // XT2on
  do
  {
    IFG1 &= ~OFIFG;                           // Clear OSCFault flag
    for (i = 0xFF; i > 0; i--);               // Time for flag to set
  }
  while ((IFG1 & OFIFG));                   // OSCFault flag still set?
  BCSCTL2 |= SELM_2 + SELS;
}
void ini_uart(void)
{
    P3SEL |= 0x30;                            // ѡP3.4P3.5UARTͨŶ˿
    ME1 |= UTXE0 + URXE0;                     // ʹUSART0ķͺͽ
    UCTL0 |= CHAR;                            // ѡ8λַ
    UTCTL0 |= SSEL0;                          // UCLK = ACLK
    UBR00 = 0x03;                             // 9600
    UBR10 = 0x00;                             //
    UMCTL0 = 0x4A;                            // Modulation
    UCTL0 &= ~SWRST;                          // ʼUART״̬
    IE1 |= URXIE0;                            // ʹUSART0Ľж
    _EINT();                                  //ȫж
}

/*void PutString(uchar *ptr)
{
      while(ptr != '\0')
      {
            while (!(IFG1 & UTXIFG0));                // 0ķжϱ־ڷͻĴ
            TXBUF0 = *ptr;                       // 
      }
      while (!(IFG1 & UTXIFG0));
      TXBUF0 = '\n';
}*/
/**************
ƣSend1Char
    ܣPCһַ
    sendchar--Ҫ͵ַ
ֵ  
******************************/
void Send1Char(uchar sendchar)
{
      while (!(IFG1 & UTXIFG0));    //ȴͼĴΪ         
      TXBUF0 = sendchar;   
}
void sent_byte(uchar data)
{
  while((IFG1&UTXIFG0)==0);
  U0TXBUF=data;
}
#pragma vector=UART0RX_VECTOR
__interrupt void UART0_RX(void)
{
  uchar data=0;
  data=U0RXBUF;
  sent_byte(data);
}

void main() 
{    
  // uchar i;
    Sys_Ini();
    ini_uart();
    _EINT();
   InitMPU6050();
  while(1)   
  {            
                Display10BitData(GetData(ACCEL_XOUT_H),2,0);	//ʾXٶ
		Display10BitData(GetData(ACCEL_YOUT_H),7,0);	//ʾYٶ
		Display10BitData(GetData(ACCEL_ZOUT_H),12,0);	//ʾZٶ
		Display10BitData(GetData(GYRO_XOUT_H),2,1);	//ʾXٶ
		Display10BitData(GetData(GYRO_YOUT_H),7,1);	//ʾYٶ
		Display10BitData(GetData(GYRO_ZOUT_H),12,1);	//ʾZٶ
                 delayms(100);
                 sent_byte('\n');
  }
} 

