#include <msp430x14x.h>
typedef unsigned char uchar;
typedef unsigned int  uint;

#define DQ1 P1OUT |= BIT6
#define  DQ0 P1OUT &= ~BIT6
#define DQ_in   P1DIR &= ~BIT6
#define DQ_out  P1DIR |= BIT6
#define DQ_val  (P1IN & BIT6)

/*******************************************
ƣDelayNus
    ܣʵN΢ʱ
    n--ʱ
ֵ  
˵    ʱAļʱ1MHzCPUƵ8MHz
          ͨʱʱܹõΪȷ
          usʱ
********************************************/
void DelayNus(uint n)
{
    CCR0 = n;
    TACTL |= MC_1;           //CCR0
    while(!(TACTL & BIT0));   //ȴ
    TACTL &= ~MC_1;          //ֹͣ
    TACTL &= ~BIT0;          //жϱ־
}
/*******************************************
ƣInit_18B20
    ܣDS18B20иλ
    
ֵ  ʼ״̬־1--ʧܣ0--ɹ
********************************************/
uchar Init_18B20(void)
{
    uchar Error;
    
    DQ_out;
    _DINT();
    DQ0;
    DelayNus(500);
    DQ1;
    DelayNus(55);
    DQ_in;
    _NOP();
    if(DQ_val)      
    {
        Error = 1;          //ʼʧ
    }
    else
    {
        Error = 0;          //ʼɹ
    }
    DQ_out;
    DQ1;
    _EINT();
    
    DelayNus(400);
    
    return Error;
}
/*******************************************
ƣWrite_18B20
    ܣDS18B20дһֽڵ
    wdata--д
ֵ  
********************************************/
void Write_18B20(uchar wdata)
{
    uchar i;
    
    _DINT();
    for(i = 0; i < 8;i++)
    {
        DQ0;
        DelayNus(6);            //ʱ6us
        if(wdata & 0X01)    DQ1;
        else                DQ0;
        wdata >>= 1;
        DelayNus(50);           //ʱ50us
        DQ1;
        DelayNus(10);           //ʱ10us
    }
    _EINT();
}
/*******************************************
ƣRead_18B20
    ܣDS18B20ȡһֽڵ
    
ֵ  һֽ
********************************************/
uchar Read_18B20(void)
{
    uchar i;
    uchar temp = 0;
    
    _DINT();
    for(i = 0;i < 8;i++)
    {
        temp >>= 1;
        DQ0;
        DelayNus(6);            //ʱ6us
        DQ1;
        DelayNus(8);            //ʱ9us
        DQ_in;
        _NOP();
        if(DQ_val)   temp |= 0x80;
        DelayNus(45);           //ʱ45us
        DQ_out;
        DQ1;
        DelayNus(10);           //ʱ10us
    }
    _EINT();
    
    return  temp;
}

/*******************************************
ƣSkip
    ܣȡƷID
    
ֵ  
********************************************/
void Skip(void)
{
    Write_18B20(0xcc);
}
/*******************************************
ƣConvert
    ܣ¶ת
    
ֵ  
********************************************/
void Convert(void)
{
    Write_18B20(0x44);
}
/*******************************************
ƣRead_SP
    ܣͶScratchPad
    
ֵ  
********************************************/
void Read_SP(void)
{
    Write_18B20(0xbe);
}
/*******************************************
ƣReadTemp
    ܣDS18B20ScratchPadȡ¶ת
    
ֵ  ȡ¶ֵ
********************************************/
uint ReadTemp(void)
{
    uchar temp_low;
    uint  temp;
    
    temp_low = Read_18B20();      //λ
    temp = Read_18B20();     //λ
    temp = (temp<<8) | temp_low;
    
    return  temp;
}
/*******************************************
ƣReadTemp
    ܣDS18B20һ¶ת
    
ֵ  ¶ֵ
********************************************/
uint Do1Convert(void)
{
    uchar i; 
    
    do
    {
        i = Init_18B20();
    }
    while(i);
    Skip();
    Convert();
    for(i = 20;i > 0;i--)  
        DelayNus(60000); //ʱ800ms
    do
    {
        i = Init_18B20();
    }
    while(i);
    Skip();
    Read_SP();
    return ReadTemp();
}
